/******************************************************************
*
*	AmyGUI++ - AmyFont.h
*
*	Author: Mika Kuoppala
*
******************************************************************/

#ifndef AMYFONT_H
#define AMYFONT_H


struct TextFont;
struct TextAttr;

class AmyFont 
{

public:

  AmyFont();

  AmyFont(char *FontName, unsigned short int Size, unsigned char Style = 0);
  	// When declaring your font, you'll give it's name, size and 
	// optional style flags

  struct TextFont *Address();	// To get address of AmyFont's TextFont 
				// structure 

  char           *GetName();	// Get the font's name
  unsigned short GetSize();	// Get the font's size		
  unsigned char  GetStyle();	// Get the style flags
  unsigned char  GetFlags();	// Get the TextAttr ta_flags

  operator TextFont *();	// You'll get the TextFont pointer
				// of your amyfont. If first called or
				// casted, font will be opened (read from	
				// disk)
  
  operator TextAttr *(); 	// To get address of AmyFont's TextAttr
				// structure
  ~AmyFont();

protected:
	struct TextFont *font; 		
	struct TextAttr *ta;
};

#endif
