/**/
v="XQ Rexx  Convert FlatFile format to Xferq Williamson 54.20"
/* OPTIONS */
dl="FIDONET 1 FIDONET 2 FIDONET 3 FIDONET 4 FIDONET 5 FIDONET 6 AMIGANET 39 AMIGANET 40 AMIGANET 41 FRANCOMEDIA 101 MTLNET 17 CJNET 100"
xpack=1         /* if 0, Xpack will not be called                       */
q_outs=0        /* Set to 1 to queue OUT files remaining after XPACK    */
deletetic=0     /* set deletetic to 1 to cause tic's to be deleted      */
                /* after sending regardless of disposition in FLO file  */
debug=1
options results
options failat 99
signal on syntax
signal on halt
signal on ioerr
signal on break_c
signal on break_d

if ~show('L', "rexxsupport.library") then
    if ~addlib("rexxsupport.library", 0, -30, 0) then do
        say "Couldn't access rexxsupport.library !"
        exit 20
    end 
if ~show("L", "xferq.library") then
    if ~addlib("xferq.library", 0, -30, 0) then do
        say "Couldn't access xferq.library !"
        exit 20
    end

OUTDIR=addslash(dequote(GetClip('OUTDIR')))
FLODIR=addslash(dequote(GetClip('FLODIR')))
QDIR=OUTDIR||"f"
call makedir(QDIR)
QDIR=addslash(QDIR)
myaddress.domain=upper(GetCLip("DOMAIN"))
XQ_NOTHING=0;XQ_DELETE=1;XQ_TRUNCATE=2;XQ_IMMEDIATE=4;XQ_SENDLATER=8
DTPRI_CRASH=50;DTPRI_DIRECT=30;DTPRI_NORM=0;DTPRI_HOLD=-50
log=show('p','ROOFLOG')
script="XQ";sv=right(v,5)
if arg()~=0 then do
    parse arg xpack q_outs deletetic debug
end
DLIST=upper(GetCLip("DOMAINLIST"))
IF DLIST~="" & DLIST~="DLIST" THEN dl=DLIST

call cleanxq
call flocvt
call out_5d
if xpack then Address "REXX" GetClip('REXXDIR')||'/Xpack.rexx'
call scanout
exit

flocvt:
call PutLog('Searching for 4D ?LO files in' flodir)
Address COMMAND 'LIST >T:flofile.list 'flodir||'#?.#?.#?.#?.?LO quick nohead'
if word(statef("T:flofile.list"),2)=0 then do
   call PutLog('No 4D ?LO files in' outdir);return 0
end

if ~open('flolist',"T:flofile.list",'R') then do
   call PutLog("Error opening 4D .FLO listing");exit 10
end
i=0
do while ~eof('flolist')
  Line=Upper(strip(space(ReadLn('flolist'),1),'B'))
  if Line="" then iterate
  if debug then call PutLog('FLOLIST:'Line)
  i=i+1
  flofile.i=Line
  parse var Line flonode.i.zone"."flonode.i.net"."flonode.i.node"."flonode.i.point"."junk
  flofileadr.i=find_domain(flonode.i.zone)'#'flonode.i.zone":"flonode.i.net"/"flonode.i.node"."flonode.i.point  

  if Left(junk,1)="C" then flofile.i.pri=DTPRI_CRASH
  if Left(junk,1)="H" then flofile.i.pri=DTPRI_HOLD
  if Left(junk,1)="D" then flofile.i.pri=DTPRI_DIRECT
  if Left(junk,1)="N" then flofile.i.pri=DTPRI_NORM
  if Left(junk,1)="F" then flofile.i.pri=DTPRI_NORM
  if debug then call PutLog("FLOLIST:"flofile.i.domain flofileadr" PRI:"flofile.i.pri) 
end
call close('flolist')
if i=0 then do
  call PutLog("Error: No 4D ?LO Files found in" flodir);return 0
end

flofile.numnodes=i
do anode=1 until anode=flofile.numnodes
  drop flags
  call PutLog("Converting" flofile.anode "for" flofileadr.anode)
  floname=upper(flodir||flofile.anode)
  if debug then call PutLog("FLO FileName:"floname)
  site=flofileadr.anode

  cfgaddress=GetClip('HOST.ADDRESS.'||myaddress.domain)
  parse var cfgaddress myaddress.zone ":" myaddress.net "/" myaddress.node "." myaddress.point

  site_address=XfqGetAddress(site)
  err=0
  if ~exists(floname) then do
      call PutLog("Error: Can't find "floname)
      call drop_vars
      err=1
  end
  else if ~Open('flofile',floname,'R') then do
      call PutLog("Error: Can't open" floname)
      call drop_vars
      err=1
  end

  if ~err then do
      do while ~eof('flofile')
          Line=upper(ReadLn('flofile'))
          if Line="" then Iterate
          flags=XQ_NOTHING
          if (LEFT(Line,1)="#") then do
              flags=XQ_TRUNCATE
              Line=DELSTR(Line,1,1)
          end;else if (LEFT(Line,1)="^")|(LEFT(Line,1)="-") then do
              flags=XQ_DELETE
              Line=DELSTR(Line,1,1)
          end;else if (LEFT(Line,1)="@") then do
              flags=XQ_NOTHING
              Line=DELSTR(Line,1,1)
          end
          if ~exists(Line) then do
              call PutLog("File "Line" No Longer Exists");Iterate
          end
          if right(Line,2)="UT" then do
              sendas=get_packetname()
              select
              when Left(right(Line,3),1)="C" then t.pri=DTPRI_CRASH
              when Left(right(Line,3),1)="H" then t.pri=DTPRI_HOLD
              when Left(right(Line,3),1)="D" then t.pri=DTPRI_DIRECT
              when Left(right(Line,3),1)="N" then t.pri=DTPRI_NORM
              otherwise do
                Call PutLog('Skipping Unknown OUT file flavour:'Line);Iterate
              end;end
              call PutLog('Moving 'Line' to 'QDIR)
              call rename(Line,QDIR||Get_fn(Line))
              Line=QDIR||get_fn(Line)
           end;else do
               parse var Line x '.' x '.' x '.' x '.' ext
               if ext="" then do
                  sendas=get_fn(Line)
                  if deletetic & right(Line,3)="TIC" then flags=XQ_DELETE
                  else flags=XQ_NOTHING
                  t.pri=flofile.anode.pri
              end;else do
                  tmpext=upper(left(ext,2))
                  if datatype(right(ext,1),'n') & (tmpext="MO"|tmpext="TU"|tmpext="WE"|tmpext="TH"|tmpext="FR"|tmpext="SA"|tmpext="SU") then do
                      sendas=UPPER(d2x(65536+myaddress.net-flonode.anode.net,4)||d2x(65536+   myaddress.node-flonode.anode.node,4)||'.'ext)
                      flags=XQ_DELETE
                      t.pri=flofile.anode.pri
                  end
              end
              drop ext x
          end
          call PutLog('Queueing:'Line' as 'sendas' for:'site' Disp:'flags' Pri:'t.pri)
          QUERY.XQ_NAME=Line
          QUERY.XQ_SITE=site_address
          work=NULL
          work=XfqFindWork(QUERY)
          if work=NULL then do
              call PutLog("File "line" not in site queue, adding as "sendas)
              XfqAddWorkQuick(site,Line,sendas,t.pri,flags)
          end;else do
            call PutLog("File "line" found, re-queueing")
            call XfqUnlockWork(work)
          end
      end
      call close('flofile')
      call delete(floname)
  end
  call XfqFlushQueue(site_address)
  call XfqDropObject(site_address)
  if work ~=NULL then call XfqDropObject(work)
end
call XfqClose()
call drop_vars
call delete("T:flofile.list")
return

out_5d:
call PutLog('Searching for 4D OUT files in 'OUTDIR)
address COMMAND 'List >T:out.temp' OUTDIR||'#?.#?.#?.#?.?UT LFORMAT "%N"'
if debug then address command 'type T:out.temp'
if ~exists('T:out.temp')|word(statef('T:out.temp'),2) < 2|~open('olist','T:OUT.TEMP','r') then do
    call PutLog('No 4D ?UT files to convert');return 0
end
do while ~eof('olist')
    outfile=readln('olist')
    if outfile="" then iterate
    if debug then call PutLog('OUTFILE:'outfile)
    parse var outfile z '.' n '.' f '.' p '.' type junk
    if datatype(z,'MIXED')|junk ~="" then do
       call putlog(outfile' not 4D')
       if datatype(z,'MIXED') then call PutLog(outfile' pending for 'z)
       Iterate
    end
    if debug then call PutLog('Renaming:' OUTDIR||outfile 'to' OUTDIR||find_domain(z)'.'z'.'n'.'f'.'p'.'type)
    call rename(OUTDIR||outfile,OUTDIR||find_domain(z)'.'z'.'n'.'f'.'p'.'type)
end
call close('olist')
call delete('T:out.temp')
return


scanout:
call PutLog('Searching for 5D .?UT files in' outdir)
Address COMMAND 'LIST >T:outfile.list 'outdir||'#?.#?.#?.#?.#?.?UT quick nohead'
if word(statef("T:outfile.list"),2)=0 then do
   call PutLog('No 5D ?UT files in' outdir);return 0
end
if ~open('outs',"T:outfile.list",'R') then do
   call PutLog("Error opening 5D .?UT list");exit 10
end
do while ~eof('outs')
   outfile=upper(readln('outs'))
   if outfile="" then iterate
   parse var outfile ogd '.' ogz '.' ogn '.' ogf '.' ogp '.' ext
   if ~q_outs & ext="OUT" then do
       PutLog('Skipping 'outfile);Iterate
   end
   xtype=left(ext,1)
   if xtype="C" then flonode.i.pri=DTPRI_CRASH
   else if xtype="H" then flonode.i.pri=DTPRI_HOLD
   else if xtype="D" then flonode.i.pri=DTPRI_DIRECT
   else if xtype="N" then flonode.i.pri=DTPRI_NORM
   else if xtype="O" then flonode.i.pri=DTPRI_NORM
   else do
       call PutLog('ERROR: cannot queue 'outfile);Iterate
   end
       call PutLog('Moving 'outdir||outfile' to 'QDIR)
       newfullname=QDIR||Get_fn(outdir||outfile)
       call rename(outdir||outfile,newfullname)
       call addwork(ogd'#'ogz':'ogn'/'ogf'.'ogp,newfullname "D" flonode.i.pri)
end  
call close('outs')
call delete("T:outfile.list")
return

addwork:
site_address=arg(1)
qaz=space(arg(2),1)
parse var qaz file disposition priority
PutLog('Addwork:'site_address file disposition priority)
parse var site_address td '#' tz ':' tn '/' tf '.' tp
if file=""|~(exists(file)) then do
   PutLog('Cannot find ['file']'); return 1
end
file=upper(file)
select
   when disposition="D" then flags=XQ_DELETE
   when disposition="T" then flags=XQ_TRUNCATE
   when disposition="L" then flags=XQ_NOTHING
   otherwise flags=XQ_NOTHING
end
select
   when priority>30 then priority=DTPRI_CRASH
   when priority>0 then priority=DTPRI_DIRECT
   when priority=0 then priority=DTPRI_NORM
   when priority=-50 then priority=DTPRI_HOLD
   otherwise priority=DTPRI_CRASH
end
if right(file,4)=".CUT"|right(file,4)=".DUT"|right(file,4)=".HUT"|right(file,4)=".OUT" then do
   sendas=get_packetname()
   flags=XQ_DELETE
end;else do
   call PutLog(file 'not processed');return 0
end

site=td||"#"||tz||":"||tn||"/"||tf||"."||tp
cfgaddress=GetClip('HOST.ADDRESS.'||myaddress.domain)
parse var cfgaddress myaddress.zone ":" myaddress.net "/" myaddress.node "." myaddress.point
site_address=XfqGetAddress(site)
QUERY.XQ_NAME=file
QUERY.XQ_SITE=site_address
work=NULL
work=XfqFindWork(QUERY)
if work=NULL then do
    PutLog("File "file" not in site queue, adding")
    XfqAddWorkQuick(site,file,sendas,priority,flags)
end;else do
    PutLog("File "file" already queued")
    call XfqUnlockWork(work)
end
call XfqFlushQueue(site_address)
call XfqDropObject(site_address)
  if work ~=NULL then call XfqDropObject(work)
call XfqClose()
return

cleanxq:
    sitelist=XfqGetSiteList()
    call XfqWalkSession(sitelist,sitearray)
    call PutLog("There are "sitearray.numentries" sites in the queue")
    do loop=1 to sitearray.numentries
        addrtags.XQ_Mandatory=511
        addrtags.XQ_Optional=511
        System=XfqPutAddress(sitearray.loop,addrtags)
        call XfqWalkQueue(sitearray.loop,thestem)
        call PutLog("There are "thestem.NUMENTRIES" files for "System)
        do i=1 to thestem.NUMENTRIES
            call PutLog("Sending "thestem.i.NAME" as "thestem.i.ASNAME" at priority "thestem.i.PRI) 
            if ~EXISTS(thestem.i.NAME) then do
                call PutLog("File "thestem.i.NAME" does not exist")
                FINDIT.XQ_NAME=thestem.i.NAME
                FINDIT.XQ_SITE=sitearray.loop
                work=XfqFindWork(FINDIT)
                if(work=NULL) then call PutLog("Someone got to it before us!")
                else call XfqRemoveWork(work)
            end
        end
    end
    call XfqDropObject(sitelist)
    call XfqClose()
return thestem.NUMENTRIES

get_packetname:
if ~open('out',"CFG:packet_spec",'R') then call PutLog("Can't read packet_spec file")
else do
   packet_spec=readln('out')
   close('out')
end
tspec=left(date(),2)||compress(time(),":")
if (tspec=packet_spec) then tspec=tspec+1
do while exists(outdir||""||tspec".PKT")
   tspec=tspec+1
end
if ~open('out',pktspec,'W') then call PutLog("Can't write new packet_spec file")
else do
   writeln('out',tspec)
   close('out')
end
return(tspec||".PKT")

get_fn: procedure
if LastPos('/', arg(1)) ~=0 then return SubStr(arg(1), LastPos('/', arg(1)) + 1)
else if LastPos(':', arg(1)) ~=0 then return SubStr(arg(1), LastPos(':', arg(1)) + 1)
else return arg(1)

find_domain: procedure expose dl
dz=FIND(dl,arg(1))
if dz=0 then return GetClip('DOMAIN')
else return strip(word(dl,dz-1))

drop_vars:
drop tonode. flonode. hisaddress. work err line
drop flofileadr site site_address i file pktname floname sendas flags disposition priority
return 0

PutLog: procedure expose log script
if log then address 'ROOFLOG' 'logline' left(time(),5) script': 'arg(1)
else say arg(1)
return 0

addslash:
curr=arg(1)
select
when right(curr,1)=":" then nop
when right(curr,1)="/" then nop
otherwise curr=curr||"/"
end
return curr

dequote: procedure
parse arg thing
parse var thing '"' unq_thing '"'
if unq_thing ~="" then return unq_thing
return thing

break_c:
break_d:
call cleanup()
PutLog('User Aborted')
exit 0
novalue:
call template_oops "Novalue" sigl
syntax:
call template_oops "Syntax(RC=" || RC || ")" sigl RC
failure:
call template_oops "Failure(RC=" || RC || ")" sigl
ioerr:
call template_oops "IOErr(RC=" || RC || ")" sigl
halt:
call template_oops "Halt" sigl
template_oops:
parse arg what badline code
if code~="" then call PutLog("ERROR LINE:"badline errortext(code))
else call PutLog("ERROR LINE:"badline what)
cleanup:
call XfqClose()
if ~debug then do
call delete('T:flofile.list')
call delete('T:outfile.list')
call delete('T:out.temp')
end
exit(40)
