/**/
v="$VER: AddWork Rexx    XferQ   Williamson 53.12"
/*  ADDWORK SITEADDRESS FULLPATHNAME DISPOSITION PRIORITY */
options results
options failat 20
signal on syntax  
signal on halt
signal on ioerr
signal on break_c
signal on break_d
parse arg site_address file disposition priority queuectl
IF ARG()=0 THEN SIGNAL USAGE
sv='v'||right(v,5)
script='AddWork'
log=show('P','ROOFLOG')
if ~show("L", "xferq.library") then
if ~addlib("xferq.library", 0, -30, 0) then
do
PutLog("Couldn't access xferq.library !",10,10)
exit 20
end
XQ_NOTHING     =0
XQ_DELETE      =1
XQ_TRUNCATE    =2
XQ_IMMEDIATE   =4
XQ_SENDLATER   =8
DTPRI_CRASH    =50
DTPRI_DIRECT   =30 
DTPRI_NORM     =0
DTPRI_HOLD     =-50

wspec='RAW:0/10/640/100/ROOF 'script sv'/INACTIVE/AUTO/SCREEN'||GetClip('SCREEN')
call close('STDOUT') ; call open('STDOUT',wspec,'W')  
call close('STDIN')  ; call open('STDIN','*','R')
call myadr
PutLog(site_address file disposition priority queuectl,70,70)
if datatype(site_address,"MIXED") then isftn=0
else do 
site_address=make5d(site_address)
isftn=1
end
if site_address=0 then return
if file="" | ~(exists(file)) then
do
PutLog('Cannot find ['file']',10,10)
return 1
end
file=upper(file)
select
when upper(disposition)="D" then flags=XQ_DELETE
when upper(disposition)="T" then flags=XQ_TRUNCATE
when upper(disposition)="L" then flags=XQ_NOTHING
otherwise flags=XQ_NOTHING
end
if upper(queuectl)="A" then queuectl=XQ_SENDLATER
else if upper(queuectl)="I" then queuectl=XQ_IMMEDIATE
else queuectl=XQ_NOTHING
select
when priority > 50 then nop
when priority > 30 then priority=DTPRI_CRASH
when priority > 0 then priority=DTPRI_DIRECT
when priority = 0 then priority=DTPRI_NORM
when priority = -50 then priority=DTPRI_HOLD
otherwise priority=DTPRI_CRASH
end
added=0
if ~isftn then do
sendas=get_fn(file)
site=site_address
end;else do
if right(file,4)=".CUT" | right(file,4)=".DUT" | right(file,4)=".HUT" | right(file,4)=".OUT" then do
sendas=get_packetname()
flags=XQ_DELETE
end
else if right(file,4)=".PKT" | right(file,4)=".TIC" then do
sendas=get_fn(file)
flags=XQ_DELETE
end;else do
parse var file td'.'tz'.'tn'.'tf'.'tp'.'ext .
if ext ~= "" then call addarcmail
else do
parse var file tz'.'tn'.'tf'.'tp'.'ext .
if ext ~= "" then call addarcmail
else do
sendas=get_fn(file)
end
end
drop td tz tn tf tp ext tmpext j 
end
site=hisaddress.domain||"#"||hisaddress.zone||":"||hisaddress.net||"/"||hisaddress.node||"."||hisaddress.point
end

site_address=XfqGetAddress(site)
QUERY.XQ_NAME=file
QUERY.XQ_SITE=site_address
work=NULL
work=XfqFindWork(QUERY)
if work=NULL then
do
PutLog("File "file" not in "site" queue, adding",60,10)
XfqAddWorkQuick(site,file,sendas,priority,flags+queuectl)
added=1
end
else do
PutLog("File "file" already queued for "site,60,10)
if work ~= NULL then call XfqUnlockWork(work)
end
call XfqFlushQueue(site_address)
call XfqDropObject(site_address)  
if work ~= NULL then 
do
call XfqDropObject(work)  
    if isftn then call PutLog('Queued 'file' as 'sendas' for 'hisaddress.zone':'hisaddress.net'/'hisaddress.node'.'hisaddress.point' Pri:'priority 'Dsp:'flags+queuectl,10,10)
    else call PutLog('Queued 'file' as 'sendas' for 'site_address' Pri:'priority 'Dsp:'flags+queuectl,10,10)
end
call XfqClose()
exit
addarcmail:
tmpext=upper(left(ext,2))
if datatype(right(ext,1),'n') & (tmpext="MO" | tmpext="TU" | tmpext="WE" | tmpext="TH" | tmpext="FR" | tmpext="SA" | tmpext="SU")  then 
do
sendas=UPPER(d2x(65536+myaddress.net-tn,4)||d2x(65536+myaddress.node-tf,4)||'.'ext)
flags=XQ_DELETE
end
return
get_packetname:
if ~open('out',"CFG:packet_spec",'R') then call PutLog("Can't read packet_spec file",70,10)
else DO
packet_spec=readln('out')
close('out')
END
tspec=left(date(), 2) || compress(time(), ":")
if (tspec=packet_spec) then tspec=tspec+1
do while exists(BUNDLES||tspec".PKT") 
tspec=tspec + 1   
end   
if ~open('out',"CFG:packet_spec",'W') then call PutLog("Can't write new packet_spec file",10,10)
else DO
writeln('out',tspec)
close('out')
END
return(tspec||".PKT")
get_fn:
if LastPos('/', arg(1)) ~= 0 then return SubStr(arg(1), LastPos('/', arg(1)) + 1)
else if LastPos(':', arg(1)) ~= 0 then return SubStr(arg(1), LastPos(':', arg(1)) + 1)
else return arg(1)
make5d: 
a=strip(arg(1))
select
when index(a, "#") > 0 then parse var a hisaddress.domain "#" hisaddress.zone ":" hisaddress.net "/" hisaddress.node "." hisaddress.point
when index(a, ":") > 0 then parse var a hisaddress.zone ":" hisaddress.net "/" hisaddress.node "." hisaddress.point
when index(a, "/") > 0 then parse var a hisaddress.net "/" hisaddress.node "." hisaddress.point
when index(a, ".") > 0 then parse var a hisaddress.node "." hisaddress.point
when left(a, 1)="." then parse var a "." hisaddress.point
otherwise parse var a hisaddress.node .
end
call myadr    
if hisaddress.point="" | hisaddress.point='HISADDRESS.POINT' then hisaddress.point="0"
if hisaddress.net  ="" | hisaddress.net  ='HISADDRESS.NET'   then hisaddress.net  =myaddress.net
if hisaddress.node ="" | hisaddress.node ='HISADDRESS.NODE'  then hisaddress.node =myaddress.node
if hisaddress.zone ="" | hisaddress.zone ='HISADDRESS.ZONE'  then hisaddress.zone =myaddress.zone
if hisaddress.domain="" | hisaddress.domain ='HISADDRESS.DOMAIN' then hisaddress.domain=find_domain(hisaddress.zone)
drop a
return(hisaddress.domain'#'hisaddress.zone':'hisaddress.net'/'hisaddress.node'.'hisaddress.point)
myadr:
def_domain=GetClip('DOMAIN')
myaddress.domain=GetClip('DOMAIN')
cfgaddress=GetClip('HOST.ADDRESS.'||myaddress.domain)
parse var cfgaddress myaddress.zone ":" myaddress.net "/" myaddress.node "." myaddress.point
myaddress.pointnet=GetClip('POINTNET')
return(myaddress.zone':'myaddress.net'/'myaddress.node'.'myaddress.point)
find_domain:
dl=GetClip('DOMAINLIST')
dz=FIND(dl,arg(1))
if dz=0 then return def_domain
else return strip(word(dl,dz-1))
PutLog:  procedure expose log script
say arg(1)
if log then address 'ROOFLOG' 'logline' left(time(),5) script': 'arg(1)
return 0
cleanup:
call XfqClose()
return 0
break_c:
break_d:
PutLog('User Abort',10,10)
call cleanup
exit 10
novalue: 
call template_oops "Novalue" sigl
syntax:
call template_oops "Syntax(RC=" || RC || ")" sigl RC
failure:
call template_oops "Failure(RC=" || RC || ")" sigl
ioerr:
call template_oops "IOErr(RC=" || RC || ")" sigl 
halt:
call template_oops "Halt" sigl 
template_oops: 
parse arg what badline code
if code~="" then call PutLog("ERR:"what "Line:"badline errortext(code),10,60)
else PutLog("ERR:"what "Line:"badline,10,10)
call cleanup
exit(40)
USAGE:
SAY "    ADDWORK site_address fullname disposition priority queuectl"
SAY "    disposition: D=delete"
SAY "                 T=truncate to zero bytes"
SAY "                 L=do nothing    (default)"
SAY "    priority:    (-128 to +128)  (default 50)"
SAY "    queuectl:    I=queue only if connected to site"
SAY "                 A=queue after current session with site"
SAY ""   
SAY "   if file is *.?UT then it will be sent as a *.PKT"
SAY "   if file is ARCmail, sendas name will be created"
SAY "   Both default to disposition=D and priority 50"
RETURN
