 /* Checkexists.rexx 
  *
  *  Simple script to demonstrate a few interesting uses of XferQ by
  *  showing how to remove any work nodes in the database that point to files
  *  that no longer exist.
  *
  * Uses xferq.library by David Jones (aa457@freenet.carleton.ca)
  *
  * Russell McOrmond   rmcormon@ccs.carleton.ca aa302@freenet.carleton.ca 
  * FidoNet 1:163/109  Net Support: (613) 230-2282  WPL Support  1:1/139 
  *
  */

 Options RESULTS
 Options failat 100

 /* Create a stem for all the nodes who have work */
 sitelist=XfqGetSiteList()
 call XfqWalkSession(sitelist,sitearray)

 say "There are "sitearray.numentries" sites in the queue"

 /* Now we'll iterate through them all */
 do loop = 1 to sitearray.numentries

   /* As we loop, we remember that we don't 'own' the sitearray.loop 
      pointer to the address.  Do not do a DROP on that object! */

   /* I want full 5-D addresses shown here! */
   addrtags.XQ_Mandatory = 511 /* XQADDR_ANYTHING */
   addrtags.XQ_Optional = 511  /* XQADDR_ANYTHING */
   System = XfqPutAddress(sitearray.loop,addrtags)
  
   /* Create a stem for all the work nodes.  All the stem extensions
      that XfqExamObject understands will be set up! */
   call XfqWalkQueue(sitearray.loop,thestem)

   say ""
   say "There are "thestem.NUMENTRIES" files for "System
 
   /* now iterate through all the files */
   do i=1 to thestem.NUMENTRIES

     say "sending "thestem.i.NAME" as "thestem.i.ASNAME" at priority "thestem.i.PRI
 
     /* does the full pathname exist? */
     if ~EXISTS(thestem.i.NAME) then do
       say "File does not exist!"

       /* NOP - Let's find the work node */
       FINDIT.XQ_NAME = thestem.i.NAME
       FINDIT.XQ_SITE = sitearray.loop
       work = XfqFindWork(FINDIT)
       if(work=NULL) then say "Something is broken!"
       else do
         /* and remove the work from the Queue */
         call XfqRemoveWork(work)
         call XfqDropObject(work)
       end
     end
   end
 end
 /* Drop the sitelist */
 call XfqDropObject(sitelist)
 call XfqClose()
 Exit 0
