/**/
v="$VER: Scall Rexx  Shelter Poll Manager  Williamson 00.98"
sv=right(v,5);script='Scall'
options results
options failat 999
signal on syntax
signal on halt
signal on ioerr
signal on break_c
signal on break_d
shelter=GetClip("SHELTER")
if shelter="" then do;Say "No Shelter Mailer available";EXIT;end
ushelter=upper(shelter);lshelter=lower(shelter)
point=ushelter=="UMBRELLA"
pollwin=upper(Getclip('POLLWIN'))=="TRUE"

 parse arg args
 number=""
 line=""
 pri=""
 redialdelay=""
 duration=""
 crash=0;nopickup=0;manual=0
 template="Site_Address/A,LINE/K,NUMBER/K,PRI/K,REDIALDELAY/K,DURATION/K,CRASH/S,NOPICKUP/S"
 if ~ReadArgs(args,template) then do
    say Fault(RC,script)
    signal usage
 end;else do
    if site_address="?" then signal usage
    if pri~="" then call Pragma('p',pri)
    else call Pragma('p',-1)
    if number~="" then do
        man_number=number
        manual=1
    end 
    if line~="" then do
        requested_line=line
    end;else do
        if ushelter=="PORTICUS"|ushelter=="ROOF" then slave=2
        else slave=1
    end
    noclip=0
    if redialdelay="" then do
        redialdelay=GetClip('REDIALDELAY')
        noclip=1
    end
    if duration="" then duration=GetClip('CALLWINDOWMIN')

    bbs=0;fax=0;clock=0;uucp=0;ftn=0
    bbs    =left(upper(site_address),3)=="BBS"
    fax    =left(upper(site_address),3)=="FAX"
    clock  =(~fax & ~bbs & left(upper(site_address),5)="CLOCK")
    uucp   =(~fax & ~bbs &~clock) & (left(upper(site_address),2)=="UU" | datatype(right(site_address,2),'MIXED'))
    ftn    =(~bbs & ~fax & ~uucp & ~clock)
    if bbs | fax | clock then site_address=upper(site_address)
        else if uucp then site_address=delstr(site_address,1,2)
                else site_address=make5d(site_address)
    if site_address=0 then do
        call PutLog('BAD site_address',10,10)
        exit 10
    end
end
if point & (bbs|uucp|clock) then address=0
if site_address=0 then do
call PutLog('BAD site_address:'site_address);exit 10
end
cs=strip(GetClip("S"||site_address))
if datatype(cs)='NUM' then do
call PutLog('Already calling 'site_address' Status:['cs']');exit 10
end
x=Pragma('p',-1)
tadr=translate(site_address,"...","#:/")
if pollwin then do
polls=Getclip('POLLS')
if polls="" then polls=1
else polls=polls+1
call openwin('CON:0/'80+(polls*10)'/400/60/'script 'v'sv tadr'/AUTO/INACTIVE/CLOSE/SCREEN')
call SetClip('POLLS',polls)
end
docall=1 ; nocall=0 ; callcount=0 ; callok=0 ; retry=5 ; exitcall=10 
if bbs then  call PutLog('Polling BBS 'site_address' on line' slave)
else if clock then call PutLog('Polling 'site_address' on line' slave)
else if uucp then call PutLog('Polling UUCP Site 'site_address' on line' slave)
else do
    call PutLog('Polling 'dd'#'z':'n'/'f'.'p 'on line' slave)
    outdir=GetClip('OUTDIR')'/'
    if exists(outdir||z'.'n'.'f'.'p'.REQ') then do
        address COMMAND 'Copy 'outdir||z'.'n'.'f'.'p'.REQ' outdir||z'.'n'.'f'.'p'.REQTEMP'
    end
end
if manual then call PutLog('Manual Poll 'man_number)
callstart=time('n');callcount=0
dial_from=time('s');df=left(callstart,5)
dial_till=dial_from+(duration*60);dt=dial_till%(60*60)':'right('0'||strip(left(dial_till//(60*60)/60,2),T,'.') ,2)

call PutLog(site_address' Poll Window: 'df'->'dt)
do while (time('s') < dial_till)
    if pollwin & eof('STDOUT') then leave
    callcount=callcount+1
    p_stat=GetClip("S"||site_address)
    call SetClip("S"||site_address,callcount)
    if p_stat='abort' then do
        call PutLog('User aborted poll to 'site_address' at 'left(time(),5)' on call 'callcount)
        call SetClip("S"||site_address,'USER ABORT')
        call callcleanup;return(exitcall)
    end
    d_stat=do_dial()
    if d_stat=exitcall then do
        call PutLog('Poll of 'site_address' terminated')
        call callcleanup;return 0
    end
    if d_stat=callok then do
        call SetClip("S"||site_address,'OK')
        call PutLog('Poll of 'site_address' completed')
        call callcleanup;return 0
    end
end
if ~EOF('STDOUT') then call PutLog('Exceeded 'duration' min. call window for 'site_address', callcount:'callcount)
else do
    call PutLog('Poll of 'site_address' aborted')
    call SetClip("S"||site_address,'abort')
end
call callcleanup
Return 0

do_dial:
if ~show('p',ushelter||slave) then do
PutLog(ushelter||slave 'is not active');return(exitcall);end
Address VALUE ushelter||slave
'String $(state)'
ws=RESULT
call Putlog(ushelter||slave 'state:'ws)
wstat=upper(word(ws,1))
select
when wstat='EXITING' then do
    call PutLog('Exiting, aborting dial 'site_address);return(exitcall)
end
when wstat='SESSION' then do
    if find(upper(ws),upper(site_address))=0 then call PutLog('Queuing dial of 'site_address)
    else do
        call PutLog('Aborting call, already 'wstat site_address);return(exitcall)
    end
end
when wstat='DIALING' then do
    if find(upper(ws),upper(site_address)) ~=0 then
    do
        call PutLog('Aborting call, already 'wstat site_address);return(exitcall)
    end
end
otherwise nop
end
call PutLog('Dialing 'site_address)
Address VALUE ushelter||slave
if manual then 'Set number' man_number 'MANUAL TRUE'
if ftn & crash then 'Set CRASH TRUE'
if ftn & nopickup then 'Set NOPICKUP TRUE'
'Call '||site_address
welstat=RC
if ~noclip then redial_delay=GetClip('REDIALDELAY')
select
when welstat=0 then do
    call PutLog(site_address' OK on 'callcount);return(callok)
end
when welstat=1 then do
    call PutLog(site_address' OWNDEVUNIT HAS LINE on 'callcount);return(retry)
end
when welstat=5 then do
    call PutLog(site_address' BUSY on 'callcount)
    call redial_pause(GetClip('BUSYDELAY'));return(retry)
end
when welstat=6 then do
    call PutLog(site_address' NO NUMBER TO CALL on 'callcount);return(exitcall)
end
when welstat=7 then do
    call PutLog(site_address' CALL FORWARDED on 'callcount);return(exitcall)
end
when welstat=10 then do
    call PutLog(site_address' NO MODEM FOUND on 'callcount);return(exitcall)
end
when welstat=11 then do
    call PutLog(site_address' NO CARRIER on 'callcount)
    call redial_pause(redialdelay)
    return(retry)
end
when welstat=12 then do
    call PutLog(site_address' MODEM RESPONSE TIMEOUT on 'callcount)
    call redial_pause(redialdelay)
    return(retry)
end
when welstat=15 then do
    if GetClip('IGNORENOANSWER')='FALSE' then do
        call PutLog(site_address' EXIT BADLINE on 'callcount);return(exitcall)
    end;else do
        call PutLog(site_address' RETRY BADLINE on 'callcount)
        call redial_pause(redialdelay)
        return(retry)
    end
end
when welstat=99 then do
    call PutLog(site_address' EXIT BADHANDSHAKE on 'callcount);return(exitcall)
end
otherwise do
    call PutLog('Call 'callcount' to 'site_address' Status: 'welstat);return(exitcall)
end
end
PutLog('ERROR: FallThru Call 'callcount' to 'site_address' Status: 'welstat);return(retry)
redial_pause:
call PutLog('Waiting 'arg(1)' Secs Call:'site_address)
call delay(arg(1)*50)
return 0
callcleanup:
call PutLog('Removing 'site_address' from dial queue')
call SetClip("S"||site_address,"")
return 0
make5d: procedure expose dd z n f p
da=arg(1)
select
when index(da, "#") > 0 then parse var da dd "#" z ":" n "/" f "." p
when index(da, ":") > 0 then parse var da z ":" n "/" f "." p
when index(da, "/") > 0 then parse var da n "/" f "." p
when index(da, ".") > 0 then parse var da f "." p
when left(da, 1)="." then parse var da "." p
otherwise parse var da f .
end
myaddress.domain=GetClip('DOMAIN')
cfgaddress=GetClip('HOST.ADDRESS.'||myaddress.domain)
parse var cfgaddress myaddress.zone ":" myaddress.net "/" myaddress.node "." myaddress.point
if p=""|p='P' then p='0'
if n=""|n='N' then n=myaddress.net
if f=""|f='F' then f=myaddress.node
if z=""|z='Z' then z=myaddress.zone
if dd=""|dd='DD' then do
dl=GetClip('DOMAINLIST');dd=0;x=find(dl,z)
if x~=0 then dd=word(dl,x-1)
else dd=myaddress.domain
end
if ~datatype(z,'n')|~datatype(n,'n')|~datatype(f,'n')|~datatype(p,'n') then
do
call PutLog('make5d: Invalid address ['da']')
drop da;return 0
end
drop da
return(dd'#'z':'n'/'f'.'p)

openwin:
call close('STDOUT')
call open('STDOUT',arg(1)||GetClip('SCREEN'),'W')
call close('STDIN')
call open('STDIN','*','R')
return

lower:
return(bitor(arg(1),'20'x))

PutLog: procedure expose lshelter ushelter slave pollwin
address 'LOGPROC' 'PutLog 'lshelter'wpl' time() ushelter||slave': 'arg(1)
if pollwin then say arg(1)
return 0

PutStatus: procedure expose lshelter slave
address 'LOGPROC' 'Putline 'lshelter'wplstat'||slave arg(1)
return 0

break_c:
break_d:
call callcleanup()
PutLog('User Aborted 'what where)
cleanup:
exit 0
novalue:
call template_oops "Novalue" sigl
syntax:
call template_oops "Syntax(RC=" || RC || ")" sigl RC
failure:
call template_oops "Failure(RC=" || RC || ")" sigl
ioerr:
call template_oops "IOErr(RC=" || RC || ")" sigl
halt:
call template_oops "Halt" sigl
template_oops:
parse arg what badline code
if code~="" then call PutLog("ERROR LINE:"badline errortext(code))
    else call PutLog("ERROR LINE:"badline what)
exit(40)

usage:
    say "Usage: Scall" 
    say "     "template
    say "       Site_Address    FTN-  [domain#][z:][net/]node[.p] CLOCK- clock<n>"
    say "                       UUCP- uu<site> FAX- fax_<site> BBS- bbs_<site>"
    say "       Number          phone number when manual dialing"
    say "       Line            modem line to use for dialing"
    say "           DEFAULT "def_line
    say "       Pri             task priority for poll"
    say "           DEFAULT -1"
    say "       RedialDelay     number of seconds to wait between dials"
    say "           DEFAULT "GetClip('REDIALDELAY')
    say "       Duration        number of minutes to attempt connection"
    say "           DEFAULT "GetCLip('CALLWINDOWMIN')
    say "   Switches"
    say "       crash           send crash mail only"
    say "       nopickup        do not accept inbound files"
    say
