; This file is an example SuperDiskCopy PRO/SuperLabeler Label File (.sl).
; All options and parameters are described here.  See the manual
;   for further details.
; To look at the output this file generates, type 'sl example.sl prn'.
; This assumes your printer is on and connected to the printer port.
; Alternatively, labels can be printed during diskette duplication with
;   SuperDiskCopy PRO.

; An SuperLabeler Label File consists of any combination of:
;       label lines
;       comments 
;       command keywords
;       in-label keywords
;       printer control code sequences (See your printer manual for details.)


; Any text after a ';' is ignored (use for comments).
; Blank lines are ignored.
; Any other line that DOESN'T start with a   @ ; . <   will be an error.
; Maximum line length is 1024.

; Label file for SuperDiskCopy PRO Full System Disk.

;***************************************************************************
; These are command keywords.  A command keyword must start with
;   an '@' in the first column of a line.  One keyword per line only.
; The letters in keywords can be upper and/or lower case.
; Multiple keywords on a line are ignored.
; The equal sign ('=') assigns a value to a keyword.  Spaces after an
;   equal sign are significant.
; NOTE: snfile, snlist and pause are not supported by SuperDiskCopy PRO.

@copies=1               ;number of identical copies (makes 1 set).
                        ; Default 1, maximum 32767.
@s/n=SDC32000000         ;serial number of first label set. Default is 0.
                        ; SuperDiskCopy PRO S/N option will override this
                        ; keyword.
                        ;Using 'SL.EXE filename.sl' from the command line 
                        ;will start the label serialization with the number
                        ;indicated for @s/n=.  Within SDCP.EXE, and if no
                        ;serial list file exists (*.ser), Utility/Find Serial
                        ;will search for the beginning serial number on the 
                        ;master disk which is generally the same number as
                        ;indicated in the 'filename.sl' file as @s/n=????? 
                        ;and will make the first copy with a number one greater
                        ;than that found on the original master disk.
@snfile=a:serial.ssw    ; Has no effect when running SuperDiskCopy PRO and using
                        ; this label definition file.  When specified, a file
                        ; containing the current serial number will be written
                        ; to disk drive and  file name specified.  The serial
                        ; number will be placed into this file.  If the file
                        ; already exists, it will be overwritten.  Meant for
                        ; serializing diskettes.  With SL.EXE, this is the
                        ; filename and extension that will be created on
                        ; floppy disk as labels are printed for each disk.
                        ; The @snfile= is not used during execution of
                        ; SuperDiskCopy PRO.  The last serial number within the
                        ; indicated by @snlist= will be incremented by 1 and
                        ; written to the specified @snfile= file as well as
                        ; appended to @snlist=.
@snlist=c:serial.ser    ;when specified, the serial number will be apppended
                        ; into this file.  If the file doesn't already exist,
                        ; it will be created, otherwise the serial number
                        ; is appended.  Meant for keeping a list of serial
                        ; numbers that were printed.  When this file exists,
                        ; the last serial number, plus 1 is used as the
                        ; starting point for the next serial number.  To 
                        ; eliminate confusion, always use the .SER extension.
@pause=on               ;causes a pause before printing a label set.
@output=lpt1            ;specify port, file, screen.  Default is 'prn'.
                        ; '@output=con:' specifies to screen
                        ; '@output=filename.ext' specifes to file filename.ext
@labels=1              ;number of label sets to print, default is 1, max 32767.
                        ; @labels is IGNORED when label printed with SDCP
                        ; since 1 label set is printed for each disk copied.
@dtformat=mm-dd-ccyy    ;format for date field. No spaces allowed within format.
                        ;Defaults to mm/dd/ccyy. Max length is 32.
                        ; dd is date, mm is month, yy is year, cc is century
@date=07-01-1993        ;uses today's date when not specified.
                        ; OVERRIDES dtformat keyword. Max length is 32.
@time=12:00:00          ;uses current time when not specified. Max length is 8.
;***************************************************************************


;***************************************************************************
; These are in-label keywords.  All start with a '~' and are only valid
;   on a label line (see further below).
; CAUTION:  ANY characters directly after an in-label keyword are ignored
;           (up to the replacement length).  DON'T place additional keywords
;           or printer control codes directly after in-label keywords.
;
;   ~D is replaced with date - format selected by 'dtformat' keyword.
;   ~T is replaced with time.
;   ~S is replaced with serial number - selected by 's/n' keyword,
;       or from the SuperDiskCopy PRO serial number.  If this keyword
;       appears at the end of a line, pad the area with any character
;       so the total space is at least as long as the serial number.
;***************************************************************************


;***************************************************************************
; Any line that starts with a '<' is a printer control code line.
; Control code numbers must be listed in decimal and seperated by spaces.
; Control codes can also be interspersed within a form by surrounding
; the list of codes with '<' and '>'.  Codes do not take any space on the
; printed label, unless the code causes a blank space.
; The file 'EPSON.SL' lists some useful EPSON control code sequences.

<27 69> ;This code sequence tells an Epson compatible printer to print bold.
;***************************************************************************


;***************************************************************************
; Here is a typical label, 6 lines high by 34 columns wide.
; Every label line must start with a period.
; If printer control codes are interspersed within a label, alignment
;   of label areas should be thoroughly tested.

.  <27 45 1>SuperDiskCopy PRO (tm) V3.xx<27 45 0>      ; Underline on/off
.       Serial # ~SSSSSSSSS        ;
.Release: ~DDDDDDDDD Time: ~TTTTTTT;
.(C)opyright 1988-93 SuperSoftWare;
.        FULL SYSTEM DISK          ;
.                                  ;

;***************************************************************************

<27 70> ;This code sequence tells an Epson compatible printer to turn off bold.
