/*                               MLV
                        (Multiple List Viewer)
                                 v0.3
                           By Bill Esposito
                          The Cereal Port BBS
                               1:132/152
                             (603)899-3335

                            Magic name 'MLV'
                           for latest version

***********************************************************************
DISCLAIMER:  This software is provided "AS IS" without any warranty of
any kind, either expressed or implied.  USE IT AT YOUR OWN RISK.

Copyright 1993 by Bill Esposito.  This program is FREEWARE, just let me
know how you like it.
***********************************************************************
                                           
The Multiple List Viewer was written specifically to interface with the national
USBBS list published by Darwin, or any 80 column ASCII text file.

Put MLV.CMD in your Max directory, and put the text files anywhere you want
them, just be sure to define them below.

Modify your Max Menu.ctl file as follows:

     Xtern_Run Maxpipe.exe_%P_MLV.CMD   normal  "Text Database"

Your users will be presented with up to five (5) selections.  They may either
perform a text search, or display the entire file.

To configure MLV, you must define some variables, and comment/uncomment some
lines.

In order to comment out (REM) a line in REXX, you must precede the line with the 
characters:  /*
You must also CLOSE the remark with these characters:  */
example:

/*   This is a REXX Remark  */

Read through the program and follow the instructions.

*/
l=1
y=1
/*  YOU CAN DEFINE UP TO 5 TEXT FILES FOR YOUR DATABASE                     */

file1='g:\max\mlv\sample.lst'       /* enter the full drive, path and filename                                    
                                        of the 1st selection */                                       
file2='drive:\path\filename.ext'    /* enter the full drive, path and filename
                                       of the 2nd selection */                 
file3='drive:\path\filename.ext'    /* enter the full drive, path and filename
                                        of the 3rd selection */
file4='drive:\path\filename.ext'     /* enter the full drive, path and filename
                                        of the 4th selection */
file5='drive:\path\filename.ext'     /* enter the full drive, path and filename
                                        of the 5th selection */


'@echo off'
call RxFuncAdd 'SysloadFuncs','RexxUtil','Sysloadfuncs'
call sysloadfuncs

menu:
/* ansi on */
cls
noclr:
say '[1;36m'
say '               [33m    Multiple List Viewer'
say '             [32m             v0.3'
say '                [35m     by Bill Esposito'
say
say '             [32m    '
say ''

/*  YOU SHOULD NOW DEFINE THE TITLES OF YOUR SELECTIONS.  MAKE SURE THAT THE
    SELECTION NUMBERS CORRESPOND TO THE TEXT FILE NUMBERS DEFINED ABOVE      */

say '              1.  Darwin USBBS List'
say
/* say '              2.  BLANK  '*/ 
/* say                            */
/* say '              3.  BLANK  '*/  
/* say                            */
/* say '              4.  BLANK  '*/ 
/* say                            */
/* say '              5.  BLANK  '*/ 
/* say                            */
say '              Q.  Quit back to BBS'
pull todo
if todo=Q then exit
/*  NEXT, GO TO THE END OF THE FILE AND DEFINE THE HEADERS                */
if todo=1 then filesch=file1
if todo=2 then filesch=file2
if todo=3 then filesch=file3
if todo=4 then filesch=file4
if todo=5 then filesch=file5

if todo=1 then call find
if todo=2 then call find
if todo=3 then call find
if todo=4 then call find
if todo=5 then call find
call menu
/* find */
find:
count=0
i=0
cls
say '[1;36m'
say '               [33m    Multiple List Viewer'
say '             [32m             v0.3'
say '                [35m     by Bill Esposito'
say
say '             [32m    '
say ''
say
say'                 1. Search for text'
say
say'                 2. Display the entire file '
pull sd
if sd=2 then call read
if sd=1 then call search
call menu
search:
say
say 'What do you want to search for? (any text or numbers,[35m no wildcards[32m)'
say '                                (ex. "NH" "603" "Esposito" "Espo" "Cereal")'
say
pull what
if what='' then call menu
call sysfilesearch what, filesch, 'file.'
if todo=1 then call head1
if todo=2 then call head2
if todo=3 then call head3
if todo=4 then call head4
if todo=5 then call head5
return: 
do i=1 to file.0
say file.i
count = count + 1
if count=20 then call more1
end
say 'Press <enter> to continue'
pull enter
call menu
/* Read */
read: 
x=1
loop:
y='1'

newq = rxqueue('create')
oq = rxqueue('set',newq)
l=l+y
ok=stream(filesch,'c','open')
linein(filesch,1,0)
loop2:
do until x > 23
say ''linein(filesch)''
if lines(filesch)=''0'' then say 'Press the <ENTER> key to continue'
if lines(filesch)=''0'' then pull enter
if lines(filesch)=''0'' then call qdel
x=x+y
end
more:
  x=1
   say 'more? (Y,n)'
    pull yn
    if yn='N' then call qdel
     else
call loop2
call qdel
qdel:
call rxqueue 'delete',newq
call rxqueue 'set',oq 
ok=stream(filesch,'c','close')
call menu
more1:
say 'more? (Y,n)'
pull yn
if yn='N' then call menu
if todo=1 then call head1
if todo=2 then call head2
if todo=3 then call head3
if todo=4 then call head4
if todo=5 then call head5
return
/*     HEADER SECTION - The header will be displayed at the beginning of each
23 line screen.  If you do not want a header, just comment out the two (2)
'SAY' lines as shown for HEAD2: below.  You need only define/comment out the
header for the selections you've defined.  In otherwords, if you have only
three (3) of the five (5) selections enabled, then HEAD4 and HEAD5 need not
be touched.                                                                 */


head1:
say 'PHONE        STATE  CITY      SYSOP          T/S      |    NAME, FEATURES'
say '-------------------------------------------------------------------------'  
count = 0
return

head2:
/* say ''  Comment out the 2 'say' lines if you don't want a header displayed */
/* say '' */ 
count = 0
return

head3:
say 'Put your header title on this line for the 3rd selection                 '
say '-------------------------------------------------------------------------'  
count = 0
return

head4:
say 'Put your header title on this line for the 4th selection                 '
say '-------------------------------------------------------------------------'  
count = 0
return

head5:
say 'Put your header title on this line for the 5th selection                 '
say '-------------------------------------------------------------------------'  
count = 0
return
/* History
.2  Fixed Header Display problem
.3  Fixed 'Bad Arithmatic' error
*/
