UNIT ScanLZHFiles;
{$V-}
(* ----------------------------------------------------------------------
   Part of 4DESC - A Simple 4DOS File Description Editor
       and 4FF   - 4DOS File Finder

   (c) 1992, 1993 Copyright by David Frey,
                               Urdorferstrasse 30
                               8952 Schlieren ZH
                               Switzerland

   DISCLAIMER: This unit is freeware: you are allowed to use, copy
               and change it free of charge, but you may not sell or hire
               this part of 4DESC. The copyright remains in our hands.

               If you make any (considerable) changes to the source code,
               please let us know. (send a copy or a listing).
               We would like to see what you have done.

               We, David Frey and Tom Bowden, the authors, provide absolutely
               no warranty of any kind. The user of this software takes the
               entire risk of damages, failures, data losses or other
               incidents.


       Code created using Turbo Pascal 6.0 (c) Borland International 1990

   This unit provides the extraction of file names in .LZH files.

   ----------------------------------------------------------------------- *)

INTERFACE USES Dos, Globals;

PROCEDURE SearchInLZHFile(FileSpec: FileSpecArrayType; FileSpecs: BYTE;
                          VAR Dir: PathStr; VAR lhsearch: SearchRec);
PROCEDURE ShowCompLZHFileData(VAR search,lhsearch: SearchRec;VAR Path: PathStr;
                              csize: LONGINT);

VAR OldLHFileName: PathStr;

IMPLEMENTATION USES Objects, Drivers, StringDateHandling;

VAR LHFile       : FILE;

PROCEDURE SearchInLZHFile(FileSpec: FileSpecArrayType; FileSpecs: BYTE;
                          VAR Dir: PathStr; VAR lhsearch: SearchRec);

VAR i        : WORD;
    k, Dummy : BYTE;
    LHAFile  : NameExtStr;

BEGIN (* SearchInLZHFile *)
 Assign(LHFile,lhsearch.Name); Reset(LHFile,1);

 BlockRead(LHFile,Buffer^,BufSize,BytesRead); BufPtr := 2; FilePtr := 2;
 (* first 2 unknown bytes skipped *)
 REPEAT
  s := '';
  REPEAT
   s := s+Chr(ReadByte);
  UNTIL (Pos('-lh',s) > 0) OR (BufPtr > BytesRead);
  Dummy := ReadByte; Dummy := ReadByte; (* overread Method *)

  IF BufPtr <= BytesRead THEN
   BEGIN
    csize       := LONGINT(ReadByte) SHL 24 + LONGINT(ReadByte) SHL 16 + LONGINT(ReadByte) SHL 8 + ReadByte;
    Search.size := LONGINT(ReadByte) SHL 24 + LONGINT(ReadByte) SHL 16 + LONGINT(ReadByte) SHL 8 + ReadByte;
    Search.time := LONGINT(ReadByte) SHL 24 + LONGINT(ReadByte) SHL 16 + LONGINT(ReadByte) SHL 8 + ReadByte;
    Search.attr := ReadByte;
    Dummy := ReadByte; (* unknown 2 *)

    WITH Search DO
     BEGIN
      name  := ''; FOR i := 1 TO ReadByte DO name := name+DownCase(Chr(ReadByte));
     END;

    FOR k := 1 TO FileSpecs DO
     BEGIN
      FSplit(FileSpec[k],Path,name,ext);
      WHILE Length(name) < 8 DO name := name+' ';
      IF Ext = '' THEN Ext := '.   '
      ELSE
       WHILE Length(ext)      < 4 DO ext := ext+' ';

      i := Pos('*',name);
      IF  i > 0 THEN
       WHILE i <= 8 DO
        BEGIN
         name[i] := '?'; INC(i);
        END;

      i := Pos('*',ext);
      IF  i > 0 THEN
       WHILE i <= 4 DO
        BEGIN
         ext[i] := '?'; INC(i);
        END;
      FileSpec[k] := Path+name+ext;

      FSplit(Search.Name,Path,name,ext);
      WHILE Length(name) < 8 DO name := name +' ';
      IF Ext = '' THEN Ext := '.   '
      ELSE
       WHILE Length(ext)      < 4 DO ext := ext+' ';
      LHAFile:= Path+name+ext;

      i := 1;
      WHILE ((FileSpec[k][i] = '?') OR (FileSpec[k][i] = LHAFile[i])) AND
             (i<12) DO
       INC(i);

      IF ((ExactAttr AND (Search.Attr = Attr)) OR (NOT ExactAttr)) AND
          (FileSpec[k][i] = '?') OR (FileSpec[k][i] = LHAFile[i]) THEN
       ShowCompLZHFileData(search,lhsearch,Dir,csize);
     END;

    INC(BufPtr,csize); INC(FilePtr,csize);
    IF BufPtr > BufSize THEN
     BEGIN
      Seek(LHFile,FilePtr);
      BlockRead(LHFile,Buffer^,BufSize,BytesRead); BufPtr := 0;
     END;
   END;
 UNTIL BufPtr > BytesRead;

 Close(LHFile);
END; (* SearchInLZHFile *)

PROCEDURE ShowCompLZHFileData(VAR search,lhsearch: SearchRec;VAR Path: PathStr;
                              csize: LONGINT);

BEGIN
 IF BareOutput THEN
  Write(Output,Path,lhsearch.Name,' ')
 ELSE
  BEGIN
   IF FileCount = 0 THEN
    BEGIN
     WriteLn(Output); IF DoPage THEN TestForMoreMsg;
     WriteLn(Output,Path); IF DoPage THEN TestForMoreMsg;
    END;

   IF lhsearch.Name <> OldLHFileName THEN
    BEGIN
     DownString(lhsearch.Name); OldLHFileName := lhsearch.Name;

     InfoArray[0] := LONGINT(@lhsearch.Name);

     SizeStr := FormattedLongIntStr(lhsearch.Size,8);
     InfoArray[1] := LONGINT(@SizeStr);

     UnpackTime(lhsearch.Time,DateRec);
     Date := FormDate(DateRec); Time := FormTime(DateRec);
     InfoArray[2] := LONGINT(@Date);
     InfoArray[3] := LONGINT(@Time);

     AttrStr := '....';
     IF lhSearch.Attr AND Archive  = Archive  THEN AttrStr[1] := 'a';
     IF lhSearch.Attr AND Hidden   = Hidden   THEN AttrStr[2] := 'h';
     IF lhSearch.Attr AND SysFile  = SysFile  THEN AttrStr[3] := 's';
     IF lhSearch.Attr AND ReadOnly = ReadOnly THEN AttrStr[4] := 'r';
     InfoArray[4] := LONGINT(@AttrStr);

     FormatStr(s,'(%-12s   %8s '+DateTempl+' '+TimeTempl+' %4s)',InfoArray);
     WriteLn(Output,s); IF DoPage THEN TestForMoreMsg;
    END;

   InfoArray[0] := LONGINT(@search.Name);

   SizeStr := FormattedLongIntStr(search.Size,8);
   InfoArray[1] := LONGINT(@SizeStr);

   UnpackTime(search.Time,DateRec);
   Date := FormDate(DateRec); Time := FormTime(DateRec);
   InfoArray[2] := LONGINT(@Date);
   InfoArray[3] := LONGINT(@Time);

(*   AttrStr := '----';
   IF Search.Attr AND Archive  = Archive  THEN AttrStr[1] := 'a';
   IF Search.Attr AND Hidden   = Hidden   THEN AttrStr[2] := 'h';
   IF Search.Attr AND SysFile  = SysFile  THEN AttrStr[3] := 's';
   IF Search.Attr AND ReadOnly = ReadOnly THEN AttrStr[4] := 'o'
                                          ELSE AttrStr[4] := 'w';
   InfoArray[4] := LONGINT(@AttrStr);

   FormatStr(s,'+ %-12s  %8s '+DateTempl+' '+TimeTempl+' %4s',InfoArray); *)
   FormatStr(s,'+ %-12s  %8s '+DateTempl+' '+TimeTempl,InfoArray);
   WriteLn(Output,s); IF DoPage THEN TestForMoreMsg;

   INC(TotalSize,csize); INC(DirSize,csize);
   INC(TotalFileCount);  INC(FileCount);
  END;
END; (* ShowFileData *)

END.