(* ------------------------------------------------------------------------
  :Program.       Example
  :Contents.      Demonstrates use auf Nico Franois' powerpacker.library
  :Author.        Kai Bolay [kai] (C-Version by Nico Franois)
  :Address.       Hoffmannstrae 168
  :Address.       D-7250 Leonberg 1 (Germany)
  :Address.       UUCP: ...!cbmvax!cbmehq!cbmger!depot1!amokle!kai
  :Address.       FIDO: 2:247/706.3
  :History.       v1.0 [kai] long ago  (translated from C)
  :History.       v2.0 [kai] 22-Nov-91 (upated)
  :Copyright.     Freeware
  :Language.      Oberon
  :Translator.    AMIGA OBERON v2.12e, A+L AG
  :Remark.        Thanks to Nico for his great library
------------------------------------------------------------------------ *)

(*********************************
*                                *
*   powerpacker.library V35      *
*                                *
*   Release 2.0                  *
*                                *
*   (c) Mar 1991 Nico Franois   *
*                                *
*   Example.mod                  *
*                                *
*   This source is public domain *
*   in all respects.             *
*                                *
*********************************)

MODULE Example;

IMPORT
   pp: PowerPacker, e: Exec, io;
CONST
   file = "testfile";
VAR
   filestart: e.ADDRESS;
   filelen: LONGINT;
   err: LONGINT;
BEGIN
   filestart := NIL;
   io.WriteString ("Loading file...\n");

   err := pp.LoadData (file, pp.DecrPoint, LONGSET {}, filestart, filelen, NIL);
   IF err # pp.LoadOk THEN
      CASE err OF
      | pp.ReadErr: io.WriteString ("Error loading text file !\n");
      | pp.NoMemory: io.WriteString ("No memory to decrunch file !\n");
      | pp.PassErr: io.WriteString ("Incorrect password, loading aborted !\n");
      | pp.OpenErr: io.WriteString ("Can't open file !\n");
      | pp.UnknownPP: io.WriteString ("Crunched with unknown PP !\n");
      ELSE
         io.WriteString ("Unknown error !\n");
      END; (* CASE *)
   ELSE
      io.WriteString ("file in memory, using it...\n");

      (* file is loaded at 'filestart' and can now be used *)

      (* ... *)

      io.WriteString ("done, freeing file...\n");
   END; (* IF *)
CLOSE
   IF filestart # NIL THEN e.FreeMem (filestart, filelen); filestart := NIL END;

   io.WriteString ("exiting.\n");
END Example.
