{$M 16384,0,655360}

(* This is a test program for the TSUNT45.TPU unit *)

uses Dos
     {$IFDEF VER40}
     ,TSUNT45
     {$ENDIF}
     ;

procedure LOGO;
begin
  writeln;
  writeln ('TSUNT45 unit test by Prof. Timo Salmi, Sat 23-Jan-1993');
  writeln ('University of Vaasa, Finland, ts@uwasa.fi');
{$IFDEF VER40}
  writeln ('TP version 4.0');
{$ENDIF}
{$IFDEF VER50}
  writeln ('TP version 5.0');
{$ENDIF}
{$IFDEF VER55}
  writeln ('TP version 5.5');
{$ENDIF}
{$IFDEF VER60}
  writeln ('TP version 6.0');
{$ENDIF}
{$IFDEF VER70}
  writeln ('TP version 7.0');
{$ENDIF}
  writeln;
end;

(* Which Dos version *)
procedure TEST1;
begin
  writeln ('Dos version ', Lo(DosVersion), '.', Hi(DosVersion));
end;  (* test1 *)

(* Number of environment strings *)
procedure TEST2;
begin
  write ('The number of environment strings is ');
  writeln (EnvCount);
end;  (* test2 *)

(* Display environment strings *)
procedure TEST3;
var i : integer;
begin
  for i := 1 to EnvCount do writeln (EnvStr(i));
end;  (* test3 *)

(* Display a particular environment string *)
procedure TEST4;
var i : integer;
begin
  writeln ('Path is ', GetEnv('path'));
  Flush (output);
end;  (* test4 *)

(* The name of the current program *)
procedure TEST5;
begin
  writeln (ParamStr0);
end;  (* test5 *)

(* The expanded name of any program *)
procedure TEST6;
begin
  writeln (FExpand('anyprog'));
end;  (* test6 *)

(* Is the disk write verification on or off, cf MsDos verify command *)
procedure TEST7;
var yes : boolean;
begin
  GetVerify (yes);
  if yes then
    writeln ('System verify (read-after-write) flag is on')
    else
    writeln ('System verify (read-after-write) flag is off')
end;  (* test7 *)

(* Set the MsDos disk write verify flag, c.f. the MsDos verify command *)
procedure TEST8;
begin
  SetVerify (true);
  TEST7;
  SetVerify (false);
  TEST7;
end;  (* test8 *)

(* Return state of Ctr-Break checking in DOS *)
procedure TEST9;
var yes : boolean;
begin
  SetCBreak (false);
  GetCBreak (yes);
  if yes then writeln ('Crtl-Break checking is on')
    else writeln ('Crtl-Break checking is off');
  SetCBreak (true);
  GetCBreak (yes);
  if yes then writeln ('Crtl-Break checking is on')
    else writeln ('Crtl-Break checking is off');
end;  (* test9 *)

(* Main program: the tests *)
begin
  LOGO;
  TEST1;
  TEST2;
  TEST3;
  TEST4;
  TEST5;
  TEST6;
  TEST8;
  TEST9;
end.  (* tsunt45.tst *)
