program Tablerun;  {Calculate tables as Chi square}
   uses crt;

const
   LoProb   = 0.005;                                    {Mod. #1}
   HiProb   = 0.995;                                    {Mod. #1}
   OneThird = 1.0 / 3.0;

type
   KeyListType = string[4];
   FuncType    = function(Argument: real): real;

var
   ChiSq, Probability, Unused, CumDis   : real;
   LoChiSq, HiChiSq, Numer, Term, NormX : real;
   DegFreedom, Code                     : integer;
   OK                                   : boolean;
   CharFlag, Reply, Reply2              : char;
   FuncName                             : FuncType;

{$I ChiProb.PSL}
{$I GetKey.PSL}
{$I GetNumI.PSL}
{$I GetNumR.PSL}
{$I NormDis.PSL}
{$I Power.PSL}
{$I Root.PSL}

function GetProb(X: real): real;

begin
   if DegFreedom < 30 then
      GetProb := ChiProb(X, DegFreedom)
   else
      begin
         Term  := 2.0 / 9.0 / DegFreedom;
         Numer := Power(X / DegFreedom, OneThird) - 1.0 + Term;
         NormX := Numer / sqrt(Term);
         NormDis(0.0, 1.0, NormX, Unused, CumDis);
         GetProb := 1.0 - CumDis
      end
end;

{$F+}

function DeltaProb(X:real): real;

begin
   DeltaProb := GetProb(X) - Probability
end;

{$F-}

BEGIN
   clrscr;
   writeln('DoChiSq - Generate chi-square tables');
   writeln;
   repeat
      writeln('Degrees of freedom?');
      GetNumI(DegFreedom, CharFlag, Code)
   until
      (Code = 0) and (DegFreedom > 0);
   writeln;
   writeln('Which would you like to specify, C or P ?');
   writeln('   C - Chi-square');
   writeln('   P - Probability');
   write('Which one? ');
   GetKey('CcPp', Reply, Reply2);
   writeln(Reply);
   writeln;
   if (Reply = 'C') or (Reply = 'c') then
      begin
         repeat
            writeln('Value for Chi-square?');
            GetNumR(ChiSq, CharFlag, Code)
         until
            (Code = 0) and (ChiSq > 0.0);
         writeln('Probability = ', GetProb(ChiSq))
      end
   else
      begin
         repeat
            writeln('Value for Probability?');
            GetNumR(Probability, CharFlag, Code)
         until
            (Code = 0) and (Probability >= LoProb) and
                           (Probability <= HiProb);
         if DegFreedom < 40 then
            if DegFreedom < 9 then
               LoChiSq := 1.0E-6                        {Mod. #2}
            else
               LoChiSq := 0.05 * Power(DegFreedom, 1.6) {Mod. #2}
         else
            LoChiSq := DegFreedom / 2.0;                {Mod. #2}
         HiChiSq  := 2.0 * DegFreedom + 7.0;            {Mod. #2}
         FuncName := DeltaProb;
         Root(LoChiSq, HiChiSq, FuncName, ChiSq, OK);
         if OK then
            writeln('Chi-square = ', ChiSq)
         else
            writeln('Can''t converge on your answer.')
      end
END.
