(*****************************************************************************)
(*                                                                           *)
(*        filename        : XSTREAM.PAS                                      *)
(*        author          : Stefan Boether / Compuserve Id : 100023,275      *)
(*                                                 FidoNet :  2:243/91.331   *)
(*                                  Internet: 100023.275@CompuServe.COM      *)
(*        system          : BP 7.0 / DOS 5.0 / WIN 3.1                       *)
(*        changes         :                                                  *)
(*        when    what                                                who    *)
(*---------------------------------------------------------------------------*)
(*        09.09.92 Instead of TBufStream use TDosStream in MemoryStrm Stefc  *)
(*        01.01.93 Add TMemoryStream to "MemoryStrm" if DPMI present  Stefc  *)
(*        01.01.93 Also use "Seg0040" for Port-Access                 Stefc  *)
(*        03.01.93 Remove TMemStream                                  Stefc  *)
(*        03.01.93 Open DOS-Streams with another filemode             Stefc  *)
(*        31.01.93 Add the TFileStream & TSharedStream                Stefc  *)
(*****************************************************************************)
(*  Description :  Extended Stream access                                    *)
(*****************************************************************************)

UNIT  XStream;  {$D+,O+}

INTERFACE

USES  Dos, Objects;

TYPE  PPortStream = ^TPortStream;
      TPortStream = object( TStream )
        ThePort    : Integer;
        TimeOut    : Byte;
        OldTimeOut : Byte;
        constructor Init( APort:Integer; ATimeOut:Byte);
        destructor  Done; virtual;
        constructor Load( var S:TStream );
        procedure   Store( var S:TStream );
        function    GetTimeOut:Byte; virtual;
        procedure   SetTimeOut(B:Byte); virtual;
        function    InitPort:Boolean; virtual;
      end;

CONST Lpt1 = 1;
      Lpt2 = 2;
      Lpt3 = 3;
      Lpt4 = 4;

      Com1 = 1;
      Com2 = 2;

TYPE  PLptStream = ^TLptStream;
      TLptStream = object( TPortStream )
        constructor Init( APort:Integer; ATimeOut:Byte);
        constructor Load( var S:TStream );
        function    GetTimeOut:Byte; virtual;
        procedure   SetTimeOut(B:Byte); virtual;
        procedure   Write( var Buf; Count:Word ); virtual;
        function    InitPort:Boolean; virtual;
      end;

      PComStream = ^TComStream;
      TComStream = object( TPortStream )
        ComParam  : Byte;
        constructor Init( APort:Integer; ATimeOut:Byte;
                          ABaud:Word; AData:Byte; AParity:Char; AStop:Byte);
        constructor Load( var S:TStream );
        procedure   Store( var S:TStream );
        function    GetTimeOut:Byte; virtual;
        procedure   SetTimeOut(B:Byte); virtual;
        procedure   Write( var Buf; Count:Word ); virtual;
        function    InitPort:Boolean; virtual;
      end;

      PNulStream = ^TNulStream;
      TNulStream = object( TStream )
        Size : LongInt;
        constructor Init;
        function    GetSize: LongInt; VIRTUAL;
        function    GetPos: LongInt; VIRTUAL;
        constructor Load( var S:TStream );
        procedure   Store( var S:TStream );
        procedure   Write( var Buf; Count:Word ); virtual;
      end;

      PCRCStream = ^TCRCStream;
      TCRCStream = OBJECT(TNulStream)
         CRC: Word;
         CONSTRUCTOR Init;
         FUNCTION    GetCRC: LongInt; VIRTUAL;
         PROCEDURE   Write(VAR Buf; Count: Word); VIRTUAL;
      END;

      PXmsStream   = ^TXmsStream;
      TXmsStream   = OBJECT ( TStream )
         Handle     : WORD;
         Size       : LONGINT;
         Position   : LONGINT;
         Blocks     : WORD;

         CONSTRUCTOR  Init;
         DESTRUCTOR   Done; virtual;
         FUNCTION     GetPos: LongInt; virtual;
         FUNCTION     GetSize: LongInt; virtual;
         PROCEDURE    Read(var Buf; Count: word); virtual;
         PROCEDURE    Seek(Pos: LongInt); virtual;
         PROCEDURE    Write(var Buf; Count: word); virtual;
         FUNCTION     MaxAvail : WORD;
         FUNCTION     MemAvail : WORD;
       private
         FUNCTION     Check( InfoCode:INTEGER ) : BOOLEAN;
      END;

      PFileStream = ^TFileStream;
      TFileStream = object ( TDosStream )
         Name : FNameStr;
         Mode : Word;
         constructor Init( FileName:FNameStr; FMode:Word );
         constructor Load( var S:TStream );
         procedure   Store( var S:TStream );
      end;

      PSharedStream = ^TSharedStream;
      TSharedStream = object ( TMemoryStream )
         Original : PMemoryStream;
         constructor Init ( Owner:PMemoryStream );
         destructor  Done; virtual;
         function    GetSize:Longint; virtual;
         procedure   Write(var Buf; Count:Word); virtual;
         procedure   Read(var Buf; Count:Word); virtual;
      end;

CONST  RLptStream: TStreamRec = (
          ObjType: 20100;
          VmtLink: Ofs(TypeOf(TLptStream)^);
          Load:    @TLptStream.Load;
          Store:   @TLptStream.Store
        );
       RComStream: TStreamRec = (
          ObjType: 20101;
          VmtLink: Ofs(TypeOf(TComStream)^);
          Load:    @TComStream.Load;
          Store:   @TComStream.Store
        );

       RNulStream: TStreamRec = (
          ObjType: 20102;
          VmtLink: Ofs(TypeOf(TNulStream)^);
          Load:    @TNulStream.Load;
          Store:   @TNulStream.Store
        );

       RFileStream: TStreamRec = (
          ObjType: 20103;
          VmtLink: Ofs(TypeOf(TFileStream)^);
          Load:    @TFileStream.Load;
          Store:   @TFileStream.Store
        );

PROCEDURE RegisterXStream;

{ Thanks to Pat Ritchey for this ! }
const  stOpenReadDenyWrite = $3D22;

FUNCTION  MemoryStrm( FName:PATHSTR ) : PStream;

IMPLEMENTATION


(************************************************************************)
 (*                                                                      *)
  (*        Object : TPortStrm                                            *)
   (*                                                                      *)
    (************************************************************************)

constructor TPortStream.Init( APort:Integer; ATimeOut:Byte );
begin
  inherited Init;
  ThePort := Pred(APort);
  TimeOut := ATimeOut;
end;

destructor TPortStream.Done;
begin
  SetTimeOut( OldTimeOut );
  inherited Done;
end;

constructor TPortStream.Load( var S:TStream );
begin
  inherited Init;
  S.Read( ThePort, Sizeof(ThePort));
  S.Read( TimeOut, Sizeof(TimeOut));
end;

procedure TPortStream.Store( var S:TStream );
begin
  S.Write( ThePort, Sizeof(ThePort));
  S.Write( TimeOut, Sizeof(TimeOut));
end;

function TPortStream.GetTimeOut:Byte;
begin Abstract; end;

procedure TPortStream.SetTimeOut( B:Byte );
begin Abstract; end;

function TPortStream.InitPort:Boolean;
begin
  InitPort:=True;
  OldTimeOut:= GetTimeOut;
end;

(************************************************************************)
 (*                                                                      *)
  (*        Object : TLptStrm                                             *)
   (*                                                                      *)
    (************************************************************************)

const  PrnStateMask = $29;

constructor TLptStream.Init( APort:Integer; ATimeOut:Byte );
begin
  inherited Init(APort,ATimeOut);
  IF NOT InitPort THEN FAIL
  else SetTimeOut( TimeOut );
end;

constructor TLptStream.Load( var S:TStream );
begin
  inherited Load(S);
  IF NOT InitPort THEN Fail
  else SetTimeOut( TimeOut );
end;

procedure TLptStream.SetTimeOut(B:Byte);
begin
  MEM[Seg0040:$78+ThePort] := B;
end;

function TLptStream.GetTimeOut:Byte;
begin
  GetTimeOut := MEM[Seg0040:$78+ThePort];
end;

procedure TLptStream.Write( var Buf; Count:Word );
  type   BuffType = array[1..MaxInt] of byte;
  var    I : Integer;
         Reg: Registers;
begin
  i := 1;
  While (Status = 0) and (I<= Count) do
    begin
      Reg.AH := $00;
      Reg.AL := BuffType(Buf)[i];
      Reg.DX := ThePort;
      Intr($17,Reg);
      IF (Reg.AH and PrnStateMask) > 0 then
         Error(stWriteError,Reg.AH );
      Inc(i);
    end; (* while *)
end;

function TLptStream.InitPort:Boolean;
  var Reg:Registers;
begin
  InitPort := inherited InitPort;
  Reg.AH := $01;
  Reg.DX := ThePort;
  Intr($17,Reg);
  If (Reg.AH and PrnStateMask) > 0 then
     begin
       Error(stInitError,Reg.AH);
       InitPort := False;
     end;
end;

(************************************************************************)
 (*                                                                      *)
  (*        Object : TComStream                                           *)
   (*                                                                      *)
    (************************************************************************)

const  ComStateMask = $9E;

constructor TComStream.Init( APort:Integer; ATimeOut:Byte;
                          ABaud:Word; AData:Byte; AParity:Char; AStop:Byte);
begin
  inherited Init( APort, ATimeOut );
  if      ABaud >= 9600 then ComParam :=$E0
  else if ABaud >= 4800 then ComParam :=$C0
  else if ABaud >= 2400 then ComParam :=$A0
  else if ABaud >= 1200 then ComParam :=$80
  else if ABaud >=  600 then ComParam :=$60
  else if ABaud >=  300 then ComParam :=$40
  else if ABaud >=  150 then ComParam :=$20
  else             {110}     ComParam :=$00;

  If AData = 7 then ComParam := ComParam or $02
               else ComParam := ComParam or $03;

  IF AStop = 1 then ComParam := ComParam or $04;

  Case Upcase(AParity) of
    'O': ComParam := ComParam or $08;
    'E': ComParam := ComParam or $18;
  end; (* Case *)
  IF NOT InitPort THEN Fail
  else SetTimeOut( TimeOut );
end;

constructor TComStream.Load( var S:TStream );
begin
  inherited Load(S);
  S.Read( ComParam, Sizeof(ComParam));
  IF NOT InitPort THEN Fail
  else SetTimeOut( TimeOut );
end;

procedure TComStream.Store( var S:TStream );
begin
  inherited Store(S);
  S.Write( ComParam, Sizeof(ComParam));
end;

procedure TComStream.SetTimeOut(B:Byte);
begin
  MEM[Seg0040:$7C+ThePort]:= B;
end;

function TComStream.GetTimeOut:Byte;
begin
  GetTimeOut := MEM[Seg0040:$7C+ThePort];
end;

function TComStream.InitPort:Boolean;
  var Reg:Registers;
begin
  InitPort := inherited InitPort;
  Reg.AH := $00;
  Reg.AL := ComParam;
  Reg.DX := ThePort;
  Intr($14,Reg);
  If (Reg.AH and ComStateMask) > 0 then
     begin
       Error(stInitError,Reg.AH);
       InitPort := False;
     end;
end;

procedure TComStream.Write( var Buf; Count:Word );
  type   BuffType = array[1..MaxInt] of byte;
  var    I : Integer;
         Reg: Registers;
begin
  i := 1;
  While (Status = 0) and (I<= Count) do
    begin
      Reg.AH := $01;
      Reg.AL := BuffType(Buf)[i];
      Reg.DX := ThePort;
      Intr($14,Reg);
      IF (Reg.AH and ComStateMask) > 0 then
         Error(stWriteError,Reg.AH );
      Inc(i);
    end; (* while *)
end;

(************************************************************************)
 (*                                                                      *)
  (*        Object : TNulStream                                           *)
   (*                                                                      *)
    (************************************************************************)

constructor TNulStream.Init;
begin
  inherited Init;
  Size := 0;
end;

function TNulStream.GetSize: LongInt;
begin
  GetSize := Size;
end;

constructor TNulStream.Load( var S:TStream );
begin Size := 0; end;

procedure TNulStream.Store( var S:TStream );
begin end;

procedure TNulStream.Write( var Buf; Count:Word );
begin Inc(Size, Count); end;

function TNulStream.GetPos: LongInt;
begin GetPos := 0; end;

(************************************************************************)
 (*                                                                      *)
  (*        Object : TCrcStream                                           *)
   (*                                                                      *)
    (************************************************************************)

CONSTRUCTOR TCrcStream.Init;
BEGIN
  TNulStream.Init;
  CRC := 0;
END;

FUNCTION TCrcStream.GetCRC: LongInt;
BEGIN
  GetCRC := CRC + Size SHL 16;
END;

PROCEDURE TCrcStream.Write(VAR Buf; Count: Word);
  VAR L: Integer;
BEGIN
  TNulStream.Write(Buf,Count);
  FOR L := 0 TO PRED(Count) DO
    CRC := CRC + TByteArray(Buf)[L];
END;

(************************************************************************)
 (*                                                                      *)
  (*        Object : TXmsStream                                           *)
   (*                                                                      *)
    (************************************************************************)

CONST xms_PageSize = 1024;
      is_xms_init  : BOOLEAN = FALSE;

VAR   xms_iosts : BYTE;
      xms_addr  : POINTER;

{ - Some Xms - Procedures that I need ! -}

  (* /////////////////////////////////////////////////////////////////////// *)

  PROCEDURE MoveMem ( ToAddress   : POINTER; ToHandle  : WORD;
                      FromAddress : POINTER; FromHandle: WORD;
                      Size        : LONGINT );
  BEGIN
    ASM
      MOV  AH,$0B
      LEA  SI,Size
      PUSH DS
      POP  ES
      PUSH SS
      POP  DS
      CALL ES:[xms_addr]
      PUSH ES
      POP  DS
      OR   AX,AX
      JNZ  @@1
      MOV  BYTE PTR xms_iosts,BL
    @@1:
    END;
  END;

  (* /////////////////////////////////////////////////////////////////////// *)

  FUNCTION GetByte(Handle: WORD; FromAddress: LONGINT): BYTE;
    VAR TempBuf: ARRAY[0..1] OF BYTE;
  BEGIN
    MoveMem(@TempBuf, 0, POINTER(FromAddress AND $FFFFFFFE), Handle, 2);
    GetByte := TempBuf[FromAddress AND $00000001];
  END;

  (* /////////////////////////////////////////////////////////////////////// *)

  PROCEDURE SetByte(Handle: WORD; ToAddress: LONGINT; Value: BYTE);
    VAR TempBuf: ARRAY[0..1] OF BYTE;
  BEGIN
    MoveMem(@TempBuf, 0, POINTER(ToAddress AND $FFFFFFFE), Handle, 2);
    TempBuf[ToAddress AND $00000001] := Value;
    MoveMem(POINTER(ToAddress AND $FFFFFFFE), Handle, @TempBuf, 0, 2);
  END;

  (* /////////////////////////////////////////////////////////////////////// *)

  PROCEDURE xms_Init; ASSEMBLER;
  ASM
    MOV  AX,$4300
    INT  $2F
    CMP  AL,$80
    JNE  @@1
    MOV  AX,$4310
    INT  $2F
    MOV  WORD PTR xms_addr,BX
    MOV  WORD PTR xms_addr+2,ES
    JMP  @@2
  @@1:
    MOV  BYTE PTR xms_iosts,$80
  @@2:
  END;

  (* /////////////////////////////////////////////////////////////////////// *)

  FUNCTION xms_GetMem( KB: WORD): WORD; ASSEMBLER;
  ASM
    MOV  AH,$09
    MOV  DX,WORD PTR KB
    CALL [xms_addr]
    OR   AX,AX
    JZ   @@1
    MOV  AX,DX
    JMP  @@2
  @@1:
    MOV  BYTE PTR xms_iosts,BL
  @@2:
  END;

  (* /////////////////////////////////////////////////////////////////////// *)

  PROCEDURE xms_FreeMem ( Handle: WORD);
  BEGIN
    ASM
      MOV  AH,$0A
      MOV  DX,WORD PTR Handle
      CALL [xms_addr]
      OR   AX,AX
      JNZ  @@1
      MOV  BYTE PTR xms_iosts,BL
    @@1:
    END;
  END;

  (* /////////////////////////////////////////////////////////////////////// *)

  PROCEDURE xms_ResizeMem ( Size, Handle: WORD);
  BEGIN
    ASM
      MOV  AH,$0F
      MOV  BX,WORD PTR Size
      MOV  DX,WORD PTR Handle
      CALL [xms_Addr]
      OR   AX,AX
      JNZ  @@1
      MOV  BYTE PTR xms_iosts,BL
    @@1:
    END;
  END;

  (* /////////////////////////////////////////////////////////////////////// *)

  PROCEDURE xms_MoveFrom(Size, Handle: WORD; FromAddress: LONGINT;
                         ToAddress: POINTER);
  TYPE ByteArr = ARRAY[0..MaxInt] OF BYTE;
       BytePtr = ^ByteArr;
  BEGIN
    IF Size = 0 THEN Exit;
    IF Odd(FromAddress) THEN BEGIN
      BytePtr(ToAddress)^[0] := GetByte(Handle,FromAddress);
      IF xms_iosts <> 0 THEN Exit;
      Dec(Size);
      Inc(FromAddress);
      Inc(LONGINT(ToAddress));
    END;
    MoveMem(ToAddress, 0, POINTER(FromAddress), Handle, Size AND $FFFE);
    IF xms_iosts <> 0 THEN Exit;
    IF Odd(Size)
     THEN BytePtr(ToAddress)^[Size-1] := GetByte(Handle, FromAddress+Size-1);
    IF xms_iosts <> 0 THEN Exit;
  END;

  (* /////////////////////////////////////////////////////////////////////// *)

  PROCEDURE xms_MoveTo( Size,Handle: WORD; FromAddress:POINTER;
                        ToAddress: LONGINT);
  TYPE ByteArr = ARRAY[0..MaxInt] OF BYTE;
       BytePtr = ^ByteArr;
  BEGIN
    IF Size = 0 THEN Exit;
    IF Odd(ToAddress) THEN BEGIN
      SetByte(Handle, ToAddress, BytePtr(FromAddress)^[0]);
      IF xms_iosts <> 0 THEN Exit;
      Dec(Size);
      Inc(LONGINT(FromAddress));
      Inc(ToAddress);
    END;
    MoveMem(POINTER(ToAddress), Handle, FromAddress, 0, Size AND $FFFE);
    IF xms_iosts <> 0 THEN Exit;
    IF Odd(Size)
     THEN SetByte(Handle, ToAddress+Size-1, BytePtr(FromAddress)^[Size-1]);
    IF xms_iosts <> 0 THEN Exit;
  END;

  (* /////////////////////////////////////////////////////////////////////// *)

  CONSTRUCTOR TXmsStream.Init;
  BEGIN
    IF NOT is_xms_Init THEN
       BEGIN
         xms_iosts := 0;
         xms_init;
         is_xms_init := TRUE;
       END;
    TStream.Init;
    If Check( stInitError ) THEN
       BEGIN
         Handle := xms_getmem( 1 );  (* 1 Kb at first *)
         IF Check( stInitError ) THEN
            BEGIN
              Size     := 0;   (* Nothing in here *)
              Blocks   := 1;   (* Number of block in Handle *)
              Position := 0;   (* Memory-Pointer *)
            END
         ELSE
            Fail;
       END
    ELSE
       Fail;
  END;

  FUNCTION TXmsStream.Check;
  BEGIN
    IF xms_iosts <> 0 then
       BEGIN
         ErrorInfo := xms_iosts;
         Status    := InfoCode;
       END;
    Check := xms_iosts = 0;
  END;

  FUNCTION TXmsStream.GetPos: LongInt;
  BEGIN
    GetPos := Position;
  END;

  FUNCTION TXmsStream.GetSize : LongInt;
  BEGIN
    GetSize := Size;
  END;

  PROCEDURE TXmsStream.Read(var Buf; Count: word);
  BEGIN
    IF Count <> 0 THEN
       BEGIN
         xms_movefrom(Count, Handle, Position, @Buf);
         IF Check( stReadError ) THEN
            INC(Position, Count);
       END;
  END;

  PROCEDURE TXmsStream.Seek(Pos: LongInt);
  BEGIN
     IF Pos > Size THEN
        Error( stReadError, Pos )
     ELSE
        Position := Pos;
  END;

  PROCEDURE TXmsStream.Write( var Buf; Count: word);
  BEGIN
    IF Count <> 0 THEN
       BEGIN
         IF Position + ( SUCC(Count) AND $FFFE ) >
            LONGINT(Blocks) * xms_PageSize THEN
            BEGIN
              xms_resizemem(SUCC((Position + PRED(Count)) DIV xms_PageSize),Handle);
              IF NOT Check(stWriteError) THEN Exit;
              Blocks := SUCC((Position + PRED(Count)) DIV xms_PageSize);
            END;
         xms_moveto(Count, Handle, @Buf, Position);
         IF NOT Check(stWriteError) THEN Exit;
         INC( Position, Count);
         IF Size < Position THEN
            Size := Position;
       END;
  END;

  FUNCTION TXmsStream.MaxAvail : WORD; ASSEMBLER;
  ASM
    MOV  AH,$08
    CALL [xms_addr]
    OR   AX,AX
    JNZ  @@1
    MOV  BYTE PTR xms_iosts,BL
   @@1:
  END;

  FUNCTION TXmsStream.MemAvail: WORD; ASSEMBLER;
  ASM
    MOV  AH,$08
    CALL [xms_addr]
    OR   AX,AX
    JZ   @@1
    MOV  AX,DX
    JMP  @@2
   @@1:
    MOV  BYTE PTR xms_iosts,BL
   @@2:
  END;

  DESTRUCTOR TXmsStream.Done;
  BEGIN
    xms_freemem( Handle );
    TStream.Done;
  END;

(************************************************************************)
 (*                                                                      *)
  (*        Object : TFileStream                                          *)
   (*                                                                      *)
    (************************************************************************)

constructor TFileStream.Init;
begin
  inherited Init(FileName,FMode);
  Name := FileName;
  Mode := FMode;
end;

constructor TFileStream.Load( var S:TStream );
begin
  S.Read(Name,Sizeof(Name));
  S.Read(Mode,Sizeof(Mode));
  Init(Name,Mode);
end;

procedure TFileStream.Store( var S:TStream );
begin
  S.Write(Name,Sizeof(Name));
  S.Write(Mode,Sizeof(Mode));
end;

constructor TSharedStream.Init;
begin
  TStream.Init;
  SegCount := Owner^.SegCount;
  SegList  := Owner^.SegList;
  CurSeg   := Owner^.CurSeg;
  BlockSize:= Owner^.BlockSize;
  Size     := Owner^.Size;
  Position := 0;
  Original := Owner;
end;

destructor TSharedStream.Done;
begin
  TStream.Done;
end;

function   TSharedStream.GetSize:Longint;
begin GetSize := Original^.Size;
end;

procedure  TSharedStream.Write(var Buf; Count:Word);
begin end;

procedure TSharedStream.Read(var Buf; Count:Word);
begin
  SegCount := Original^.SegCount;
  SegList  := Original^.SegList;
  inherited Read(Buf,Count);
end;

(************************************************************************)
 (*                                                                      *)
  (*        Other functions/Procedures                                    *)
   (*                                                                      *)
    (************************************************************************)

procedure RegisterXStream;
begin
  RegisterType( RLptStream  );
  RegisterType( RComStream  );
  RegisterType( RNulStream  );
  RegisterType( RFileStream );
end;

function MemoryStrm( FName : PATHSTR ) : PStream;

    VAR DosStrm : PDosStream;
        Result  : PStream;

     FUNCTION NoMemory( P : PStream ) : BOOLEAN;
     BEGIN
       IF P <> NIL THEN
          IF P^.Status <> stOk THEN
             BEGIN
               DISPOSE( P, Done );
               P := NIL;
             END;
       Result   := P;
       NoMemory := P = NIL;
     END;

BEGIN (* MemoryStrm *)

    DosStrm    := NEW( pDosStream, Init( FName,stOpenReadDenyWrite));
    MemoryStrm := DosStrm;
    Result     := NIL;

    IF DosStrm <> NIL THEN
      WITH DosStrm^ DO
       {$IFDEF DPMI}
       IF NoMemory( NEW( pMemoryStream,Init( GetSize, 1024 ))) then
       {$ENDIF}
         IF NoMemory( NEW( pEmsStream,Init( GetSize, GetSize ))) then
          IF NoMemory( NEW( pXmsStream,Init ))                    then ;

    IF Result <> NIL THEN
       BEGIN
         Result^.CopyFrom( DosStrm^, DosStrm^.GetSize );
         Dispose( DosStrm, Done );
         Result^.Seek(0);
         MemoryStrm := Result;
       END;

END; (* MemoryStrm *)

end.