unit page_18;

interface

uses crt, dos, ifpextrn, ifpglobl, ifpcomon;

procedure page18;

implementation

const
  winclass: array[0..6] of string[21] = ('vector plotter', 'raster display',
              'raster printer', 'raster camera', 'character-stream, PLP',
              'Metafile, VDM', 'display-file');
  pcAstatus: array[$FFFC..$FFFF] of string[23] = ('resident and active',
               'resident and not active', 'memory resident mode',
               'automatic mode');
  pcAspd: array[0..$F] of word = (50, 75, 110, 134, 150, 300, 600, 1200, 1800,
            2000, 2400, 4800, 7200, 9600, 19200, 38400);


procedure page18;

type
  smartdrvt = record
               write_through: byte;
               write_buffered: byte;
               cache_enabled: byte;
               drivertype: byte;
               cticks: word;
               locked: byte;
               reboot_flush: byte;
               full_track_write: byte;
               buffering_type: byte;
               origInt13ofs: word;
               origInt13seg: word;
               minorversion: byte;
               majorversion: byte;
               reserved: word;
               secs_read: word;
               secs_in_cache: word;
               secs_in_trk_buf: word;
               cache_hitrate: byte;
               track_buf_hitrate: byte;
               total_tracks: word;
               tracks_used: word;
               locked_tracks: word;
               dirty_tracks: word;
               current_size: word;
               original_size: word;
               minimum_size: word;
               lock_pointer_ofs: word;
               lock_pointer_seg: word;
             end;

  fossilbuft = record
                 fbufsize: word;
                 spec: byte;
                 rev: byte;
                 idstrofs: word;
                 idstrseg: word;
                 inbufsize: word;
                 infree: word;
                 outbufsize: word;
                 outfree: word;
                 scrwidth: byte;
                 scrlen: byte;
                 baudrate: byte;
                 extra: array[1..13] of byte;
               end;
  vfossilbuft = record
                  fbufsize: word;
                  ver: word;
                  rev: word;
                  hifunc: word
                end;
  stackerbuft = record
                  signature: word;
                  unknown: word;
                  ddofs: word;
                  ddseg: word
                end;
  T386maxbuf = record
                 version: byte;
                 signature: array[1..6] of char;
                 verstr: array[1..4] of char;
                 lowseg: word;
                 unkw1: word;
                 unkw2: word;
                 flags1: word;
                 unk1: array [1..16] of byte;
                 int15port: word;
                 int67port: word;
                 unkw3: word;
                 unkw4: word;
                 unkd1: longint;
                 unkd2: longint;
                 sysconfig: word;
                 unk2: array [1..8] of byte;
                 flags2: word;
                 flags3: word;
                 flags4: word;
                 unkw5: word;
                 extfree: word;
                 unkd3: longint;
                 unkw6: word;
                 unkd4: longint;
                 flags5: word;
                 oldint21ofs: word;
                 oldint21seg: word;
                 emsofs: word;
                 emsseg: word;
                 extra: byte;
               end;

var
  i : 1..63;
  xbool1 : boolean;
  xbool2 : boolean;
  xbool3 : boolean;
  xchar : char;
  xword1: word;
  xword2: word;
  regs: registers;
  QEMMid: byte;
  foundit: boolean;
  xbyte, xbyte2: byte;
  s: string;
  fossilbuf: fossilbuft;
  vfossilbuf: vfossilbuft;
  smartdrvbuf: smartdrvt;
  stackerbuf: stackerbuft;
  xlong: longint;
  V386maxbuf: T386maxbuf;

function windev(device: byte): word;
  var
    regs: registers;
    saveit: word;

  begin
  with regs do
    begin
    AX:=$1682;
    Intr($2F, regs);
    AX:=$170A;
    DX:=device;
    Intr($2F, regs);
    windev:=AX
    end
  end; {windev}

procedure nortonstatus(b: byte);
  begin
  case b of
    0: Write('disabled');
    1: Write('enabled')
  else
    Write('unknown')
  end
  end; {nortonstatus}

  begin (* procedure page_18 *)
  caption1('----Shells and Shell enhancers----');
  Writeln;
  caption2('JP Software 4DOS');
  with regs do
    begin
    AX:=$D44D;
    BX:=0;
    CX:=0;
    DX:=0;
    Intr($2F, regs);
    if AX <> $44DD then
      Writeln('no')
    else
      begin
      Writeln('yes');
      caption3('version');
      xword1:=BH;
      Write(BL, decimal);
      zeropad(xword1);
      caption3('shell no.');
      Write(DL);
      caption3('PSP segment');
      Writeln(hex(CX, 4))
      end;
    end;
  pause3(-1);
  if endit then
    Exit;
  caption2('JP Software KSTACK.COM');
  with regs do
    begin
    AX:=$D44F;
    BX:=0;
    CX:=0;
    DX:=0;
    Intr($2F, regs);
    yesorno(AX = $44DD);
    end;
  pause3(-2);
  if endit then
    Exit;
  caption2('Norton NDOS');
  with regs do
    begin
    AX:=$E44D;
    BX:=0;
    CX:=0;
    DX:=0;
    Intr($2F, regs);
    if AX <> $44EE then
      Writeln('no')
    else
      begin
      Writeln('yes');
      caption3('version');
      xword1:=BH;
      Write(BL, decimal);
      zeropad(xword1);
      caption3('shell no.');
      Write(DL);
      caption3('PSP segment');
      Writeln(hex(CX, 4))
      end;
    end;
  pause3(-1);
  if endit then
    Exit;
  caption2('WildUnix');
  with regs do
    begin
    AH:=$4E;
    DS:=0;
    DX:=0;
    MsDos(regs);
    yesorno(AH = $99);
    end;
  pause3(-1);
  if endit then
    Exit;
  caption2('Anarkey');
  with regs do
    begin
    AX:=$E300;
    Intr($2F, regs);
    case AL of
      $00: Writeln('no');
      $FE: Writeln('yes; but suspended');
      $FF: Writeln('yes; and active');
    else
      Writeln('???')
    end
    end;
  pause3(-1);
  if endit then
    Exit;
  caption1('----DOS Extenders----');
  Writeln;
  caption2('DOS/16M');
  with regs do
    begin
    AX:=$BF02;
    DX:=0;
    Intr($15, regs);
    yesorno(DX <> 0);
    end;
  pause3(-4);
  if endit then
    Exit;
  caption2('Phar Lap DOS Extender');
  xbool1:=false;
  xbyte:=1;
  with regs do
    repeat
      AX:=$ED00;
      BL:=xbyte;
      Intr($2F, regs);
      if (AL = $FF) and (SI = $5048 {PH}) and (DI = $4152 {AR}) then
        begin
        xbool1:=true;
        Write('yes');
        caption3('type');
        case xbyte of
          1: Write('286dosx v1.3+ SDK');
          2: Write('286dosx v1.3+ RTK');
          3: Write('386dosx v4.0+ SDK');
          4: Write('386dosx v4.0+ RTK')
        end;
        caption3('version');
        Write(CH, decimal);
        zeropad(CL);
        end;
      Inc(xbyte);
    until xbyte > 4;
  if not xbool1 then
    Writeln('no');
  pause3(-4);
  if endit then
    Exit;
  caption1('----Memory Managers and Memory utilities----');
  Writeln;
  caption2('QEMM');
  with regs do
    begin
    QEMMid:=$D2;
    foundit:=false;
    repeat
      AH:=QEMMId;
      AL:=0;
      BX:=$5144; {'QD'}
      CX:=$4D45; {'ME'}
      DX:=$4D30; {'M0'}
      Intr($2F, regs);
      if (AL = $FF) and (BX = $4D45) and (CX = $4D44) and (DX = $5652) then
        foundit:=true
      else
        begin
        if QEMMid < $FF then
          Inc(QEMMid)
        else
          QEMMid:=$C0;
        end;
    until foundit or (QEMMid = $D2);
    if not foundit then
      Writeln('no')
    else
      begin
      AH:=QEMMid;
      AL:=1;
      BX:=$5145; {'QE'}
      CX:=$4D4D; {'MM'}
      DX:=$3432; {'42'}
      Intr($2F, regs);
      if BX = $4F4B {'OK'} then
        begin
        Write('yes');
        caption3('API entry');
        segofs(ES, DI);
        xlong:=longint(ES) shl 16 + DI;
        caption3('version');
        AH:=3;
        longcall(xlong, regs);
        if not nocarry(regs) then
          Write('error')
        else
          Write(unBCD(BH), decimal, addzero(unBCD(BL)));
        xword:=BX;
        caption3('status');
        AH:=0;
        longcall(xlong, regs);
        if not nocarry(regs) then
          Write('error')
        else
          if AL and 1 = 1 then
            Write('OFF')
          else
            if AL and 2 = 2 then
               Write('Auto')
            else
              Write('ON');
        Writeln;
        caption3('High RAM');
        AH:=$12;
        longcall(xlong, regs);
        if not nocarry(regs) then
          Write('error')
        else
          begin
          yesorno2(BX <> 0);
          if BX <> 0 then
            begin
            caption3('first MCB at');
            Write(hex(BX, 4));
            end;
          end;
        if Hi(xword) >= 6 then
          begin
          caption3('Stealth');
          AX:=$1E00;
          longcall(xlong, regs);
          if not nocarry(regs) then
            Write('error')
          else
            begin
            case CL of
                0: Write('OFF');
              $46: Write('Frame');
              $4D: Write('Map')
            else
              Write('????');
            end;
            if (CL = $46) or (CL = $4D) then
              begin
              caption3('Stealthed ROMs');
              AX:=$1E01;
              longcall(xlong, regs);
              if not nocarry(regs) then
                Write('error')
              else
                Write(BX);
              end;
            end;
          end;
        Writeln;
        end
      else
        Writeln('no')
      end;
    caption2('Quarterdeck''s Manifest (memory resident)');
    if not foundit then
      Writeln('no')
    else
      begin
      AH:=QEMMid;
      AL:=1;
      BX:=$4D41; {'MA'}
      CX:=$4E49; {'NI'}
      DX:=$4645; {'FE'}
      Intr($2F, regs);
      yesorno(BX = $5354 {'ST'});
      end;
    caption2('Quarterdeck''s VIDRAM');
    if not foundit then
      Writeln('no')
    else
      begin
      AH:=QEMMid;
      AL:=1;
      BX:=$5649; {'VI'}
      CX:=$4452; {'DR'}
      DX:=$414D; {'AM'}
      Intr($2F, regs);
      if BX = $4F4B {'OK'} then
        begin
        Write('yes');
        caption3('at code segment');
        Writeln(hex(ES, 4))
        end
      else
        Writeln('no');
      end
    end;
  pause3(-2);
  if endit then
    Exit;
  caption2('386^Max');
  with regs do
    begin
    s:='386MAX$$'#0;
    AX:=$3D00;
    DS:=Seg(s);
    DX:=Ofs(s) + 1;
    MsDos(regs);
    if not nocarry(regs) then
      Writeln('no')
    else
      begin
      xbyte:=AX;
      AX:=$4402;
      BX:=xbyte;
      CX:=$5A;
      DS:=Seg(V386Maxbuf);
      DX:=Ofs(V386Maxbuf);
      V386Maxbuf.version:=3;
      MsDos(regs);
      if not nocarry(regs) then
        Writeln('Maybe; IOCTL call failed')
      else
        with V386maxbuf do
          if signature <> '386MAX' then
            Writeln('No; wrong signature found - "', signature, '"')
          else
            begin
            Write('yes');
            caption3('version');
            Write(verstr[1], decimal, verstr[3], verstr[4]);
            caption3('at segment');
            Writeln(hex(lowseg, 4));
            caption3('EMS active');
            yesorno2(flags1 and $0080 = $0080);
            caption3('Windows 3 support');
            yesorno(flags4 and 1 = 1);
            end;
      AH:=$3E;
      BX:=xbyte;
      MsDos(regs);
      end
    end;
  pause3(-1);
  if endit then
    Exit;
  Caption2('MICEMM');
  if not EMSOK then
    Writeln('no')
  else
    with Regs do
      begin
      AX:=$58F0;
      Intr($67, Regs);
      if AH <> 0 then
        Writeln('no')
      else
        begin
        Write('yes');
        Caption3('Code Segment');
        Writeln(Hex(BX, 4));
        end;
      end;
  pause3(-1);
  if EndIt then
    Exit;
  Caption2('EMM386');
  if not EMSOK then
    Writeln('no')
  else
    with Regs do
      begin
      AX:=$FFA5;
      Intr($67, Regs);
      if AX <> $845A then
        Writeln('no')
      else
        begin
        Write('yes');
        Caption3('API entry');
        SegOfs(BX, CX);
        Caption3('Status');
        xlong:=longint(BX) shl 16 + CX;
        AH:=0;
        LongCall(xlong, Regs);
        if AL and 1 = 1 then
          Write('ON')
        else
          Write('OFF');
        Caption3('Weitek');
        AH:=2;
        AL:=0;
        LongCall(xlong, Regs);
        if AL and 1 = 1 then
          begin
          Write('present ');
          if AL and 2 = 2 then
            Writeln('and enabled')
          else
            Writeln('but disabled')
          end
        else
          Writeln('not present');
        end;
      end;
  pause3(-4);
  if endit then
    Exit;
  caption2('Virtual DMA Spec. (VDS)');
  with regs do
    begin
    AX:=$354B;
    MsDos(regs);
    if (ES = 0) and (BX = 0) then
      Writeln('no')
    else
      begin
      AX:=$8102;
      DX:=0;
      Flags:=FCarry;
      Intr($4B, regs);
      yesorno2(nocarry(regs));
      if nocarry(regs) then
        begin
        caption3('version');
        Write(AH, decimal, hex(AL, 2));
        caption3('product');
        case BX of
          $0000: Write('QMAPS/HPMM');
          $0001: Write('EMM386');
          $0003: Write('Windows 3');
          $4560: Write('386^Max');
          $4D53: Write('Memory Cmdr');
          $5145: Write('QEMM')
        else
          Write(BX);
        end;
        caption3('rev.');
        Writeln(CH, decimal, hex(CL, 2));
        caption3('max. DMA buffer size');
        Write((longint(SI) * 65536 + DI)/1024:0:1, 'K');
        caption3('transfers OK in');
        if DX and 1 = 1 then
          Writeln('First Meg only')
        else
          Writeln('any address');
        caption3('buffer in first meg');
        yesorno2(DX and 2 = 2);
        caption3('auto-remap enabled');
        yesorno2(DX and 4 = 4);
        caption3('contiguous memory');
        yesorno(DX and 8 = 8);
        caption3('BIOS Data bit set');
        yesorno(Mem[$40:$7B] and $20 = $20);
        end
      else
        Writeln;
      end;
    end;
  pause3(-6);
  if endit then
    Exit;
  caption1('----Multi-Taskers and Task Switchers + Utilities---');
  Writeln;
  caption2('Quarterdeck''s Desqview');
  with regs do
    begin
    AX:=$2B01;
    CX:=$4445; {DE}
    DX:=$5351; {SQ}
    MsDos(regs);
    if AL = $FF then
      Writeln('no')
    else
      begin
      Write('yes');
      caption3('version');
      if BX = $0002 then
        Writeln('2', decimal, '00')
      else
        begin
        Write(BH, decimal);
        zeropad(BL);
        Writeln;
        end;
      caption3('window number');
      AX:=$DE07;
      Intr($15, regs);
      Write(AX);
      caption3('true video mode');
      AX:=$DE1E;
      Intr($15, regs);
      Write(BL);
      caption3('width');
      Write(CH);
      caption3('height');
      Writeln(CL);
      caption3('      common memory -> avail');
      AX:=$DE04;
      Intr($15, regs);
      Write(BX:6);
      caption3('largest');
      Write(CX:6);
      caption3('total');
      Writeln(DX:6);
      caption3('conventional memory -> avail');
      AX:=$DE05;
      Intr($15, regs);
      Write(BX:5, 'K');
      caption3('largest');
      Write(CX:5, 'K');
      caption3('total');
      Writeln(DX:5, 'K');
      caption3('    expanded memory -> avail');
      AX:=$DE06;
      Intr($15, regs);
      Write(BX:5, 'K');
      caption3('largest');
      Write(CX:5, 'K');
      caption3('total');
      Writeln(DX:5, 'K');
      end;
    end;
  pause3(-1);
  if endit then
    Exit;
  caption2('DOS 5 task switcher');
  with regs do
    begin
    AX:=$4B02;
    BX:=0;
    ES:=0;
    DI:=0;
    Intr($2F, regs);
    if nocarry(regs) and (AX = 0) and (BX = 0) then
      begin
      Write('yes');
      caption3('switcher entry point');
      segofs(ES, DI);
      Writeln;
      end
    else
      Writeln('no');
    end;
  pause3(-1);
  if endit then
    Exit;
  caption2('DRDOS TaskMAX');
  with regs do
    begin
    AX:=$2700;
    BX:=0;
    CX:=0;
    Intr($2F, regs);
    if AL <> $FF then
      Writeln('no')
    else
      begin
      Write('yes');
      caption3('version');
      AX:=$2701;
      Intr($2F, regs);
      Write(DX);
      caption3('maximum tasks');
      Write(AX);
      caption3('active tasks');
      Writeln(CX)
      end;
    end;
  pause3(-1);
  if endit then
    Exit;
  caption2('TAME');
  with regs do
    begin
    AX:=$2B01;
    CX:=$5441;
    DX:=$4D45;
    MsDos(regs);
    if AL <> 2 then
      Writeln('no')
    else
      begin
      Write('yes');
      caption3('data area');
      Writeln(hex(ES, 4), ':', hex(DX, 4))
      end
    end;
  pause3(-6);
  if endit then
    Exit;
  caption2('Microsoft Windows');
  with regs do
    begin
    AX:=$1600;
    Intr($2F, regs);
    case AL of
    $01,$FF: begin
             Writeln('yes');
             caption3('version');
             Writeln('Windows/386 2.x')
             end;
    $00,$80: begin
             AX:=$4680;
             Intr($2F, regs);
             if AX = 0 then
               begin
               Writeln('yes');
               caption3('mode');
               Writeln('Real or Standard')
               end
             else
               Writeln('no');
             end;
    $02..$7F,$81..$FE: begin
                       Writeln('yes');
                       caption3('version');
                       Write(AL, decimal, AH, ' enhanced mode');
                       caption3('Virtual Machine ID');
                       AX:=$1683;
                       Intr($2F, regs);
                       Writeln(BX);
                       caption3('WINOLDAP support');
                       AX:=$1700;
                       Intr($2F, regs);
                       if AX = $1700 then
                         Writeln('no')
                       else
                         begin
                         Write('yes');
                         caption3('version');
                         Writeln(AL, decimal, AH);
                         end;
                       caption3('Driver version');
                       xword1:=windev(0);
                       Write(Hi(xword1), decimal, Lo(xword1));
                       caption3('Device type');
                       Writeln(winclass[Lo(windev(2))]);
                       caption3('Pixel width');
                       Write(windev(8));
                       caption3('height');
                       Write(windev($A));
                       caption3('colors');
                       Write(windev($18));
                       caption3('bits/pixel');
                       Write(windev($C));
                       caption3('bit planes');
                       Writeln(windev($E));
                       caption3('X aspect');
                       Write(windev($28));
                       caption3('Y aspect');
                       Writeln(windev($2A));
                       caption3('brushes');
                       Write(windev($10));
                       caption3('pens');
                       Write(windev($12));
                       caption3('markers');
                       Write(windev($14));
                       caption3('fonts');
                       Writeln(windev($16));
                       end;
    end; {case}
    end;
  pause3(-1);
  if endit then
    Exit;
  caption1('----Norton Utilities----');
  Writeln;
  caption2('Norton NCACHE');
  with regs do
    begin
    AX:=$FE00;
    BX:=0;
    CX:=0;
    DX:=0;
    DI:=$4E55; {NU}
    SI:=$4346; {CF}
    Intr($2F, regs);
    if SI = $6366 {cf} then
      begin
      Write('yes (NCACHE-F or NCACHE v6+)');
      caption3('status');
      nortonstatus(AH);
      Writeln;
      end
    else
      begin
      AX:=$FE00;
      BX:=0;
      CX:=0;
      DX:=0;
      DI:=$4E55; {NU}
      SI:=$4353; {CS}
      Intr($2F, regs);
      if SI = $6373 {cs} then
        begin
        Write('yes (NCACHE-S)');
        caption3('status');
        nortonstatus(AH);
        Writeln
        end
      else
        Writeln('no');
      end
    end;
  pause3(-1);
  if endit then
    Exit;
  caption2('Norton Diskreet');
  with regs do
    begin
    AX:=$FE00;
    BX:=0;
    CX:=0;
    DX:=0;
    DI:=$4E55; {NU}
    SI:=$4443; {DC}
    Intr($2F, regs);
    if SI = $6463 {dc} then
      begin
      Write('yes');
      caption3('status');
      nortonstatus(AH);
      caption3('resident at');
      Writeln(hex(CX, 4))
      end
    else
      Writeln('no');
    end;
  pause3(-1);
  if endit then
    Exit;
  caption2('Norton DiskMon');
  with regs do
    begin
    AX:=$FE00;
    BX:=0;
    CX:=0;
    DX:=0;
    DI:=$4E55; {NU}
    SI:=$444D; {DM}
    Intr($2F, regs);
    if SI = $646D {dm} then
      begin
      Write('yes');
      caption3('status');
      nortonstatus(AH);
      caption3('resident at');
      Writeln(hex(CX, 4));
      end
    else
      Writeln('no');
    end;
  pause3(-1);
  if endit then
    Exit;
  caption2('Norton FileSave/EraseProtect');
  with regs do
    begin
    AX:=$FE00;
    BX:=0;
    CX:=0;
    DX:=0;
    DI:=$4E55; {NU}
    SI:=$4653; {FS}
    Intr($2F, regs);
    if SI = $6673 {fs} then
      begin
      Write('yes');
      caption3('resident at');
      Writeln(hex(CX, 4));
      end
    else
      Writeln('no');
    end;
  pause3(-1);
  if endit then
    Exit;
  caption1('----Virus protectors---');
  Writeln;
  caption2('F-PROT package -> F-LOCK');
  with regs do
    begin
    AX:=$4653;
    BX:=0;
    CX:=2;
    Intr($2F, regs);
    yesorno2(AX = $FFFF);
    caption3('F-XCHK');
    AX:=$4653;
    BX:=0;
    CX:=3;
    Intr($2F, regs);
    yesorno2(AX = $FFFF);
    caption3('F-POPUP');
    AX:=$4653;
    BX:=0;
    CX:=4;
    Intr($2F, regs);
    yesorno2(AX = $FFFF);
    caption3('F-DLOCK');
    AX:=$4653;
    BX:=0;
    CX:=5;
    Intr($2F, regs);
    yesorno(AX = $FFFF)
    end;
  pause3(-1);
  if endit then
    Exit;
  caption2('TBScanX');
  with regs do
    begin
    AX:=$CA00;
    BX:=$5442; {TB}
    Intr($2F, regs);
    if (AL <> $FF) or (BX <> $7462 {tb}) then
      Writeln('no')
    else
      begin
      Write('yes');
      caption3('version');
      AX:=$CA01;
      Intr($2F, regs);
      if AH <> $CA then
        Write(AH shr 4, decimal, addzero(AH and $F))
      else
        Write('2.2-');
      caption3('status');
      if AL = 0 then
        Writeln('disabled')
      else
        Writeln('enabled');
      end
    end;
  pause3(-1);
  if endit then
    Exit;
  caption2('Flu_Shot+');
  with regs do
    begin
    AX:=$FF0F;
    MsDos(regs);
    yesorno(AX = $0101);
    end;
  pause3(-1);
  if endit then
    Exit;
  caption1('----SCSI drivers----');
  Writeln;
  caption2('Common Access Method SCSI (CAM-SCSI)');
  with regs do
    begin
    AX:=$354F;
    MsDos(regs);
    if (ES <> 0) and (BX <> 0) then
      begin
      AX:=$8200;
      CX:=$8765;
      DX:=$CBA9;
      Intr($4F, regs);
      if (CX = $9ABC) and (DX=$5678) then
        begin
        s:='';
        for xword1:=DI to DI + 7 do
          s:=s + Chr(Mem[ES:xword1]);
        yesorno(s = 'SCSI_CAM');
        end
      else
        Writeln('no');
      end;
    end;
  pause3(-1);
  if endit then
    Exit;
  caption2('CMC International SCSI driver');
  with regs do
    begin
    AX:=$3578;
    MsDos(regs);
    s:='';
    for xword1:=BX + 3 to BX + 6 do
      s:=s + Chr(Mem[ES:xword1]);
    yesorno(s = 'SCSI');
    end;
  pause3(-4);
  if endit then
    Exit;
  caption1('----Disk Caches----');
  Writeln;
  caption2('SMARTDRV');
  with regs do
    begin
    s:='SMARTAAR'#0;
    AX:=$3D00;
    DS:=Seg(s);
    DX:=Ofs(s) + 1;
    MsDos(regs);
    if not nocarry(regs) then
      begin
      AX:=$4A10;
      BX:=0;
      CX:=0;
      DX:=0;
      Intr($2F, regs);
      if AX = $BABE then
        begin
        Write('yes');
        caption3('ver');
        Write(Hi(BP), decimal, addzero(Lo(BP)));
        caption3('size now');
        AX:=$4A10;
        BX:=4;
        Intr($2F, regs);
        Write((longint(CX) * BX) div 1024, 'K');
        caption3('min size');
        Write((longint(DX) * CX) div 1024, 'K');
        caption3('element size');
        Writeln(CX div 1024, 'K');
        caption3('cache hits');
        AX:=$4A10;
        BX:=0;
        Intr($2F, regs);
        Write(longint(DX) shl 16 + BX);
        caption3('cache misses');
        Writeln(longint(DI) shl 16 + SI);
        for xbyte:=0 to $19 do
          begin
          pause3(-1);
          if endit then
            Exit;
          AX:=$4A10;
          BX:=3;
          BP:=xbyte;
          DX:=0;
          Intr($2F, regs);
          if DL <> $FF then
            begin
            caption3('Drive');
            Write(Chr(xbyte + Ord('A')));
            caption3('read cache');
            yesorno2(DL and $80 <> $80);
            caption3('write cache');
            yesorno2(DL and $40 <> $40);
            caption3('double buffered');
            AX:=$4A10;
            BX:=5;
            BP:=xbyte;
            Intr($2F, regs);
            yesorno(AX = $BABE);
            end;
          end;
        end
      else
        Writeln('no')
      end
    else
      begin
      xbyte:=AX;
      AX:=$4400;
      BX:=xbyte;
      MsDos(regs);
      if (not nocarry(regs)) or (DX and $4080 <> $4080) then
        Writeln('Maybe. IOCTL interface not supported.')
      else
        begin
        AX:=$4402;
        BX:=xbyte;
        CX:=SizeOf(smartdrvbuf);
        DS:=Seg(smartdrvbuf);
        DX:=Ofs(smartdrvbuf);
        MsDos(regs);
        if not nocarry(regs) then
          Writeln('Maybe. IOCTL read failed.')
        else
          begin
          Write('yes');
          with smartdrvbuf do
            begin
            caption3('ver.');
            Write(majorversion, decimal, minorversion);
            caption3('Size');
            Write(current_size * 16, 'K');
            caption3('Max');
            Write(original_size * 16, 'K');
            caption3('Min');
            Write(minimum_size * 16, 'K');
            caption3('enabled');
            yesorno(cache_enabled = 1);
            caption3('locked tracks');
            yesorno2(locked > 0);
            caption3('write-through');
            yesorno2(write_through = 1);
            caption3('write-buffered');
            yesorno2(write_buffered = 1);
            caption3('hit rate');
            Writeln(cache_hitrate, '%');
            caption3('DMA buffering');
            case buffering_type of
              0: Write('off');
              1: Write('on');
              2: Write('dynamic')
            else
              Write('(unknown)');
            end; {case}
            caption3('memory type');
            case drivertype of
              1: Write('XMS');
              2: Write('EMS')
            else
              Write('unknown:', drivertype);
            end;
            caption3('flush on reboot');
            yesorno(reboot_flush <> 0);
            caption3('Tracks total');
            Write(total_tracks);
            caption3('used');
            Write(tracks_used);
            caption3('locked');
            Write(locked_tracks);
            caption3('dirty');
            Writeln(dirty_tracks);
            end
          end
        end;
      AH:=$3E;
      BX:=xbyte;
      MsDos(regs);
      end
    end;
  pause3(-1);
  if endit then
    Exit;
  caption2('HyperDisk');
  with regs do
    begin
    AX:=$DF00;
    BX:=$4448; {DH}
    Intr($2F, regs);
    yesorno((AL = $FF) and (CX = $5948 {YH}));
    end;
pause3(-1);
  if endit then
    Exit;
  xword1:=Seg(stackerbuf);
  xword2:=Ofs(stackerbuf);
  caption2('Stacker');
    asm
    mov  ax,$CDCD       {signature entry}
    mov  cx,1
    mov  dx,0
    push ds             {need to preserve these}
    push bp
    mov  ds,xword1      {pointer to address buffer}
    mov  bx,xword2
    int  $25            {DOS absolute read sectors}
    pop  cx             {remove old flags}
    pop  bp             {restore important regs}
    pop  ds
    mov  xword1,ax      {save return code}
    end;
  if (xword1 = $CDCD) and (MemW[stackerbuf.ddseg:stackerbuf.ddofs] = $A55A) then
    with stackerbuf do
      begin
      Write('yes');
      caption3('version');
      Writeln((MemW[ddseg:ddofs + 2] / 100.0):2:2);
      end
  else
    Writeln('no');
  pause3(-1);
  if endit then
    Exit;
  caption1('----Miscellaneous----');
  Writeln;
  caption2('pcAnywhere');
  with regs do
    begin
    AH:=$79;
    Intr($16, regs);
    if AX < $FFFC then
      Writeln('no')
    else
      begin
      Write(pcAstatus[AX]);
      caption3('port');
      AH:=$7C;
      Intr($16, regs);
      Write(AH);
      caption3('baud rate');
      Writeln(pcAspd[AL]);
      end;
    end;
  pause3(-5);
  if endit then
    Exit;
  caption2('Disk Spool II');
  with regs do
    begin
    AH:=$A0;
    Intr($1A, regs);
    if AH = $B0 then
      begin
      Write('yes');
      caption3('at segment');
      Writeln(hex(ES, 4));
      caption3('spooler is');
      case CH of
        $00: Writeln('disabled');
        $41: begin
             Writeln('enabled');
             caption3('spooling file');
             xbyte:=0;
             repeat
               xchar:=Chr(Mem[ES:BX]);
               if xchar <> #0 then
                 Write(xchar);
               Inc(xbyte);
               Inc(BX);
             until (xchar = #0) or (xbyte >= 64);
             if xbyte = 0 then
               Write('(none)');
             Writeln;
             end;
      else
        Writeln('??')
      end;
      caption3('despooler is');
      case CL of
        $00: Writeln('disabled');
        $41: begin
             Write('enabled and ');
             case DL of
               $00: Writeln('actively printing');
               $41: Writeln('standing by');
             else
               Writeln('?????');
             end;
             caption3('despooler file');
             xbyte:=0;
             repeat
               xchar:=Chr(Mem[ES:SI]);
               if xchar <> #0 then
                 Write(xchar);
               Inc(xbyte);
               Inc(SI);
             until (xchar = #0) or (xbyte >= 64);
             if xbyte = 0 then
               Write('(none)');
             Writeln;
             end;
      else
        Writeln('????');
      end;
      end
    else
      Writeln('no');
    end;
  pause3(-1);
  if endit then
    Exit;
  caption2('Microsoft/LANtastic Network');
  regs.AH:=0;
  Intr($2A, regs);
  yesorno(regs.AH <> 0);
  pause3(-1);
  if endit then
    Exit;
  caption2('PC/TCP Packet driver');
  with regs do
    begin
    xbyte:=$60;
    foundit:=false;
    repeat
      AH:=$35;
      AL:=xbyte;
      MsDos(regs);
      s:='';
      for xword1:=BX + 3 to BX + $A do
        s:=s + Chr(Mem[ES:xword1]);
      if s = 'PKT DRVR' then
        foundit:=true;
      Inc(xbyte);
    until foundit or (xbyte = $81);
    if foundit then
      Writeln('yes, at interrupt $', hex(xbyte - 1, 2))
    else
      Writeln('no')
    end;
  pause3(-1);
  if endit then
    Exit;
  caption2('Inset');
  with regs do
    begin
    AH:=2;
    DX:=0;
    CX:=$07C3; {1987}
    Intr($17, regs);
    yesorno(CX = $07C2 {1986})
    end;
  pause3(-1);
  if endit then
    Exit;
  caption2('Microsoft CD-ROM extensions');
  asm
  mov ax,$DADA
  push ax
  mov ax,$1100
  int $15
  mov xbyte,al
  pop ax
  mov xword1,bx
  end;
  if (xbyte <> $FF) or (xbyte2 <> $ADAD) then
    Writeln('no')
  else
    with regs do
      begin
      Write('yes');
      caption3('version');
      AX:=$150C;
      Intr($2F, regs);
      if BX = 0 then
        Writeln('1.02 or older')
      else
        Writeln(BH, decimal, BL);
      end;
  pause3(-2);
  if endit then
    Exit;
  caption2('Fossil');
  xbool1:=false;
  with regs do
    begin
    AH:=$BC;
    DX:=$1954;
    Intr($11, regs);
    if AX = $1954 then
      xbool1:=true;
    AX:=$1B00;
    DX:=$FF;
    CX:=SizeOf(fossilbuf);
    ES:=Seg(fossilbuf);
    DI:=Ofs(fossilbuf);
    Intr($14, regs);
    if AX <> $1B00 then
      begin
      Write('yes');
      caption3('type');
      if xbool1 then
        Write('BNU')
      else
        if (CX = $3058 {0X}) and (DX = $2030 { 0}) then
          Write('X00')
        else
          Write('unknown');
      with fossilbuf do
        begin
        caption3('specification level');
        Write(spec);
        caption3('revision level');
        Writeln(rev);
        caption3('ID string');
        while Mem[idstrseg:idstrofs] <> 0 do
          begin
          Write(Chr(Mem[idstrseg:idstrofs]));
          Inc(idstrofs)
          end;
        Writeln;
        end
      end
    else
      Writeln('no');
    end;
  pause3(-1);
  if endit then
    Exit;
  caption2('Video Fossil');
  with regs do
    begin
    AX:=$8100;
    ES:=Seg(vfossilbuf);
    DI:=Ofs(vfossilbuf);
    Intr($14, regs);
    if AX <> $1954 then
      Writeln('no')
    else
      with vfossilbuf do
        begin
        Write('yes');
        caption3('version');
        Write(ver);
        caption3('revision');
        Write(rev);
        caption3('highest function');
        Write('$', hex(hifunc, 4));
        end
    end;
  end;
end.
