{$S-,R-,V-,I-,B-,F-,W-,A-,G+,X+,N-}

{$I WSDEFINE.INC}   {Controls how exported functions are declared}

{$IFDEF UseWinSysDLL}
  Error -- INSTALL program must be compiled with Win/Sys units
{$ENDIF}

{*********************************************************}
{*                    DEWINST.PAS 1.00                   *}
{*        Copyright (c) TurboPower Software 1992.        *}
{*                 All rights reserved.                  *}
{*********************************************************}

program Inst;
  {-DEW installation program}

uses
  {----------- TPW}
  Strings,
  WinDos,
  WinTypes,
  WinProcs,
  Ver,
  BWCC,
  WObjects,
  {-------- WinSys}
  WsBase,
  WsString,
  WsInline,
  WsSort,
  WsDos,
  {----------- DEW}
  DewData,
  OoDewSC,
  {--------- Other}
  WArchiv,
  WLzh;

{$R DEWINST.RES}

const
  {+++ Application dependent constants +++}

  {Control IDs for main dialog}
  id_ToDirectory      = 101;  {edit}
  id_FromDirectory    = 102;  {edit}
  id_DirButton        = 103;  {button}
  id_OptButton        = 104;  {button}
  id_CDirButton       = 106;  {button}
  id_BytesRequired    = 105;  {static}
  id_Stop             = 500;  {button}
  id_Go               = 501;  {button}
  id_Restore          = 502;  {button}
  id_ReadMe           = 503;  {button}

  {Control IDs for Options dialog}
  id_Pascal           = 101;  {check box}
  id_Cpp              = 102;  {check box}
  id_OverwriteAlways  = 103;  {radio button}
  id_OverwriteNever   = 104;  {radio button}
  id_OverwriteCompiler= 105;  {radio button}
  id_BC30             = 106;  {radio button}
  id_BC31             = 107;  {radio button}
  id_TC30             = 108;  {radio button}
  id_TC31             = 118;  {radio button}
  id_CreateGroup      = 109;  {check box}
  id_DllSource        = 110;  {check box}
  id_Examples         = 111;  {check box}
  id_Utilities        = 112;  {check box}
  id_Demos            = 113;  {check box}
  id_Help             = 114;  {check box}
  id_ModifyINI        = 115;  {check box}
  id_PascalPrimary    = 117;  {check box}

  {Control IDs for Directories dialog}
  id_PascalDir        = 101;  {edit}
  id_PascalDemoDir    = 102;  {edit}
  id_CDir             = 103;  {edit}
  id_CDemoDir         = 104;  {edit}
  id_UtilityDir       = 105;  {edit}
  id_DllDir           = 106;  {edit}
  id_BonusDir         = 107;  {edit}
  id_HelpDir          = 108;  {edit}

  {Control IDs for CDirectories dialog}
  id_BcIncDir         = 101;  {edit}
  id_ClassIncDir      = 102;  {edit}
  id_OwlIncDir        = 103;  {edit}
  id_WsIncDir         = 105;  {edit}
  id_BcLibDir         = 106;  {edit}
  id_ClassLibDir      = 107;  {edit}
  id_OwlLibDir        = 108;  {edit}
  id_WsLibDir         = 110;  {edit}
  id_CompilerDir      = 111;  {edit}
  id_BcRootDir        = 112;  {edit}

  {Control IDs for Progress window}
  id_AllMeter         = 101;  {meter control}
  id_FileMeter        = 102;  {meter control}
  id_StatusMsg        = 103;  {static}
  id_AllPercent       = 104;  {static}
  id_FilePercent      = 105;  {static}

  {Control IDs for NewDisk window}
  id_DiskName         = 101;  {static}
  id_DriveLetter      = 102;  {static}
  id_NewDirectory     = 103;  {edit}

  {Customized limits}
  DestDirCnt = 9;             {Number of destination dirs for this program}

  {Default values for main dialog controls}
  DefToDirectory      = 'C:\DEW';
  DefFromDirectory    : array[0..79] of char = 'A:\';

  {Default values for Options dialog}
  DefPascal             = 1;
  DefCpp                = 0;
  DefOverwriteAlways    = 1;
  DefOverwriteNever     = 0;
  DefOverwriteCompiler  = 0;
  DefBC30               = 0;
  DefBC31               = 1;
  DefTC30               = 0;
  DefTC31               = 0;
  DefCreateGroup        = 1;
  DefDllSource          = 1;
  DefExamples           = 1;
  DefUtilities          = 1;
  DefDemos              = 1;
  DefHelp               = 1;
  DefModifyINI          = 1;
  DefPascalPrimary      = 1;

  {Default values for Directores dialog}
  DefPascalDir        = 'PASCAL';
  DefPascalDemoDir    = 'PASCAL';
  DefCDir             = 'C';
  DefCDemoDir         = 'C';
  DefUtilityDir       = '';
  DefDllDir           = '';
  DefBonusDir         = 'BONUS';
  DefHelpDir          = '';

  {Default values for CDirectories dialog}
  DefBcIncDir         = 'INCLUDE';
  DefClassIncDir      = 'CLASSLIB\INCLUDE';
  DefOwlIncDir        = 'OWL\INCLUDE';
  DefWsIncDir         = 'C';
  DefBcLibDir         = 'LIB';
  DefClassLibDir      = 'CLASSLIB\LIB';
  DefOwlLibDir        = 'OWL\LIB';
  DefWsLibDir         = 'C';
  DefCompilerDir      = 'BIN';
  DefBcRootDir        = 'C:\BC3';

  {Commands to send to Program Manager to create group and items}
  MaxCommands = 14;
  Commands : array[1..MaxCommands] of array[0..255] of Char =
    ('[CreateGroup(DEW)]',
    '[AddItem(makesrc.exe, Make Source)]',
    '[AddItem(cvtoplw.exe, Convert OPL)]',
    '[AddItem(cvtoplcw.exe, Convert OPL)]',
    '[AddItem(addrbook.exe, Address Book)]',
    '[AddItem(custdata.exe, Customer Data)]',
    '[AddItem(doodle.exe, Doodle)]',
    '[AddItem(mdidemo.exe, MDI Demo)]',
    '[AddItem(addrbook.exe, Address Book)]',
    '[AddItem(custdata.exe, Customer Data)]',
    '[AddItem(doodle.exe, Doodle)]',
    '[AddItem(mdidemo.exe, MDI Demo)]',
    '[AddItem(winhelp.exe dew.hlp, DEW Reference)]',
    '[ShowGroup(DEW, 7)]');

  {Group bit flags -- same as DEWINST.TXT}
  gbPascalInt  = $0002;
  gbCppInt     = $0004;
  gbDllSource  = $0008;
  gbPExamples  = $0010;
  gbPDemos     = $0020;
  gbPUtilities = $0040;
  gbCExamples  = $0080;
  gbCDemos     = $0100;
  gbCUtilities = $0200;
  gbHelp       = $0400;

  {INI keys under [User controls]}
  IniName = 'WORKSHOP.INI';
  ControlHeader      = 'User controls';
  EntryFieldKey      = 'sEntryField';
  MeterControlKey    = 'dewMeterControl';

  {+++ End of application dependent constants +++}

  {For general copying}
  CopyBufferSize = 4096;

  {General limits}
  MaxDestDirs = 10;           {Maximum destination dirs}
  MaxFiles = 1000;            {Maximum files allowed}
  MaxGroups = 32;             {Maximum groups allowed}

  {Yield during sort}
  YieldFactor = 400;

type
  {Install media types}
  MediaType = (Disk360, Disk720, Disk1200, Disk1440, DiskHard);

  {For convenient PChar declarations}
  TCharArray = array[0..255] of Char;

  {General copying buffer}
  CopyBufferType = array[0..CopyBufferSize] of Char;

  {Format of install.dat entry}
  FileInfoRec = record
    Name       : String[12];
    SourceDir  : Byte;
    DestDir    : Byte;
    Group      : LongInt;
    Size       : LongInt;
    CompSize   : LongInt;
    Disk36     : Byte;
    Disk72     : Byte;
    Disk12     : Byte;
    Disk14     : Byte;
    Archived   : Boolean;
    Disk1      : Boolean;
    Tagged     : Boolean;
    FileVer    : Longint;
  end;
  FilesArray = array[1..MaxFiles] of FileInfoRec;
  PFilesArray = ^FilesArray;

  {Transfer record for new disk}
  NewDiskDataRec = record
    Name : array[0..2] of Char;
    Letter : Char;
    NewDirectory : array[0..79] of Char;
  end;

  {NewDisk window object}
  PNewDiskWindow = ^TNewDiskWindow;
  TNewDiskWindow =
    object(TDlgWindow)
      DiskName : PStatic;
      DriveLetter : PStatic;
      NewDirectory : PEdit;

      constructor Init(AParent : PWindowsObject);
      procedure SetupWindow; virtual;
      procedure Ok(var Msg : TMessage); virtual id_First+id_ok;
    end;

  {Special button for trapping <Enter> on modeless progress window}
  PCancelButton = ^TCancelButton;
  TCancelButton =
    object(TButton)
      procedure wmChar(var Msg : TMessage); virtual wm_First+wm_Char;
  end;

  {Progress window object}
  PProgressWindow = ^TProgressWindow;
  TProgressWindow =
    object(TDlgWindow)
      AllMeter    : PControl;
      FileMeter   : PControl;
      AllPercent  : PStatic;
      FilePercent : PStatic;
      StatusMsg   : PStatic;

      constructor Init(AParent : PWindowsObject);
      procedure SetFileMeter(N : Byte);
      procedure SetAllMeter(N : Byte);
      procedure SetStatusMsg(P : PChar);
      procedure Cancel(var Msg : TMessage); virtual id_First+id_Cancel;
      function WmSysCommand(var Msg : TMessage) : Word; virtual wm_First+wm_SysCommand;
    end;

  {+++ Application specific types +++}

  {Transfer data for Option window}
  OptionDataRec = record
    Pascal            : Word;
    Cpp               : Word;
    OverwriteAlways   : Word;
    OverwriteNever    : Word;
    OverwriteCompiler : Word;
    BC30              : Word;
    BC31              : Word;
    TC30              : Word;
    TC31              : Word;
    CreateGroup       : Word;
    DllSource         : Word;
    Examples          : Word;
    Utilities         : Word;
    Demos             : Word;
    Help              : Word;
    ModifyINI         : Word;
    PascalPrimary     : Word;
  end;

  {Option dialog window}
  POptionWindow = ^TOptionWindow;
  TOptionWindow =
    object(TDlgWindow)
      constructor Init(AParent : PWindowsObject; var Data : OptionDataRec);
      function CanClose : Boolean; virtual;
      procedure idHelp(var Msg : TMessage); virtual id_First+idHelp;
      procedure SelectPascal(var Msg : TMessage); virtual id_First+id_Pascal;
    end;

  {Transfer data for Directories window}
  DirectoryDataRec = record
    PascalDir     : array[0..79] of Char;
    PascalDemoDir : array[0..79] of Char;
    CDir          : array[0..79] of Char;
    CDemoDir      : array[0..79] of Char;
    UtilityDir    : array[0..79] of Char;
    DllDir        : array[0..79] of Char;
    BonusDir      : array[0..79] of Char;
    HelpDir       : array[0..79] of Char;
  end;

  {Directories dialog window}
  PDirectoriesWindow = ^TDirectoriesWindow;
  TDirectoriesWindow =
    object(TDlgWindow)
      constructor Init(AParent : PWindowsObject; var Data : DirectoryDataRec);
      procedure idHelp(var Msg : TMessage); virtual id_First+idHelp;
    end;

  {Transfer data for CDirectories window}
  CDirectoryDataRec = record
    BcIncDir     : array[0..79] of Char;
    ClassIncDir  : array[0..79] of Char;
    OwlIncDir    : array[0..79] of Char;
    WsIncDir     : array[0..79] of Char;
    BcLibDir     : array[0..79] of Char;
    ClassLibDir  : array[0..79] of Char;
    OwlLibDir    : array[0..79] of Char;
    WsLibDir     : array[0..79] of Char;
    CompilerDir  : array[0..79] of Char;
    BcRootDir    : array[0..79] of Char;
  end;

  {Directories dialog window}
  PCDirectoriesWindow = ^TCDirectoriesWindow;
  TCDirectoriesWindow =
    object(TDlgWindow)
      constructor Init(AParent : PWindowsObject; var Data : CDirectoryDataRec);
      procedure UpdateNames(var Msg : TMessage); virtual id_First+id_BcRootDir;
      procedure idHelp(var Msg : TMessage); virtual id_First+idHelp;
    end;

  {DDE window for communicating with Program Manager}
  PDDEWindow = ^TDDEWindow;
  TDDEWindow = object(TDlgWindow)
    ServerWindow   : HWnd;
    PendingMessage : Word;
    CurrentCmd     : Word;
    UseCommand     : array[1..MaxCommands] of Boolean;

    constructor Init;
    procedure SetupWindow; virtual;
    function GetClassName: PChar; virtual;
    procedure InitiateDDE;
    procedure TerminateDDE;
    function SendCommand : Boolean;                                    {!!.01}
    procedure CreateGroup;
    procedure WMDDEAck(var Msg: TMessage); virtual wm_First + wm_DDE_Ack;
    procedure WMDDETerminate(var Msg: TMessage); virtual wm_First + wm_DDE_Terminate;
    procedure WMDestroy(var Msg: TMessage); virtual wm_First + wm_Destroy;
  end;

  {Transfer buffer for TInstallWindow}
  MainDataRec =
    record
      ToDirectory : array[0..79] of Char;
      FromDirectory : array[0..79] of Char;
      BytesRequired : array[0..15] of Char;
    end;

  PInstallWindow = ^TInstallWindow;
  TInstallWindow =
    object(TDlgWindow)
      Info : File of FileInfoRec;           {Install information file}
      InfoRec : FileInfoRec;                {Current file information}
      Src : TCharArray;                     {Complete source name}
      Dest : TCharArray;                    {Complete destination name}
      CurrentDisk : Byte;                   {Current disk number}
      ArcName : TCharArray;                 {Archive name}
      Progress : PProgressWindow;           {Progress dialog box}
      DDEWindow : PDDEWindow;               {DDE window for talking to PROGMAN}

      {Methods that will likely require customization}
      constructor Init(AParent : PWindowsObject; var Data : MainDataRec);
      procedure ResetDefaults;
      procedure UpdateGroups;
      procedure idDirButton(var Msg : TMessage); virtual id_First+id_DirButton;
      procedure idOptButton(var Msg : TMessage); virtual id_First+id_OptButton;
      procedure idCDirButton(var Msg : TMessage); virtual id_First+id_CDirButton;
      procedure BuildDestDirs;
      procedure MakeDestDirs;
      procedure MakeGroup;
      procedure UpdateIni;
      procedure RenameFiles;
      procedure UpdateMakeFiles;
      procedure CreateCfgFiles;
      procedure CreateWsIntlFile;
      procedure RenameTemplateFiles;
      procedure MoveFiles;

      {Standard methods that shouldn't require customization}
      procedure CopyAllFiles;
      procedure LoadFiles;
      procedure SortFiles;
      procedure idGo(var Msg : TMessage); virtual id_First+id_Go;
      procedure idReadMe(var Msg : TMessage); virtual id_First+id_ReadMe;
      procedure idRestore(var Msg : TMessage); virtual id_First+id_Restore;
      procedure idStop(var Msg : TMessage); virtual id_First+id_Stop;
      procedure PromptNewDisk(Disk : Byte);
    end;

  {+++ End of application specific types +++}

  InstallApplication =
    object(TApplication)
      procedure InitMainWindow; virtual;
    end;

var
  InstallApp : InstallApplication;      {Our application object}
  MainData : MainDataRec;               {Transfer buffer for main data}
  OptionData : OptionDataRec;           {Transfer buffer for Option data}
  DirectoryData : DirectoryDataRec;     {Transfer buffer for Directory data}
  CDirectoryData : CDirectoryDataRec;   {Transfer buffer for CDirectory data}
  NewDiskData : NewDiskDataRec;         {Transfer buffer for NewDisk data}
  CopyBuffer : CopyBufferType;          {General copy buffer}
  DestDirs : array[1..MaxDestDirs] of PChar; {List of destination dirs}
  Groups : LongInt;                     {Longint map of selected groups}
  MeterJunk : Word;                     {Bogus transfer buffer for meters}
  Media : MediaType;                    {Media type of ToDirectory}
  LessCnt : LongInt;                    {Number of times Less is called}
  Files : PFilesArray;                  {For holding all files }
  FileCnt : Word;                       {Number of files in Files array}
  BytesTransferred : LongInt;           {Bytes copied so far (uncompressed)}
  CancelFlag : Boolean;                 {True if a cancel is pending}
  OldCursor : HCursor;                  {Save old cursor during waits}
  LzhFileSize : LongInt;                {Size of LZH file}

  {+++ Application specific globals +++}

  {Currently selected options}
  gToDirectory       : array[0..79] of Char;
  gOldToDirectory    : array[0..79] of Char;
  gFromDirectory     : array[0..79] of Char;
  gPascal            : Boolean;
  gCpp               : Boolean;
  gOverwriteAlways   : Boolean;
  gOverwriteNever    : Boolean;
  gOverwriteCompiler : Boolean;
  gBC30              : Boolean;
  gBC31              : Boolean;
  gTC30              : Boolean;
  gTC31              : Boolean;
  gCreateGroup       : Boolean;
  gDllSource         : Boolean;
  gExamples          : Boolean;
  gUtilities         : Boolean;
  gDemos             : Boolean;
  gHelp              : Boolean;
  gModifyINI         : Boolean;
  gPascalPrimary     : Boolean;
  gPascalDir         : array[0..79] of Char;
  gPascalDemoDir     : array[0..79] of Char;
  gCDir              : array[0..79] of Char;
  gCDemoDir          : array[0..79] of Char;
  gUtilityDir        : array[0..79] of Char;
  gDllDir            : array[0..144] of Char;
  gSystemDir         : array[0..114] of Char;
  gBonusDir          : array[0..79] of Char;
  gHelpDir           : array[0..79] of Char;
  gDisk              : Byte;
  gDrive             : Char;
  gBcIncDir          : array[0..79] of Char;
  gClassIncDir       : array[0..79] of Char;
  gOwlIncDir         : array[0..79] of Char;
  gWsIncDir          : array[0..79] of Char;
  gBcLibDir          : array[0..79] of Char;
  gClassLibDir       : array[0..79] of Char;
  gOwlLibDir         : array[0..79] of Char;
  gWsLibDir          : array[0..79] of Char;
  gCompilerDir       : array[0..79] of Char;
  gBcRootDir         : array[0..79] of Char;
  gOldBcRootDir      : array[0..79] of Char;

  {+++ End of application specific globals +++}

const                                                                  {!!.01}
  {Custom error codes}                                                 {!!.01}
  ecDDEFailed        = 9991;                                           {!!.01}

{General purpose routines}

  procedure WaitCursor;
    {-Set hourglass cursor}
  begin
    OldCursor := SetCursor(LoadCursor(0, idc_Wait));
  end;

  procedure RestoreCursor;
    {-Remove hourglass cursor and restore old}
  begin
    SetCursor(OldCursor);
  end;

  procedure InsertCommas(P : PChar);
    {-Inserts commas in P (assumed to be a number)}
  var
    Temp : array[0..9] of Char;
    Len : Byte;
    I : Word;
  begin
    Len := StrLen(P);
    if Len = 7 then begin
      StrChInsert(Temp, P, ',', 1);
      StrChInsert(Temp, Temp, ',', 5);
    end else if Len > 3 then
      StrChInsert(Temp, P, ',', Len-3);
    StrCopy(P, Temp);
  end;

  procedure Yield;
    {-This procedure replaces the Windows API call Yield. Window's
      Yield function will not yield to other processes if the
      calling program has a message at the top of the system queue.}
  var
    Msg : TMsg;
  begin
    if PeekMessage(Msg, 0, 0, 0, pm_Remove) then begin
      TranslateMessage(Msg);
      DispatchMessage(Msg);
    end;
  end;

  function ReportError(ErrCode : Integer) : Boolean;
    {-Report error and ask if we should continue (true means continue)}
  const
    DosErrorCode : array[0..3] of Char = '000';
  var
    P : PChar;
    P1 : TCharArray;
    Msg : TCharArray;
    Continue : Boolean;
  begin
    case ErrCode of
      ecUserAbort :
        {already reported, just exit}
        begin
          ReportError := False;
          Exit;
        end;
      ecOutOfMemory :
        begin
          Continue := False;
          P := 'Not enough memory to run INSTALL . Close other applications'+
               ' and restart INSTALL.';
        end;
      ecBadWindowsMode :
        begin
          Continue := False;
          P := 'INSTALL cannot be run in real mode -- restart Windows '+
               'in Standard or Enhanced mode';
        end;
      ecDiskFull :
        begin
          Continue := False;
          P := 'Disk is full. Exit INSTALL and assure that '+
               'enough free space is available on your selected ' +
               'drives.';
        end;
      ecWriteProtected :
        begin
          Continue := True;
          P := 'Disk is write protected. Remove the write protection or'+
               'select a different destination drive.';
        end;
      ecDriveNotReady :
        begin
          Continue := False;
          P := 'Drive not ready. Make the drive ready or select a '+
               'different drive.';
        end;
      else
        begin
          Continue := True;
          StrCopy(P1, 'Got DOS error ');
          Long2Str(DosErrorCode, ErrCode);
          StrCat(P1, DosErrorCode);
          StrCat(P1, '.');
          P := P1;
        end;
    end;

    {Inform user of problem}
    if Continue then begin
      StrCopy(Msg, P);
      StrCat(Msg, '  Select OK to continue or Cancel to cancel.');

      ReportError := BWCCMessageBox(Application^.MainWindow^.HWindow, Msg, 'Error',
                     mb_IconExclamation+mb_OKCancel+mb_DefButton2) = id_Ok;
    end else begin
      StrCopy(Msg, P);
      StrCat(Msg, '  Stopping INSTALL.');
      BWCCMessageBox(Application^.MainWindow^.HWindow, Msg, 'Error',
                     mb_IconExclamation+mb_OK);
      ReportError := False;
    end;
  end;

  function GetBytesRequired : LongInt;
    {-Return number of bytes required for currently selected options}
  var
    I : Word;
    L : LongInt;
  begin
    L := 0;
    for I := 1 to FileCnt do
      with Files^[I] do
        if DestDir <> 0 then
          if FlagIsSet(Groups, Group) then
            Inc(L, Files^[I].Size);
    GetBytesRequired := L;
  end;

  function OkToWriteDLL(DllName : PChar; NewVer : LongInt) : Boolean;
    {-Return True if it's ok to overwrite DllName with NewVer}
  var
    BufSize : Longint;
    Handle : Longint;
    Buffer : Pointer;
    FileInfo : Pvs_FixedFileInfo;
    Len : Word;

  begin
    {Assume we should overwrite}
    OkToWriteDll := True;
    Buffer := nil;

    {Find file and get a buffer}
    BufSize := GetFileVersionInfoSize(DllName, Handle);
    if (BufSize = 0) or (BufSize > 65535) or not GetMemCheck(Buffer, BufSize) then
      Exit;

    {Fill the buffer}
    if not GetFileVersionInfo(DllName, Handle, BufSize, Buffer) then begin
      FreeMemCheck(Buffer, BufSize);
      Exit;
    end;

    if not VerQueryValue(Buffer, '\', Pointer(FileInfo), Len) then begin
      FreeMemCheck(Buffer, BufSize);
      Exit;
    end;

    {Should we overwrite?}
    OkToWriteDll := NewVer > FileInfo^.dwFileVersionMS;
    FreeMemCheck(Buffer, BufSize);
  end;

  function MyShowProgressFunc(BytesWritten, TotalBytes : LongInt) : Boolean; far;
    {-Update the FileMeter and FilePercent controls}
  var
    Ratio : Word;
  begin
    {Show file progress}
    Ratio := (BytesWritten * 100 ) div TotalBytes;
    PInstallWindow(Application^.MainWindow)^.Progress^.SetFileMeter(Ratio);

    {Show total progress}
    if BytesWritten = TotalBytes then begin
      Inc(BytesTransferred, TotalBytes);
      Ratio := (BytesTransferred * 100 ) div GetBytesRequired;
      PInstallWindow(Application^.MainWindow)^.Progress^.SetAllMeter(Ratio);
    end;

    Yield;
    MyShowProgressFunc := not CancelFlag;
  end;

  function StUpcase(S : String) : String;
  var
    I : Word;
  begin
    for I := 1 to Length(S) do
      S[I] := Upcase(S[I]);
    StUpcase := S;
  end;

  function FindFile(FName : String) : Integer;
    {-Return the index of FName in Files}
  var
    I : Word;
  begin
    for I := 1 to FileCnt do begin
      if FName = StUpcase(Files^[I].Name) then begin
        {Assure this is a selected file}
        if FlagIsSet(Groups, Files^[I].Group) then
          {Make sure we haven't copied this file already (for dups)}
          if not Files^[I].Tagged then begin
            Files^[I].Tagged := True;
            FindFile := I;
            Exit;
          end;
      end;
    end;
    FindFile := -1;
  end;

  function MyOkToWriteFunc(var LH : LzhHeader; var FName : String) : Boolean; far;
    {-If not overwriting files, return True only if LH is newer than FName}
  type
    DT = record
      Time : Word;
      Date : Word;
    end;
  var
    NewF : File;
    NTime : DT;
    S : String;
    NewName : TCharArray;
    Index : Integer;
    DoIt : Boolean;
    P1, P2 : array[0..40] of Char;
    PName : array[0..80] of Char;
    Ratio : Word;

    procedure AdjustFileName(P : PChar);
    var
      Name : array[0..8] of Char;
      Ext  : array[0..3] of Char;
    begin
      JustExtension(Ext, P);
      JustName(Name, P);
      if StrIComp(Ext, 'EXC') = 0 then begin
        StrCopy(P, Name);
        StrCat(P, '.exe');
      end;
    end;

  begin
    {Add destination directory}
    Index := FindFile(FName);
    if Index = -1 then begin
      {Shouldn't ever happen, but ....}
      MyOkToWriteFunc := False;
      Exit;
    end;

    with Files^[Index] do begin
      {Always add destination directory}
      StrCopy(NewName, DestDirs[DestDir]);
      AddBackSlash(NewName, NewName);
      S := StrPas(NewName);
      S := S + FName;
      FName := S;
    end;

    {if Always check VER or filedate before overwriting file}
    if gOverwriteAlways then begin
      StrPCopy(PName, FName);
      JustExtension(P1, PName);
      if (StrIComp(P1, 'EXE') = 0) or (StrIComp(P1, 'DLL') = 0) then
        {If DLL or EXE then check VER info}
        DoIt := OkToWriteDll(PName, Files^[Index].FileVer)
      else begin
        {Compare file dates, overwrite only if newer}
        Assign(NewF, FName);
        Reset(NewF);
        if IOResult <> 0 then
          DoIt:= True
        else begin
          GetFTime(NewF, LongInt(NTime));
          if LH.Date > DT(NTime).Date then
            DoIt := True
          else if (LH.Date = DT(NTime).Date) and
                  (LH.Time > DT(NTime).Time) then
            DoIt := True
          else
            DoIt := False;
        end;
        Close(NewF);
        if IOResult <> 0 then ;
      end;
    end else begin
      {Only write file if it doesn't already exist}
      Assign(NewF, FName);
      Reset(NewF);
      DoIt := IOResult <> 0;
    end;

    {Assure hourglass cursor is gone}
    RestoreCursor;

    {Always show extraction message}
    StrCopy(P1, 'Extracting file ');
    StrPCopy(P2, Files^[Index].Name);
    AdjustFileName(P2);
    StrCat(P1, P2);
    PInstallWindow(Application^.MainWindow)^.Progress^.SetStatusMsg(P1);

    if DoIt then
      {Show initial progress}
      PInstallWindow(Application^.MainWindow)^.Progress^.SetFileMeter(0)
    else begin
      {Increment all meter as though this file was just extracted}
      Inc(BytesTransferred, LH.OrigSize);
      Ratio := (BytesTransferred * 100 ) div GetBytesRequired;
      PInstallWindow(Application^.MainWindow)^.Progress^.SetAllMeter(Ratio);
    end;
    MyOkToWriteFunc := DoIt;
  end;

  function MySuccessFunc(var LH  : LzhHeader;
                         FName : String;
                         ErrCode : Word) : Boolean; far;
    {-Report errors}
  var
    Ratio : Word;
  begin
    if ErrCode <> 0 then
      MySuccessFunc := ReportError(ErrCode)
    else
      MySuccessFunc := True;
  end;

  function MySeekStatusFunc(CurSeek : LongInt; LH : LzhHeader) : Boolean; far;
    {-Update the FileMeter to show seeking progress}
  var
    Ratio : Word;
  begin
    {Show file progress}
    if LzhFileSize <> 0 then
      Ratio := (CurSeek * 100 ) div LzhFileSize
    else
      Ratio := 0;
    PInstallWindow(Application^.MainWindow)^.Progress^.SetFileMeter(Ratio);
    Yield;
    MySeekStatusFunc := not CancelFlag;
  end;

  function NoSeekStatus(CurSeek : LongInt; LH : LzhHeader) : Boolean; far;
    {-No status right now}
  begin
    NoSeekStatus := True;
  end;

  function CopyFile(SrcPath, DestPath : PChar;
                    Buffer : Pointer;
                    BufferSize : Word;
                    ShowStatus : Boolean;
                    Ver : LongInt) : Word;
    {-Copy the file specified by SrcPath into DestPath. DestPath must specify
      a complete filename, it may not be the name of a directory without the
      file portion.  This a low level routine, and the input pathnames are not
      checked for validity. Buffer must already be allocated, and must be no
      less than BufferSize.}
  type
    DT = record
      Time : Word;
      Date : Word;
    end;
  var
    NTime : DT;
    STime : DT;
    BytesRead,BytesWritten : Word;
    TotalBytes, DoneBytes : LongInt;
    Ratio : Word;
    Time : LongInt;
    Src,Dest : File;
    SaveFileMode : Word;
    SaveFAttr : Word;
    Result : Word;
    P : array[0..80] of Char;

    procedure UnDo(CloseAndDeleteDest : Boolean);
    begin
      Close(Src);
      if IoResult <> 0 then ;
      if CloseAndDeleteDest then begin
        Close(Dest);
        if IoResult <> 0 then ;
        Erase(Dest);
        if IoResult <> 0 then ;
      end;
    end;

  begin
    {Should we copy?}
    CopyFile := ecOk;

    if gOverwriteAlways then begin
      if ExistFile(DestPath) then begin
        JustExtension(P, DestPath);
        if (StrIComp(P, 'EXE') = 0) or (StrIComp(P, 'DLL') = 0) then
          {If DLL or EXE then check VER info}
          if not OkToWriteDll(DestPath, Ver) then
            Exit
          else
        else begin
          {Compare file dates, overwrite only if newer}
          Assign(Dest, DestPath);
          Reset(Dest);
          GetFTime(Dest, LongInt(NTime));
          Assign(Src, SrcPath);
          Reset(Src);
          GetFTime(Src, LongInt(STime));
          Close(Dest);
          Close(Src);
          if IOResult <> 0 then
            Exit
          else if DT(STime).Date <= DT(NTime).Date then
            Exit
          else if not ((DT(STime).Date = DT(NTime).Date) and
                       (DT(STime).Time > DT(NTime).Time)) then
           Exit;
        end;
      end;
    end else begin
      {Never mode - only write file if it doesn't already exist}
      if ExistFile(DestPath) then
        Exit;
    end;

    {If we get here we should copy file}
    SaveFileMode := FileMode;
    FileMode := FileMode and $F0;
    Assign(Src,SrcPath);
    GetFAttr(Src, SaveFAttr);
    if DosError <> 0 then begin
      CopyFile := DosError;
      Exit;
    end;
    Reset(Src,1);
    FileMode := SaveFileMode;
    Result := IoResult;
    if Result <> 0 then begin
      CopyFile := Result;                   {unable to open SrcPath}
      Exit;
    end;
    Assign(Dest,DestPath);
    Rewrite(Dest,1);
    Result := IoResult;
    if Result <> 0 then begin
      CopyFile := Result;                   {unable to open DestPath}
      Undo(False);
      Exit;
    end;

    {Show status if asked}
    if ShowStatus then begin
      {Init status vars}
      DoneBytes := 0;
      TotalBytes := FileSize(Src);

      {Draw initial status bar}
      PInstallWindow(Application^.MainWindow)^.Progress^.SetFileMeter(0);
      Yield;
    end;

    while not EOF(Src) do begin
      BlockRead(Src,Buffer^,BufferSize,BytesRead);
      Result := IoResult;
      if Result <> 0 then begin
        CopyFile := Result;                 {error reading SrcPath}
        UnDo(True);
        Exit;
      end;
      BlockWrite(Dest,Buffer^,BytesRead,BytesWritten);
      Result := IoResult;
      if Result <> 0 then begin
        CopyFile := Result;                 {error writing DestPath}
        UnDo(True);
        Exit;
      end;
      if BytesWritten <> BytesRead then begin
        CopyFile := ecDiskFull;              {error writing DestPath}
        UnDo(True);
        Exit;
      end;

      {Update status bar if necessary}
      if ShowStatus then begin
        Inc(DoneBytes, BytesWritten);
        Ratio := (DoneBytes * 100 ) div TotalBytes;
        PInstallWindow(Application^.MainWindow)^.Progress^.SetFileMeter(Ratio);
        Yield;
      end;

      {Check for cancel}
      if CancelFlag then begin
        Undo(True);
        CopyFile := ecUserAbort;
        Exit;
      end;
    end;

    {Get/set source timestamp}
    GetFTime(Src,Time);
    SetFTime(Dest,Time);

    {Close up}
    Close(Dest);
    Result := IoResult;
    if Result <> 0 then begin
      CopyFile := Result;
      Close(Src);
      if IoResult <> 0 then ;
    end else begin
      Close(Src);
      if IoResult <> 0 then ;
      CopyFile := 0;
    end;
    SetFAttr(Dest, SaveFAttr);
  end;

{TOptionWindow}

  procedure InitOptionData(var Data : OptionDataRec);
    {-Initialize test data}
  begin
    {Initialize all fields in transfer record}
    with Data do begin
      Pascal            := Ord(gPascal);
      Cpp               := Ord(gCpp);
      OverwriteAlways   := Ord(gOverwriteAlways);
      OverwriteNever    := Ord(gOverwriteNever);
      OverwriteCompiler := Ord(gOverwriteCompiler);
      BC30              := Ord(gBC30);
      BC31              := Ord(gBC31);
      TC30              := Ord(gTC30);
      TC31              := Ord(gTC31);
      CreateGroup       := Ord(gCreateGroup);
      DllSource         := Ord(gDllSource);
      Examples          := Ord(gExamples);
      Utilities         := Ord(gUtilities);
      Demos             := Ord(gDemos);
      Help              := Ord(gHelp);
      ModifyINI         := Ord(gModifyINI);
      PascalPrimary     := Ord(gPascalPrimary);
    end;
  end;

  constructor TOptionWindow.Init(AParent : PWindowsObject; var Data : OptionDataRec);
    {-Instantiate Option window}
  var
    CP : PControl;
  begin
    {Init our transfer buffer first}
    InitOptionData(Data);

    {Do the parent}
    TDlgWindow.Init(AParent, 'OPTIONS');
    TransferBuffer := @Data;

    {Initialize control objects}
    CP := New(PCheckBox, InitResource(@Self, id_Pascal));
    CP := New(PCheckBox, InitResource(@Self, id_Cpp));
    CP := New(PRadioButton, InitResource(@Self, id_OverwriteAlways));
    CP := New(PRadioButton, InitResource(@Self, id_OverwriteNever));
    CP := New(PRadioButton, InitResource(@Self, id_OverwriteCompiler));
    CP := New(PRadioButton, InitResource(@Self, id_BC30));
    CP := New(PRadioButton, InitResource(@Self, id_BC31));
    CP := New(PRadioButton, InitResource(@Self, id_TC30));
    CP := New(PRadioButton, InitResource(@Self, id_TC31));
    CP := New(PCheckBox, InitResource(@Self, id_CreateGroup));
    CP := New(PCheckBox, InitResource(@Self, id_DllSource));
    CP := New(PCheckBox, InitResource(@Self, id_Examples));
    CP := New(PCheckBox, InitResource(@Self, id_Utilities));
    CP := New(PCheckBox, InitResource(@Self, id_Demos));
    CP := New(PCheckBox, InitResource(@Self, id_Help));
    CP := New(PCheckBox, InitResource(@Self, id_ModifyINI));
    CP := New(PCheckBox, InitResource(@Self, id_PascalPrimary));
  end;

  function TOptionWindow.CanClose : Boolean;
    {-Assure either Pascal or C button is checked}
  var
    PButton : PCheckBox;
    CButton : PCheckBox;
  begin
    PButton := PCheckBox(ChildWithID(id_Pascal));
    CButton := PCheckBox(ChildWithID(id_Cpp));
    if (PButton^.GetCheck = bf_Unchecked) and
       (CButton^.GetCheck = bf_Unchecked) then begin
      {Error -- one of these must be checked}
      CanClose := False;
      BWCCMessageBox(Application^.MainWindow^.hWindow,
                     'You must check Install Pascal, Install C++, or both.',
                     'Error', mb_IconStop+mb_Ok);
    end else
      CanClose := True;
  end;

  procedure TOptionWindow.idHelp(var Msg : TMessage);
    {-Show brief help message}
  begin
    BWCCMessageBox(0,
                   'Use these options to customize the behavior ' +
                   'of INSTALL. See section 1.B of the manual ' +
                   'for more information',
                   'Information', mb_Ok+mb_TaskModal);
  end;

  procedure TOptionWindow.SelectPascal(var Msg : TMessage);
    {-Enable or disable DLL checkbox based on new state of id_Pascal control}
  var
    CPascal : PCheckBox;
    CDLL    : PCheckBox;
  begin
    CPascal := PCheckBox(ChildWithID(id_Pascal));
    CDLL := PCheckBox(ChildWithID(id_DLLSource));

    if CPascal^.GetCheck = bf_Unchecked then begin
      {id_Pascal just unselected, unselect id_DLLSource and grey it}
      CDLL^.UnCheck;
      EnableWindow(CDLL^.HWindow, False)
    end else
      {Pascal just selected, ungrey DLL control}
      EnableWindow(CDLL^.HWindow, True);
  end;

{TDirectoriesWindow}

  procedure InitDirectoryData(var Data : DirectoryDataRec);
    {-Initialize all fields in transfer record}
  begin
    with Data do begin
      StrCopy(PascalDir, gPascalDir);
      StrCopy(PascalDemoDir, gPascalDemoDir);
      StrCopy(CDir, gCDir);
      StrCopy(CDemoDir, gCDemoDir);
      StrCopy(UtilityDir, gUtilityDir);
      StrCopy(DllDir, gDllDir);
      StrCopy(BonusDir, gBonusDir);
      StrCopy(HelpDir, gHelpDir);
    end;
  end;

  function DiffDrive(A, B : PChar) : Boolean;
  begin
    DiffDrive := True;
    if (A[1] = ':') and (B[1] = ':') then
      if Upcase(A[0]) = Upcase(B[0]) then
        DiffDrive := False;
  end;

  procedure UpdateSubDirs(NewDir : PChar);
    {-Update the subdir fields based on current contents and gToDirectory}
  var
    P1 : array[0..255] of Char;
    DefDir : PChar;
    P : PChar;
    Work : TCharArray;
    Len : Byte;
    SaveDir : PChar;

    procedure CheckDir(CurDir, SubDir : PChar);
      {-Replace base of CurDir if its base is same as old base}
    begin
      {Exit if drives are different}
      if DiffDrive(gOldToDirectory, CurDir) then
        Exit;

      SaveDir := CurDir;
      Inc(CurDir, 3);
      P := StrScan(CurDir, '\');
      if P <> nil then begin
        Len := P - CurDir;
        StrCopy(Work, CurDir);
        Work[Len] := #0;
      end else if SubDir[0] = #0 then                                  {!!.01}
        StrCopy(Work, CurDir)                                          {!!.01}
      else                                                             {!!.01}
        Exit;                                                          {!!.01}

      if StrIComp(DefDir, Work) = 0 then begin
        StrCopy(SaveDir, NewDir);
        if SubDir[0] <> #0 then
          AddBackSlash(SaveDir, SaveDir);
        StrCat(SaveDir, SubDir);
      end;
    end;

  begin
    DefDir := gOldToDirectory;
    Inc(DefDir, 3);

    CheckDir(gPascalDir, DefPascalDir);
    CheckDir(gPascalDemoDir, DefPascalDemoDir);
    CheckDir(gCDir, DefCDir);
    CheckDir(gCDemoDir, DefCDemoDir);
    CheckDir(gUtilityDir, DefUtilityDir);
    CheckDir(gBonusDir, DefBonusDir);
    CheckDir(gHelpDir, DefHelpDir);
  end;

  constructor TDirectoriesWindow.Init(AParent : PWindowsObject; var Data : DirectoryDataRec);
    {-Instantiate Directories window}
  var
    CP : PControl;
  begin
    {Init our transfer buffer first}
    InitDirectoryData(Data);

    {Do the parent}
    TDlgWindow.Init(AParent, 'DIRECTORIES');
    TransferBuffer := @Data;

    {Initialize control objects}
    CP := New(PEdit, InitResource(@Self, id_PascalDir, 80));
    CP := New(PEdit, InitResource(@Self, id_PascalDemoDir, 80));
    CP := New(PEdit, InitResource(@Self, id_CDir, 80));
    CP := New(PEdit, InitResource(@Self, id_CDemoDir, 80));
    CP := New(PEdit, InitResource(@Self, id_UtilityDir, 80));
    CP := New(PEdit, InitResource(@Self, id_DllDir, 80));
    CP := New(PEdit, InitResource(@Self, id_BonusDir, 80));
    CP := New(PEdit, InitResource(@Self, id_HelpDir, 80));
  end;

  procedure TDirectoriesWindow.idHelp(var Msg : TMessage);
    {-Show brief help message}
  begin
    BWCCMessageBox(0,
                   'Specify the various destination subdirectories ' +
                   'that INSTALL will use. See section 1.B of the manual ' +
                   'for more information',
                   'Information', mb_Ok+mb_TaskModal);
  end;

{TCDirectoriesWindow}

  procedure InitCDirectoryData(var Data : CDirectoryDataRec);
    {-Initialize all fields in transfer record}
  begin
    with Data do begin
      StrCopy(BcIncDir,    gBcIncDir);
      StrCopy(ClassIncDir, gClassIncDir);
      StrCopy(OwlIncDir,   gOwlIncDir);
      StrCopy(WsIncDir,    gWsIncDir);
      StrCopy(BcLibDir,    gBcLibDir);
      StrCopy(ClassLibDir, gClassLibDir);
      StrCopy(OwlLibDir,   gOwlLibDir);
      StrCopy(WsLibDir,    gWsLibDir);
      StrCopy(CompilerDir, gCompilerDir);
      StrCopy(BcRootDir,   gBcRootDir);
    end;
  end;

  procedure CopyCDirectoryData(var Data : CDirectoryDataRec);
    {-Copy data from transfer buffer to global vars}
  begin
    with Data do begin
      StrCopy(gBcIncDir, BcIncDir);
      StrCopy(gClassIncDir, ClassIncDir);
      StrCopy(gOwlIncDir, OwlIncDir);
      StrCopy(gWsIncDir, WsIncDir);
      StrCopy(gBcLibDir, BcLibDir);
      StrCopy(gClassLibDir, ClassLibDir);
      StrCopy(gOwlLibDir, OwlLibDir);
      StrCopy(gWsLibDir, WsLibDir);
      StrCopy(gCompilerDir, CompilerDir);
      StrCopy(gBcRootDir, BcRootDir);
    end;
  end;

  procedure UpdateCSubDirs(NewDir : PChar);
    {-Update the C subdir fields based on current contents and gToDirectory}
  var
    DefDir : PChar;
    P : PChar;
    Work : TCharArray;
    Len : Byte;
    SaveDir : PChar;

    procedure CheckDir(CurDir, SubDir : PChar);
      {-Replace base of CurDir if its base is same as old base}
    begin
      {Exit if drives are different}
      if DiffDrive(gOldToDirectory, CurDir) then
        Exit;

      SaveDir := CurDir;
      Inc(CurDir, 3);
      P := StrScan(CurDir, '\');
      if P <> nil then begin
        Len := P - CurDir;
        StrCopy(Work, CurDir);
        Work[Len] := #0;
      end else if SubDir[0] = #0 then                                  {!!.01}
        StrCopy(Work, CurDir)                                          {!!.01}
      else                                                             {!!.01}
        Exit;                                                          {!!.01}

      if StrIComp(DefDir, Work) = 0 then begin
        StrCopy(SaveDir, NewDir);
        if SubDir[0] <> #0 then
          AddBackSlash(SaveDir, SaveDir);
        StrCat(SaveDir, SubDir);
      end;
    end;

  begin
    DefDir := gOldBcRootDir;
    Inc(DefDir, 3);

    CheckDir(gBcIncDir, DefBcIncDir);
    CheckDir(gClassIncDir, DefClassIncDir);
    CheckDir(gOwlIncDir, DefOwlIncDir);
    CheckDir(gBcLibDir, DefBcLibDir);
    CheckDir(gClassLibDir, DefClassLibDir);
    CheckDir(gOwlLibDir, DefOwlLibDir);
    CheckDir(gCompilerDir, DefCompilerDir);
  end;

  procedure UpdateCDewSubDirs(NewDir : PChar);
    {-Update the C subdir fields based on current contents and gToDirectory}
  var
    DefDir : PChar;
    P : PChar;
    Work : TCharArray;
    Len : Byte;
    SaveDir : PChar;

    procedure CheckDir(CurDir, SubDir : PChar);
      {-Replace base of CurDir if its base is same as old base}
    begin
      {Exit if drives are different}
      if DiffDrive(gOldToDirectory, CurDir) then
        Exit;

      SaveDir := CurDir;
      Inc(CurDir, 3);
      P := StrScan(CurDir, '\');
      if P <> nil then begin
        Len := P - CurDir;
        StrCopy(Work, CurDir);
        Work[Len] := #0;
      end else if SubDir[0] = #0 then                                  {!!.01}
        StrCopy(Work, CurDir)                                          {!!.01}
      else                                                             {!!.01}
        Exit;                                                          {!!.01}

      if StrIComp(DefDir, Work) = 0 then begin
        StrCopy(SaveDir, NewDir);
        if SubDir[0] <> #0 then
          AddBackSlash(SaveDir, SaveDir);
        StrCat(SaveDir, SubDir);
      end;
    end;

  begin
    DefDir := gOldToDirectory;
    Inc(DefDir, 3);

    CheckDir(gWsIncDir, DefWsIncDir);
    CheckDir(gWsLibDir, DefWsLibDir);
  end;

  constructor TCDirectoriesWindow.Init(AParent : PWindowsObject; var Data : CDirectoryDataRec);
    {-Instantiate CDirectories window}
  var
    CP : PControl;
  begin
    {Init our transfer buffer first}
    InitCDirectoryData(Data);

    {Do the parent}
    TDlgWindow.Init(AParent, 'CDIRECTORIES');
    TransferBuffer := @Data;

    {Initialize control objects}
    CP := New(PEdit, InitResource(@Self, id_BcIncDir, 80));
    CP := New(PEdit, InitResource(@Self, id_ClassIncDir, 80));
    CP := New(PEdit, InitResource(@Self, id_OwlIncDir, 80));
    CP := New(PEdit, InitResource(@Self, id_WsIncDir, 80));
    CP := New(PEdit, InitResource(@Self, id_BcLibDir, 80));
    CP := New(PEdit, InitResource(@Self, id_ClassLibDir, 80));
    CP := New(PEdit, InitResource(@Self, id_OwlLibDir, 80));
    CP := New(PEdit, InitResource(@Self, id_WsLibDir, 80));
    CP := New(PEdit, InitResource(@Self, id_CompilerDir, 80));
    CP := New(PEdit, InitResource(@Self, id_BcRootDir, 80));
  end;

  procedure TCDirectoriesWindow.idHelp(var Msg : TMessage);
    {-Show brief help message}
  begin
    BWCCMessageBox(0,
                   'INSTALL uses this directory information solely '+
                   'to update various *.MAK and *.CFG files. No files '+
                   'are copied to any BC directories. See '+
                   'section 1.B of the manual for more information.',
                   'Information', mb_Ok+mb_TaskModal);
  end;

  procedure TCDirectoriesWindow.UpdateNames(var Msg: TMessage);
    {-Base BC dir may have changed -- update other dirs}
  begin
    case Msg.LParamHi of
      en_KillFocus :
        begin
          TransferData(tf_GetData);
          CopyCDirectoryData(CDirectoryData);
          StrUpper(gBcRootDir);
          UpdateCSubDirs(gBcRootDir);
          InitCDirectoryData(CDirectoryData);
          TransferData(tf_SetData);
        end;
      en_SetFocus :
        {Note original root directory}
        StrCopy(gOldBcRootDir, gBcRootDir);
    end
  end;

{TInstallWindow}

  function CheckFreeSpace : Boolean;
    {-Assure target drives have enough free space}
  var
    I : Word;
    Result : Word;
    Drive : Char;
    DriveIndex : Byte;
    Drives : array[1..26] of LongInt;
    Free : LongInt;
    P : PChar;
  begin
    {Assume we'll be continuing}
    CheckFreeSpace := True;

    {Sum selected file sizes into appropriate Drive bins}
    FillChar(Drives, SizeOf(Drives), 0);
    for I := 1 to FileCnt do begin
      with Files^[I] do begin
        if DestDir <> 0 then
          if FlagIsSet(Groups, Group) then begin
            Drive := DestDirs[DestDir, 0];
            DriveIndex := Ord(Drive) - Ord('A') + 1;
            Inc(Drives[DriveIndex], Size);
          end;
      end;
    end;

    {Review drive bins and warn of too little free space}
    for I := 3 to 26 do
      if Drives[I] <> 0 then begin
        Free := DiskFree(I);
        if Free < Drives[I] then begin
          P := 'Drive X: doesn''t exist or doesn''t have enough free space for your requested files. Continue anyway?';
          P[6] := Char(I + Ord('A') - 1);
          Result := BWCCMessageBox(Application^.MainWindow^.hWindow, P,
                                   'Warning',
                                   mb_IconStop+mb_YesNo+mb_DefButton2);
          if (Result = id_No) or (Result = id_Cancel) then begin
            CheckFreeSpace := False;
            Exit;
          end;
        end;
      end;
  end;

  procedure InitMainData(var Data : MainDataRec);
    {Initialize all fields in transfer record}
  begin
    with Data do begin
      StrCopy(ToDirectory, DefToDirectory);
      StrCopy(FromDirectory, DefFromDirectory);
      StrCopy(BytesRequired, ' 0 bytes');
    end;
  end;

  function Less(SR : Pointer; var X, Y) : WordBool;
  {$IFDEF Export} Export; {$ELSE} far; {$ENDIF}
    {-Return True if X is less than Y}
  var
    X1 : FileInfoRec absolute X;
    Y1 : FileInfoRec absolute Y;
    XDisk : Byte;
    YDisk : Byte;
  begin
    {Note media type}
    case Media of
      Disk360 :
        begin
          XDisk := X1.Disk36;
          YDisk := Y1.Disk36;
        end;
      Disk720 :
        begin
          XDisk := X1.Disk72;
          YDisk := Y1.Disk72;
        end;
      Disk1200 :
        begin
          XDisk := X1.Disk12;
          YDisk := Y1.Disk12;
        end;
      Disk1440 :
        begin
          XDisk := X1.Disk14;
          YDisk := Y1.Disk14;
        end;
    end;

    {Compare first on disk number, then on name}
    if XDisk < YDisk then
      Less := True
    else if XDisk = YDisk then
      Less := X1.Name < Y1.Name
    else
      Less := False;

    {Yield occasionally}
    if LessCnt mod YieldFactor = 0 then
      Yield;
    Inc(LessCnt);
  end;

  procedure GetElements(SR : Pointer);
  {$IFDEF Export} Export; {$ELSE} far; {$ENDIF}
    {-Send all Files elements to the sort}
  var
    I : Word;
  begin
    for I := 1 to FileCnt do begin
      Yield;
      if not PutElement(SR, Files^[I]) then
        Exit;
    end;
  end;

  procedure PutElements(SR : Pointer);
  {$IFDEF Export} Export; {$ELSE} far; {$ENDIF}
    {-Retrieve sorted Files elements}
  var
    LastElem : LongInt;
    I : Word;
  begin
    I := 1;
    while GetElement(SR, Files^[I]) do begin
      Yield;
      Inc(I);
    end;
  end;

  constructor TInstallWindow.Init(AParent : PWindowsObject; var Data : MainDataRec);
    {-Instantiate the main window}
  var
    CP : PControl;
    P : TCharArray;
    L : LongInt;
    Result : Word;
  begin
    TDlgWindow.Init(AParent, 'MAIN');
    TransferBuffer := @Data;

    {Initialize control objects}
    CP := New(PEdit, InitResource(@Self, id_ToDirectory, 80));
    CP := New(PEdit, InitResource(@Self, id_FromDirectory, 80));
    CP := New(PEdit, InitResource(@Self, id_BytesRequired, 16));

    {Do other non-window related inits}
    LoadFiles;
    if ArchiveStatus <> ecOk then
      if not ReportError(ArchiveStatus) then
        Exit;

    {Set initial default values for dialog boxes}
    ResetDefaults;

    {Get the Windows system directory}
    Result := GetSystemDirectory(gDllDir, SizeOf(gDllDir));
    if Result = 0 then
      {Failed to get system directory, use root dir}
      StrCopy(gDllDir, gToDirectory);

    {Note the system directory in case user changes DLL directory}
    StrCopy(gSystemDir, gDllDir);

    {Set bytes required static control value in transfer buffer}
    L := GetBytesRequired;
    Long2Str(P, L);
    InsertCommas(P);
    StrCopy(Data.BytesRequired, P);
    StrCat(Data.BytesRequired, ' bytes');
  end;

  procedure TInstallWindow.ResetDefaults;
    {-Reset all options to their default values}

    procedure MakeDir(P : PChar);
    var
      P1 : TCharArray;
    begin
      StrCopy(P1, gToDirectory);
      if P[0] <> #0 then
        AddBackSlash(P1, P1);
      StrCat(P1, P);
      StrCopy(P, P1);
    end;

    procedure MakeBCDir(P : PChar);
    var
      P1 : TCharArray;
    begin
      StrCopy(P1, gBcRootDir);
      if P[0] <> #0 then
        AddBackSlash(P1, P1);
      StrCat(P1, P);
      StrCopy(P, P1);
    end;

  begin
    StrCopy(gToDirectory, DefToDirectory);
    StrCopy(gFromDirectory, DefFromDirectory);

    gPascal            := DefPascal = 1;
    gCpp               := DefCpp = 1;
    gOverwriteAlways   := DefOverwriteAlways = 1;
    gOverwriteNever    := DefOverwriteNever = 1;
    gOverwriteCompiler := DefOverwriteCompiler = 1;
    gBC30              := DefBC30 = 1;
    gBC31              := DefBC31 = 1;
    gTC30              := DefTC30 = 1;
    gTC31              := DefTC31 = 1;
    gCreateGroup       := DefCreateGroup = 1;
    gDllSource         := DefDllSource = 1;
    gExamples          := DefExamples = 1;
    gUtilities         := DefUtilities = 1;
    gDemos             := DefDemos = 1;
    gHelp              := DefHelp = 1;
    gModifyINI         := DefModifyINI = 1;
    gPascalPrimary     := DefPascalPrimary = 1;

    {Make default subdirectories from gToDirectory}
    StrCopy(gPascalDir, DefPascalDir);
    MakeDir(gPascalDir);
    StrCopy(gPascalDemoDir, DefPascalDemoDir);
    MakeDir(gPascalDemoDir);
    StrCopy(gCDir, DefCDir);
    MakeDir(gCDir);
    StrCopy(gCDemoDir, DefCDemoDir);
    MakeDir(gCDemoDir);
    StrCopy(gUtilityDir, DefUtilityDir);
    MakeDir(gUtilityDir);
    StrCopy(gBonusDir, DefBonusDir);
    MakeDir(gBonusDir);
    StrCopy(gHelpDir, DefHelpDir);
    MakeDir(gHelpDir);

    {Make default C directories}
    StrCopy(gBcRootDir, DefBcRootDir);
    StrCopy(gBcIncDir, DefBcIncDir);
    MakeBCDir(gBcIncDir);
    StrCopy(gClassIncDir, DefClassIncDir);
    MakeBCDir(gClassIncDir);
    StrCopy(gOwlIncDir, DefOwlIncDir);
    MakeBCDir(gOwlIncDir);
    StrCopy(gWsIncDir, DefWsIncDir);
    MakeDir(gWsIncDir);
    StrCopy(gBcLibDir, DefBcLibDir);
    MakeBCDir(gBcLibDir);
    StrCopy(gClassLibDir, DefClassLibDir);
    MakeBCDir(gClassLibDir);
    StrCopy(gOwlLibDir, DefOwlLibDir);
    MakeBCDir(gOwlLibDir);
    StrCopy(gWsLibDir, DefWsLibDir);
    MakeDir(gWsLibDir);
    StrCopy(gCompilerDir, DefCompilerDir);
    MakeBCDir(gCompilerDir);

    {Update groups flag}
    UpdateGroups;
  end;

  procedure TInstallWindow.UpdateGroups;
    {-Update Groups flags based on global booleans}
  const
    BitOnOff : array[Boolean] of LongInt = (0, 1);
  begin
    Groups := 1;

    {Set direct options}
    SetLongFlag(Groups, BitOnOff[gPascal] shl 1);
    SetLongFlag(Groups, BitOnOff[gCpp] shl 2);
    SetLongFlag(Groups, BitOnOff[gDllSource] shl 3);
    SetLongFlag(Groups, BitOnOff[gHelp] shl 10);

    {Set indirect options}
    if gPascal then begin
      if gExamples then
        SetLongFlag(Groups, gbPExamples);
      if gDemos then
        SetLongFlag(Groups, gbPDemos);
      if gUtilities then
        SetLongFlag(Groups, gbPUtilities);
    end;

    if gCpp then begin
      if gExamples then
        SetLongFlag(Groups, gbCExamples);
      if gDemos then
        SetLongFlag(Groups, gbCDemos);
      if gUtilities then
        SetLongFlag(Groups, gbCUtilities);
    end;
  end;

  procedure TInstallWindow.idDirButton(var Msg : TMessage);
    {-Execute the Directories dialog box}
  var
    P : TCharArray;
  begin
    {Update the base directory}
    GetDlgItemText(HWindow, id_ToDirectory, P, 80);
    if P[1] <> ':' then
      {Bad format entered, force back to default}
      StrCopy(P, DefToDirectory);
    StrUpper(P);

    if StrIComp(P, gToDirectory) <> 0 then begin
      {Base directory changed, go update subdirs}
      StrCopy(gOldToDirectory, gToDirectory);
      UpdateSubDirs(P);
      UpdateCDewSubDirs(P);
      StrCopy(gToDirectory, P);
    end;

    {Do the Directories dialog box}
    if Application^.ExecDialog(PWindowsObject(New(PDirectoriesWindow,
                    Init(@Self, DirectoryData)))) = id_Ok then begin

      {Copy transfer buffer contents to global vars}
      with DirectoryData do begin
        StrCopy(gPascalDir, PascalDir);
        StrCopy(gPascalDemoDir, PascalDemoDir);
        StrCopy(gCDir, CDir);
        StrCopy(gCDemoDir, CDemoDir);
        StrCopy(gUtilityDir, UtilityDir);
        StrCopy(gBonusDir, BonusDir);
        StrCopy(gHelpDir, HelpDir);
      end;
    end;
  end;

  procedure TInstallWindow.idCDirButton(var Msg : TMessage);
    {-Execute the CDirectories dialog box}
  var
    P : TCharArray;
  begin
    {Update the base directory}
    GetDlgItemText(HWindow, id_ToDirectory, P, 80);
    if P[1] <> ':' then
      {Bad format entered, force back to default}
      StrCopy(P, DefToDirectory);
    StrUpper(P);

    if StrIComp(P, gToDirectory) <> 0 then begin
      {Base directory changed, go update subdirs}
      StrCopy(gOldToDirectory, gToDirectory);
      UpdateSubDirs(P);
      UpdateCDewSubDirs(P);
      StrCopy(gToDirectory, P);
    end;

    {Do the Directories dialog box}
    if Application^.ExecDialog(PWindowsObject(New(PCDirectoriesWindow,
                               Init(@Self, CDirectoryData)))) = id_Ok then begin

      {Copy transfer buffer contents to global vars}
      with CDirectoryData do begin
        StrCopy(gBcIncDir,    BcIncDir);
        StrCopy(gClassIncDir, ClassIncDir);
        StrCopy(gOwlIncDir,   OwlIncDir);
        StrCopy(gWsIncDir,    WsIncDir);
        StrCopy(gBcLibDir,    BcLibDir);
        StrCopy(gClassLibDir, ClassLibDir);
        StrCopy(gOwlLibDir,   OwlLibDir);
        StrCopy(gWsLibDir,    WsLibDir);
        StrCopy(gCompilerDir, CompilerDir);
        StrCopy(gBcRootDir,   BcRootDir)
      end;
    end else begin
      {Restore old directories}
      StrCopy(P, gBcRootDir);
      StrCopy(gBcRootDir, gOldBcRootDir);
      StrCopy(gOldBcRootDir, P);
      UpdateCSubDirs(gBcRootDir);
    end;
  end;

  procedure TInstallWindow.idOptButton(var Msg : TMessage);
    {-Execute the Options dialog box}
  var
    PC : PStatic;
    P : array[0..15] of Char;
    L : LongInt;
  begin
    Application^.ExecDialog(PWindowsObject(New(POptionWindow,
                 Init(@Self, OptionData))));

    {Copy transfer buffer contents to global vars}
    with OptionData do begin
      gPascal            := Pascal = 1;
      gCpp               := Cpp = 1;
      gOverwriteAlways   := OverwriteAlways = 1;
      gOverwriteNever    := OverwriteNever = 1;
      gOverwriteCompiler := OverwriteCompiler = 1;
      gBC30              := BC30 = 1;
      gBC31              := BC31 = 1;
      gTC30              := TC30 = 1;
      gTC31              := TC31 = 1;
      gCreateGroup       := CreateGroup = 1;
      gDllSource         := DllSource = 1;
      gExamples          := Examples = 1;
      gUtilities         := Utilities = 1;
      gDemos             := Demos = 1;
      gHelp              := Help = 1;
      gModifyINI         := ModifyINI = 1;
      gPascalPrimary     := PascalPrimary = 1;
    end;

    {Set Groups bits based on booleans}
    UpdateGroups;

    {Update the bytes required field}
    PC := PStatic(ChildWithId(id_BytesRequired));
    L := GetBytesRequired;
    Long2Str(P, L);
    InsertCommas(P);
    StrCat(P, ' bytes');
    PC^.SetText(P);
  end;

  procedure TInstallWindow.BuildDestDirs;
    {-Fill DestDir}
  begin
    DestDirs[1] := gToDirectory;
    DestDirs[2] := gPascalDir;
    DestDirs[3] := gPascalDemoDir;
    DestDirs[4] := gCDir;
    DestDirs[5] := gCDemoDir;
    DestDirs[6] := gUtilityDir;
    DestDirs[7] := gBonusDir;
    DestDirs[8] := gHelpDir;
    DestDirs[9] := gDllDir;
  end;

  procedure TInstallWindow.MakeDestDirs;
    {-Build the destination directories}

    function AddBackSlash(DirName : String) : String;
      {-Add a default backslash to a directory name}
    const
      DosDelimSet : set of Char = ['\', ':', #0];
    begin
      if DirName[Length(DirName)] in DosDelimSet then
        AddBackSlash := DirName
      else
        AddBackSlash := DirName+'\';
    end;

    procedure MakeDir(Tree : PChar);
      {-Make the directory tree Tree}
    var
      I : Byte;
      P, N : String;
      PLen : Byte absolute P;
    begin
      P := '';
      N := AddBackSlash(StrPas(Tree));
      repeat
        I := Pos('\', N);
        if I <> 0 then begin
          P := AddBackslash(P)+Copy(N, 1, I-1);
          Delete(N, 1, I);
          if (PLen = 0) or (P[PLen] = ':') then
            P := P+'\'
          else begin
            MkDir(P);
            if IoResult <> 0 then ;
          end;
        end;
      until (I = 0);
    end;

  begin
    {Always make main directory}
    MakeDir(DestDirs[1]);

    {Need Pascal dirs?}
    if gPascal then begin
      MakeDir(DestDirs[2]);
      MakeDir(DestDirs[3]);
    end;

    {Need C dirs?}
    if gCpp then begin
      MakeDir(DestDirs[4]);
      MakeDir(DestDirs[5]);
    end;

    {Need utility dir?}
    if gUtilities then
      MakeDir(DestDirs[6]);

    {Always make bonus dir}
    MakeDir(DestDirs[7]);

    {Need help dir?}
    if gHelp then
      MakeDir(DestDirs[8]);
  end;

  procedure TInstallWindow.MakeGroup;
    {-Make a program manager group and install our program items}
  var
    I : Word;
  begin
    {Don't create a group unless we have something to add to it}
    if not gUtilities and not gDemos and not gHelp then
      Exit;

    {Instantiate our DDE  window}
    DDEWindow := New(PDDEWindow, Init);
    Application^.MakeWindow(DDEWindow);

    if ArchiveStatus = ecOk then
      {Create the groups and items}
      DDEWindow^.CreateGroup;

    {We're done}
    Dispose(DDEWindow, Done);
  end;

  procedure TInstallWindow.UpdateIni;
    {-Update WORKSHOP.INI}
  var
    P : TCharArray;
  begin
    StrCopy(P, gDllDir);
    AddBackSlash(P, P);
    StrCat(P, 'RWDEWCC.DLL');
    WritePrivateProfileString(ControlHeader, EntryFieldKey, P, IniName);

    StrCopy(P, gDllDir);
    AddBackSlash(P, P);
    StrCat(P, 'RWDEWSC.DLL');
    WritePrivateProfileString(ControlHeader, MeterControlKey, P, IniName);
  end;

  procedure TInstallWindow.RenameFiles;
    {-Handle duplicate files names}

    procedure RenameFile(Dir, OldName, NewName : PChar);
    var
      OldP, NewP : TCharArray;
      F : File;
    begin
      StrCopy(OldP, Dir);
      AddBackSlash(OldP, OldP);
      StrCat(OldP, OldName);
      StrCopy(NewP, Dir);
      AddBackSlash(NewP, NewP);
      StrCat(NewP, NewName);
      Assign(F, OldP);
      Rename(F, NewP);
      if IoResult <> 0 then ;
    end;

    procedure DeleteFile(Dir, FName : PChar);
    var
      P : TCharArray;
      F : File;
    begin
      StrCopy(P, Dir);
      AddBackSlash(P, P);
      StrCat(P, FName);
      Assign(F, P);
      Erase(F);
      if IoResult <> 0 then ;
    end;

  begin
    if gBC30 or gTC30 then begin
      {Give the TC30/BC30 libs the proper name}
      RenameFile(gCDir, 'DEWCC.LIB', 'DEWCC1.LIB');
      RenameFile(gCDir, 'DEWSC.LIB', 'DEWSC1.LIB');
      RenameFile(gCDir, 'WINSYS.LIB', 'WINSYS1.LIB');
      RenameFile(gCDir, 'DEWCC3.LIB', 'DEWCC.LIB');
      RenameFile(gCDir, 'DEWSC3.LIB', 'DEWSC.LIB');
      RenameFile(gCDir, 'WINSYS3.LIB', 'WINSYS.LIB');
    end else begin
      {Don't need the TC30/BC30 style libs}
      DeleteFile(gCDir, 'DEWCC3.LIB');
      DeleteFile(gCDir, 'DEWSC3.LIB');
      DeleteFile(gCDir, 'WINSYS3.LIB');
    end;

    if gCpp and gDemos then begin
      {Give the C++ executables the proper name}
      RenameFile(gCDemoDir, 'CUSTDATA.EXC', 'CUSTDATA.EXE');
      RenameFile(gCDemoDir, 'ADDRBOOK.EXC', 'ADDRBOOK.EXE');
      RenameFile(gCDemoDir, 'MDIDEMO.EXC',  'MDIDEMO.EXE');
      RenameFile(gCDemoDir, 'DOODLE.EXC',   'DOODLE.EXE');
    end;
  end;

  procedure TInstallWindow.UpdateMakeFiles;
    {-Update the macro tags in the MAKE files for our directories}
  var
    MakeName : TCharArray;
    BakName : TCharArray;

    function OpenWithBak(var T, Bak : Text; FName : PChar) : Word;
      {-Rename FName to .BAK, create new T, return T and Bak file vars}
    var
      DotPos : Word;
      Result : Word;
    begin
      {Make a BAK file name}
      StrCopy(BakName, FName);
      if HasExtension(FName, DotPos) then
        BakName[DotPos] := #0;
      StrCat(BakName, '.BAK');

      {Erase existing BAK file}
      Assign(T, BakName);
      Erase(T);
      if IoResult <> 0 then ;

      {Rename FName to BakName}
      Assign(Bak, FName);
      Rename(Bak, BakName);
      Result := IoResult;
      if Result <> 0 then begin
        OpenWithBak := Result;
        Exit;
      end;

      {Open Bak for reading}
      Reset(Bak);
      Result := IoResult;
      if Result <> 0 then begin
        OpenWithBak := Result;
        Exit;
      end;

      {Open T for writing}
      Assign(T, FName);
      Rewrite(T);
      Result := IoResult;
      if Result <> 0 then begin
        OpenWithBak := Result;
        Exit;
      end;

      {Ok if we get here}
      OpenWithBak := 0;
    end;

    procedure CloseWithBak(var T, Bak : Text; FName : PChar; Error : Boolean);
      {-Close}
    begin
      if Error then begin
        {Error - T and rename Bak}
        Close(T);
        if IoResult <> 0 then ;
        Erase(T);
        if IoResult <> 0 then ;
        Close(Bak);
        Rename(Bak, FName);
      end else begin
        {OK - delete the bak file}
        Close(Bak);
        if IoResult <> 0 then ;
        Erase(Bak);
        if IoResult <> 0 then ;

        {Close the new file}
        Close(T);
        if IoResult <> 0 then ;
      end;
    end;

    procedure UpdateMake(MName : PChar; C : Boolean);
      {-Open and update the requested make file}
    var
      T : Text;
      Bak : Text;
      P : TCharArray;
      Loc : PChar;
      Len : Word;
      Token : TCharArray;

      procedure NewMakeLine(P : PChar; Len : Byte; Dir : PChar; Preserve : Boolean);
        {-Make a new assignment line}
      var
        Out : TCharArray;
      begin
        StrLCopy(Out, P, Len);
        Write(T, Out);
        Write(T, '=');
        Write(T, Dir);
        if Preserve then
          WriteLn(T, '\    #End with comment to preserve backslash')
        else
          WriteLn(T);
      end;
    begin
      if OpenWithBak(T, Bak, MName) <> 0 then
        Exit;

      repeat
        ReadLn(Bak, P);

        {See if it's an assignment}
        Loc := StrScan(P, '=');
        if Loc <> nil then begin
          {Might be a macro assignment, get left side of the = sign}
          Len := Loc-P;
          StrCopy(Token, P);
          Token[Len] := #0;
          if StrLComp(Token, 'DLLpath', 7) = 0 then
            NewMakeLine(P, Len, gDllDir, True)
          else if StrLIComp(Token, 'bcinc', 5) = 0 then
            NewMakeLine(P, Len, gBcIncDir, True)
          else if StrLIComp(Token, 'clsinc', 6) = 0 then
            NewMakeLine(P, Len, gClassIncDir, True)
          else if StrLIComp(Token, 'owlinc', 6) = 0 then
            NewMakeLine(P, Len, gOwlIncDir, True)
          else if StrLIComp(Token, 'dewinc', 6) = 0 then
            NewMakeLine(P, Len, gCDir, True)
          else if StrLIComp(Token, 'wsinc', 5) = 0 then
            NewMakeLine(P, Len, gWsIncDir, True)
          else if StrLIComp(Token, 'bclib', 5) = 0 then
            NewMakeLine(P, Len, gBcLibDir, True)
          else if StrLIComp(Token, 'clslib', 6) = 0 then
            NewMakeLine(P, Len, gClassLibDir, True)
          else if StrLIComp(Token, 'owllib', 6) = 0 then
            NewMakeLine(P, Len, gOwlLibDir, True)
          else if StrLIComp(Token, 'dewlib', 6) = 0 then
            NewMakeLine(P, Len, gCDir, True)
          else if StrLIComp(Token, 'wslibc', 6) = 0 then
            NewMakeLine(P, Len, gWsLibDir, True)
          else if StrLIComp(Token, 'bin', 3) = 0 then
            NewMakeLine(P, Len, gCompilerDir, True)
          else
            {Not one of our assingments, just write out the old line}
            WriteLn(T, P);
        end else
          {Not an assignment, just write out the old line}
          WriteLn(T, P);
      until Eof(Bak);

      CloseWithBak(T, Bak, MName, False);
    end;

  begin
    {Update MAKEC.TEM}
    StrCopy(MakeName, gToDirectory);
    AddBackSlash(MakeName, MakeName);
    StrCat(MakeName, 'MAKEC.TEM');
    UpdateMake(MakeName, False);

    {Update DEWC.MAK}
    StrCopy(MakeName, gCDir);
    AddBackSlash(MakeName, MakeName);
    StrCat(MakeName, 'DEWC.MAK');
    UpdateMake(MakeName, False);
  end;

  procedure TInstallWindow.CreateCfgFiles;
    {-Create .CFG files with our directories}
  var
    T : Text;

    function OkToWrite(P : PChar) : Boolean;
      {-Return False if file exists and gNever is True}
    var
      F : File;
    begin
      if gOverwriteAlways or gOverwriteCompiler then
        {Unconditionally overwrite CFG file}
        OkToWrite := True
      else
        {Otherwise, only write if cfg file doesn't already exist}
        OkToWrite := not ExistFile(P);
    end;

    procedure CreatePascalCfg(FName : PChar);
      {-Write the current CFG file}
    begin
      ChDir(gPascalDir);

      if not OkToWrite(FName) then
        Exit;

      Assign(T, FName);
      Rewrite(T);
      Write(T, '-I');
      WriteLn(T, gPascalDir);
      Write(T, '-U');
      WriteLn(T, gPascalDir);
      Write(T, '-R');
      WriteLn(T, gPascalDir);
      WriteLn(T, '-M');
      Close(T);
      if IoResult <> 0 then ;
    end;

    procedure WriteDewCfg;
    var
      P : TCharArray;
    begin
      if not OkToWrite('DEWC.CFG') then
        Exit;

      Assign(T, 'DEWC.CFG');
      Rewrite(T);

      {Build and write -I line}
      StrCopy(P, '-I');
      StrCat(P, gBcIncDir);
      StrCat(P, ';');
      StrCat(P, gClassIncDir);
      StrCat(P, ';');
      StrCat(P, gOwlIncDir);
      StrCat(P, ';');
      StrCat(P, gCDemoDir);
      StrCat(P, ';');
      StrCat(P, gCDir);
      WriteLn(T, P);

      {Build and write -L line}
      StrCopy(P, '-L');
      StrCat(P, gBcLibDir);
      StrCat(P, ';');
      StrCat(P, gClassLibDir);
      StrCat(P, ';');
      StrCat(P, gOwlLibDir);
      WriteLn(T, P);

      {Write other options}
      WriteLn(T, '-WS');
      if gBC31 then begin
        WriteLn(T, '-DSTRICT');
        WriteLn(T, '-DWIN31');
      end;
      Close(T);
      if IoResult <> 0 then ;
    end;

  begin
    if gPascal then begin
      {Make various TP CFG files with proper directory paths}
      CreatePascalCfg('TPCW.CFG');
    end;

    if gCPP then begin
      {Make a TURBOC.CFG file with proper directory paths}
      ChDir(gCDir);
      if OkToWrite('TURBOC.CFG') then begin
        Assign(T, 'TURBOC.CFG');
        Rewrite(T);
        Write(T, '-I');
        WriteLn(T, gCDir);
        Write(T, '-L');
        WriteLn(T, gCDir);
        Close(T);
        if IoResult <> 0 then ;
      end;

      {Make a TLINK.CFG file with proper directory paths}
      ChDir(gCDir);
      if OkToWrite('TLINK.CFG') then begin
        Assign(T, 'TLINK.CFG');
        Rewrite(T);
        Write(T, '-L');
        WriteLn(T, gCDir);
        Close(T);
        if IoResult <> 0 then ;
      end;

      {Make a DEW.CFG file with proper directory paths}
      WriteDewCfg;
    end;
  end;

  procedure TInstallWindow.CreateWsIntlFile;
    {-Create WSINTL.INI file}
  var
    SrcF, DestF : TCharArray;
  begin
    {Set up src path}
    StrCopy(SrcF, gToDirectory);
    AddBackSlash(SrcF, SrcF);
    StrCat(SrcF, 'WSINTL.ENG');

    {Set up dest path}
    StrCopy(DestF, gSystemDir);
    AddBackSlash(DestF, DestF);
    StrCat(DestF, 'WSINTL.INI');

    {Copy without showing progress}
    CancelFlag := False;
    CopyFile(SrcF, DestF, @CopyBuffer, SizeOf(CopyBuffer), False, -1);

    {Ignore errors}
  end;

  procedure TInstallWindow.RenameTemplateFiles;
    {-Rename C templates to standard if only C++ was installed}

    procedure RenameFile(Old, New : PChar);
    var
      F : File;
      NewP : TCharArray;
      OldP : TCharArray;
    begin
      StrCopy(OldP, gToDirectory);
      AddBackSlash(OldP, OldP);
      StrCat(OldP, Old);

      StrCopy(NewP, gToDirectory);
      AddBackSlash(NewP, NewP);
      StrCat(NewP, New);

      Assign(F, OldP);
      Rename(F, NewP);
      if IoResult <> 0 then ;
    end;

  begin
    if (gCpp and not gPascal) or (gCpp and not gPascalPrimary) then begin
      RenameFile('STANDARD.TEM', 'STANDRDP.TEM');
      RenameFile('ENTRY.TEM',    'ENTRYP.TEM');
      RenameFile('TOOLBOX.TEM',  'TOOLBXP.TEM');
      RenameFile('TOOLBAR.TEM',  'TOOLBRP.TEM');
      RenameFile('STANDRDC.TEM', 'STANDARD.TEM');
      RenameFile('ENTRYC.TEM',   'ENTRY.TEM');
      RenameFile('TOOLBXC.TEM',  'TOOLBOX.TEM');
      RenameFile('TOOLBRC.TEM',  'TOOLBAR.TEM');
    end;
  end;

  procedure TInstallWindow.MoveFiles;
    {-Move SAMPLE.RES from root dir to C and Pascal example dirs}
  var
    SrcF, DstF : TCharArray;
  begin
    if gExamples then begin
      {Set up source path}
      StrCopy(SrcF, gToDirectory);
      AddBackslash(SrcF, SrcF);
      StrCat(SrcF, 'SAMPLE.RES');

      if gPascal then begin
        {Set up destination path and copy}
        StrCopy(DstF, gPascalDemoDir);
        AddBackslash(DstF, DstF);
        StrCat(DstF, 'SAMPLE.RES');

        CancelFlag := False;
        CopyFile(SrcF, DstF, @CopyBuffer, SizeOf(CopyBuffer), False, -1);
      end;

      if gCpp then begin
        {Set up destination path and copy}
        StrCopy(DstF, gCDemoDir);
        AddBackslash(DstF, DstF);
        StrCat(DstF, 'SAMPLE.RES');

        CancelFlag := False;
        CopyFile(SrcF, DstF, @CopyBuffer, SizeOf(CopyBuffer), False, -1);
      end;
    end;
  end;

  procedure TInstallWindow.CopyAllFiles;
    {-Copy files specified by INSTALL.DAT}
  var
    FName : TCharArray;
    P : TCharArray;
    S : String;
    Disk : Byte;
    I : Word;
    Ratio : Word;
    Select : Boolean;
    FML : FileMaskList;
    F : File;

  begin
    {Inits}
    CurrentDisk := 0;
    BytesTransferred := 0;
    CancelFlag := False;

    {Set our custom LZH functions}
    SetOkToWriteFunc(MyOkToWriteFunc);
    SetShowProgressFunc(MyShowProgressFunc);
    SetExtractSuccessFunc(MySuccessFunc);

    {Make a file list}
    InitFileMaskList(FML);

    {Copy or extract files}
    for I := 1 to FileCnt do begin
      with Files^[I] do begin

        {Skip files with a DestDir of zero (which means don't copy)}
        Select := DestDir <> 0;

        {Skip files that fail the group test}
        if Select then
          Select := FlagIsSet(Groups, Group);

        {Only process selected files}
        if Select then begin

          {Note archive disk for this file}
          Disk := 0;
          case Media of
            Disk360  : Disk := Disk36;
            Disk720  : Disk := Disk72;
            Disk1200 : Disk := Disk12;
            Disk1440 : Disk := Disk14;
          end;

          {Check for disk change}
          if CurrentDisk <> Disk then begin

            {Decompress all files for the current disk}
            if CurrentDisk <> 0 then begin
              StrCopy(ArcName, 'FILES');
              StrCat(ArcName, Long2Str(P, CurrentDisk));
              DefaultExtension(ArcName, ArcName, 'LZH');
              AddBackSlash(P, gFromDirectory);
              StrCat(P, ArcName);
              S := StrPas(P);
              InitLzhFile(S);

              {Say we're scanning directory}
              StrCopy(P, 'Scanning archive directory');
              Progress^.SetStatusMsg(P);
              Progress^.SetFileMeter(0);

              {Set up a SeekStatus proc so we can update the progress bar}
              Assign(F, S);
              Reset(F, 1);
              LzhFileSize := FileSize(F);
              if IoResult <> 0 then
                LzhFileSize := 0;
              SetSeekStatusFunc(MySeekStatusFunc);
              Close(F);                                                {!!.01}
              if IoResult <> 0 then ;                                  {!!.01}

              {Show hourglass cursor while scanning directory}
              WaitCursor;

              ExtractFileMaskList(FML);
              if ArchiveStatus <> ecOk then
                if not ReportError(ArchiveStatus) then
                  Exit;
              DoneLzhFile;

              {No more seek status}
              SetSeekStatusFunc(NoSeekStatus);
            end;

            {New current disk}
            CurrentDisk := Disk;
            DoneFileMaskList(FML);
            InitFileMaskList(FML);

            {Prompt for and check for the next disk}
            PromptNewDisk(Disk);
            if ArchiveStatus <> ecOk then
              Exit;
          end;

          {Copy current file or add to extract list}
          if not Archived then begin
            {Make fully qualified Src and Dest parameters}
            StrCopy(Src, gFromDirectory);
            AddBackSlash(Src, Src);
            StrPCopy(FName, Name);
            StrCat(Src, FName);
            StrCopy(Dest, DestDirs[DestDir]);
            AddBackSlash(Dest, Dest);
            StrCat(Dest, FName);

            {Make and show a status message}
            StrCopy(P, 'Copying file ');
            StrCat(P, FName);
            Progress^.SetStatusMsg(P);

            {Copy the file}
            ArchiveStatus :=
              CopyFile(Src, Dest, @CopyBuffer, SizeOf(CopyBuffer), True, FileVer);
            Inc(BytesTransferred, Size);

            {Update the AllMeter and AllPercent}
            Ratio := (BytesTransferred * 100 ) div GetBytesRequired;
            Progress^.SetAllMeter(Ratio);

          end else begin
            {Just add it to the file mask list}
            if not AppendFileName(Name, FML) then begin
              ReportError(ecOutOfMemory);
              Exit;
            end;
          end;
        end;

        {Handle copy errors (out of space, write error, sharing error)}
        if ArchiveStatus <> ecOk then
          if not ReportError(ArchiveStatus) then
            Exit;
      end;
    end;

    {Decompress all files for the last disk}
    StrCopy(ArcName, 'FILES');
    StrCat(ArcName, Long2Str(P, CurrentDisk));
    DefaultExtension(ArcName, ArcName, 'LZH');
    AddBackSlash(P, gFromDirectory);
    StrCat(P, ArcName);
    S := StrPas(P);
    InitLzhFile(S);

    {Say we're scanning directory}
    StrCopy(P, 'Scanning archive directory');
    Progress^.SetStatusMsg(P);
    Progress^.SetFileMeter(0);

    {Set up a SeekStatus proc so we can update the progress bar}
    Assign(F, S);
    Reset(F, 1);
    LzhFileSize := FileSize(F);
    if IoResult <> 0 then
      LzhFileSize := 0;
    SetSeekStatusFunc(MySeekStatusFunc);

    {Show hourglass cursor while scanning directory}
    WaitCursor;

    ExtractFileMaskList(FML);
    if ArchiveStatus <> ecOk then
      if not ReportError(ArchiveStatus) then
        Exit;
    DoneLzhFile;
  end;

  procedure TInstallWindow.LoadFiles;
    {-Load data from INSTALL.DAT to Files^}
  var
    I : Word;
  begin
    {Allocate the Files array}
    Assign(Info, 'INSTALL.DAT');
    Reset(Info);
    FileCnt := FileSize(Info);
    GetMem(Files, FileCnt*SizeOf(FileInfoRec));
    if Files = nil then begin
      ArchiveStatus := ecOutOfMemory;
      Exit;
    end;

    {Read in the Files array}
    for I := 1 to FileCnt do begin
      Read(Info, Files^[I]);
      Files^[I].Tagged := False;
    end;

    {Report I/O errors}
    ArchiveStatus := IoResult;
    if ArchiveStatus <> 0 then
      Exit;

    {Finished with INSTALL.DAT}
    Close(Info);
    if IoResult <> 0 then ;
  end;

  procedure TInstallWindow.SortFiles;
    {-Sort the file list according to "from" media type}
  var
    SRec : TSearchRec;
    S : String[2];
    P : TCharArray;
    Result : Word;
  begin
    {Search for a file named DISK?_??}
    StrCopy(P, gFromDirectory);
    AddBackSlash(P, P);
    StrCat(P, 'DISK?_??');
    FindFirst(P, faAnyFile, SRec);
    if DosError <> 0 then
      Media := Disk1200
    else begin
      S := Copy(SRec.Name, 7, 2);
      if S = '36' then
        Media := Disk360
      else if S = '72' then
        Media := Disk720
      else if S = '12' then
        Media := Disk1200
      else
        Media := Disk1440
    end;

    {Sort Files info based on media type}
    ArchiveStatus := Sort(FileCnt,
                          SizeOf(FileInfoRec),
                          GetElements,
                          Less,
                          PutElements);
  end;

  procedure TInstallWindow.idGo(var Msg : TMessage);
    {-Start installing}
  var
    PeekMsg : TMsg;
    P : TCharArray;
    S : String;
    W : Word;
    Code : Word;
  begin
    {Clear old errors}
    ArchiveStatus := ecOk;

    {Note the old destination directory}
    StrCopy(gOldToDirectory, gToDirectory);

    {Fill in transfer buffer and copy to global vars}
    TransferData(tf_GetData);
    with MainData do begin
      StrCopy(gToDirectory, ToDirectory);
      StrCopy(gFromDirectory, FromDirectory);
    end;

    {Upcase all directories}
    StrUpper(gToDirectory);
    StrUpper(gFromDirectory);

    {Assure subdirectories are up to date}
    if gToDirectory[1] <> ':' then
      {Bad format entered, force back to default}
      StrCopy(gToDirectory, DefToDirectory);
    UpdateSubDirs(gToDirectory);

    {Assure C DEW subdirs are up to date also}
    UpdateCDewSubDirs(gToDirectory);

    {Fill in DestDirs}
    BuildDestDirs;

    {Check for enough free space on all drives}
    if not CheckFreeSpace then
      Exit;

    {Build destination directories}
    MakeDestDirs;

    {Sort the files list according to media type}
    SortFiles;

    {Remove the main dialog box and let Windows restore what's underneath}
    Show(sw_Hide);
    PeekMessage(PeekMsg, 0, 0, 0, pm_Remove);

    {Show the progress dialog box}
    Progress := New(PProgressWindow, Init(@Self));
    Application^.MakeWindow(Progress);
    Progress^.Show(sw_Normal);

    {Copy all files}
    CopyAllFiles;

    if ArchiveStatus <> ecOk then begin
      {Error during copying, return to main dialog}
      CancelFlag := True;
      Progress^.Cancel(Msg);
      Show(sw_Normal);
      PeekMessage(PeekMsg, 0, 0, 0, pm_Remove);
      Exit;
    end else begin
      {Finished OK, get rid of progress dialog}
      CancelFlag := True;
      Progress^.Cancel(Msg);
    end;

    {Do all post copying work}
    if ArchiveStatus = ecOk then begin

      {Update MAKEC.TEM}
      UpdateMakeFiles;

      {Create CFG files}
      CreateCfgFiles;

      {Rename template files}
      RenameTemplateFiles;

      {Rename duplicate files}
      RenameFiles;

      {Move files that need to be moved}
      MoveFiles;

      {Update WORKSHOP.INI}
      UpdateIni;

      {Create WSINTL.INI}
      CreateWsIntlFile;

      {Create a program group}
      if gCreateGroup then
        MakeGroup;

      {Say we're finished}
      StrCopy(P, 'Installation complete. ');
      StrCat(P, 'Please be sure to read the READ.ME ');
      StrCat(P, 'file for last-minute information about ');
      StrCat(P, 'Data Entry Workshop');
      BWCCMessageBox(Application^.MainWindow^.HWindow, P, 'Finished!', mb_IconExclamation+mb_Ok);
    end;

    TDlgWindow.Cancel(Msg);
  end;

  procedure TInstallWindow.idReadMe(var Msg : TMessage);
    {-Exec the notepad to view the read.me file}
  var
    CmdLine : TCharArray;
    P : TCharArray;
  begin
    {Assure global vars are up to date}
    TransferData(tf_GetData);
    StrCopy(gFromDirectory, MainData.FromDirectory);

    StrCopy(CmdLine, 'notepad ');
    StrCopy(P, gFromDirectory);
    AddBackSlash(P, P);
    StrCat(CmdLine, P);
    StrCat(CmdLine, 'read.me');

    {Exec notepad}
    if WinExec(CmdLine, sw_Normal) < 32 then
      BWCCMessageBox(Application^.MainWindow^.hWindow,
        'Sorry, can''t find NOTEPAD to view READ.ME file',
        'Warning', mb_IconInformation);
  end;

  procedure TInstallWindow.idRestore(var Msg : TMessage);
    {-Restore all default directories and options}
  var
    PC : PEdit;
    PS : PStatic;
    L  : LongInt;
    P  : array[0..15] of Char;
  begin
    {Reset default data}
    ResetDefaults;

    {Update controls directly}
    with MainData do begin
      StrCopy(ToDirectory, DefToDirectory);
      StrCopy(FromDirectory, DefFromDirectory);
      PC := PEdit(ChildWithId(id_ToDirectory));
      PC^.SetText(ToDirectory);
      PC := PEdit(ChildWithId(id_FromDirectory));
      PC^.SetText(FromDirectory);

      {Update bytes required}
      L := GetBytesRequired;
      Long2Str(P, L);
      InsertCommas(P);
      StrCopy(BytesRequired, P);
      StrCat(BytesRequired, ' bytes');
      PS := PStatic(ChildWithId(id_BytesRequired));
      PS^.SetText(BytesRequired);
    end;
  end;

  procedure TInstallWindow.IdStop(var Msg : TMessage);
  begin
    Cancel(Msg);
  end;

  procedure TInstallWindow.PromptNewDisk(Disk : Byte);
    {-Prompt for a new disk, check for DiskX file}
  var
    Result : Word;
    DiskName : TCharArray;
    P : array[0..1] of Char;
    Finished : Boolean;
  begin
    Finished := False;
    StrCopy(DiskName, gFromDirectory);
    AddBackSlash(DiskName, DiskName);
    StrCat(DiskName, 'DISK');
    Long2Str(P, Disk);
    StrCat(DiskName, P);
    case Media of
      Disk360  : StrCat(DiskName, '_36');
      Disk720  : StrCat(DiskName, '_72');
      Disk1200 : StrCat(DiskName, '_12');
      Disk1440 : StrCat(DiskName, '_14');
    end;

    {Exit immediately if we find our disk name file}
    if ExistFile(DiskName) then
      Exit;

    {Beep when we really do need a new disk}
    MessageBeep(0);

    {Prepare prompts}
    gDisk := Disk;
    gDrive := gFromDirectory[0];

    {Ask for new disk until we get one or user cancels}
    Result := Application^.ExecDialog(PWindowsObject(New(PNewDiskWindow,
                           Init(@Self))));

    if Result = id_Ok then
      ArchiveStatus := ecOk
    else
      ArchiveStatus := ecUserAbort;

    Progress^.Show(sw_Normal);
    UpdateWindow(Progress^.HWindow);
    SetFocus(Progress^.HWindow);
  end;

{TNewDiskWindow}

  constructor TNewDiskWindow.Init(AParent : PWindowsObject);
    {-Instantiate newdisk window}
  begin
    TDlgWindow.Init(AParent, 'NEWDISK');

    TransferBuffer := @NewDiskData;

    {Initialize control objects}
    DiskName := New(PStatic, InitResource(@Self, id_DiskName, 3));
    DriveLetter := New(PStatic, InitResource(@Self, id_DriveLetter, 1));
    NewDirectory := New(PEdit, InitResource(@Self, id_NewDirectory, 80));
  end;

  procedure TNewDiskWindow.SetupWindow;
    {-Modify the static prompts as required}
  var
    PC : PStatic;
    P : array[0..3] of Char;
  begin
    TDlgWindow.SetupWindow;

    {Fill in disk prompt}
    case Media of
      Disk360, Disk1200 : StrCopy(P, '5-');
      Disk720, Disk1440 : StrCopy(P, '3-');
    end;
    Long2Str(@P[2], gDisk);
    DiskName^.SetText(P);

    {Fill in drive prompt}
    P[0] := gDrive;
    P[1] := #0;
    DriveLetter^.SetText(P);

    {Fill in edit control with current gFromDirectory}
    NewDirectory^.SetText(gFromDirectory);
  end;

  procedure TNewDiskWindow.Ok(var Msg : TMessage);
    {-Check for file}
  var
    DName : TCharArray;
    P : array[0..1] of Char;
    SRec : TSearchRec;
    WinMsg : TMsg;
  begin
    {Wait while we check for the signal file}
    WaitCursor;

    {Compare edit data to old dir (to see if one was entered)}
    TransferData(tf_GetData);
    with NewDiskData do
      if StrIComp(NewDirectory, gFromDirectory) <> 0 then
        {New directory was entered, make that gFromDirectory}
        StrCopy(gFromDirectory, NewDirectory);

    {Make a signal file name}
    StrCopy(DName, gFromDirectory);
    AddBackSlash(DName, DName);
    StrCat(DName, 'DISK');
    Long2Str(P, gDisk);
    StrCat(DName, P);
    StrCat(DName, '_??');

    {Finished only if the file exists}
    FindFirst(DName, faAnyfile, SRec);

    {Discard all waiting messages}
    while PeekMessage(WinMsg, HWindow, 0, 0, pm_Remove) do ;

    if DosError = 0 then
      {Say we're finished}
      TDlgWindow.Ok(Msg);

    {Finished waiting one way or the other}
    RestoreCursor;
  end;

{TCancelButton}

  procedure TCancelButton.wmChar(var Msg : TMessage);
    {-Force cancel if Enter pressed}
  begin
    if Msg.wParam = $0D then
      CancelFlag := True;
  end;

{TProgressWindow}

  constructor TProgressWindow.Init(AParent : PWindowsObject);
    {-Instantiate progress window}
  var
    CP : PControl;
  begin
    TDlgWindow.Init(AParent, 'PROGRESS');

    {Initialize control objects}
    AllMeter := New(PMeterControl, InitResource(@Self, id_AllMeter));
    FileMeter := New(PMeterControl, InitResource(@Self, id_FileMeter));
    AllPercent := New(PStatic, InitResource(@Self, id_AllPercent, 4));
    FilePercent := New(PStatic, InitResource(@Self, id_FilePercent, 4));
    StatusMsg := New(PStatic, InitResource(@Self, id_StatusMsg, 40));
    CP := New(PCancelButton, InitResource(@Self, 2));
  end;

  procedure TProgressWindow.SetFileMeter(N : Byte);
    {-Update file meter control and percent}
  var
    P : array[0..4] of Char;
  begin
    SendMessage(FileMeter^.hWindow, dwm_SetMeterValue, N, 0);
    Long2Str(P, N);
    StrCat(P, '%');
    FilePercent^.SetText(P);
    UpdateWindow(hWindow);
  end;

  procedure TProgressWindow.SetAllMeter(N : Byte);
    {-Update the all meter control and percent}
  var
    P : array[0..4] of Char;
  begin
    SendMessage(AllMeter^.hWindow, dwm_SetMeterValue, N, 0);
    Long2Str(P, N);
    StrCat(P, '%');
    AllPercent^.SetText(P);
    UpdateWindow(hWindow);
  end;

  procedure TProgressWindow.SetStatusMsg(P : PChar);
    {-Update progress status message}
  begin
    StatusMsg^.SetText(P);
  end;

  procedure TProgressWindow.Cancel(var Msg : TMessage);
    {-Set flag saying cancel was requested}
  begin
    if CancelFlag then
      TDlgWindow.Cancel(Msg)
    else
      CancelFlag := True;
  end;

  function TProgressWindow.WmSysCommand(var Msg : TMessage) : Word;
    {-Return a non-zero value for the SC_ScreenSave command}
  begin
    if Msg.wParam = $F140 then
      WmSysCommand := 1
    else
      DefWndProc(Msg);
  end;

{TDDEWindow}

  constructor TDDEWindow.Init;
    {-Instantiate the DDE window}
  begin
    TDlgWindow.Init(nil, 'DDE');
    ServerWindow := 0;
    PendingMessage := 0;
    CurrentCmd := 1;
  end;

  procedure TDDEWindow.SetupWindow;
    {-Initiate the DDE conversation}
  begin
    TDlgWindow.SetupWindow;
    InitiateDDE;
  end;

  function TDDEWindow.GetClassName: PChar;
    {-Return our subclass name}
  begin
    GetClassName := 'DDEWindow';
  end;

  procedure TDDEWindow.InitiateDDE;
    {-Try to initiate a DDE conversation with the Program Manager}
  var
    AppAtom : TAtom;
    TopicAtom : TAtom;
  begin
    PendingMessage := wm_DDE_Initiate;
    AppAtom := GlobalAddAtom('PROGMAN');
    TopicAtom := GlobalAddAtom('PROGMAN');
    SendMessage(HWnd(-1), wm_DDE_Initiate, HWindow,
                MakeLong(AppAtom, TopicAtom));
    GlobalDeleteAtom(AppAtom);
    GlobalDeleteAtom(TopicAtom);
    PendingMessage := 0;
    if ServerWindow = 0 then begin
      MessageBox(HWindow, 'Can''t find Program Manager! ' +
                          'You will need to create the DEW '+
                          'group and add the program icons '+
                          'manually.',
        'Error', mb_IconExclamation or mb_Ok);
      ArchiveStatus := ecDDEFailed;
    end else
      ArchiveStatus := ecOk;
  end;

  procedure TDDEWindow.TerminateDDE;
    {-Terminate DDE by sending terminate message to server (if it still exists)}
  var
    W: HWnd;
  begin
    W := ServerWindow;
    ServerWindow := 0;
    if IsWindow(W) then
      PostMessage(W, wm_DDE_Terminate, HWindow, 0);
  end;

  function TDDEWindow.SendCommand : Boolean;                           {!!.01}
    {-Format and send one progman command, return False if we fail}
  var
    Executed : Boolean;
    HCommands : THandle;
    PCommands : PChar;
    P : TCharArray;
    Len : Word;

  begin
    Executed := False;
    if (ServerWindow <> 0) and (PendingMessage = 0) then begin

      {Get a global memory handle}
      Len := StrLen(Commands[CurrentCmd]);
      HCommands := GlobalAlloc(gmem_Moveable or gmem_DDEShare, Len);
      if HCommands <> 0 then begin

        {Copy command to global memory}
        PCommands := GlobalLock(HCommands);
        PCommands[0] := #0;
        StrCat(PCommands, Commands[CurrentCmd]);
        GlobalUnlock(HCommands);

        {Send command to Program Manager}
        if PostMessage(ServerWindow, wm_DDE_Execute, HWindow,
                      MakeLong(0, HCommands)) then begin
          PendingMessage := wm_DDE_Execute;
          Executed := True;
        end else
          GlobalFree(HCommands);
      end;
    end;

    {Give up if we can't find Program Manager}
    if not Executed then
      MessageBox(HWindow, 'Failed to execute DDE command!' +           {!!.01}
                          'You may need to create the DEW '+           {!!.01}
                          'group and add the program icons '+          {!!.01}
                          'manually.',                                 {!!.01}
        'Error', mb_IconExclamation or mb_Ok);                         {!!.01}
    SendCommand := Executed;                                           {!!.01}
  end;

  procedure TDDEWindow.CreateGroup;
    {-Set up commands to be sent to PROGMAN}
  var
    I : Integer;
    Dir : TCharArray;
    P : TCharArray;

    procedure AddCommand(NewInfo : PChar; Index, Loc : Word);
    begin
      StrStInsert(Commands[Index], Commands[Index], NewInfo, Loc);
      UseCommand[Index] := True;
    end;

  begin
    FillChar(UseCommand, SizeOf(UseCommand), False);

    {Always do first and last commands}
    UseCommand[1] := True;
    UseCommand[MaxCommands] := True;

    {Add path to utility program names}
    if gUtilities then begin
      AddBackSlash(Dir, gUtilityDir);

      {Always add MAKESRC}
      AddCommand(Dir, 2, 9);

      {Conditionally add CVTOPL programs}
      if gPascal then begin
        AddCommand(Dir, 3, 9);
        if gCpp then
          AddCommand(' <Pas>', 3, StrLen(Commands[3])-2);
      end;
      if gCpp then begin
        AddCommand(Dir, 4, 9);
        if gPascal then
          AddCommand(' <C++>', 4, StrLen(Commands[4])-2);
      end;
    end;

    {Add path to Pascal demo program names}
    if gPascal then begin
      AddBackSlash(Dir, gPascalDemoDir);
      for I := 5 to 8 do begin
        AddCommand(Dir, I, 9);
        if gCpp then
          AddCommand(' <Pas>', I, StrLen(Commands[I])-2);
      end;
    end;

    {Add path to C++ demo program names}
    if gCpp then begin
      AddBackSlash(Dir, gCDemoDir);
      for I := 9 to 12 do begin
        AddCommand(Dir, I, 9);
        if gPascal then
          AddCommand(' <C++>', I, StrLen(Commands[I])-2);
      end;
    end;

    {Add path to help file name}
    AddCommand(AddBackSlash(P, gToDirectory), 13, 21);

    {Start sending commands}
    if not SendCommand then begin                                      {!!.01}
      ArchiveStatus := ecDDEFailed;                                    {!!.01}
      Exit;                                                            {!!.01}
    end;                                                               {!!.01}

    {Dawdle until all commands have been sent and acknowledged}
    repeat
      SafeYield;
    until (CurrentCmd > MaxCommands);
  end;

  procedure TDDEWindow.WMDDEAck(var Msg: TMessage);
    {-Handle DDE acknowledgement}
  var
    Finished : Boolean;
  begin
    case PendingMessage of
      wm_DDE_Initiate:
        begin
          if ServerWindow = 0 then
            ServerWindow := Msg.WParam
          else
            PostMessage(Msg.WParam, wm_DDE_Terminate, HWindow, 0);
          GlobalDeleteAtom(Msg.LParamLo);
          GlobalDeleteAtom(Msg.LParamHi);
        end;
      wm_DDE_Execute:
        begin
          GlobalFree(Msg.LParamHi);
          PendingMessage := 0;

          {See if any more commands to do}
          Finished := False;
          repeat
            Inc(CurrentCmd);
            Finished := CurrentCmd > MaxCommands;
            if not Finished and UseCommand[CurrentCmd] then begin
              if not SendCommand then                                  {!!.01}
                {Force an exit from MakeGroup}                         {!!.01}
                CurrentCmd := MaxCommands+1;                           {!!.01}
              Exit;
            end;
          until Finished;
          SetFocus(HWindow);
        end;
    end;
  end;

  procedure TDDEWindow.WMDDETerminate(var Msg: TMessage);
    {-Terminate if msg from our server, else ignore}
  begin
    if Msg.WParam = ServerWindow then
      TerminateDDE;
  end;

  procedure TDDEWindow.WMDestroy(var Msg: TMessage);
    {-Terminate the DDE link}
  begin
    TerminateDDE;
    TDlgWindow.WMDestroy(Msg);
  end;

{InstallApplication}

  procedure InstallApplication.InitMainWindow;
  var
    S : String;
  begin
    {Get the original drive letter}
    S := ParamStr(1);
    case S[1] of
      'A' : {do nothing} ;
      'B' : DefFromDirectory[0] := 'B';
      else begin
        {GetDir(0, S);}                                                {!!.01}
        StrPCopy(DefFromDirectory, S);
      end;
    end;

    InitMainData(MainData);
    MainWindow := New(PInstallWindow, Init(nil, MainData));
  end;

begin
  InstallApp.Init('DEWINST');
  InstallApp.Run;
  InstallApp.Done;
end.
