

MaxAllModes EQU     6;  /* The maximum number of modes supported by any printer */

CR          EQU  0Dh;
NL          EQU  0Ah;
Esc         EQU  01Bh;

COMMENT \ ******************************************************************

   /* When command sending to printer is divided into two parts  */
   /* it means that first Str1 is sending then needed parameter */
   /* and at last Str2. Of cource Str2 may be empty one */

\ \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

DriversNo = 0;
DriverDefOnlySize = 26h;   /* without modes defined */
ModeDefSize = 28h;
ConstDriverDefSize = DriverDefOnlySize + ModeDefSize*MaxAllModes;   /* with modes defined, without strings */
string_offset = ConstDriverDefSize;

ModeDefAddr = 0;
DriverDefAddr = 0;

GenString  MACRO  Stype,str
      ifidni <&str>,<NULL>
         dw  ConstDriverDefSize
         EXITM
      endif
      ifb   <&str>
         dw  ConstDriverDefSize
         EXITM
      endif
      o1 = $
      org DriverDefAddr+string_offset
      o2 = $
      l  = 0
      ifdifi <&Stype>,<C>
         db   ?
         db   str
         l  = $-o2
         ifidni <&Stype>,<Both>
            db  0
         else
            ifdifi <&Stype>,<Pascal>
               err Wrong string type specified
            endif
         endif
         org  o2
         db   l-1;        string length
      else
         ifidni <&Stype>,<C>
            db   str
            db   0
            l  = $-o2
         endif
      endif
      org  o1
      dw    string_offset
      ifidni <&Stype>,<Both>
             l = l+1;
      endif
      string_offset = string_offset+l
   ENDM

GenPString  MACRO  str
            GenString  <Pascal>,<&str>
            ENDM


genstmnt    MACRO a,b,c,d,e,f,g,h
            a&b   c&d   e&f&g&h
            ENDM

DriverDef  MACRO
           DriverDefAddr = $
           org   ConstDriverDefSize
           db    0;    ; NULL strings points here
           org   DriverDefAddr
           string_offset = ConstDriverDefSize+1;
           DriversNo = DriversNo + 1;
           genstmnt  <DriverDefOffs_>,%DriversNo,<=>,,<DriverDefAddr-PRT__Drivers>
           ModesNo = 0
           dw      ? ; place for Driver definition size
           db      ? ; place for ModesNo
           ENDM

EndDriverDef  MACRO
              l     = $
              ORG   DriverDefAddr
              dw    string_offset   ; driver definition size
              db    ModesNo;
              org   l
              l = $-DriverDefAddr
              if l GT ConstDriverDefSize
                 err ConstDriverDefSize === &l&
                 Display "ConstDriverDefSize = &l&"
              endif
              ModesNo   = 0;
              org   DriverDefAddr+string_offset
           ENDM

PRT__RLE_COMPRESSION   EQU  1
CompressionType MACRO  a
                db     a
                ENDM

DriverName      MACRO  s
                GenString <Both>,<&s>
                Display   " &DriversNo. &s"
                ENDM

ASCIInumbers    MACRO p
                db    p
                ENDM

TransferValueInBytes MACRO p
                     db    p
                     ENDM

InitPRTStr        MACRO  s      ;  /* Init PRT string */
                GenPString <&s>
                ENDM
EndPRTStr         MACRO  s      ;  /* End PRT string */
                GenPString <&s>
                ENDM
CompressedStr     MACRO  s      ;  /* Compress mode string */
                GenPString  <&s>
                ENDM
UncompressedStr   MACRO  s      ;  /* Compress mode string */
                GenPString <&s>
                ENDM

LeftMargin     MACRO  s1,s2,mult,div      ;
                GenPString <&s1>
                GenPString <&s2>
                dw         mult
                dw         div
                ENDM

TopMargin     MACRO  s1,s2,mult,div      ;
                GenPString <&s1>
                GenPString <&s2>
                dw         mult
                dw         div
                ENDM

ColorsStrings   Macro s1,s2,map
                GenPString <&s1>
                GenPString <&s2>
                GenString <&map>
                ENDM


__ModeName      MACRO  s
                GenString <Both>,<&s>
                ENDM


ModeDef   MACRO XPinch,YPinch,ColorsNo,ModeName;
          ModeDefAddr  = $;
          if  DriverDefOnlySize EQ 0
              DriverDefOnlySize = $-DriverDefAddr
          endif
          if ModesNo EQ 0
             if DriverDefOnlySize NE $-DriverDefAddr
                err Wrong driver definition
             endif
          endif
          dw   XPinch,YPinch
          dw   ColorsNo
          ifnb <&ModeName>
               __ModeName <&ModName>
          else
              mname  CATSTR  <'>,<&XPinch>,<x&YPinch>
              if     ColorsNo GT 2
                     mname  CATSTR  mname,<(&ColorsNo>,< colors)>
              endif
              mname  CATSTR  mname,<'>
              __ModeName  <%mname>
          endif
          ModesNo = ModesNo+1;
          ENDM

ModeOptions MACRO o1;
            l  = 0;
            ifidni <&o1>,<Planes>
                l  = 1;
            endif
            ifidni <&o1>,<SimPlanes>
                l  = 3;
            endif
            ifnb  <&o1>
               ifdif <&o1>,<0>
                  ife l
                     err Wrong argument &o1& in macro ModeOptions
                  endif
               endif
            endif
            dw    l;
            ENDM

ColorPalette     MACRO  palette
           GenString <&palette>
           ENDM

InitGraphStr MACRO s;       /* init graph string  */
           GenPString <&s>
           ENDM
EndGraphStr MACRO s;       /* end graph string  */
           GenPString <&s>
           ENDM

PicWidth Macro s1,s2,multiplier,divisor;  /* Def. picture width command, multiplier, divisor */
         GenPString <&s1>
         GenPString <&s2>
         ifnb  <&multiplier>
              dw multiplier
         else
              dw 1
         endif
         ifnb  <&divisor>
              dw divisor
         else
              dw 1
         endif
         endm

InitTransferStr MACRO s1,s2; /* init graphic mode cmnd. */
           GenPString <&s1>
           GenPString <&s2>
           ENDM

PinsPerHead MACRO p;      ;/* number of pins in a head */
                          ;/* 1 - for laser printers */
            db     p
            ENDM

PixelsStep  MACRO  p;       /* vertical density / pins distance */
            db      p
            ENDM

EolnStr     Macro s
           GenPString <&s>
           ENDM

SmallEoln  MACRO  s1,s2,mult,div
                           ; /* SmallEoln multipier and dividend are the numbers */
                           ; /* needed to adjust paper for one pins distance,    */
                           ; /* in the case when SmallEoln command adjusts paper */
                           ; /* not at vertical pixel distance but some other value */
           GenPString <&s1>
           GenPString <&s2>
           dw        mult,div
           if    ModeDefSize NE $-ModeDefAddr
              err Wrong mode definition
           endif
           ENDM



