MASM51
.XALL

MaxDriversNo    = 16;  <----- If you want to define more drivers change this number

; Adding, deleting or changing the order of drivers definitions requires
; appriopriate changes in PRTGRAPH.H and PDrivers.pas.
;

include drivers.inc

 MODEL large
;;.MODEL FarStack large pascal
ifNdef WithCode
   WithCode EQU 1
endif
IF WithCode

   .CODE

   EXTRN  Pascal PRT__DriversPtr: word:2
   PUBLIC pascal PRT_LinkDriversDefinitions
   PRT_LinkDriversDefinitions PROC pascal FAR
                   mov  AX, seg PRT__DriversPtr
                   mov  ES,AX
                   mov  ES:PRT__DriversPtr, offset PRT__Drivers
                   mov  ES:PRT__DriversPtr+2, seg PRT__Drivers
                   RET
   PRT_LinkDriversDefinitions ENDP

ENDIF

  .DATA

PRT__Drivers   LABEL WORD

PRT__MaxDriverNo dw  ?  ; will be defined at the end of the file
                 dw  2  ; index to PRT__DriversOffsets
PRT__DriversOffsets  dw  MaxDriversNo dup (0) ; place for drivers definitions offsets


        ; /*===============================*/
        ; /* 9-pins : STAR SR              */
        ; /*===============================*/
         DriverDef
         ;         4,                            /* ModesNo  */
         CompressionType  0                      /* CompressionType */
         DriverName      <'9 pins: STAR SR'> ;
         ASCIInumbers    0;
         TransferValueInBytes 0;                 /*  TransferValueInBytes  */
         InitPRTStr      NULL;                   /* Init PRT string */
         EndPRTStr       NULL;                   /* End PRT string */
         CompressedStr   NULL;                   /* CompressedStr  */
         UncompressedStr NULL;                   /* UncompressedStr  */
         LeftMargin     <1bh,'M'>,NULL,1,100;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
         TopMargin      <1bh,'R'>,NULL,1,166;      /* TopMarginStr1,TopMarginStr2,TopMarginDiv */
         ColorsStrings  NULL,NULL, NULL;         /* ColorStr1,ColorStr2, ColorsMap */

         ModeDef  60,72,2;                       /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette   NULL;                    /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'g',0>,NULL
         PinsPerHead    8
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,04Ah>,NULL,2,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  120,72,2;                      /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette   NULL;                    /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'g',1>,NULL
         PinsPerHead    8
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,04Ah>,NULL,2,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  120,144,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'g',1>,NULL
         PinsPerHead    8
         PixelsStep     2
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,04Ah>,NULL,1,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  240,144,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette     NULL;                  /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'g',3>,NULL
         PinsPerHead    8
         PixelsStep     2
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,04Ah>,NULL,1,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         EndDriverDef   ; <----------------------------


         ;/*===============================*/
         ;/* 9 pins : IBM, EPSON */
         ;/*===============================*/

         DriverDef
         ;         4,                            /* ModesNo  */
         CompressionType  0                      /* CompressionType */
         DriverName     <'9 pins: IBM, EPSON'>
         ASCIInumbers    0;
         TransferValueInBytes 0;                 /*  TransferValueInBytes  */
         InitPRTStr      NULL;                   /* Init PRT string */
         EndPRTStr       NULL;                   /* End PRT string */
         CompressedStr   NULL;                   /* CompressedStr  */
         UncompressedStr NULL;                   /* UncompressedStr  */
         LeftMargin     <Esc,'l'>,NULL,1,100;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
         TopMargin      <Esc,'c'>,NULL,1,166;      /* TopMarginStr1,TopMarginStr2,TopMarginDiv */
         ColorsStrings  NULL,NULL, NULL;         /* ColorStr1,ColorStr2, ColorsMap */

         ModeDef  60,72,2;                       /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'K'>,NULL
         PinsPerHead    8
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,04Ah>,NULL,3,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  120,72,2;                      /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'L'>,NULL
         PinsPerHead    8
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,04Ah>,NULL,3,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  120,216,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'L'>,NULL
         PinsPerHead    8
         PixelsStep     3
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,04Ah>,NULL,1,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  240,216,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'Z'>,NULL
         PinsPerHead    8
         PixelsStep     3
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,04Ah>,NULL,1,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         EndDriverDef   ; <----------------------------

         ;/*===============================*/
         ;/* 9-pins : PANASONIC KX-P1124   */
         ;/*===============================*/

         DriverDef
         ;         4,                            /* ModesNo  */
         CompressionType  0                      /* CompressionType */
         DriverName       <'9 pins: Panasonic KX-P1124'>
         ASCIInumbers    0;
         TransferValueInBytes 0;                 /*  TransferValueInBytes  */
         InitPRTStr      NULL;                   /* Init PRT string */
         EndPRTStr       NULL;                   /* End PRT string */
         CompressedStr   NULL;                   /* CompressedStr  */
         UncompressedStr NULL;                   /* UncompressedStr  */
         LeftMargin     <Esc,'l'>,NULL,1,100;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
         TopMargin      <Esc,'c'>,NULL,1,166;      /* TopMarginStr1,TopMarginStr2,TopMarginDiv */
         ColorsStrings  NULL,NULL, NULL;         /* ColorStr1,ColorStr2, ColorsMap */

         ModeDef  60,72,2;                       /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'K'>,NULL
         PinsPerHead    8
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,04Ah>,NULL,5,2          /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  120,72,2;                      /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'L'>,NULL
         PinsPerHead    8
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,04Ah>,NULL,5,2;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  120,144,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette   NULL;                    /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'L'>,NULL
         PinsPerHead    8
         PixelsStep     2
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,04Ah>,NULL,5,4;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  240,144,2;                     /* X and Y densities,, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'Z'>,NULL
         PinsPerHead    8
         PixelsStep     2
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,04Ah>,NULL,5,4;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
         EndDriverDef   ; <----------------------------

         if 0
            ;/*===============================*/
            ;/* 9 pins : IBM, EPSON color */
            ;/*===============================*/

            DriverDef
            ;         4,                            /* ModesNo  */
            CompressionType  0                      /* CompressionType */
            DriverName       <'9 pins(color): IBM, EPSON'>
            ASCIInumbers    0;
            TransferValueInBytes 0;                 /*  TransferValueInBytes  */
            InitPRTStr      NULL;                   /* Init PRT string */
            EndPRTStr       NULL;                   /* End PRT string */
            CompressedStr   NULL;                   /* CompressedStr  */
            UncompressedStr NULL;                   /* UncompressedStr  */
            LeftMargin     <Esc,'l'>,NULL,1,100;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
            TopMargin      <Esc,'c'>,NULL,1,166;      /* TopMarginStr1,TopMarginStr2,TopMarginDiv */
            ColorsStrings  <Esc,'r'>,NULL, NULL;    /* ColorStr1,ColorStr2, ColorsMap */

            ModeDef  60,72,8;                       /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette   NULL;                    /* Color palette        */
            InitGraphStr   NULL;                    /* InitGraphStr */
            EndGraphStr    NULL;                    /* EndGraphStr  */
            PicWidth
            InitTransferStr <CR, Esc,'K'>,NULL
            PinsPerHead    8
            PixelsStep     1
            EolnStr   NULL;                         /* EolnStr          */
            SmallEoln  <Esc,04Ah>,NULL,3,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  120,72,8;                      /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */ /* ?????????????????????????????? */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   NULL;                    /* InitGraphStr */
            EndGraphStr    NULL;                    /* EndGraphStr  */
            PicWidth
            InitTransferStr <CR, Esc,'L'>,NULL
            PinsPerHead    8
            PixelsStep     1
            EolnStr   NULL;                         /* EolnStr          */
            SmallEoln  <Esc,04Ah>,NULL,3,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  120,216,8;                     /* X and Y densities */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   NULL;                    /* InitGraphStr */
            EndGraphStr    NULL;                    /* EndGraphStr  */
            PicWidth
            InitTransferStr <CR, Esc,'L'>,NULL
            PinsPerHead    8
            PixelsStep     3
            EolnStr   NULL;                         /* EolnStr          */
            SmallEoln  <Esc,04Ah>,NULL,1,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  240,216,8;                     /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   NULL;                    /* InitGraphStr */
            EndGraphStr    NULL;                    /* EndGraphStr  */
            PicWidth
            InitTransferStr <CR, Esc,'Z'>,NULL
            PinsPerHead    8
            PixelsStep     3
            EolnStr   NULL;                         /* EolnStr          */
            SmallEoln  <Esc,04Ah>,NULL,1,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
            EndDriverDef   ; <----------------------------

         else

            ;/*===============================*/
            ;/* 9 pins : IBM, EPSON color */
            ;/*===============================*/
            ;/* the same as previous but with Planes and SimPlanes bits on */
            ;/* This introduces some optimalization in changing ribbon  */
            ;/* current color but it assumes that any composed color */
            ;/* can be build from colors c1 and c2 which are  */
            ;/* power of 2. E.G. color orange(0x5) is composed */
            ;/* of yellow(4) and red(1).                      */
            ;/* It may not work for more than 7 colors available. */
            DriverDef
            ;         4,                            /* ModesNo  */
            CompressionType  0                      /* CompressionType */
            DriverName       <'9 pins(color): IBM, EPSON'>
            ASCIInumbers    0;
            TransferValueInBytes 0;                 /*  TransferValueInBytes  */
            InitPRTStr      NULL;                   /* Init PRT string */
            EndPRTStr       NULL;                   /* End PRT string */
            CompressedStr   NULL;                   /* CompressedStr  */
            UncompressedStr NULL;                   /* UncompressedStr  */
            LeftMargin     <Esc,'l'>,NULL,1,100;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
            TopMargin      <Esc,'c'>,NULL,1,166;      /* TopMarginStr1,TopMarginStr2,TopMarginDiv */
            ColorsStrings  <Esc,'r'>,NULL, NULL;    /* ColorStr1,ColorStr2, ColorsMap */

            ModeDef  60,72,8;                       /* X and Y densities, ColorsNo */
            ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   NULL;                    /* InitGraphStr */
            EndGraphStr    NULL;                    /* EndGraphStr  */
            PicWidth
            InitTransferStr <CR, Esc,'K'>,NULL
            PinsPerHead    8
            PixelsStep     1
            EolnStr   NULL;                         /* EolnStr          */
            SmallEoln  <Esc,04Ah>,NULL,3,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  120,72,8;                      /* X and Y densities, ColorsNo */
            ModeOptions  SimPlanes;                 /* Planes, SimPlanes */ /* ?????????????????????????????? */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   NULL;                    /* InitGraphStr */
            EndGraphStr    NULL;                    /* EndGraphStr  */
            PicWidth
            InitTransferStr <CR, Esc,'L'>,NULL
            PinsPerHead    8
            PixelsStep     1
            EolnStr   NULL;                         /* EolnStr          */
            SmallEoln  <Esc,04Ah>,NULL,3,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  120,216,8;                     /* X and Y densities, ColorsNo */
            ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   NULL;                    /* InitGraphStr */
            EndGraphStr    NULL;                    /* EndGraphStr  */
            PicWidth
            InitTransferStr <CR, Esc,'L'>,NULL
            PinsPerHead    8
            PixelsStep     3
            EolnStr   NULL;                         /* EolnStr          */
            SmallEoln  <Esc,04Ah>,NULL,1,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  240,216,8;                     /* X and Y densities, ColorsNo */
            ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   NULL;                    /* InitGraphStr */
            EndGraphStr    NULL;                    /* EndGraphStr  */
            PicWidth
            InitTransferStr <CR, Esc,'Z'>,NULL
            PinsPerHead    8
            PixelsStep     3
            EolnStr   NULL;                         /* EolnStr          */
            SmallEoln  <Esc,04Ah>,NULL,1,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
            EndDriverDef   ; <----------------------------
         endif

         ;/*===============================*/
         ;/* Epson LQ 1000                 */
         ;/*===============================*/

         DriverDef
         ;         5,                            /* ModesNo  */
         CompressionType  0                      /* CompressionType */
         DriverName       <'24 pins: Epson LQ1000'>
         ASCIInumbers    0;
         TransferValueInBytes 0;                 /*  TransferValueInBytes  */
         InitPRTStr      NULL;                   /* Init PRT string */
         EndPRTStr       NULL;                   /* End PRT string */
         CompressedStr   NULL;                   /* CompressedStr  */
         UncompressedStr NULL;                   /* UncompressedStr  */
         LeftMargin     <Esc,'l'>,NULL,1,100;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
         TopMargin      <Esc,'r'>,NULL,1,166;      /* TopMarginStr1,TopMarginStr2,TopMarginDiv ??????????????? ?????????? */
         ColorsStrings  NULL,NULL, NULL;         /* ColorStr1,ColorStr2, ColorsMap */

         ModeDef  60,180,2;                      /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'*',20h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,'J'>,NULL,1,1;          /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  120,180,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'*',21h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,'J'>,NULL,1,1;          /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  180,180,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'*',27h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,'J'>,NULL,1,1;          /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  360,180,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'*',28h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,'J'>,NULL,1,1;          /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  360,360,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    <Esc,'@'>;               /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'*',28h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,'+'>,NL,1,1;            /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
         EndDriverDef   ; <----------------------------

         ;/*===============================*/
         ;/*   IBM Pro X24                 */
         ;/*===============================*/
         DriverDef
         ;         5,                            /* ModesNo  */
         CompressionType  0                      /* CompressionType */
         DriverName       <'24 pins: IBM Pro X24'>
         ASCIInumbers    0;
         TransferValueInBytes 0;                 /*  TransferValueInBytes  */
         InitPRTStr      NULL;                   /* Init PRT string */
         EndPRTStr       NULL;                   /* End PRT string */
         CompressedStr   NULL;                   /* CompressedStr  */
         UncompressedStr NULL;                   /* UncompressedStr  */
         LeftMargin     <Esc,'l'>,NULL,1,100;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
         TopMargin      <Esc,'r'>,NULL,1,166;      /* TopMarginStr1,TopMarginStr2,TopMarginDiv ???????????? */
         ColorsStrings  NULL,NULL, NULL;         /* ColorStr1,ColorStr2, ColorsMap */

         ModeDef  60,180,2;                      /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'*',20h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,'J'>,NULL,29,24;        /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  120,180,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'*',21h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,'J'>,NULL,29,24;        /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  180,180,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'*',27h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,'J'>,NULL,29,24;        /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  360,180,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'*',28h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,'J'>,NULL,29,24;        /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  360,360,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    <Esc,'@'>;               /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'*',28h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,'+'>,NL,1,1;            /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
         EndDriverDef   ; <----------------------------

         ;/*===============================*/
         ;/* EPSON LQ860                   */
         ;/*===============================*/
         DriverDef
         ;         5,                            /* ModesNo  */
         CompressionType  0                      /* CompressionType */
         DriverName       <'24 pins(color): EPSON LQ860'>
         ASCIInumbers    0;
         TransferValueInBytes 0;                 /*  TransferValueInBytes  */
         InitPRTStr      NULL;                   /* Init PRT string */
         EndPRTStr       NULL;                   /* End PRT string */
         CompressedStr   NULL;                   /* CompressedStr  */
         UncompressedStr NULL;                   /* UncompressedStr  */
         LeftMargin     <Esc,'l'>,NULL,1,100;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
         TopMargin      NULL,NULL,1,1;             /* TopMarginStr1,TopMarginStr2,TopMarginDiv ???????????????? */
         ColorsStrings  <Esc,'r'>,NULL, NULL;    /* ColorStr1,ColorStr2, ColorsMap */

         ModeDef  60,180,8;                      /* X and Y densities, ColorsNo */
         ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'*',20h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,'J'>,NULL,1,1;          /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  120,180,8;                     /* X and Y densities, ColorsNo */
         ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'*',21h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,'J'>,NULL,1,1;          /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  180,180,8;                     /* X and Y densities,, ColorsNo */
         ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'*',27h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,'J'>,NULL,1,1;          /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  360,180,8;                     /* X and Y densities, ColorsNo */
         ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'*',28h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr   NULL;                         /* EolnStr          */
         SmallEoln  <Esc,'J'>,NULL,1,1;          /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  360,360,8;                     /* X and Y densities, ColorsNo */
         ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    <Esc,'@'>;               /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'*',28h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr        NULL;                    /* EolnStr          */
         SmallEoln  <Esc,'+'>,NL,1,1;            /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
         EndDriverDef   ; <----------------------------

         ;/*===============================*/
         ;/* 24 pin IBM Pro X24 (color)    */
         ;/*===============================*/
         DriverDef
         ;         5,                            /* ModesNo  */
         CompressionType  0                      /* CompressionType */
         DriverName       <'24 pins(color): IBM Pro X24'>
         ASCIInumbers    0;
         TransferValueInBytes 0;                 /*  TransferValueInBytes  */
         InitPRTStr      NULL;                   /* Init PRT string */
         EndPRTStr       NULL;                   /* End PRT string */
         CompressedStr   NULL;                   /* CompressedStr  */
         UncompressedStr NULL;                   /* UncompressedStr  */
         LeftMargin     <Esc,'l'>,NULL,1,100;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
         TopMargin      NULL,NULL,1,1;             /* TopMarginStr1,TopMarginStr2,TopMarginDiv ???????????? */
         ColorsStrings  <Esc,'r'>,NULL, NULL;    /* ColorStr1,ColorStr2, ColorsMap */

         ModeDef  60,180,8;                      /* X and Y densities, ColorsNo */
         ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;          ;// "\x01b[\\""\x04" "\x00""\x00""\x00""\x00""\x0B4",
         EndGraphStr    NULL;          ;// "\x01b[\\""\x04" "\x00""\x00""\x00""\x00""\x0D8",
         PicWidth
         InitTransferStr <CR, Esc,'*',20h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr        NULL;                    /* EolnStr          */
         SmallEoln  <Esc,'J'>,NULL,29,24;        /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  120,180,8;                     /* X and Y densities, ColorsNo */
         ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;          ;// "\x01b[\\""\x04" "\x00""\x00""\x00""\x00""\x0B4",
         EndGraphStr    NULL;          ;// "\x01b[\\""\x04" "\x00""\x00""\x00""\x00""\x0D8",
         PicWidth
         InitTransferStr <CR, Esc,'*',21h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr        NULL;                    /* EolnStr          */
         SmallEoln  <Esc,'J'>,NULL,29,24;        /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  180,180,8;                     /* X and Y densities, ColorsNo */
         ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;          ;// "\x01b[\\""\x04" "\x00""\x00""\x00""\x00""\x0B4",
         EndGraphStr    NULL;          ;// "\x01b[\\""\x04" "\x00""\x00""\x00""\x00""\x0D8",
         PicWidth
         InitTransferStr <CR, Esc,'*',27h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr        NULL;                    /* EolnStr          */
         SmallEoln  <Esc,'J'>,NULL,29,24;        /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  360,180,8;                     /* X and Y densities, ColorsNo */
         ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;          ;// "\x01b[\\""\x04" "\x00""\x00""\x00""\x00""\x0B4",
         EndGraphStr    NULL;          ;// "\x01b[\\""\x04" "\x00""\x00""\x00""\x00""\x0D8",
         PicWidth
         InitTransferStr <CR, Esc,'*',28h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr        NULL;                    /* EolnStr          */
         SmallEoln  <Esc,'J'>,NULL,29,24;        /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  360,360,8;                     /* X and Y densities, ColorsNo */
         ModeOptions  SimPlanes;                 /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    <Esc,'@'>;               /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,'*',28h>,NULL
         PinsPerHead    24
         PixelsStep     1
         EolnStr        NULL;                    /* EolnStr          */
         SmallEoln  <Esc,'+'>,NL,1,1;            /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
         EndDriverDef   ; <----------------------------

         if 0
            ;/* Hewlet Packard PaintJet */
            ;/*    without Run Length Encoding compression     */
            ;/*===============================*/
            ;/* Hewlet Packard PaintJet       */
            ;/*===============================*/
            DriverDef
            ;         3,                            /* ModesNo  */
            CompressionType  0                      /* CompressionType */
            DriverName       <'HP PaintJet'>
            ASCIInumbers    1;
            TransferValueInBytes 1;                 /*  TransferValueInBytes  */
            InitPRTStr      <Esc,'9', Esc,'&s1C'>;                   /* Init PRT string */
            EndPRTStr       NULL;                   /* End PRT string */
            CompressedStr   NULL;                   /* CompressedStr  */
            UncompressedStr NULL;                   /* UncompressedStr  */
            LeftMargin     <Esc,'&a'>,<'H'>,1,1;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
            TopMargin      <Esc,'&l'>,<'E'>,1,166;    /* TopMarginStr1,TopMarginStr2,TopMarginDiv ???????????? */
            ColorsStrings  NULL,NULL, NULL;         /* ColorStr1,ColorStr2, ColorsMap */

            ModeDef  90,90,2;                       /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <Esc,'*t90R', Esc,'*r1U', Esc,'*r1A', Esc,'*b0M'>;
            EndGraphStr    <Esc,'*r0B'>;
            PicWidth       <Esc,'*r'>,<'S'>,1,1
            InitTransferStr <Esc,'*b'>,<'W'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        NULL;                    /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  90,90,16;                      /* X and Y densities, ColorsNo */
            ModeOptions  Planes;                    /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <Esc,'*t90R', Esc,'*r4U', Esc,'*r1A', Esc,'*b0M'>;
            EndGraphStr    <Esc,'*r0B'>;
            PicWidth       <Esc,'*r'>,<'S'>,1,1
            InitTransferStr <Esc,'*b'>,<'V'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        <Esc,'*b0W'>;            /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  180,180,8;                     /* X and Y densities, ColorsNo */
            ModeOptions  Planes;                    /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <Esc,'*t180R', Esc,'*r3U', Esc,'*r1A', Esc,'*b0M'>;
            EndGraphStr    <Esc,'*r0B'>;
            PicWidth       <Esc,'*r'>,<'S'>,1,1
            InitTransferStr <Esc,'*b'>,<'V'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        <Esc,'*b0W'>;            /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
            EndDriverDef   ; <----------------------------

         else

            ;/*===============================*/
            ;/* Hewlet Packard PaintJet       */
            ;/*===============================*/
            DriverDef
            ;         4,                            /* ModesNo  */
            CompressionType  PRT__RLE_COMPRESSION   /* CompressionType */
            DriverName       <'HP PaintJet'>
            ASCIInumbers    1;
            TransferValueInBytes 1;                 /*  TransferValueInBytes  */
            InitPRTStr      <Esc,'9', Esc,'&s1C'>;  /* Init PRT string */
            EndPRTStr       <Esc,'*r0B'>;           /* End PRT string */
            CompressedStr   <Esc,'*b1M'>;           /* CompressedStr  */
            UncompressedStr <Esc,'*b0M'>;           /* UncompressedStr  */
            LeftMargin     <Esc,'*p'>,<'X'>,1,3;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
            TopMargin      <Esc,'&l'>,<'E'>,1,166;    /* TopMarginStr1,TopMarginStr2,TopMarginDiv ???????????? */
            ColorsStrings  NULL,NULL, NULL;         /* ColorStr1,ColorStr2, ColorsMap */

            ModeDef  90,90,2;                       /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <Esc,'*t90R', Esc,'*r1U', Esc,'*r1A'>;
            EndGraphStr    NULL;
            PicWidth       <Esc,'*r'>,<'S'>,1,1
            InitTransferStr <Esc,'*b'>,<'W'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        NULL;                    /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  180,180,2;                     /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <Esc,'*t180R', Esc,'*r1U', Esc,'*r1A'>;
            EndGraphStr    NULL;
            PicWidth       <Esc,'*r'>,<'S'>,1,1
            InitTransferStr <Esc,'*b'>,<'W'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        NULL;                    /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  90,90,16;                      /* X and Y densities, ColorsNo */
            ModeOptions  Planes;                    /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <Esc,'*t90R', Esc,'*r4U', Esc,'*r1A'>;
            EndGraphStr    NULL;
            PicWidth       <Esc,'*r'>,<'S'>,1,1
            InitTransferStr <Esc,'*b'>,<'V'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        <Esc,'*b0W'>;            /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  180,180,8;                     /* X and Y densities, ColorsNo */
            ModeOptions  Planes;                    /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <Esc,'*t180R', Esc,'*r3U', Esc,'*r1A'>;
            EndGraphStr    NULL;
            PicWidth       <Esc,'*r'>,<'S'>,1,1
            InitTransferStr <Esc,'*b'>,<'V'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        <Esc,'*b0W'>;            /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
            EndDriverDef   ; <----------------------------
         endif

         if  0
            ;/* Hewlet Packard LaserJet */
            ;/*    without Run Length Encoding compression     */
            ;/*===============================*/
            ;/* Hewlet Packard LaserJet       */
            ;/*===============================*/
            DriverDef
            ;         4,                            /* ModesNo  */
            CompressionType  0                      /* CompressionType */
            DriverName       <'HP LaserJet'>
            ASCIInumbers    1;
            TransferValueInBytes 1;                 /*  TransferValueInBytes  */
            InitPRTStr      <Esc,'9', Esc,'&s1C'>;  /* Init PRT string */
            EndPRTStr       NULL;                   /* End PRT string */
            CompressedStr   NULL;                   /* CompressedStr  */
            UncompressedStr NULL;                   /* UncompressedStr  */
            LeftMargin     <Esc,'*p'>,<'X'>,3,10;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
            TopMargin      <Esc,'&l'>,<'E'>,1,166;    /* TopMarginStr1,TopMarginStr2,TopMarginDiv ????? */
            ColorsStrings  NULL,NULL, NULL;         /* ColorStr1,ColorStr2, ColorsMap */

            ModeDef  75,75,2;                       /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <Esc,'*t75R', Esc,'*r1A', Esc,'*b0M'>;
            EndGraphStr    <Esc,'*rB'>;
            PicWidth
            InitTransferStr <Esc,'*b'>,<'W'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        NULL;                    /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  100,100,2;                     /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <Esc,'*t100R', Esc,'*r1A', Esc,'*b0M'>;
            EndGraphStr    <Esc,'*rB'>;
            PicWidth
            InitTransferStr <Esc,'*b'>,<'W'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        NULL;                    /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  150,150,2;                     /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <Esc,'*t150R', Esc,'*r1A', Esc,'*b0M'>;
            EndGraphStr    <Esc,'*rB'>;
            PicWidth
            InitTransferStr <Esc,'*b'>,<'W'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        NULL;                    /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  300,300,2;                     /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <Esc,'*t300R', Esc,'*r1A', Esc,'*b0M'>;
            EndGraphStr    <Esc,'*rB'>;
            PicWidth
            InitTransferStr <Esc,'*b'>,<'W'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        NULL;                    /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
            EndDriverDef   ; <----------------------------

         else

            ;/*===============================*/
            ;/* Hewlet Packard LaserJet       */
            ;/*===============================*/
            DriverDef
            ;         4,                            /* ModesNo  */
            CompressionType  PRT__RLE_COMPRESSION   /* CompressionType */
            DriverName       <'HP LaserJet'>
            ASCIInumbers    1;
            TransferValueInBytes 1;                 /*  TransferValueInBytes  */
            InitPRTStr      <Esc,'9', Esc,'&s1C'>;  /* Init PRT string */
            EndPRTStr       NULL;                   /* End PRT string */
            CompressedStr   <Esc,'*b1M'>;           /* CompressedStr  */
            UncompressedStr <Esc,'*b0M'>;           /* UncompressedStr  */
            LeftMargin     <Esc,'*p'>,<'X'>,3,10;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
            TopMargin      <Esc,'&l'>,<'E'>,1,166;    /* TopMarginStr1,TopMarginStr2,TopMarginDiv ???????????? */
            ColorsStrings  NULL,NULL, NULL;         /* ColorStr1,ColorStr2, ColorsMap */

            ModeDef  75,75,2;                       /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <Esc,'*t75R', Esc,'*r1A'>;
            EndGraphStr    <Esc,'*rB'>;
            PicWidth
            InitTransferStr <Esc,'*b'>,<'W'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        NULL;                    /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  100,100,2;                     /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <Esc,'*t100R', Esc,'*r1A'>;
            EndGraphStr    <Esc,'*rB'>;
            PicWidth
            InitTransferStr <Esc,'*b'>,<'W'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        NULL;                    /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  150,150,2;                     /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <Esc,'*t150R', Esc,'*r1A'>;
            EndGraphStr    <Esc,'*rB'>;
            PicWidth
            InitTransferStr <Esc,'*b'>,<'W'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        NULL;                    /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

            ModeDef  300,300,2;                     /* X and Y densities, ColorsNo */
            ModeOptions  0;                         /* Planes, SimPlanes */
            ColorPalette       NULL;                /* Color palette        */
            InitGraphStr   <Esc,'*t300R', Esc,'*r1A'>;
            EndGraphStr    <Esc,'*rB'>;
            PicWidth
            InitTransferStr <Esc,'*b'>,<'W'>
            PinsPerHead    1
            PixelsStep     1
            EolnStr        NULL;                    /* EolnStr          */
            SmallEoln      NULL,NULL,1,1;           /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
            EndDriverDef   ; <----------------------------
         endif


   if   0
         ;/*===============================*/
         ;/* 9 pins : EPSON                */
         ;/*===============================*/
         DriverDef
         ;         2,                            /* ModesNo  */
         CompressionType  0                      /* CompressionType */
         DriverName       <'9 pin: EPSON (9 pin graphic)'>
         ASCIInumbers    0;
         TransferValueInBytes 0;                 /*  TransferValueInBytes  */
         InitPRTStr      NULL;                   /* Init PRT string */
         EndPRTStr       NULL;                   /* End PRT string */
         CompressedStr   NULL;                   /* CompressedStr  */
         UncompressedStr NULL;                   /* UncompressedStr  */
         LeftMargin     <Esc,'l'>,NULL,1,100;      /* LeftMarginStr1,LeftMarginStr2,LeftMarginDiv */
         TopMargin      <Esc,'c'>,NULL,1,166;      /* TopMarginStr1,TopMarginStr2,TopMarginDiv ???????????? */
         ColorsStrings  NULL,NULL, NULL;         /* ColorStr1,ColorStr2, ColorsMap */

         ModeDef  120,72;                        /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,05Eh,1>,NULL
         PinsPerHead    9
         PixelsStep     1
         EolnStr        NULL;                    /* EolnStr          */
         SmallEoln  <Esc,04Ah>,NULL,3,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */

         ModeDef  120,216,2;                     /* X and Y densities, ColorsNo */
         ModeOptions  0;                         /* Planes, SimPlanes */
         ColorPalette       NULL;                /* Color palette        */
         InitGraphStr   NULL;                    /* InitGraphStr */
         EndGraphStr    NULL;                    /* EndGraphStr  */
         PicWidth
         InitTransferStr <CR, Esc,05Eh,1>,NULL
         PinsPerHead    9
         PixelsStep     3
         EolnStr        NULL;                    /* EolnStr          */
         SmallEoln  <Esc,04Ah>,NULL,1,1;         /* SmallEoln,SmallEolnMult,SmallEolnDiv   */
         EndDriverDef   ; <----------------------------
   endif


org PRT__MaxDriverNo
    dw   DriversNo

    if   DriversNo GT MaxDriversNo
         err Too many drivers definitions, change MaxDriversNo at the file beginning
         DriversNo = MaxDriversNo;
    endif
    d = 0
    org PRT__DriversOffsets
    Rept DriversNo
         d = d+1
         genstmnt  <D_offs>,,<=>,,<DriverDefOffs_>,%d
         dw        D_offs ; driver definition offset
    ENDM

     END

     END
