/////////////////////////////////////////////////
//  DYNAMIC MEMORY ALLOCATION LIBRARY
//      newtest.cxx
//
//      Test dynamic memory debugging functions.
//
//      Copyright 1992 Scott Robert Ladd
//      All Rights Reserved
/////////////////////////////////////////////////

#include "newdebug.h"
#include "iostream.h"

// prototypes
void MyNewHandler();
void MemStatus();
void MemBug(NewDbg::Errors err);

int main()
    {
    // install error handlers
    NewDbg::InstallHandler(MemBug); // my system
    set_new_handler(MyNewHandler);  // std. C++

    MemStatus();

    // allocate a pointer
    long * iptr = new long;
    cout << "long * iptr = new long;" << endl;
    MemStatus();

    // set the value at the pointer to zero
    *iptr = 0;
    cout << "*iptr = 0; (iptr = " 
         << *iptr << ")" << endl;
    MemStatus();

    // delete the pointer
    delete iptr;
    cout << "delete iptr;" << endl;
    MemStatus();

    // delete it again -- ERROR!
    delete iptr;
    MemStatus();

    // allocate a block that's too big!
    iptr = new long[32000];
    MemStatus();

    return 0;
    }

// _new_handler function
void MyNewHandler()
    {
    cout << "\aNEW HANDLER: allocation failure"
         << endl;
    }

// display memory allocation status
void MemStatus()
    {
    cout << "\tcount = " 
         << NewDbg::GetCount()
         << ", bytes = " 
         << NewDbg::GetBytes()
         << ", error = " 
         << (int)NewDbg::GetError()
         << endl;
    }

// MemDbg error handler
void MemBug(NewDbg::Errors err)
    {
    switch (err)
        {
        case NewDbg::EF_ZEROSIZE:
            cout << "\n\azero-sized allocation"
                 << endl;
            break;

        case NewDbg::EF_NOTALLOC:
            cout << "\n\afailed allocation" 
                 << endl;
            break;

        case NewDbg::EF_INVALID:
            cout << "\n\adeleted invalid pointer"
                 << endl;
            break;

        case NewDbg::EF_UNDERFLOW:
            cout << "\n\atoo much memory deleted"
                 << endl;
            break;

        case NewDbg::EF_TOOMANY:
            cout << "\n\atoo many ptrs deleted" 
                 << endl;
            break;

        default:
            cout << "This should NEVER happen!"
                 << endl;
        }

    NewDbg::ClearError();
    }
