/*========================================================================
 fpspeed.cpp  --  Timing benchmarks for fpnum class  [Listing #4]
 by Robert N. Goldrich
                    In order to             In order to
 Compiler           Use x87 Chip            not use x87
--------------------------------------------------------------------------
 Borland            <default>               set 87=n
 Microsoft
 Zortech            <default>               extern int _8087=0 ;
 Topspeed
========================================================================*/
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "fpnum.h"

#define SEED   12345

inline int Random(int n)
{
    return (int) (((long)rand() * n ) /(RAND_MAX+1)) ;
}

main( int argc, char *argv[] )
{
#if defined(__ZTC__) && defined( NO87 )
extern int _8087 ;  _8087=0 ;
#endif

int loops = ( argc>1 ) ? atoi( argv[1] )  :  10000 ;

clock_t  start, stop ;
int      count ;
fpnum    a, b, x ;
double   ad, bd, xd ;
double   overhead, fpdiv, fpmul, fpadd, ddiv, dmul, dadd ;

//-- FIXED POINT OVERHEAD --------------------------------
srand( SEED ) ;
start = clock() ;
for( count=0; count<loops; count++ ) {
    long temp = ( (long)(Random(180)+1) << 16 ) | rand() ;
    a.poke( temp ) ;
    temp = ( (long)(Random(180)+1) << 16 ) | rand() ;
    b.poke( temp ) ;
}
stop = clock() ;
overhead = ( stop - start ) / CLK_TCK ;
printf("Fixed point overhead = %lf seconds \n", overhead ) ;

//-- FIXED POINT MULT
srand( SEED ) ;
start = clock() ;
for( count=0; count<loops; count++ ) {
    long temp = ( (long)(Random(180)+1) << 16 ) | rand() ;
    a.poke( temp ) ;
    temp = ( (long)(Random(180)+1) << 16 ) | rand() ;
    b.poke( temp ) ;
    x = a * b ;
}
stop = clock() ;
fpmul = ( stop - start - overhead ) / CLK_TCK ;

//-- FIXED POINT DIVIDE
srand( SEED ) ;
start = clock() ;
for( count=0; count<loops; count++ ) {
    long temp = ( (long)(Random(180)+1) << 16 ) | rand() ;
    a.poke( temp ) ;
    temp = ( (long)(Random(180)+1) << 16 ) | rand() ;
    b.poke( temp ) ;
    x = a / b ;
}
stop = clock() ;
fpdiv = ( stop - start - overhead ) / CLK_TCK ;

//-- FIXED POINT ADD
srand( SEED ) ;
start = clock() ;
for( count=0; count<loops; count++ ) {
    long temp = ( (long)(Random(180)+1) << 16 ) | rand() ;
    a.poke( temp ) ;
    temp = ( (long)(Random(180)+1) << 16 ) | rand() ;
    b.poke( temp ) ;
    x = a + b ;
}
stop = clock() ;
fpadd = ( stop - start - overhead ) / CLK_TCK ;

//-- DOUBLE PRECISION OVERHEAD --------------------------------
srand( SEED ) ;
start = clock() ;
for( count=0; count<loops; count++ ) {
    ad = Random(180) + (double)rand()/FP_ONE + 1 ;
    bd = Random(180) + (double)rand()/FP_ONE + 1 ;
}
stop = clock() ;
overhead = ( stop - start ) / CLK_TCK ;
printf("Double prec overhead = %lf seconds \n", overhead ) ;

//-- DOUBLE PREC MULT
srand( SEED ) ;
start = clock() ;
for( count=0; count<loops; count++ ) {
    ad = Random(180) + (double)rand()/FP_ONE + 1 ;
    bd = Random(180) + (double)rand()/FP_ONE + 1 ;
    xd = ad * bd ;
}
stop = clock() ;
dmul = ( stop - start - overhead ) / CLK_TCK ;

//-- DOUBLE PREC DIVIDE
srand( SEED ) ;
start = clock() ;
for( count=0; count<loops; count++ ) {
    ad = Random(180) + (double)rand()/FP_ONE + 1 ;
    bd = Random(180) + (double)rand()/FP_ONE + 1 ;
    xd = ad / bd ;
}
stop = clock() ;
ddiv = ( stop - start - overhead ) / CLK_TCK ;

//-- DOUBLE PREC ADD
srand( SEED ) ;
start = clock() ;
for( count=0; count<loops; count++ ) {
    ad = Random(180) + (double)rand()/FP_ONE + 1 ;
    bd = Random(180) + (double)rand()/FP_ONE + 1 ;
    xd = ad + bd ;
}
stop = clock() ;
dadd = ( stop - start - overhead ) / CLK_TCK ;

//-- Tally the results
printf("-----------------------------------------\n" ) ;
printf("    Stats for %d operations:\n", loops ) ;
printf("-----------------------------------------\n" ) ;
printf("        fpnum    double   fpnum/double\n") ;
printf("%5s  %7.3lf  %7.3lf    %7.4lf\n",  "Add",
                fpadd, dadd, fpadd/dadd ) ;
printf("%5s  %7.3lf  %7.3lf    %7.4lf\n", "Mult",
                fpmul, dmul, fpmul/dmul ) ;
printf("%5s  %7.3lf  %7.3lf    %7.4lf\n",  "Div",
                fpdiv, dadd, fpdiv/ddiv ) ;
return 0 ;
}
