program makeinc;
{TPDB Version 3.30      }
{Copyright 1992 Softiron}

{
  Syntax: MAKEINC filename.dbf filename.inc
  Do not append a path to the file names.

  This little utility allows you to create a small constants declaration
  file from a DBF file header.  Use of the declarations file simplifies
  calls to field-level routines. For  example, the following constants file
  was created by this program from customer.dbf:
  const
   COMPANY    =   1
   ADDRESS1   =   2
   ADDRESS2   =   3
   CITY       =   4
   STATE      =   5
   ZIP        =   6

   When accessing fields, as in the Repl procedure, the required field
   number may be replaced by the constant, as in
      Repl(COMPANY,'SoftIron');
   }


uses tpdb,tpdbstr;

var dbf : dataobject;
    constfile : text;
    f : byte;
    root : string[8];

    procedure writefieldname(fno : byte);
    var c : byte;
        fname : string[10];
    begin
      fillchar(fname,10,#0);
      fname[0] := #10;
      for c := 1 to 11 do
         if dbf^.fields^[fno].fieldname[c] <> #0 then
            fname[c] :=  dbf^.fields^[fno].fieldname[c]
         else
         begin
            dec(c);
            fname[0] := chr(c);
            write(constfile,'   '+root+'_'+padr(fname,10));
            exit;
         end;
    end;

begin
   root := copy(paramstr(1),1,pos('.',paramstr(1))-1);
   new(dbf,init(paramstr(1)));
   assign(constfile,paramstr(2));
   rewrite(constfile);
   writeln(constfile,'const');
   with dbf^ do
   for f := 1 to numfields do
   begin
      writefieldname(f);
      writeln(constfile,' = ',f:3,';');
   end;
   dbf^.done;
   close(constfile);
end.
