program joystick;
uses dos,crt;
{joystick test routines

 Copyright (c) 1993 By Dave Evartt. All Rights Reserved

 I have been looking for a couple of years for some decent
 code to help me make it easier to use joysticks on my computers. So far,
 I have been unable to locate anything that WORKED, so I wrote this one in
 the wee hours of the night.

 These routines demonstrate how to read the joystick ports. They were written
 on a 386/40 using a SOUND BLASTER JOYSTICK PORT. They are written in Borland
 Pascal 7.0 in real mode and should work ok with TURBO PASCAL 6.0 also,
 since I still think in that language. If you have any problems with it, drop
 me a line.

 I am a freelance computer programmer with 19 years experience with
 microcomputers. I am always looking for more work. My main interest
 is making the computer perform tricks like these. If you find any bugs
 or make improvements to this routine, please drop me a line. I am always
 looking for a better way to make these beasties work.

 Sincerly,


 Dave Evartt
 BBS: Programmers Forum at (301) 596-7692

 I hereby release this code and any portions of it to the public domain
 and further specify that it is entirely my creation. None of the code
 in this program came from any other source. That is to say that NONE of it
 is copied or extracted from any programn written by anyone else.


}

type
jstype = record
         j1present,j2present,
         a1,b1,{joystick1 buttons}
         a2,b2:boolean;{joystick2 buttons}
         x1,y1,
         x2,y2:integer;{potentiometers}
end;

var
x1max,x1min,x1cen,{these hold joystick calibration data}
y1max,y1min,y1cen,
x2max,x2min,x2cen,
y2max,y2min,y2cen:integer;

js:jstype;

jy1,jx1l,jx1r,jy1u,jy1d:real; {used for the display part of the program to
                               scale the output to the screen}

ROWS,COLS,row,col,i:integer;{worker beez}




procedure readjs(var js:jstype);
{
 this routine does all of the real work.
}
var
buttons:byte;
regs:registers;
begin
 with regs do begin
  ah:=$84;{read joy stick}
  dx:=$0;{switch settings}
  es:=$0;{these two lines are for protected mode and windows compatibility}
  ds:=$0;
  intr($15,regs); {Do it}
  {returns buttons in high order 4 bits of AL. Button is pressed if bit is OFF}

  buttons:=al shr 4 and 3;{test joystick 1 buttons}
  with js do begin
    a1:=false;
    b1:=false;
    if buttons=2 then js.a1:=true ;
    if buttons=1 then js.b1:=true ;
    if buttons=0 then begin
     a1:=true;
     b1:=true;
    end;
  end;{js}


{ The code for the second joystick below is untested as I don't have a dual
  joystick port. It SHOULD work as it is written per documentation used in
  testing joystick1 above.
}

  buttons:=al shr 6 and 3;{test joystick 2 buttons}
  with js do begin
    a2:=false;
    b2:=false;
    if buttons=2 then a2:=true ;
    if buttons=1 then b2:=true ;
    if buttons=0 then begin
      a2:=true;
      b2:=true;
    end;
  end;{js}


  ah:=$84;{read joy stick}
  dx:=$01;{Pot settings}
  es:=$0;
  ds:=$0;
  intr($15,regs); {Do it}
  with js do begin
    x1:=ax;
    y1:=bx;
    x2:=cx;
    y2:=dx;

  { Contrary to documentation, the carry flag does NOT get set properly. This
  may be in part due to the fact that I am using the SOUND BLASTER joystick
  port instead of a normal one. Also, there is no flag to indicate the
  presence of the second joystick port.

  However, the values for x1 and y1 are 0 if the joystick is NOT present and
  have a range of 1-366(on my machine and joystick). I suspect that this is
  a more logical way of dealing with it.

  The following code works on my machine.
  }
    if (js.x1=0) or (js.y1=0) then js.j1present:=false else js.j1present:=true;
    if (js.x2=0) or (js.y2=0) then js.j2present:=false else js.j2present:=true;
  end;{js}

 end;
end;

Procedure Calibrate_js;
{ this routines stores the minimum, maximum and center values for each
  axis of the joysticks. It returns an error message if joysticks are
  not connected to the computer.
}
begin
readjs(js);
 gotoxy(31,3);
with js do
{ do joystick 1}
 if j1present then begin
  gotoxy(1,2);
  write('Move Joystick 1 to Top Left Corner and Press button');
  repeat
   readjs(js);
  until (a1=true) or(b1=true);{ waits until a button is pressed}
  gotoxy(1,2);
  clreol;
  x1min:=x1;
  y1min:=y1;
  delay(250);{gives time to release the button}

  gotoxy(25,24);
  clreol;
  write('Move Joystick 1 to Bottom Right Corner and Press button');
  repeat
   readjs(js);
  until (a1=true) or(b1=true);
  gotoxy(25,24);
  clreol;
  x1max:=x1;
  y1max:=y1;
  delay(250);
  gotoxy(20,12);
  clreol;
  write('Move Joystick 1 to Center and Press button');
  repeat
   readjs(js);
  until (a1=true) or(b1=true);
  gotoxy(20,12);
  clreol;
  x1cen:=x1;
  y1cen:=y1;
 end else write('No Joystick Present');

{ now do joystick 2}
 gotoxy(31,3);
 clreol;
  with js do
  if j2present then begin
  gotoxy(1,10);
  write('Move Joystick 2 to Top Left Corner and Press button');
  repeat
   readjs(js);
  until (a2=true) or(b2=true);
  gotoxy(1,10);
  clreol;
  x2min:=x2;
  y2min:=y2;
  delay(250);

  gotoxy(25,24);
  clreol;
  write('Move Joystick 2 to Bottom Right Corner and Press button');
  repeat
   readjs(js);
  until (a2=true) or(b2=true);
  gotoxy(25,24);
  clreol;
  x2max:=x2;
  y2max:=y2;
  delay(250);
  gotoxy(20,12);
  clreol;
  write('Move Joystick 1 to Center and Press button');
  repeat
   readjs(js);
  until (a2=true) or(b2=true);
  gotoxy(20,12);
  clreol;
  x2cen:=x2;
  y2cen:=y2;
 end else write('Only 1 Joystick Present');


end;

begin
 clrscr;
 Writeln('Joystick Test Program - Copyright 1993 (c) Dave Evartt All rights Reserved');
 Calibrate_js;
 window(10,4,70,20);{set the window size}
{ fill the window with something so that we can see the size and position
   of it
}
 for i:=1 to 975 do write(#176);

{get the number of columns and rows in the current window or screen}
 cols:=LO(windmax)-LO(windmin);
 rows:=hi(windmax)-hi(windmin);

{Next 4 lines provide linear scaling to the current Screen/window size and
 is used below to calculate the proper offsets to move the cursor to.
}
 jx1r:= ((x1max-x1cen) / (cols / 2))  ;{Right linearity}
 jx1l:= ((x1cen-x1min) / (cols / 2))  ;{left linearity}
 jy1d:= ((y1max-y1cen) / (rows / 2))  ;{dn    linearity}
 jy1u:= ((y1cen-y1min) / (rows / 2))  ;{up   linearity}

{ code above this point is only executed once.}

{ read joystick 1 and place it on the screen accordingly until a key is
  pressed
}
 repeat
  readjs(js);
  with js do begin
  if j1present  then begin

   { the following two sections of code are here to deal with the problem
      that many joysticks have with linearity. Ever notice that in some
      simulators the vehicle will turn quicker in one direction than in
      the other? The reason is that the center joystick position is NOT in
      the middle of the two two extreme positions. It usualy sits off to one
      side. As a result, joystick port readings may not be as accurate as the
      programmer believes. The code here attempts to deal with this problem
      so that a side to side lock provides a more smooth and consistant
      effect.
   }
   col:=trunc(cols div 2);
   if x1>x1cen{ compensate for nolinearity by calculating the offset from center}
     then col:=trunc(cols div 2) + trunc((x1-x1cen) / jx1r);
   if x1<x1cen{ compensate for nolinearity by calculating the offset from center}
     then col:=trunc(cols div 2) - trunc((x1cen-x1) / jx1l);

   ROW:=trunc(rows div 2);
   if y1<y1cen{ compensate for nolinearity by calculating the offset from center}
     then row:=trunc(rows div 2) + trunc((y1-y1cen) / jy1u);
   if y1>y1cen{ compensate for nolinearity by calculating the offset from center}
     then row:=trunc(rows div 2) - trunc((y1cen-y1) / jy1d);


   { range checking stuff}
   IF COL<1 THEN COL:=1;
   IF COL>cols THEN COL:=cols+1;
   IF ROW<1 THEN ROW:=1;
   IF ROW>rows THEN ROW:=rows+1;


{ get out of the window to write status information and return to the
  original window sizing.
}
  window(1,24,80,24);{set the window size}
  WRITE(COL,' x ',row);
  clreol;
  window(10,4,70,20);{set the window size}

{  Put the cursor '1' on the screen or a button if that button is pressed}
    gotoxy(col,ROW);
    write('1');
    if a1=true then begin
      gotoxy(col,ROW);
      write('A');
    end;
    if b1=true then begin
      gotoxy(col,ROW);
      write('B');
    end;
    delay(50);
    if (not a1) and (not b1) then begin
      gotoxy(col,ROW);
      write(' ');
    end;
  end;

 end;{js}
 until keypressed;
end.