PROGRAM SetTest;  { Copyright (c) 1992,1993 Norbert Juffa }

USES Time;

VAR Box1, Box2:         ARRAY [0..255] OF BYTE;
    OneWOTwo, TwoWOOne,
    UnionSet, InterSet,
    Set1, Set2, Set3:   SET OF BYTE;
    K, MaxNr, L,
    N, Low, Hi:         INTEGER;
    Start:              LONGINT;

BEGIN
   WriteLn ('Set operators functional and speed test');
   WriteLn;

   RandSeed := 17;

   FOR L := 0 TO 255 DO BEGIN
      Box1 [L] := L;
   END;
   MaxNr := 255;
   FOR L := 0 TO 255 DO BEGIN
      K := Random (MaxNr+1);
      Box2 [L] := Box1 [K];
      Box1 [K] := Box1 [MaxNr];
      Dec (MaxNr);
   END;

   Start := Clock;

   Set1 := [];
   Set2 := [];
   FOR L := 0 TO 255 DO BEGIN
      Set1 := Set1 + [Box2 [L]];
      IF NOT (Box2 [L] IN Set1) THEN BEGIN
         WriteLn ('error in AddElem or InSet functions');
         Halt;
         END;
      Set2 := Set2 + [Box2 [L]] + [];
   END;

   IF (Set1 <> Set2) OR (NOT (Set1 <= Set2)) OR (NOT (Set1 >= Set2)) THEN BEGIN
      WriteLn ('error in relational operators 1');
      Halt;
      END;

   FOR L := 0 TO 255 DO BEGIN
      Set1 := Set1 - [Box2 [L]];
      IF Box2 [L] IN Set1 THEN BEGIN
         WriteLn ('error in set difference 1');
         Halt;
         END;
   END;

   IF Set1 <> [] THEN BEGIN
      WriteLn ('error in set difference 2');
      Halt;
      END;

   FOR L := 1 TO 10000 DO BEGIN
      REPEAT
         Low := Random (256);
         Hi  := Random (256);
      UNTIL Low <= Hi;

      Set1 := [];
      Set1 := Set1 + [Low..Hi];
      FOR K := 0 TO 255 DO BEGIN
         IF (K IN Set1) AND ((K < Low) OR (K > Hi)) THEN BEGIN
            WriteLn ('wrong set inclusion in add range');
            Halt;
            END;
         IF (NOT (K IN Set1)) AND ((K >= Low) AND (K <= Hi)) THEN BEGIN
            WriteLn ('wrong set exclusion in add range');
            Halt;
            END;
      END;
   END;

   FOR L := 1 TO 10000 DO BEGIN
      Set1 := [];
      Set2 := [];

      FOR K := 1 TO 10 DO BEGIN
         Low := Random (256);
         Hi  := Random (256);
         Set2:= Set1 + [Low..Hi];
         IF (Set1 >= Set2) AND (Set1 <> Set2) THEN BEGIN
            WriteLn ('error in relational operators 2');
            Halt;
            END;
         IF NOT (Set1 <= Set2) THEN BEGIN
            WriteLn ('error in relational operators 3');
            Halt;
            END;
         Set1 := Set2;

      END;
   END;

   FOR L := 1 TO 10000 DO BEGIN
      Set1 := [];
      FOR K := 1 TO 10 DO BEGIN
         Low := Random (256);
         Hi  := Random (256);
         Set1:= Set1 + [Low..Hi];
      END;
      Set2 := [];
      FOR K := 1 TO 10 DO BEGIN
         Low := Random (256);
         Hi  := Random (256);
         Set2:= Set2 + [Low..Hi];
      END;

      OneWOTwo := Set1 - Set2;
      TwoWOOne := Set2 - Set1;
      InterSet := Set1 * Set2;
      UnionSet := Set1 + Set2;

      IF InterSet <> (Set2 * Set1) THEN BEGIN
         WriteLn ('error in set difference');
         Halt;
         END;

      IF (InterSet + OneWOTwo) <> Set1 THEN BEGIN
         WriteLn ('error in set difference or intersection');
         Halt;
         END;

      IF (InterSet + TwoWOOne) <> Set2 THEN BEGIN
         WriteLn ('error in set difference or intersection');
         Halt;
         END;

      IF (OneWOTwo + TwoWOOne + InterSet) <> UnionSet THEN BEGIN
         WriteLn ('error in set union, intersection or difference');
         Halt;
         END;

   END;

   WriteLn ('Set test completes in ', (Clock-Start)*1e-3:0:3, ' seconds');

END.

