UNIT Error ;
(****************************************************************************)
(* ERROR.PAS (Turbo Pascal 6.0 unit)                                        *)
(*$O+                                                                       *)
(* Error handling and revovery services                                     *)
(****************************************************************************)
(* Documentation is available in the file ERROR.DOC from the same ZIP.      *)
(****************************************************************************)
(* Revision history:                                                        *)
(*  05-Jun-1989 Hans Schleichert, created as DOSERRMSG.PAS                  *)
(*  06-Oct-1989 Change into ERROR.PAS, include PascalErrorHandler           *)
(*  26-Dec-1989 Add Msg #105 that had been forgotten                        *)
(*  29-Jul-1990 Rewrite DosErrorMsg in assembly language                    *)
(*  11-Feb-1991 Now supports ErrMsgIntercept (see below); Rewrite           *)
(*              PascalErrorHandler in TURBO PASCAL 6.0 style; change ErrStr *)
(*  22-Feb-1991 Replace PascalErrorHandler by PasErrHandler, which is a re- *)
(*              entrant version of PascalErrorHandler. PasErrHandler now    *)
(*              takes a Context variable parameter. See explanation below.  *)
(*              Remove CriticalErrorMessage that had never been used.       *)
(*  05-Mar-1991 Change type of ErrMsgIntercept from Pointer to the (new)    *)
(*              ErrInterceptFn type, add DefaultErrorIntercept, and change  *)
(*              the comment on how to use ErrMsgIntercept.                  *)
(*  02-Apr-1991 Add ErrorAt; add ERR_Ok constant.                           *)
(*  14-May-1991 Make incompatible changes to PasErrHandler, rename          *)
(*              PasErrCtx to TPasErrCtx and add fields beyond Checksum.     *)
(*  22-Jul-1991 Remove errors in the examples to PasErrHandler.             *)
(*  18-Apr-1992 new prototype written and released on CompuServe            *)
(*  24-Apr-1992 include all functions from previous version; change all     *)
(*              ERR_... names to err...; fundamental changes to error       *)
(*              message concept.                                            *)
(*  23-Jun-1992 fix a bug in PasErrorHandler which overwrote system data.   *)
(****************************************************************************)
(* Documentation is available in the file ERRHANDL.DOC from the same ZIP.   *)
(****************************************************************************)
(* This unit was written by Hans Schleichert at Institute of Ophthalmology, *)
(* London.                                                                  *)
(* Copyright (c) all parts Hans Schleichert, 1992.                          *)
(* This piece of software is intended for and donated to the auditory of    *)
(* Borland's programming forums on CompuServe for their private, non-       *)
(* commercial use. The term "non-commercial" means that they must not make  *)
(* financial profit with this software, or by use of it. If you intend to   *)
(* use the software for commercial purposes you are required to ask the     *)
(* author's permission BEFORE you do so.                                    *)
(* Neither the author nor anyone else can take responsibility for the       *)
(* software being error-free. The author shall not be liable for any damage *)
(* or loss resultant from the use of the software.                          *)
(****************************************************************************)
(* Contacting the author:                                                   *)
(*  Send a CISMail message to Hans Schleichert, [100031,775]. Your comments *)
(*  are always welcome.                                                     *)
(****************************************************************************)

(****************************************************************************)
(*************************************) INTERFACE (**************************)
(****************************************************************************)

(****************************************************************************)
(************************************** Error message services **************)
(****************************************************************************)

    CONST   (************************** error code constants ****************)
        errSuccess          =     0 ;
        errOk               =     0 ;   errInvFunc          =     1 ;
        errFileNF           =     2 ;   errPathNF           =     3 ;
        errTooMnyFil        =     4 ;   errAccDenied        =     5 ;
        errInvHandle        =     6 ;   errMcbDestr         =     7 ;
        errInsfMem          =     8 ;   errInvAddr          =     9 ;
        errInvEnv           =    10 ;   errInfFormat        =    11 ;
        errInvAccCode       =    12 ;   errInvData          =    13 ;
                                        errInvDrive         =    15 ;
        errRemCurrDir       =    16 ;   errNotSameDev       =    17 ;
        errNoMoreFiles      =    18 ;   errWriteProt        =    19 ;
        errUnknownUnit      =    20 ;   errDriveNotRdy      =    21 ;
        errUnknownCmd       =    22 ;   errBadCrc           =    23 ;
        errBadLength        =    24 ;   errSeekErr          =    25 ;
        errUnknownMed       =    26 ;   errSectorNF         =    27 ;
        errOutOfPaper       =    28 ;   errWriteFault       =    29 ;
        errReadFault        =    30 ;   errGenFail          =    31 ;
        errShareViol        =    32 ;   errLockViol         =    33 ;
        errInvDiskChg       =    34 ;   errFcbUnavail       =    35 ;
        errShrBufOvf        =    36 ;
        errNetNotSupp       =    50 ;   errRemNotList       =    51 ;
        errDupNetName       =    52 ;   errNetNF            =    53 ;
        errNetBusy          =    54 ;   errNetDevNotEx      =    55 ;
        errNetLimExc        =    56 ;   errNetHdwErr        =    57 ;
        errNetResponse      =    58 ;   errNetUnexpErr      =    59 ;
        errNetIncAdapt      =    60 ;   errPrintQF          =    61 ;
        errPrintSpace       =    62 ;   errPrintFile        =    63 ;
        errNetDeleted       =    64 ;   errNetAccDeny       =    65 ;
        errNetType          =    66 ;   errNetNF_2          =    67 ;
        errNetNameExc       =    68 ;   errNetSessExc       =    69 ;
        errTempPaused       =    70 ;   errNetNotAcc        =    71 ;
        errRedirPaused      =    72 ;
        errFileExists       =    80 ;
        errDirEntry         =    82 ;   errFailInt24        =    83 ;
        errTooMnyRedir      =    84 ;   errDuplRedir        =    85 ;
        errInvPasswd        =    86 ;   errInvParam         =    87 ;
        errNetDevFault      =    88 ;
        errPasDiskRead      =   100 ;   errPasDiskWrite     =   101 ;
        errPasFileAssign    =   102 ;   errPasFileNotOpen   =   103 ;
        errPasFileOpenIn    =   104 ;   errPasFileOpenOut   =   105 ;
        errPasNumFormat     =   106 ;
        errPasWriteProtect  =   150 ;   errPasUnknownUnit   =   151 ;
        errPasDrvNotRdy     =   152 ;   errPasUnknownCmd    =   153 ;
        errPasBadCrcInData  =   154 ;   errPasRqStrucLen    =   155 ;
        errPasDiskSeek      =   156 ;   errPasMediaType     =   157 ;
        errPasSectorNF      =   158 ;   errPasOutOfPaper    =   159 ;
        errPasWriteFault    =   160 ;   errPasReadFault     =   161 ;
        errPasHardwareFail  =   162 ;
        errPasDivZero       =   200 ;   errPasRangeCheck    =   201 ;
        errPasStackOvf      =   202 ;   errPasHeapOvf       =   203 ;
        errPasInvPointer    =   204 ;   errPasFloatingOvf   =   205 ;
        errPasFloatingUnf   =   206 ;   errPasInvFloating   =   207 ;
        errPasOvlNotInst    =   208 ;   errPasOvlFileRead   =   209 ;
        errPasObjNotInit    =   210 ;   errPasAbstract      =   211 ;
        errPasStmRegister   =   212 ;   errPasCollIndex     =   213 ;
        errPasCollOvf       =   214 ;
                                        errAbort            =   255 ;

    TYPE    (************************** error message types *****************)
        TErrStr = String [79] ;         (* error message string             *)
        TErrorMessageFn = FUNCTION (    (* error message function prototype *)
            ErrNo : Integer
        ) : TErrStr ;

    FUNCTION DefaultErrorMsg (          (* default error message function   *)
        ErrNo : Integer
    ) : TErrStr ;

    CONST   (************************** error message routine ***************)
        DosErrorMsg : TErrorMessageFn = DefaultErrorMsg ;

(****************************************************************************)
(************************************** Run-time error handler **************)
(****************************************************************************)

    TYPE    (************************** Error handler context record ********)
        TErrCtx = RECORD CASE Integer OF
            1: (
                State : Byte ;
                SaveBP, SaveCallerBP, SaveFlags : Word ;
                RetAddr, SaveCtx, SaveExit, ActionRoutine : Pointer ;
                DontHandle : SET OF Byte
            ) ;
            2: (
                IsError : Boolean ;
                Fill__1 : Word ;
                ErrCode : Integer ;
                Fill__2 : ARRAY [0..1] OF LongInt ;
                ErrAddr : Pointer
            )
        END ;

    CONST   (************************** State flags *************************)
        errIsError  =   $01 ;
        errActive   =   $02 ;
        errOvl      =   $04 ;

    CONST   (************************** action routine returns **************)
        errReport   =   0 ;
        errRecover  =   1 ;
        errRetry    =   2 ;

    FUNCTION PasErrHandler (Context : TErrCtx) : Boolean ;

(****************************************************************************)
(************************************** Run-time error generation ***********)
(****************************************************************************)

    PROCEDURE ErrorAt (Code : Integer ; Addr : Pointer) ;

(****************************************************************************)
(*************************************) IMPLEMENTATION (*********************)
(****************************************************************************)

    USES
        OvrService ;

(****************************************************************************)
(************************************** Error message services **************)
(****************************************************************************)

    PROCEDURE GetTable ; NEAR ; EXTERNAL ; {$L ErrMsg}

    FUNCTION DefaultErrorMsg (ErrNo : Integer) : TErrStr ; ASSEMBLER ;

        ASM
            PUSH    DS
            CALL    GetTable {return ES:DI->table, CX=#entries}
            MOV     AX,[ErrNo]
            MOV     BH,0
            CLD
@@1:        SCASW                       (* search error message in list     *)
            JE      @CopyMsg1           (* branch if found                  *)
            MOV     BL,[ES:DI]
            LEA     DI,[ES:DI+1+BX]     (* try next                         *)
            LOOP    @@1

            MOV     DI,OFFSET @DefMsg1  (* default error message            *)
            MOV     BX,AX
            OR      BX,BX               (* error number negative?           *)
            JGE     @@2                 (* no, branch                       *)
            MOV     AL,'-'              (* yes, insert sign                 *)
            STOSB
            NEG     BX

@@2:        MOV     SI,OFFSET @10Tabl   (* convert into decimal ASCII       *)
            PUSH    CS
            POP     DS
            MOV     CX,4
@@3:        CMP     BX,[SI]             (* find highest power of ten        *)
            JAE     @@4
            INC     SI
            INC     SI
            LOOP    @@3

@@4:        INC     CX
@@5:        MOV     AL,'0'-1            (* conversion loop                  *)
@@6:        INC     AL
            SUB     BX,[SI]
            JAE     @@6
            ADD     BX,[SI]
            INC     SI
            INC     SI
            STOSB
            LOOP    @@5

            MOV     SI,OFFSET @DefMsg
            SUB     DI,SI
            MOV     CX,DI
            JMP     @CopyMsg2

@DefMsg:    DB      'Error no. '
@DefMsg1:   DB      '-32768'

@10Tabl:    DW      10000, 1000, 100, 10, 1

@CopyMsg1:  MOV     SI,DI
            SEGES   LODSB
            MOV     CL,AL
            MOV     CH,0

@CopyMsg2:  PUSH    ES
            POP     DS
            LES     DI,[@Result]
            MOV     AL,CL
            STOSB
            REP     MOVSB
            POP     DS
        END ;

    CONST   (************************** current context address *************)
        ErrorContext : Pointer = NIL ;

    PROCEDURE Handler ; FAR ; ASSEMBLER ; (******************************)
    (* This is the actual error handling procedure. The system jumps    *)
    (* here when an error condition arises.                             *)
    (********************************************************************)

        ASM     (********************** PROCEDURE Handler *******************)
            (*  This is the error handler routine. First of all, it unin-   *)
            (*  stalls itself from the context and exit handler chains.     *)
            MOV     AX,DS
            MOV     ES,AX
            LDS     SI,[ErrorContext]
            PUSH    SI
            LEA     SI,[(TErrCtx PTR DS:SI).SaveCtx]
            MOV     DI,OFFSET ErrorContext
            CLD
            PUSHF
            CLI
            MOVSW                       (* restore context                  *)
            MOVSW
            MOV     DI,OFFSET ExitProc
            MOVSW                       (* restore exit procedure           *)
            MOVSW
            POPF
            POP     SI                  (* from here on, DS will always     *)
            PUSH    DS                  (* point to the data segment and    *)
            POP     ES                  (* ES:SI will point to the context. *)
            MOV     DS,AX

            (*  The handler does not become active when ErrorAddr=NIL. This *)
            (*  is the case when Halt was called rather than RunError.      *)
            MOV     AX,[Word PTR ErrorAddr+0]
            OR      AX,[Word PTR ErrorAddr+2]
            JZ      @Report             (* ErrorAddr=NIL, call next handler *)

            (*  The handler will neither become active when the DontHandle  *)
            (*  bit is set which corresponds to the error code.             *)
            MOV     CL,[Byte PTR ExitCode]
            MOV     BL,CL
            (*$IFOPT G+*)
            SHR     BL,3                (* the 8086 can't do this           *)
            (*$ELSE*)
            SHR BL,1; SHR BL,1; SHR BL,1
            (*$ENDIF*)
            MOV     BH,0
            MOV     AL,1
            ROL     AL,CL
            TEST    [Byte PTR ((TErrCtx PTR ES:SI).DontHandle+BX)],AL
            JNZ     @Report             (* don't handle flag set, call next *)

            (*  If the ActionRoutine field is not NIL, there is a routine   *)
            (*  to call. Otherwise, the default action is error recovery.   *)
            MOV     AX,[Word PTR ((TErrCtx PTR ES:SI).ActionRoutine+0)]
            OR      AX,[Word PTR ((TErrCtx PTR ES:SI).ActionRoutine+2)]
            JZ      @Recover            (* no action, recover from error    *)
            PUSH    ES
            PUSH    SI
            PUSH    [(TErrCtx PTR ES:SI).SaveCallerBP]
            CALL    [(TErrCtx PTR ES:SI).ActionRoutine]
            POP     SI
            POP     ES
            CMP     AX,errRecover
            JB      @Report
            JE      @Recover

            (*  Action routine returns errRetry *****************************)
            (*  In this case, the handler returns a True value and the      *)
            (*  instruction(s) in the handler's scope will be executed      *)
            (*  again. For this purpose, the handler must be re-installed.  *)
            MOV     [Byte PTR CS:@RetVal],True  (* return True              *)
            PUSHF
            PUSH    SI
            LEA     DI,[(TErrCtx PTR ES:SI).SaveCtx]
            MOV     SI,OFFSET ErrorContext
            CLI
            MOVSW                       (* save error context               *)
            MOVSW
            MOV     SI,OFFSET ExitProc
            MOVSW                       (* save exit handler                *)
            MOVSW
            POP     SI
            MOV     [Word PTR ErrorContext+0],SI            (* set error    *)
            MOV     [Word PTR ErrorContext+2],ES            (*  context     *)
            MOV     [Word PTR ExitProc+0],OFFSET Handler    (* set exit     *)
            MOV     [Word PTR ExitProc+2],SEG Handler       (*  proc        *)
            POPF
            JMP     @Return

@RetVal:    DB      0                   (* return value                     *)

@Recover:   (*  Action routine returns errRecover, or no action routine *****)
            (*  This is the default action. Is passes control to the code   *)
            (*  which requested installation of the handler, returning a    *)
            (*  function result of False, which means to exit the handler's *)
            (*  context.                                                    *)
            MOV     [Byte PTR CS:@RetVal],False (* return False             *)
            AND     [(TErrCtx PTR ES:SI).State],errOvl

@Return:    (*  Common part for recovery and retry actions ******************)
            (*  This part traverses the discarded part of the call stack,   *)
            (*  searching for stack frames which point to swapped-out over- *)
            (*  lays. These frames are recognized by the address offset     *)
            (*  being zero and the segment part pointing to an INT 3Fh in-  *)
            (*  struction. For each such frame, the non-discarded stack is  *)
            (*  scanned for matching return segment values, and for the     *)
            (*  frame which matches this condition, its offset part is      *)
            (*  stored in the overlay header and then reset to zero. This   *)
            (*  makes sure all swapped-out overlays will swap in properly   *)
            (*  as control passes back to them.                             *)
            (*  During this part, ES will be pointed to the overlay header  *)
            (*  but its previous value is saved on the stack.               *)
            MOV     DX,[(TErrCtx PTR ES:SI).SaveCallerBP]
            PUSH    ES
            MOV     BX,BP               (* traverese discarded stack        *)
@@1:        CMP     BX,DX               (* top of discarded part?           *)
            JE      @@5                 (* yes, branch to next part         *)
            MOV     AX,[SS:BX+2]        (* load return address offset       *)
            OR      AX,AX               (* is it zero?                      *)
            JNZ     @@4                 (* no - ignore it                   *)
            MOV     AX,[SS:BX+4]        (* load return address segment      *)
            MOV     ES,AX
            CMP     [(TOvrHeader PTR ES:0).Signature],3FCDh
            JNE     @@4                 (* is no overlay header             *)
            PUSH    BX                  (* traverse non-discarded frames    *)
            MOV     BX,DX
@@2:        OR      BX,BX               (* top of stack?                    *)
            JZ      @@3                 (* yes, continue discarded stack    *)
            CMP     AX,[SS:BX+4]        (* matching segment?                *)
            JNE     @@3                 (* no, try next frame               *)
            XOR     AX,AX
            XCHG    AX,[SS:BX+2]        (* load and reset offset part       *)
            MOV     [(TOvrHeader PTR ES:0).SaveReturn],AX (* save offset    *)
@@3:        POP     BX                  (* restore stack context            *)
@@4:        MOV     BX,[SS:BX]          (* next stack frame                 *)
            JMP     @@1

@@5:        (*  Now we can be sure all return addresses are valid above the *)
            (*  stack frame which remains to be built.                      *)
            (*  The next part establishes the stack context which will be   *)
            (*  the stack frame used for issuing the RET instruction that   *)
            (*  finally will transfer control to the code which installed   *)
            (*  this handler.                                               *)
            (*  DS will be pointed to the context, and its original value   *)
            (*  will get lost.                                              *)
            POP     DS                  (* point to the context             *)
            CLD
            LODSB                       (* State                            *)
            MOV     CL,AL
            OR      AL,errIsError       (* set error state flag             *)
            MOV     [DS:SI-1],AL
            LODSW                       (* SavedBP                          *)
            MOV     BP,AX
            MOV     SP,BP               (* this actually discards the in-   *)
                                        (* active part of the stack         *)
            LODSW                       (* SavedCallerBP                    *)
            MOV     [BP],AX
            LODSW                       (* SavedFlags                       *)
            PUSH    AX

            (*  Next, we have to put onto the stack the return address.     *)
            (*  This is straightforward if it no overlaid address, but if   *)
            (*  it is, we shall first check whether the code is currently   *)
            (*  in memory, in which case the procedure is easy too.         *)
            (*  Remember that DS:SI points to the context's RetAddr field.  *)
            LODSW                       (* RetAddr, offset part             *)
            MOV     DX,AX
            LODSW                       (* RetAddr, segment part            *)
            MOV     BX,AX
            TEST    CL,errOvl           (* is the code overlaid?            *)
            JZ      @@8                 (* no, easy job                     *)
            MOV     ES,AX
            MOV     AX,[(TOvrHeader PTR ES:0).Segment]
            OR      AX,AX               (* code in memory?                  *)
            JNZ     @@8                 (* yes, easy job too                *)

            (*  What a mess! The code is really swapped-out. That means, we *)
            (*  have to convince the overlay manager that it wants to swap  *)
            (*  it in again. This is done by pointing the return to the     *)
            (*  overlay header table and setting the SaveReturn field to    *)
            (*  the offset we want to receive control. But before we do     *)
            (*  that, we have to make sure we aren't discarding another     *)
            (*  active stack frame that points to that unit. So we have to  *)
            (*  traverse the stack again, like the operation done above.    *)
            (*  ES:0 still points to the overlay header while DS:SI point   *)
            (*  to the SaveContext field of the context record.             *)
            MOV     CX,ES
            MOV     BX,[BP]
@@6:        MOV     AX,[SS:BX]
            OR      AX,AX               (* top of stack?                    *)
            JZ      @@7a                (* yes, done                        *)
            CMP     CX,[SS:BX+4]        (* matching segment?                *)
            JE      @@7                 (* yes, branch                      *)
            MOV     BX,AX               (* try next stack frame             *)
            JMP     @@6

@@7:        XCHG    DX,[(TOvrHeader PTR ES:0).SaveReturn]
                                        (* load saved return offset         *)
            XCHG    DX,[SS:BX+2]        (* restore stack frame offset part  *)
            JMP     @@7b

@@7a:       MOV     [(TOvrHeader PTR ES:0).SaveReturn],DX
@@7b:       XOR     DX,DX
            MOV     AX,ES

@@8:        (*  After all, we've got the return address in AX:DX (segment   *)
            (*  in AX, offset in DX), which we can now put onto the stack.  *)
            MOV     [SS:BP+4],AX
            MOV     [SS:BP+2],DX

            (*  What remains to do is to restore DS and copy error code and *)
            (*  address into the context record, and clear the error        *)
            (*  condition.                                                  *)
            (*  DS:SI still point to the SaveContext field of the context   *)
            (*  record.                                                     *)
            PUSH    DS
            POP     ES                  (* point ES to context              *)
            MOV     AX,SEG @Data
            MOV     DS,AX               (* restore data segment             *)
            MOV     AX,[ExitCode]
            MOV     [(TErrCtx PTR ES:SI-TErrCtx.SaveCtx).ErrCode],AX
            LEA     DI,[(TErrCtx PTR ES:SI-TErrCtx.SaveCtx).ErrAddr]
            XOR     AX,AX
            XCHG    [Word PTR ErrorAddr+0],AX
            STOSW
            XOR     AX,AX
            XCHG    [Word PTR ErrorAddr+0],AX
            STOSW

            (*  Now, we're done. After popping the saved flags from the     *)
            (*  stack we can pass control to either the calling code or to  *)
            (*  overlay dispatcher which loads the calling code.            *)
            POPF
            MOV     AL,[Byte PTR CS:@RetVal]    (* load the return value    *)
            POP     BP
            RETF    4                   (* pass by one VAR parameter        *)

@Report:    (*  Action routine returns errReport ****************************)
            MOV     DX,DS
            MOV     AX,ES
            MOV     DS,AX
            MOV     ES,DX
            LEA     SI,[(TErrCtx PTR DS:SI).SaveCtx]
            MOV     DI,OFFSET ErrorContext
            PUSHF
            CLI
            CLD
            MOVSW                       (* restore previous context         *)
            MOVSW
            MOV     DI,OFFSET ExitProc
            MOVSW                       (* restore previous exit procedure  *)
            MOVSW
            POPF
            MOV     DS,DX               (* use standard return              *)
        END ;   (********************** PROCEDURE Handler *******************)

    FUNCTION PasErrHandler (Context : TErrCtx) : Boolean ; ASSEMBLER ;
    (* Error Handler installation procedure. For details please see the *)
    (* documentation file.                                              *)
    (********************************************************************)

        ASM     (********************** FUNCTION PasErrHandler **************)
            LES     DI,[Context]
            TEST    [(TErrCtx PTR ES:DI).State],errActive
            JNZ     @Uninstall
            (*  Installation part   *****************************************)
            PUSHF
            PUSH    [Word PTR SS:BP+4]
            PUSH    [Word PTR SS:BP+2]
            CALL    OvrGetAddress
            LES     DI,[Context]
            OR      DX,DX
            JZ      @@1                 (* jump if not overlaid             *)
            MOV     CX,AX
            MOV     AL,errActive+errOvl
            JMP     @@2
@@1:        MOV     DX,[Word PTR SS:BP+4]   (* if not overlaid load return  *)
            MOV     CX,[Word PTR SS:BP+2]   (*  addr                        *)
            MOV     AL,errActive

@@2:        MOV     BX,DI               (* ES:DI points at Context          *)
            CLD
            STOSB                       (* State                            *)
            MOV     AX,BP
            STOSW                       (* SaveBP                           *)
            MOV     AX,[BP]
            STOSW                       (* SaveCallerBP                     *)
            POP     AX
            STOSW                       (* SaveFlags                        *)
            MOV     AX,CX
            STOSW                       (* RetAddr, offset part             *)
            MOV     AX,DX
            STOSW                       (* RetAddr segment or dispatcher    *)
            PUSHF
            CLI
            MOV     SI,OFFSET ErrorContext
            MOVSW                       (* SaveCtx                          *)
            MOVSW
            MOV     SI,OFFSET ExitProc
            MOVSW                       (* SaveExit                         *)
            MOVSW
            MOV     [Word PTR ErrorContext+0],BX
            MOV     [Word PTR ErrorContext+2],ES
            MOV     [Word PTR ExitProc+0],OFFSET Handler
            MOV     [Word PTR ExitProc+2],SEG Handler
            POPF
            XOR     AX,AX
            MOV     [Word PTR ErrorAddr+0],AX
            MOV     [Word PTR ErrorAddr+2],AX
            INC     AL                  (* return True                      *)
            JMP     @Done
@Uninstall: (*  Uninstallation part *****************************************)
            MOV     AX,DS
            MOV     ES,AX
            LDS     SI,[Context]
            MOV     BX,SI
            LEA     SI,[(TErrCtx PTR DS:SI).SaveCtx]
            MOV     DI,OFFSET ErrorContext
            CLD
            PUSHF
            CLI
            MOVSW
            MOVSW
            MOV     DI,OFFSET ExitProc
            MOVSW
            MOVSW
            POPF
            MOV     [(TErrCtx PTR DS:BX).IsError],False
            XOR     SI,SI
            MOV     [(TErrCtx PTR DS:BX).ErrCode],SI
            MOV     [Word PTR (TErrCtx PTR DS:BX).ErrAddr+0],SI
            MOV     [Word PTR (TErrCtx PTR DS:BX).ErrAddr+2],SI
            MOV     DS,AX
            MOV     AL,0                (* return False                     *)
@Done:  END ;   (********************** FUNCTION PasErrHandler **************)

(****************************************************************************)
(************************************** Run-time error generation ***********)
(****************************************************************************)

    PROCEDURE ErrorAt (Code : Integer ; Addr : Pointer) ;

        LABEL
            CallRunErr ;

        BEGIN   (********************** PROCEDURE ErrorAt *******************)
            ASM
                MOV     AX,[Code]
                LES     DI,[Addr]
                MOV     BX,ES
                OR      BX,DI
                JNZ     @ErrAt
                MOV     BX,[BP]
                LES     DI,[SS:BX+2]
@ErrAt:         PUSH    ES
                PUSH    DI
                JMP     [Pointer PTR CallRunErr + 3]
            END ;
CallRunErr: RunError (0)
        END ;   (********************** PROCEDURE ErrorAt *******************)

END .