(*

                WinPrint v1.0       (c) 1992 Paul Bayliss
                Printer unit for Turbo Pascal for Windows

Partially modified by Kurt Bertram, Compuserve [100031,3373]
New version uploaded with the friendly allowance of Mr. Paul Bayliss.

I encourage you to download the original WPRINT.ZIP to read
the original comments of Paul Bayliss.

GENERAL INFO of Paul Bayliss:

This is my first stab at printing with TPW. AS such I cannot promise that
it will work in every situation and I will not accept any liabilty etc
for ANY damage caused by using these routines. However - it works for me!

Although I wish to keep copyright to WinPrint I offer it free to anyone
who can use it. I would like to be notified of any bugs or enhancements
that you may make : Compuserve [70374,2414]
=========================================================================
*)

Unit WinPrt;

INTERFACE

uses WObjects,WinTypes,WinProcs,Strings;

Var
   PrintDC : hDC;
   PrintingAborted : Boolean;
   UsedFont        : HFont;
Type
   PLinePrinter = ^TLinePrinter;
   TLinePrinter = object(tobject)
    LineHeight,MaxX,MaxY,CurX,CurY,CWidth : word;
    Font: HFont;
    Metrics : tTextmetric;
    Constructor Init(UxFont: HFont; Qname : Pchar);
    Destructor Done; virtual;
    Procedure NewLine; virtual;
    Procedure NewPage; virtual;
    Function LineWidth(data : pchar) : integer; virtual;
    Procedure Write(Data : Pchar); virtual;
    Procedure WriteLn(data : Pchar); virtual;
    Procedure TabWrite(Tab: Byte; Data: PChar);
    Procedure TabWriteln(Tab: Byte; Data: Pchar);
   end;

Procedure Init_PrinterFonts;
Procedure List_PrinterFonts(PW: PWindowsObject; Var Ofnt: HFont);
Procedure SetupPrinter(Window : Hwnd);
Procedure SelectPrinter(Window : Hwnd);
Procedure StartPrinter(UFont: HFont; Qname : Pchar);
Procedure NewPage;
Procedure StopPrinter;
Procedure DisplayPrintCompleted(percent : byte);
Procedure DisplayPrintInfo(Info : Pchar);

IMPLEMENTATION

{$R WinPrt.RES}

Uses Pfonts;

Type
    (* Windows 3 Configuration Function *)
    TPGetExtDevMode = Function(Window  : Hwnd;
                               Handle  : tHandle;
                               OutMode : tDevMode;
                               DevName : Pchar;
                               Output  : Pchar;
                               InMode  : TDevMode;
                               Profile : Pchar;
                               PMode   : word) : Boolean;

    (* Windows 2 Configuration Function *)
    TPGetDevMode    = Function(Window  : Hwnd;
                               Handle  : tHandle;
                               DevName : Pchar;
                               OutPut  : Pchar) : Boolean;

  ErrorCode = (NoPrinterInfo,NoDC,NoMemory);

  PPrintAbortDlg = ^TPrintAbortDlg;
  TPrintAbortDlg = object(TDialog)
   Procedure Cancel(var MSG : TMessage); virtual id_first + id_cancel;
  end;

PProfileArray = ^TProfileArray;
TProfileArray = object(TSortedCollection)
 Function Compare(Key1,Key2 : Pointer) : Integer; virtual;
end;

Function TProfileArray.Compare(Key1,Key2 : Pointer): integer;
begin
  Compare:=-1;
end;

Var
   DevMode : tDevMode;
   pAddr   : tFarProc;
   DevHandle : tHandle;
   ProfileString,Message : array[0..255] of char;
   Driver,DriverName,DeviceName,Port : array[0..79] of char;
   DevName   : Pchar;
   ChPtr,ChPos : Pchar;
   Count : Longint;
   ProfileArray : PSortedCollection;
   PrintDialog : PDialog;
   PrintAbortDlg : PPrintAbortDlg;
   lpPrintAbortProc : tFarProc;

   Tempstr : array[0..20] of char;

Procedure ParseStr(Pstr : pchar; Count : longint; ch : char;
                   var ReturnedArray : PsortedCollection);
var
   Ploop,Pindex : longint;
   TempWord : array[0..80] of char;
begin
     TempWord[0]:=#0;
     Pindex:=0;
     for PLoop:=0 to Count-1 do
     begin
          if Pstr[Ploop]<>ch then
          begin
            TempWord[Pindex]:=Pstr[Ploop];
            inc(Pindex);
            TempWord[Pindex]:=#0;
          end
          else
          begin
            ReturnedArray^.insert(strnew(TempWord));
            TempWord[0]:=#0;
            Pindex:=0;
          end;
     end;
     if (ch<>#0) then ReturnedArray^.insert(strnew(TempWord));
end;

Function ParseProfileString(AppName,KeyName,Default : pchar;
                            var ReturnedArray : PSortedCollection) : integer;
begin
  Count:=GetProfileString(AppName,KeyName,Default,ProfileString,sizeof(ProfileString));
  if KeyName=NIL then
    ParseStr(ProfileString,Count,#0,ReturnedArray)
  else
    ParseStr(ProfileString,Count,',',ReturnedArray);
  ParseProfileString:=ReturnedArray^.Count;
end;


Function GetPrinterInfo : Boolean;
begin
  GetPrinterInfo:=FALSE;
  ProfileArray:=new(PProfileArray,init(1,1));
  if ParseProfileString('Windows','Device','NONE',ProfileArray)<3 then exit;
  StrCopy(DeviceName,ProfileArray^.at(0));
  strcopy(DriverName,ProfileArray^.at(1));
  StrCopy(Port,ProfileArray^.at(2));
  dispose(ProfileArray);
  strcopy(Driver,DriverName);
  strcat(DriverName,'.DRV');
  GetPrinterInfo:=TRUE;
end;

Procedure Init_PrinterFonts;
begin
  if Not GetPrinterInfo then
  begin
    Messagebox(GetActiveWindow,'Unable to Load Printer Configuration Routine',
               'ERROR',mb_iconexclamation or mb_ok);
    exit;
  end;
  DevHandle:=LoadLibrary(Drivername);
  PrintDC:=CreateDC(Driver,DeviceName,Port,Nil);
  if printdc=0 then messagebox(getfocus,'','No DC',0);
  UsedFont := SelectObject(PrintDC, GetStockObject(System_fixed_Font));
  DeleteDC(PrintDC);
  FreeLibrary(DevHandle);
end;

Procedure List_PrinterFonts(PW: PWindowsObject; Var Ofnt: HFont);
var Lf  : TLogFont;
    Size: Integer;
begin
  if Not GetPrinterInfo then
  begin
    Messagebox(Pw^.HWindow,'Unable to Load Printer Configuration Routine',
               'ERROR',mb_iconexclamation or mb_ok);
    exit;
  end;
  DevHandle:=LoadLibrary(Drivername);
  PrintDC:=CreateDC(Driver,DeviceName,Port,Nil);
  if printdc=0 then messagebox(getfocus,'','No DC',0);
  DeleteObject(OFnt);
  if FontDialog(PW,PrintDC,Lf,Size) then begin
    if Size = 0 then OFnt:= CreateFontIndirect(Lf)
    else OFnt:= CreateFont(abs(Size), 0, 0, 0, 400,
       0, 0, 0, ANSI_CharSet, Out_Default_Precis,
       Clip_Default_Precis, Default_Quality,
       Default_Pitch, Lf.lfFaceName);
  end
  else Ofnt := SelectObject(PrintDC, GetStockObject(System_fixed_Font));
  DeleteDC(PrintDC);
  FreeLibrary(DevHandle);
end;

Procedure SetupPrinter(Window : Hwnd);
begin
  if Not GetPrinterInfo then
  begin
    Messagebox(Window,'Unable to Load Printer Configuration Routine',
               'ERROR',mb_iconexclamation or mb_ok);
    exit;
  end;
  DevHandle:=LoadLibrary(Drivername);
  Paddr:=getprocaddress(DevHandle,'ExtDeviceMode');
  if (Paddr<>NIL) then
  begin
    TPGetExtDevMode(Paddr) (window,DevHandle,DevMode,DriverName,Port,DevMode,NIL, dm_update or dm_prompt);
  end
  else
  begin
    Paddr:=getprocaddress(DevHandle,'DeviceMode');
    if (Paddr<>NIL) then
    begin
      TPGetDevMode(Paddr) (window,DevHandle,DriverName,Port);
    end;
  end;
  FreeLibrary(DevHandle);
end;


Type
    PPrintDialog = ^TPrintDialog;
    TPrintDialog = object(TDialog)
     DefaultPrinter : array[0..80] of char;
     DefaultDriver : array[0..12] of char;
     DefaultPort  : array[0..5] of char;
     PrintArray : PSortedCollection;
     Procedure Setupwindow; virtual;
     Procedure AvailableList(var MSG : TMessage); virtual id_first + 103;
     Procedure OK(var MSG : TMessage); virtual id_first + id_ok;
     Procedure cancel(var MSG : TMessage); virtual id_first + id_cancel;
     Procedure Setup(var MSG : TMessage); virtual id_first + 161;
    end;

    Procedure TPrintDialog.setup(var MSG : TMessage);
    begin
      setupprinter(hwindow);
    end;

    Procedure TPrintDialog.setupwindow;
    const TabArray : array[1..2] of integer = (30,150);
    var PrnCount,PrnIndex : integer;
    begin
      TDialog.Setupwindow;
      senddlgitemmessage(hwindow,103,lb_settabstops,2,longint(@TabArray));
      ProfileArray:=new(PProfileArray,init(1,1));
      if not ParseProfileString('Windows','Device','NONE',ProfileArray)=3
      then enddlg(2);
      strcopy(DefaultPrinter,ProfileArray^.at(0));
      StrCopy(DefaultDriver,ProfileArray^.at(1));
      StrCopy(DefaultPort,ProfileArray^.at(2));
      strEcopy(StrEcopy(StrEcopy(Message,ProfileArray^.at(0)),
                                         ',  Port='),
                                         ProfileArray^.at(2));
      setdlgitemtext(hwindow,102,Message);
      Dispose(ProfileArray);
      ProfileArray:=new(PProfileArray,init(1,1));
      for PrnCount:=0 to ParseProfileString('Devices',nil,'NONE',ProfileArray)-1 do
      begin
        PrintArray:=new(PProfileArray,init(1,1));
        ParseProfileString('PrinterPorts',ProfileArray^.at(Prncount),'NONE Found',PrintArray);
        StrEcopy(StrECopy(StrEcopy(Message,ProfileArray^.at(PrnCount)),
                                           ',  Port='),
                                           PrintArray^.at(1));
        senddlgitemmessage(hwindow,103,lb_addstring,0,longint(@message));
        Dispose(PrintArray);
      end;
      Dispose(ProfileArray);
    end;

    Procedure TPrintDialog.AvailableList(var MSG : TMessage);
    var PrnIndex : integer;
    begin
      Case MSG.LParamHI of
        lbn_SelChange : Begin
                        PrnIndex:=senddlgitemmessage(Hwindow,103,lb_getcursel,0,0);
                        senddlgitemmessage(hwindow,103,lb_gettext,prnindex,longint(@message));
                        setdlgitemtext(hwindow,102,message);
                        end;
        lbn_DblClk    : begin
                        PrnIndex:=senddlgitemmessage(Hwindow,103,lb_getcursel,0,0);
                        senddlgitemmessage(hwindow,103,lb_gettext,prnindex,longint(@message));
                        setdlgitemtext(hwindow,102,message);
                        OK(MSG);
                        end;
      end;
    end;

    Procedure TPrintDialog.OK(var MSG : TMessage);
    var Mindex,MPos : Pchar;
        Printer : array[0..80] of char;
        Driver,port : array[0..12] of char;
    begin
      getdlgitemtext(hwindow,102,message,80);
      MIndex:=message;
      MPos:=StrScan(Mindex,',');
      strLcopy(Printer,Mindex,(MPos-Mindex));
      ProfileArray:=new(PProfileArray,init(1,1));
      ParseProfileString('PrinterPorts',Printer,nil,ProfileArray);
      strcopy(Driver,profilearray^.at(0));
      strcopy(Port,ProfileArray^.at(1));
      dispose(ProfileArray);
      StrEcopy(StrEcopy(StrEcopy(strEcopy(strEcopy(
          message,Printer),','),Driver),','),Port);
      Writeprofilestring('Windows','Device',message);

      strecopy(strecopy(strecopy(Message,Driver),','),Port);
      Writeprofilestring('Devices',Printer,message);

      strecopy(strecopy(strecopy(Message,DefaultDriver),','),DefaultPort);
      Writeprofilestring('Devices',DefaultPrinter,message);

      strcopy(message,'windows');
      sendmessage($FFFF,wm_wininichange,0,longint(@message));
      strcopy(message,'Devices');
      sendmessage($FFFF,wm_wininichange,0,longint(@message));
      TDialog.OK(MSG);
    end;

    Procedure TPrintDialog.Cancel(var MSG : TMessage);
    begin
      TDialog.Cancel(MSG);
    end;


Procedure SelectPrinter(Window : Hwnd);
begin
  PrintDialog:=new(PPrintDialog,init(Application^.Mainwindow,'SelectPrinter'));
  Application^.execdialog(PrintDialog);
  setfocus(window);
end;

(*=====================================================================*)




  Procedure TPrintAbortDlg.Cancel(var MSG : TMessage);
  begin
     PrintingAborted:=TRUE;
     setwindowtext(hwindow,'Printing cancelled ...');
  end;


Procedure PrinterError(Error : integer);
var Message : array[0..80] of char;
begin
  case error of
    sp_Error : strcopy(message,'Unknown (general) error');
    sp_OutofDisk : strcopy(message,'Not enough memory on harddisk');
    sp_outofmemory : strcopy(message,'Not enough memory');
  end;
  Messagebox(getfocus,message,'Printer error',mb_iconstop or mb_ok);
end;

Function PrintAbortProc(PrnDC : hdc; code : word) : Boolean; EXPORT;
var WinMSG : tMSG;
begin
  if (code<>0) and (Code<>sp_Userabort) then PrinterError(Code);
  While not PrintingAborted and Peekmessage(WinMSG,0,0,0,pm_remove) do
  begin
    if not Isdialogmessage(PrintAbortDlg^.Hwindow,WinMSG) then
    begin
      Translatemessage(WinMSG);
      Dispatchmessage(WinMSG);
    end;
  end;
  PrintAbortProc:=not PrintingAborted;
end;

Procedure StartPrinter(UFont: HFont; QName : Pchar);
begin
  if not GetPrinterInfo then exit;
  PrintAbortDlg:=new(PPrintAbortDlg,init(Application^.mainwindow,'AbortPrint'));
  PrintAbortDlg^.create;
  PrintDC:=CreateDC(Driver,DeviceName,Port,Nil);
  if printdc=0 then messagebox(getfocus,'','No DC',0);
  lpPrintAbortProc:=makeprocinstance(@PrintAbortProc,hinstance);
  if Escape(PrintDC,SetAbortProc,0,lpPrintAbortProc,nil)<1 then
  begin
     messagebox(getfocus,'Printer not available','Printer Error',0);
     PrintAbortDlg^.destroy;
     freeprocinstance(lpPrintabortproc);
     deletedc(PrintDC);
     exit;
  end;
  SelectObject(PrintDC,UFont);
  Escape(PrintDC,STARTDOC,sizeof(Qname),Qname,NIL);
  PrintAbortDlg^.show(sw_normal);
end;

Procedure NewPage;
begin
   setwindowtext(PrintAbortDlg^.Hwindow,'Spooling, please wait');
   Escape(PrintDC,NEWFRAME,0,nil,nil);
   setwindowtext(PrintAbortDlg^.Hwindow,'Printing');
end;

Procedure StopPrinter;
begin
   Escape(PrintDC,ENDDOC,0,nil,nil);
   PrintAbortDlg^.destroy;
   freeprocinstance(lpPrintabortproc);
   deletedc(PrintDC);
end;

Procedure DisplayPrintCompleted(percent : byte);
var tempstr : array[0..20] of char;
begin
   str(Percent,tempstr);
   strcat(tempstr,'% printed');
   setdlgitemtext(PrintAbortDlg^.Hwindow,4,tempstr);
end;

Procedure DisplayPrintInfo(Info : Pchar);
begin
   setdlgitemtext(PrintAbortDlg^.hwindow,3,info);
end;

(*====== Line Printer Methods ========================================*)

Constructor TLinePrinter.Init(UxFont: HFont; Qname : Pchar);
begin
  TObject.Init;
  StartPrinter(UxFont,Qname);
  Font:= UxFont;
  gettextmetrics(PrintDC,metrics);
  LineHeight:=Metrics.tmheight+metrics.tmExternalLeading;
  CWidth:= Metrics.TmMaxCharWidth;
  MaxX:=getdevicecaps(PrintDC,Horzres);
  MaxY:=Getdevicecaps(PrintDC,VertRes);
  CurX:=0; CurY:=0;
end;

Destructor TLinePrinter.Done;
begin
  TObject.done;
  stopprinter;
end;

Procedure TLinePrinter.NewLine;
begin
  CurX:=0;
  inc(CurY,LineHeight);
  if CurY>MaxY then newpage;
end;

Function TLinePrinter.LineWidth(data : Pchar) : integer;
begin
   if data<>NIL then
     LineWidth:=(lo(getTextExtent(PrintDC,data,strlen(data))))
   else
     LineWidth:=0;
end;

Procedure TLinePrinter.Write(data : Pchar);
begin
  if (CurX + LineWidth(data))> MaxX then newline;
  Textout(PrintDC,CurX,CurY,data,strlen(data));
  inc(CurX,linewidth(data));
end;

Procedure TLinePrinter.WriteLn(data : Pchar);
begin
  Write(Data);
  newline;
end;

Procedure TLinePrinter.TabWrite(Tab: Byte; Data: PChar);
begin
  if (CurX + (CWidth * (Tab+1)) > MaxX) then NewLine;
  TextOut(PrintDc,CurX,CurY,data,strlen(Data));
  inc(CurX,(CWidth * (Tab+1)));
end;

Procedure TLinePrinter.TabWriteln(Tab: Byte; Data: Pchar);
begin
  if (CurX + (CWidth * (Tab+1)) > MaxX) then NewLine;
  TextOut(PrintDc,CurX,CurY,data,strlen(Data));
  NewLine;
end;

Procedure TLinePrinter.NewPage;
begin
 setwindowtext(PrintAbortDlg^.Hwindow,'Spooling, please wait ...');
 Escape(PrintDC,NEWFRAME,0,nil,nil);
 setwindowtext(PrintAbortDlg^.Hwindow,'Printing');
 SelectObject(PrintDC,Font);
 CurX:=0; CurY:=0;
end;


end.
