{**********************************************************}
{*                                                        *}
{*  Unit to use PxEngine under Turbo-Pascal for Windows   *}
{*               Copyright 1992 Kurt Bertram              *}
{*		   Compuserve [100031,3373]               *}
{*                                                        *}
{*  If you need the same unit under Turbo-Pascal 6.0,     *)
{*  and Turbo-Vision I can upload it for you.             *}
{*                                                        *}
{*  I cannot promise that this unit will work in every    *}
{*  situation and I will not accept any liabilty etc      *}
{*  for ANY damage caused by using these routines.        *}
{*  Everyone is allowed to use this unit. If you discover *}
{*  bugs or make enhancements, I would be happy to know.  *}
{*                                                        *}
{**********************************************************}


{$N+}
Unit WinPdx;

interface

Uses WObjects;

const MAXFIELDS = 30;

type
  WordArray    = Array[1..Maxfields] of Word;

  PFieldArray = ^TFieldArray;
  TFieldArray = array[1..MaxFields] of PChar;

  { this unit can handle as many Tables as you want.   }
  { For each Table the tablestructure is registered in }
  { such record like this:                             }
  TableRec     = RECORD
                   TBLNAME     : Array[0..80] of Char;
                   TBLHandle   : WORD;
                   RECHandle   : WORD;
                   TableIsOpen : BOOLEAN;
    		   NumRecs     : LongInt;
    		   FieldNames  : PFieldArray;
    		   FieldTypes  : PFieldArray;
                   FieldLen    : ARRAY[1..MaxFields] OF INTEGER;
                   NFIELDS     : INTEGER;
                   CurRecord   : LongInt;
                 END;
  TabPtr       = ^TableRec;

  DatesArray = Array[1..MaxFields] of String;
  DatesPtr = ^DatesArray;

  { Objects like PClient handle the fields of a table. }
  { All fields are changed into PCHARs and are stored  }
  { in the FLD-Array.                                  }
  PClient = ^TClient;
  TClient = object(TObject)
    FieldCount: Byte;
    Index     : LongInt;
    Fld: Array[1..MAXFIELDS] of PChar;
    Constructor Init(NFlds: Byte; RecNum: Longint; NewDates: DatesPtr);
    Constructor Load(var S: TStream);
    Procedure Store(var S: TStream); virtual;
    Destructor Done; virtual;
  end;

  { For each Table a PMyCollection is initialized }
  { The structure is stored in Variable TableStru }
  { The commands are easy to understand, because  }
  { most of them are DBASE-like.                  }
  PMyCollection = ^TMyCollection;
  TMyCollection = object(TCollection)
    TableStruc: TabPtr;
    constructor Init(FileName:PChar);
    Procedure Translate_PClient_to_DatesPtr(DClient:PClient; DP:DatesPtr);
    Procedure FreeMemory; virtual;
    Procedure Go_Top;
    Procedure Get(RNum: LongInt; D:DatesPtr);
    Procedure Skip(NSkips: Integer; var Result: Boolean);
    Procedure Get_Records(Anz: Integer; StartNr: LongInt); virtual;
    Procedure Move_Records(StartNr: Longint; Anz: Integer);
    Procedure Search_Records(FeldName:PChar; SrchString:PChar);
    Procedure Append_Rec(Dat:DatesPtr);
    Procedure Edit_Rec(AltDat,Dat:DatesPtr);
    Procedure Delete_Rec(DClient: PClient);
    Procedure Zap;
    Destructor Done; virtual;
  end;

  { This unit makes OOP-Programming possible for PxEngine }
  { Only parts of the many PxEngine-commands are used.    }
  { But it is easy to add the other commands.             }
  PxBase = ^TxBase;
  TxBase = object(TObject)
    constructor Init(SWAPSIZE,TABLEHANDLES,MaxRecBufs,LOCKHANDLES,FILEHANDLES:Byte);
    Procedure Create(TableName: PChar; NFields: Byte; var Fields; var Types); virtual;
    Function Exist(TblName: PChar): Boolean;
    FUNCTION Error(RC : Integer) : Boolean; virtual;
    FUNCTION GetTableStructure(AktTabl: TabPtr): Boolean; virtual;
    Function NRecs(AktTab: TabPtr): longint; virtual;
    Function CountKeys(AktTab: TabPtr): Integer;
    function GetData(AktTabl: TabPtr; Fld: Integer; var G: String): Boolean;
    Function PutData(AktTabl: TabPtr; FH : Word; S : PChar) : Boolean; virtual;
    Function Search_one_Field(AktTab: TabPtr; Feld: PChar;
    			SrchString: PChar; Mode: Integer; DataRec:DatesPtr):Boolean; virtual;
    Function Search_one_Rec(AktTab: TabPtr; DataRec: DatesPtr; SuchFieldCount: Byte; Mode: Byte): Longint; virtual;
    Procedure TblDelete(TblName: PChar);
    Procedure Get(AktTab: TabPtr; Rec: Longint; DataRec: DatesPtr); virtual;
    Procedure Use(AktTab: TabPtr); virtual;
    Procedure First(AktTab: TabPtr); virtual;
    Procedure Skip(AktTabl: TabPtr; NSkips: Integer; Var Bottom: Boolean);
    Procedure EDIT(AktTab: TabPtr; NewRecord: DatesPtr);
    Procedure DELETE(AktTab:TabPtr; DataRec: DatesPtr);
    Procedure Zap(TblName: PChar);
    Procedure Close(AktTab: TabPtr); virtual;
    Procedure Copy_PxTable(SrcTblName,DestTblName: PChar);
    Procedure APPEND(AktTab: TabPtr; DataRec: DatesPtr);
    Procedure Index(tblName:PChar; nFlds: Integer; FldHandles:WordArray; mode: Integer);
    Procedure DropIndex(tblName: PChar; Mode: Integer);
    Procedure ErrIgnore(RC : Integer); virtual;
    destructor Done; virtual;
  end;

var DataBase       : PxBase;
    SampleDataColl : PMyCollection;

FUNCTION Space(Rn:Integer):String;
Procedure Stop_Programm;

implementation

{ Unit PxEngine is delivered with Turbo-Pascal for Windows }
{ and is under copyright of Borland. See OWLDEMOS, Borland }

uses PxEngine, WinTypes, WinProcs, Strings;

const
      MAXFIELDSIZE = 25; { if you need more fields, change PXENGINE-settings }
      SUCCESS = True;
      FAILURE = False;

var pxErr : Integer;

Procedure Stop_Programm;   { in later versions of this unit   }
var ctrl: integer;         { I will remove this procedure     }
                           { and add an own interrupt-routine }
begin
  ctrl:= Messagebox(GetActiveWindow,'Programm aborted',NIL,mb_IconInformation + mb_Ok);
  Application^.Done;
  Halt(1);
end;

FUNCTION Rept(RCh:Char; n:Integer):String;
VAR StrBuffer: String;
    I        : Byte;
BEGIN
  StrBuffer:= '';
  IF n > 0 THEN FOR I:= 1 TO n DO StrBuffer:= StrBuffer + RCh;
  Rept:= StrBuffer;
END;  (* Rept *)

FUNCTION Space(Rn:Integer):String;
BEGIN
  SPACE:= REPT(' ',Rn);
END; (* Space *)

Procedure Strip(VAR S : String);
VAR L1, L2 : Byte;
BEGIN
  L1:=1;
  WHILE ( L1 < Length(S) ) AND ( S[L1] IN [#9..#13, ' '] ) DO Inc(L1);
  L2:=Length(S);
  WHILE ( L2 > 0 ) AND ( S[L2] IN [#9..#13, ' '] ) DO Dec(L2);
  S:=Copy(S, L1, L2-L1+1);
END; (* Strip *)

{***********************************************************}
{*			TCLIENT				   *}
{***********************************************************}
Constructor TClient.Init (NFlds:Byte; RecNum: Longint; NewDates: DatesPtr);
var f: byte;
    z: array[0..255] of char;
begin
  FieldCount:= NFlds;			{ Every Record is stored into one PClient-object }
  Index:= RecNum;                       { where every field is defined as Fld[x]         }
  for f:= 1 to FieldCount do begin      { All kinds of data are transformed into PChars  }
    StrPCopy(z,NewDates^[f]);           { even numbers. (see txbase.getdata)             }
    Fld[f]:= StrNew(Z);
  end;
end;

Constructor TClient.Load(var S: TStream);  { not used in this example }
begin
  S.Read(FieldCount,Sizeof(FieldCount));
  S.Read(Index,Sizeof(Index));
  S.Read(Fld,Sizeof(Fld));
end;

Procedure TClient.Store(var S: TStream);   { not used in this example }
begin
  S.Write(FieldCount,Sizeof(FieldCount));
  S.Write(Index,Sizeof(Index));
  S.Write(Fld,Sizeof(Fld));
end;

Destructor TClient.Done;
var f: byte;
begin
  For f:= 1 to FieldCount do StrDispose(Fld[f]);
end;


{***********************************************************}
{*			TMYCOLLECTION			   *}
{***********************************************************}

Constructor TMyCollection.Init(FileName:PChar);
begin
  TCollection.Init(20,10);                { Normally, only those elements of a database }
  New(TableStruc);                        { are held in memory, that are actually shown }
  StrCopy(TableStruc^.TblName,FileName);  { in the listbox. I decided to do so, because }
  DataBase^.Use(TableStruc);              { the programmer never knows, how much memory }
end;					  { is available for the user of this program.  }

Procedure TMyCollection.Translate_PClient_to_DatesPtr(DClient:PClient; DP:DatesPtr);
var I : Integer;
begin
  if DClient <> NIL then begin
    for I:= 1 to TableStruc^.NFields do DP^[i]:= StrPas(DClient^.Fld[i]);
  end                { The problem of transferring data into a listbox is solved by  }
  else DP:= NIL;     { translating a PCLIENT's data into another Structure: DatesPtr }
end;		     { an array of strings - I love strings !                        }

Procedure TMyCollection.Go_Top;
begin
  DataBase^.First(TableStruc);   { You know DBase ? }
end;

Procedure TMyCollection.Get(RNum: Longint; D:DatesPtr);
begin
  DataBase^.Get(TableStruc,RNum,D);  { gets one record from the Database }
end;				     { identified by the Record-Number   }

Procedure TMyCollection.Skip(NSkips: Integer; var Result: Boolean);
var sz: integer;
    ok: boolean;
    dat: DatesPtr;
begin
  Ok:= True;
  DataBase^.Skip(TableStruc,NSkips,Ok); { You know DBase ? Returns true, if }
  Result:= ok;				{ not End of File                   }
end;

Procedure TMyCollection.FreeMemory;
begin
  if Count > 0 then begin	{ Not all Records are stored in memory at the }
    FreeAll;                    { same time. Only those, who are shown in the }
    Pack;                       { Listbox. For scrolling PageDown or PageUp,  }
  end;				{ the current records can be forgotten.       }
end;

Procedure TMyCollection.Append_Rec(Dat:DatesPtr);
begin
  if Dat <> NIL then begin
    DataBase^.Append(TableStruc,Dat);  { A new Record is inserted. Sorting is not necessary, if you have indexed the file }
    TableStruc^.NumRecs:= DataBase^.NRecs(TableStruc);
  end;
end;

Procedure TMyCollection.Edit_Rec(AltDat,Dat:DatesPtr);
var AktNum: LongInt;
    Control: Integer;
begin
  if Dat <> NIL then begin  { The old Record will be replaced by a new one }
    AktNum:= DataBase^.Search_one_Rec(TableStruc,AltDat,0,0);
    if AktNum > 0 then DataBase^.Edit(TableStruc,Dat)
    else Append_Rec(Dat);
    TableStruc^.NumRecs:= DataBase^.NRecs(TableStruc);
  end;
end;

Procedure TMyCollection.Search_Records(FeldName:PChar; SrchString:PChar);
var Data    : DatesPtr;		{ Procedure not used in this example       }
    RetValue: Boolean;          { You can update your listbox with Records }
begin                           { that are matching to some conditions.    }
  FreeMemory;
  new(Data);
  DataBase^.First(TableStruc);
  RetValue:= DataBase^.Search_one_Field(TableStruc,FeldName,SrchString,0,Data);
  While RetValue = true do begin
    Insert(New(PClient,Init(TableStruc^.NFields,TableStruc^.CurRecord,Data)));
    RetValue:= DataBase^.Search_one_Field(TableStruc,FeldName,SrchString,1,Data);
  end;
  dispose(Data);
end;

Procedure TMyCollection.Move_Records(StartNr: Longint; Anz: Integer);
var Data: DatesPtr;
    RetValue: Boolean;                  { If you scroll through your listbox using LINEDOWN or LINEUP-Keys }
    i        : Integer;                 { we cannot forget all current records. Only those are forgotten,  }
begin                                   { that are scrolled out of the listbox. These records are removed  }   
  New(Data);                            { from memory and are replaced by new ones - if there are any more }
  if Anz > 0 then begin
    for i:= 1 to Anz do AtFree(0);      { Scrolling forward }
    RetValue:= True;
    i:= 1;
    while (i <= anz) and (RetValue = true) and not(LowMemory) do begin
      Get(StartNr + i,Data);
      if Data <> NIL then Insert(New(PClient,Init(TableStruc^.NFields,TableStruc^.CurRecord,Data)));
      inc(i);
      Skip(1,RetValue);
    end;
  end
  else if Anz < 0 then begin            { Scrolling back }
    for i:= 1 to abs(Anz) do AtFree(Count-1);
    RetValue:= True;
    i:= 1;
    while (i <= abs(anz)) and (RetValue = true) and not(LowMemory) do begin
      Get(StartNr - i,Data);
      if Data <> NIL then AtInsert(0,New(PClient,Init(TableStruc^.NFields,TableStruc^.CurRecord,Data)));
      inc(i);
      Skip(-1,RetValue);
    end;
  end;
  Dispose(Data);
end;

Procedure TMyCollection.Get_Records(Anz: Integer; StartNr: LongInt);
var Data: DatesPtr;	   { If the listbox must completely be filled with new }
    i,f  : byte;           { records, you can use this procedure.              }
    Ctrl : Integer;        { If Anz is 0, all Records of the Table will be     }
    RetValue: boolean;     { stored in memory. Be careful ! Better ANZ should  }
    SuchDat  : DatesPtr;   { be 20, if your listbox can show 20 or less, if    }
    p:string; s:array[0..30] of char;  { your listbox can show less.           }
begin
  if Anz = 0 then begin
    Anz:= MaxCollectionSize;
    StartNr:= 0;
  end;
  if StartNr < 0 then StartNr:= 0;
  FreeMemory;
  i:= 1;
  RetValue:= true;
  New(Data);
  while (i < anz+1) and (RetValue = true) and not(LowMemory) do begin
    Get(StartNr + i,Data);
    if Data = NIL then messagebox(getactivewindow,'Data sind nil','',mb_ok)
    else Insert(New(PClient,Init(TableStruc^.NFields,TableStruc^.CurRecord,Data)));
    inc(i);
    Skip(1,RetValue);
  end;
  dispose(Data);
  If LowMemory then Ctrl:= MessageBox(GetActiveWindow,'No more Memory available !',nil,mb_IconInformation + mb_Ok);
end;

Procedure TMyCollection.Delete_Rec(DClient:PClient);
Var D: DatesPtr;
begin				{ The record will be deleted }
  New(D);
  Translate_PClient_to_DatesPtr(DClient,D);
  DataBase^.Delete(TableStruc,D);
  TableStruc^.NumRecs:= DataBase^.NRecs(TableStruc);
  Dispose(D);
end;

Procedure TMyCollection.Zap;
begin
  DataBase^.Close(TableStruc);           { All records will be erased out of }
  DataBase^.Zap(TableStruc^.TblName);    { your file. Be careful !           }
  DataBase^.Use(TableStruc);
  TableStruc^.NumRecs:= DataBase^.NRecs(TableStruc);
end;

Destructor TMyCollection.Done;
begin
  DataBase^.Close(TableStruc); { Should be called at the end of your Program }
  Dispose(TableStruc);
  TCollection.Done;
end;


{***********************************************************}
{*		    	  TXBASE 			   *}
{***********************************************************}

Constructor TxBase.Init(SWAPSIZE,TABLEHANDLES,MaxRecBufs,LOCKHANDLES,FILEHANDLES:Byte);
begin
{  if IPar.SortOrder = 0 then begin }   { Create a Profile, if you need other Options }
    if Error(PXSetDefaults(SWAPSIZE, TABLEHANDLES, MaxRecBufs,
                       LOCKHANDLES, FILEHANDLES, SORTORDERINT)) then Stop_Programm;
{  end
  else if IPar.SortOrder = 1 then begin
    if Error(PXSetDefaults(SWAPSIZE, TABLEHANDLES, MaxRecBufs,
                       LOCKHANDLES, FILEHANDLES, SORTORDERASCII)) then Stop_Programm;
  end
  else if IPar.SortOrder = 2 then begin
    if Error(PXSetDefaults(SWAPSIZE, TABLEHANDLES, MaxRecBufs,
                       LOCKHANDLES, FILEHANDLES, SORTORDERNORDAN)) then Stop_Programm;
  end
  else if IPar.SortOrder = 3 then begin
    if Error(PXSetDefaults(SWAPSIZE, TABLEHANDLES, MaxRecBufs,
                       LOCKHANDLES, FILEHANDLES, SORTORDERSWEDFIN)) then Stop_Programm;
  end
  else if Error(PXSetDefaults(SWAPSIZE, TABLEHANDLES, MaxRecBufs,
                       LOCKHANDLES, FILEHANDLES, SORTORDERINTL)) then Stop_Programm; }
  if Error(PXWinInit('PXDemo', PXSingleClient)) then Stop_Programm;
       { for NETINIT you must run the DOS-Program SHARE before, I do not need ... }
end;

FUNCTION TxBase.Error(RC : Integer) : Boolean;
var ctrl: integer;   { an own AbortProc would be better }
BEGIN
  IF RC <> PXSUCCESS THEN ctrl:= MessageBox(GetActiveWindow,PxErrMsg(RC),'PXBASE ERROR',mb_IconInformation + mb_Ok);
  Error:=RC<>PXSUCCESS;
END; (* Error *)

Function TxBase.Exist(Tblname: PChar): Boolean;
var Exists: Bool;
            { You can't read from a table, that doesn't exist, can you ? }
begin
  if Error(PXTblExist(TblName, Exists)) then Stop_Programm
  else Exist:= Exists;
end;

Procedure TxBase.TblDelete(TblName: PChar);
begin { Be careful ! Close table before deleting. You'll never see it again }
  if Error(PxTblDelete(TblName)) then Stop_Programm;
end;

Procedure TxBase.ErrIgnore(RC : Integer);
BEGIN 				
  IF Error(RC) THEN ;         { You know LOVE STORY ? ... Loving is .... }
END; (* ErrIgnore *)

Procedure TxBase.Skip(AktTabl: TabPtr; NSkips: Integer; var Bottom: Boolean);
var ix: longint;
    rc: integer;
begin
  RC:= PXSuccess;	   { No comment, only DBASE-Users know why }
  with AktTabl^ do begin
    if NSkips < 0 then begin
      if NSkips = -1 then RC:= PXRecPrev(TblHandle)
      else RC:= PxRecGoto(TblHandle,CurRecord+NSkips);
      Bottom:= (RC = PxSuccess);
    end
    else if NSkips > 0 then begin
      if NSkips = 1 then RC:= PxRecNext(TblHandle)
      else RC:= PxRecGoto(TblHandle,CurRecord+NSkips);
      Bottom:= (RC = PxSuccess);
    end
    else Bottom:= True;
    if RC = PxSuccess then CurRecord:= CurRecord + NSkips
    else RC:= PxRecGoto(TblHandle,CurRecord);
  end;
end;

FUNCTION TxBase.GetTableStructure(AktTabl: TabPtr) : Boolean;
VAR Temp: Array[0..30] of Char;    { Original copyright by Borland  }
    I   : Word;                    { See sample-program FONEDEX.PAS }
                                   { delivered with PXENGINE 1.0    }
       FUNCTION Compute_Length(FTyp:PChar):Integer; { Variable FldLength is filled by }
       VAR LEN  : Integer;                          { this function.                  }
           FT   : Char;
           Code : Integer;
           FTz  : String[4];
       BEGIN
         FT:= FTyp[0];
         CASE FT OF
           'A': begin
                  Ftz:= StrPas(FTyp);
                  Val(Copy(Ftz,2,Length(Ftz)-1), Len, Code);
                end;
           'D': Len := 12;
           'N': Len := 14;
           '$': Len := 14;
           'S': Len := 8;
         END; (* CASE FType *)
         Compute_Length:= Len;
       END; (* Compute_Length *)

BEGIN
  with AktTabl^ do begin
    FieldTypes := nil;
    FieldNames := nil;
    CurRecord := -1;
    NFields:= 0;
    if not(Error(PXRecNFlds(tblHandle, NFields))) and
       not(Error(PXTblNRecs(tblHandle, NumRecs))) then begin
        GetMem(FieldTypes, NFields * SizeOf(PChar));
        GetMem(FieldNames, NFields * SizeOf(PChar));
      for I := 1 to NFields do begin
        if not(Error(PXFldName(TblHandle, I, SizeOf(Temp), Temp))) then FieldNames^[I]:= StrNew(Temp);
        if not(Error(PXFldType(TblHandle, I, SizeOf(Temp), Temp))) then FieldTypes^[I]:= StrNew(Temp);
        FieldLen[I]:= Compute_Length(FieldTypes^[i]);
      END;
    end
    ELSE BEGIN
      GetTableStructure:=FAILURE;
      Exit;
    end;
    GetTableStructure:=SUCCESS;
  END;
END; (* GetTableStructure *)

FUNCTION TxBase.PutData(AktTabl: TabPtr; FH : Word; S : PChar) : Boolean;
VAR				 { Original Copyright by Borland                }
    TheDate          : LongInt;  { See FONEDEX.PAS, delivered with PXENGINE 1.0 }
    Month, Day, Year : Integer;
    TheValue         : Double;
    TheShort         : Integer;
    Code             : Integer;
    Sp		     : String;

    FUNCTION GetNextWVal(VAR xS : String):Word;
    CONST DELIM = '.';
    VAR   L    : Byte;     { Original Copyright by Borland, see FONEDEX }
          Help : Word;
          Code : Integer;
    BEGIN
      L:=Pos(DELIM, xS);
      IF L = 0
      THEN L:=Length(xS)+1;
      Val(Copy(xS, 1, L-1), Help, Code);
      xS:=Copy(xS, L+1, Length(xS));
      IF Code = 0
      THEN GetNextWVal:=Help
      ELSE GetNextWVal:=0;
    END; (* GetNextWVal *)

BEGIN
  WITH AktTabl^ DO BEGIN
    PutData:=SUCCESS;
    CASE UpCase(FieldTypes^[FH][0] ) OF
      'A': IF Error( PXPutAlpha(RecHandle,FH,S) )
           THEN PutData:=FAILURE;
      'D': BEGIN
           Sp:= StrPas(S);
           Day   := GetNextWVal(Sp);
           Month := GetNextWVal(Sp);
           Year  := GetNextWVal(Sp);
           IF PXDateEncode(Month, Day, Year, TheDate) = PxSuccess then
              if Error( PXPutDate(RecHandle, FH, TheDate) ) THEN PutData:=FAILURE;
          END;
      '$',
      'N': BEGIN
           Sp:= StrPas(S);
           Strip(Sp);
           Val(Sp, TheValue, Code);
           IF Error( PXPutDoub(RecHandle, FH, TheValue) )
           THEN PutData:=FAILURE;
           END;
      'S': BEGIN
           Val(S, TheShort, Code);
           IF Error( PXPutShort(RecHandle, FH, TheShort) )
           THEN PutData:=FAILURE;
           END;
    END; (* CASE *)
  END;
END; (* PutData *)

function TxBase.GetData(AktTabl: TabPtr; Fld: Integer;var G: String): Boolean;
var
  Tmp: array[0..255] of Char;		{ Original Copyright by Borland }
  N: Double;                            { See FONEDEX.PAS               }
  I: Integer;
  L: LongInt;
  ArgList: array[0..2] of Integer;
begin
  with AktTabl^ do begin
    GetData:= Success;
    G := '';
    if (Fld < 1) or (Fld > NFields) then Exit;
    Tmp[0] := #0;
    case FieldTypes^[Fld][0] of
      'A':
	if Error(PXGetAlpha(RecHandle, Fld, SizeOf(Tmp), Tmp)) then GetData:= Failure;
      'N':
	begin
	  if Error(PXGetDoub(RecHandle, Fld, N)) then GetData:= Failure;
	  if not IsBlankDouble(N) then Str(N:12:4, Tmp);
	end;
      '$':
	begin
	  if Error(PXGetDoub(RecHandle, Fld, N)) then GetData:= Failure;
	  if not IsBlankDouble(N) then Str(N:12:2, Tmp);
	end;
      'S':
	begin
	  if Error(PXGetShort(RecHandle, Fld, I)) then GetData:= Failure;
	  if not IsBlankShort(i) then Str(I:6, Tmp)
	end;
      'D':
	begin
	  if Error(PXGetDate(RecHandle, Fld, L)) then GetData:= Failure;
	  if Not IsBlankDate(L) then begin
	    ErrIgnore(PXDateDecode(L, ArgList[1], ArgList[0], ArgList[2]));
	    wvSprintf(Tmp, '%2d.%2d.%4d', ArgList);
	  end;
	end;
    end;
  end;
  if strlen(tmp) < 1 then strcat(tmp,' ');
  G:= StrPas(Tmp);
end;

Function TxBase.CountKeys(AktTab: TabPtr): Integer;
var NKeyFlds: Integer;
begin
  if Error(PxKeyNFlds(AktTab^.TblHandle,NKeyFlds)) then Stop_Programm;
  CountKeys:= NKeyFlds;
end;

Function TxBase.Search_one_Rec(AktTab: TabPtr; DataRec: DatesPtr; SuchFieldCount: Byte; Mode: Byte): LongInt;
var B_Found    : Boolean;       { If your table is indexed, you can quickly search Records   }
    FieldNumber: Integer;       { with this function. A new GET is not necessary, the Record }
    NKeyFlds   : Integer;       { will be returned by DATAREC-Variable.                      }
    Control    : Integer;
    RecNumber  : LongInt;
    d	       : Array[0..255] of Char;
begin
  B_Found:= False;
  with AktTab^ do begin
    if Error(PxKeyNFlds(TblHandle,NKeyFlds)) then Stop_Programm;
    if SuchFieldCount = 0 then SuchFieldCount:= NKeyFlds;
    for Fieldnumber:= 1 to SuchFieldCount do begin
      StrPCopy(D,DataRec^[Fieldnumber]);
      IF PutData(AktTab,Fieldnumber,D) <> SUCCESS THEN BEGIN
        control:= Messagebox(GetActiveWindow,'Search Error','Paradox-Error',mb_IconInformation + Mb_Ok);
        Stop_Programm;
      END;
    end;
    if Mode = 0 then PxErr:= PxSrchKey(TblHandle,RecHandle,SuchFieldCount,SearchFirst)
    else if Mode = 1 then PxErr:= PxSrchKey(TblHandle,RecHandle,SuchFieldCount,SearchNext)
    else if Mode = 2 then PxErr:= PxSrchKey(TblHandle,RecHandle,SuchFieldCount,ClosestRecord);
    if PxErr <> PxSuccess then begin
      if pxerr <> pxerr_recnotfound then
      control:= Messagebox(GetActiveWindow,pxErrmsg(pxerr),'Paradox-Error',mb_IconInformation + MB_Ok)
      else if Mode = 2 then B_Found:= true else B_Found:= false;
    end
    else B_Found:= true;
    if B_Found then begin
      if Error(PxRecNum(TblHandle,RecNumber)) then CurRecord:= 0 else CurRecord:= RecNumber;
    end
    else CurRecord:= 0;
  end;
  Search_one_Rec:= AktTab^.CurRecord;
end;

Function TxBase.Search_one_Field(AktTab: TabPtr; Feld: PChar;
			    SrchString: PChar; Mode: Integer; DataRec:DatesPtr):Boolean;
VAR FldHandle: Word;              (* Mode = 0   -------> SearchFirst   *)
    B_Found  : Boolean;           (* Mode = 1   -------> SearchNext    *)
    control  : Integer;           (* Mode = 2   -------> ClosestRecord *)
    iX       : Integer;
    RecNumber: Longint;   { You can find a Record, identified by one Field 	     }
BEGIN                     { You must know the Fieldname and the String to search for }
  B_Found:= false;
  with AktTab^ do begin
    if not(Error(pxRecBufEmpty(rechandle))) then begin
      if not(Error(pxFldHandle(tblHandle,Feld ,fldhandle))) then begin
        if not(Error(pxPutAlpha(rechandle,fldhandle,SrchString))) then begin
          if Mode = 0 then pxErr:= pxsrchfld(tblhandle,rechandle,fldHandle,searchfirst)
          else if Mode = 1 then pxErr:= pxsrchfld(tblhandle,rechandle,fldHandle,searchnext)
          else if Mode = 2 then pxErr:= pxsrchFld(TblHandle,RecHandle,FldHandle,ClosestRecord);
          if pxerr <> pxsuccess then begin
            if pxerr <> pxerr_recnotfound then
            control:= Messagebox(GetActiveWindow,pxErrmsg(pxerr),'Paradox-Error',mb_IconInformation + mb_Ok)
            else begin
              B_Found:= false;
              if Mode = 2 then begin
                if not(Error(PXRecGet(TblHandle, RecHandle))) then begin
                  if not(Error(pxRecNFlds(Tblhandle,NFields))) then begin
                    FOR Ix:=1 TO NFields DO BEGIN
                      if GetData(AktTab,Ix,DataRec^[ix]) <> Success then begin
                        Search_one_Field:= False;
                        Exit;
                      END;
                    end;
                    B_Found:= True;
                  end;
                end;
              end;
            end;
          end
          else begin
            if not(Error(PXRecGet(TblHandle, RecHandle))) then begin
              if not(Error(pxRecNFlds(Tblhandle,NFields))) then begin
                FOR Ix:=1 TO NFields DO BEGIN
                  if GetData(AktTab,Ix,DataRec^[ix]) <> Success then begin
                    Search_one_Field:= False;
                    Exit;
                  end;
                END;
                B_Found:= True;
              end;
            end;
          end;
        end;
      end;
    end;
    if B_Found then begin
      if Error(PxRecNum(TblHandle,RecNumber)) then CurRecord:= 0 else CurRecord:= RecNumber;
    end
    else CurRecord:= 0;
  end;
  Search_one_Field:= B_Found;
end;

Procedure TxBase.DELETE(AktTab:TabPtr; DataRec: DatesPtr);
var B_Found    : Boolean;
    FieldNumber: Integer;
    NKeyFlds   : Integer;
    Control    : Integer;
    SNr        : LongInt;
    RecNumber  : LongInt;
    D          : Array[0..255] of Char;
begin
  B_Found:= False;
  with AktTab^ do begin
    if Error(PxKeyNFlds(TblHandle,NKeyFlds)) then Stop_Programm;
    for Fieldnumber:= 1 to NFields do begin
      StrPCopy(D,DataRec^[FieldNumber]);
      IF PutData(AktTab,Fieldnumber,D) <> SUCCESS THEN BEGIN
        control:= Messagebox(GetActiveWindow,'Find error','Paradox-Error',mb_IconInformation + mb_Ok);
        Stop_Programm;
      END;
    end;
    PxErr:= PxSrchKey(TblHandle,RecHandle,NKeyFlds,SearchFirst);
    if PxErr <> PxSuccess then begin
      if pxerr <> pxerr_recnotfound then
      control:= Messagebox(GetActiveWindow,pxErrmsg(pxerr),'Paradox-Error',mb_IconInformation + Mb_Ok)
      else B_Found:= false;
    end
    else B_Found:= true;
    if B_Found then begin
      if Error(PxRecNum(TblHandle,RecNumber)) then CurRecord:= 0 else CurRecord:= RecNumber;
      if Error(PXRecDelete(TblHandle)) then Stop_Programm;
    end
    else CurRecord:= 0;
  end;
END;

Procedure TxBase.Zap(TblName:PChar);
begin
  ErrIgnore(PxTblEmpty(TblName));  { First close the Table, then erase it. }
end;				   { Why did you fill it before ?          }

Procedure TxBase.EDIT(AktTab: TabPtr; NewRecord: DatesPtr);
var FieldNumber: byte;      			 { See PXEDITOR.PAS }
    Control    : Integer;
    D	       : Array[0..255] of Char;
    RecNumber  : Longint;
BEGIN
  WITH AktTab^ DO BEGIN
    IF Error( PXRecBufEmpty(RecHandle)) THEN Exit;
    for Fieldnumber:= 1 to NFields do begin
      StrPCopy(D,NewRecord^[FieldNumber]);
      IF PutData(AktTab,Fieldnumber,D) <> SUCCESS THEN BEGIN
        control:= Messagebox(GetActiveWindow,'Save error','Paradox-Error',mb_IconStop + mb_Ok);
        Stop_Programm;
      END;
    end;
    IF Error(PXRecUpdate(TblHandle, RecHandle)) then Stop_Programm;
    if Error(PxRecNum(TblHandle,RecNumber)) then CurRecord:= 0 else CurRecord:= RecNumber;
  END;
END;

Procedure TxBase.APPEND(AktTab: TabPtr; DataRec: DatesPtr);
var i: integer;				{ See PXEDITOR.PAS }
    control: Integer;
    D      : Array[0..255] of Char;
    RecNumber: Longint;
BEGIN
  WITH AktTab^ DO BEGIN
    IF Error( PXRecBufEmpty(RecHandle)) THEN Exit;
    for i:= 1 to NFields do begin
      StrPCopy(D,DataRec^[i]);
      if putdata(AktTab,i,D) <> Success then begin
        Messagebox(GetActiveWindow,'Save Error','Paradox-Error',mb_IconInformation + mb_Ok);
        Stop_Programm;
      end;
    end;
    ErrIgnore( PXRecAppend(TblHandle, RecHandle) );
    if Error(PxRecNum(TblHandle,RecNumber)) then CurRecord:= 0 else CurRecord:= RecNumber;
  END;
END;

Procedure TxBase.Get(AktTab: TabPtr; Rec: Longint; DataRec: DatesPtr);
VAR Ix  :Byte;			{ if you know the number of the record, you can get it }
begin                           { otherwise use Searchfield or SearchRec.              }
  with AktTab^ do begin
    if CurRecord <> Rec then begin
      if Error(PxRecGoto(TblHandle,Rec)) then Stop_Programm;
    end;
    CurRecord:= Rec;
    if Not(Error(PXRecGet(TblHandle, RecHandle))) then begin
      FOR Ix:=1 TO NFields DO BEGIN
        if GetData(AktTab,Ix,DataRec^[ix]) <> Success then Exit;
      END;
    end
    else DataRec:= Nil;
  end;
end;

Procedure TxBase.First(AktTab: TabPtr);
begin
  if Error(PxRecFirst(AktTab^.TblHandle)) then Exit;
  AktTab^.CurRecord:= 1;
end;

Function TxBase.NRecs(AktTab: TabPtr): longint;
var x: LongInt;
begin
  if Error(PxTblNRecs(AktTab^.TblHandle,x)) then Exit;
  NRecs:= x;
end;

Procedure TxBase.Index(tblName:PChar; nFlds: Integer; FldHandles:WordArray; mode: Integer);
var FHandles: WordArray;     { Indexes Sample: FldHandles[1]:= 1; FldHandles[2]:= 2; NFlds:= 2 }
    F       : Byte;          { Close Table, before indexing                                    }
begin
  pxErr:= PxKeyDrop(TblName,Mode);
  for f:= 1 to NFlds do FHandles[f]:= FldHandles[f];
  ErrIgnore(PxKeyAdd(TblName,nFlds,FHandles,Mode));
end;

Procedure TxBase.DropIndex(tblName: PChar; Mode: Integer);
begin
  ErrIgnore(PxKeyDrop(TblName,Mode));
end;

Procedure TxBase.Copy_PxTable(SrcTblName,DestTblName: PChar);
begin
  if Error(PxTblCopy(SrcTblName,DestTblName)) then Stop_Programm;
end;

Procedure TxBase.Create(TableName: PChar; NFields: Byte; var Fields; var Types);
begin  { First define TableName,NFields,Fields as array of Char, Types as array of PChar }
  if Error(PXTblCreate(TableName, NFields, Fields, Types)) then Stop_Programm;
end;

Procedure TxBase.Use(AktTab: TabPtr);
begin
  with Akttab^ do begin
    if Error(PxTblOpen(TblName,TblHandle,0,False)) then Stop_Programm
    else begin
      if GetTableStructure(AktTab) <> Success then Stop_Programm
      else if Error(PxRecBufOpen(tblHandle,recHandle)) then Stop_Programm;
    end;
  end;
end;

Procedure TxBase.Close(AktTab: TabPtr);
begin
  with Akttab^ do begin
    ErrIgnore(PxRecBufClose(recHandle));
    ErrIgnore(PxTblClose(tblHandle));
  end;
end;

Destructor TxBase.Done;
begin
  if Error(PXExit) THEN Stop_Programm;
end;

{ Room enough for enhancements    }
{ I would be happy to be notified }

end.
