{************************************************************}
{*                                                          *}
{*  Program using PxEngine with Turbo-Pascal for Windows    *}
{*               Copyright 1992 Kurt Bertram                *}
{*		   Compuserve [100031,3373]                 *}
{*                                                          *}
{*  This program uses PXENGINE to show a list of adresses   *)
{*  You can edit, delete all fields.                        *}
{*  You can print labels for mail.                          *}
{*  You can print lists of all or of selected parts of      *}
{*  the table.                                              *}
{*  You can change printer options and select printerfonts. *}
{*                                                          *}
{*  I cannot promise, that this program will work in any    *}
{*  situation and I will not accept any liabilty etc        *}
{*  for ANY damage caused by using these routines.          *}
{*                                                          *}
{*  Everyone is allowed to use this program. If you         *}
{*  discover bugs or make enhancements, I would be happy    *}
{*  to know.  						    *}
{*                                                          *}
{************************************************************}

program PXLABELPRINTER;

{$R PXLPRT.RES}

uses WinTypes,{ Windows-Stuff }
     WinProcs,
     WObjects,
     Strings,
     BwCc,    { See Resource-Workshop }
     StdDlgs,
     WinPdx,  { Unit to OOP-use PXENGINE }
     WinPrt,  { Printing with TPW, Copyright Paul Bayliss }
     PXEdit,  { Unit to Edit Records }
     MyInpt;  { Unit to Check Inputs of the Editor }

const
  DlgDLLName  = 'BWCC.DLL';
  em_DLLNotFound = 1;

  cm_FileOpen     = 101;
  cm_FileClose	  = 102;
  cm_RecordEdit	  = 201;
  cm_RecordDel	  = 202;
  cm_RecordNew	  = 203;
  cm_PrintList    = 301;
  cm_PrintLabel	  = 302;
  cm_PrinterSel   = 401;
  cm_PrinterFonts = 402;

  id_Lb1	  = 101;

type
  PListWindow = ^TListWindow;
  TListWindow = object(TWindow)
    FileName	: array[0..128] of Char;
    Lb1		: PListbox;
    LbTransfer 	: Record
    	            Daten: PStrCollection;
                    Selections: PMultiselRec;
                 end;
    StrTyp	: Byte;
    Constructor Init(AParent: PWindowsObject; ATitle: PChar);
    Procedure SetupWindow; virtual;
    procedure GetWindowClass(var WndClass: TWndClass); virtual;
    Function Update_Listbox(idx: Integer): Integer;
    Function PrinterOptions(var A: Boolean): Integer;
    Procedure cmFileOpen(var Msg: TMessage); virtual cm_First + cm_FileOpen;
    Procedure cmFileClose(var Msg: TMessage); virtual cm_First + cm_FileClose;
    Procedure cmRecordEdit(var Msg: TMessage); virtual cm_First + cm_RecordEdit;
    Procedure cmRecordDel(var Msg: TMessage); virtual cm_First + cm_RecordDel;
    Procedure cmRecordNew(var Msg: TMessage); virtual cm_First + cm_RecordNew;
    Procedure cmPrintList(var Msg: TMessage); virtual cm_First + cm_PrintList;
    Procedure cmPrintLabel(var Msg: TMessage); virtual cm_First + cm_PrintLabel;
    Procedure cmPrinterSel(var Msg: TMessage); virtual cm_First + cm_PrinterSel;
    Procedure cmPrinterFonts(var Msg: TMessage); virtual cm_First + cm_PrinterFonts;
    Destructor Done; virtual;
  end;

  TDlgApplication = object(TApplication)
    DlgLib : THandle;
    BttnLib: THandle;
    constructor Init(AName: PChar);
    destructor Done; virtual;
    procedure Error(ErrorCode: Integer); virtual;
    procedure InitMainWindow; virtual;
  end;

constructor TListWindow.Init(AParent: PWindowsObject; ATitle: PChar);
begin
  TWindow.Init(AParent, ATitle);
  Attr.X := 0;
  Attr.Y := 0;
  Attr.Menu := LoadMenu(Hinstance, 'PXPMENUE');
  DataBase:= New(PxBase,Init(32,10,10,10,10));   { see WinPdox.pas }
  SampleDataColl:= NIL;
  Lb1:= New(PListbox,Init(@Self,id_Lb1,10,20,610,300));
  Lb1^.Attr.Style:= lb1^.attr.style or lbs_usetabstops or lbs_multiplesel;
  LbTransfer.Daten:= New(PStrCollection,Init(30,10));
  StrTyp:= 0;
end;

Destructor TListWindow.Done;
begin
  if SampleDataColl <> NIL then begin
    FreeMultisel(LBTransfer.Selections);
    LbTransfer.daten^.FreeAll;
    Dispose(SampleDataColl,Done);
  end;
  Dispose(DataBase,Done);
  TWindow.Done;
end;

Procedure TListWindow.SetupWindow;
var i: byte;
    DC: HDC;
    L : Integer;
    K: LongInt;
    A: ARRAY[0..40] OF Char;
    Pts: ARRAY[0..3] OF Char;
begin
  TWindow.SetupWindow;
  Init_PrinterFonts;
end;

procedure TListWindow.GetWindowClass(var WndClass: TWndClass);
begin
  TWindow.GetWindowClass(WndClass);
  WndClass.hIcon := LoadIcon(HInstance, 'PxLPrt');
end;

Function TListWindow.Update_Listbox(idx: Integer): Integer;
var
  Temp: array[0..255] of Char;
  f,i,j,t1 : Integer;
  TmpClient: PClient;
  Tablist: array[1..Maxfields] of Integer;
  ZWidth: Word;
  Rect   : TRect;
begin
  FreeMultiSel(LbTransfer.Selections);
  SampleDataColl^.Get_Records(0,0);
  LbTransfer.Selections:= AllocMultisel(SampleDataColl^.Count);
  If SampleDataColl^.Count > 0 then begin
    with SampleDataColl^.TableStruc^ do begin
      ZWidth:= LoWord(GetDialogBaseUnits);
      f:= 0; T1:= 0;
      repeat
        inc(f);
        Tablist[f]:= T1 + Round((ZWidth * (FieldLen[f] + 1.5))/2);
        T1:= Tablist[f];
      until (f = NFields);
      SendMessage(Lb1^.HWindow,wm_SetRedraw,0,0);
      Lb1^.Clearlist;
      LbTransfer.Daten^.FreeAll;
      SendMessage(lb1^.HWindow,lb_SetTabStops,NFields-1,longint(@Tablist));
      for i:= 1 to SampleDataColl^.Count do begin
        TmpClient:= SampleDataColl^.At(i-1);
        j:= 1;
        StrCopy(Temp,TmpClient^.Fld[j]);
        While (J < NFields) do begin
          inc(j);
          StrCat(Temp,#9);
          StrCat(Temp,TmpClient^.Fld[j]);
        end;
        LBTransfer.Daten^.Insert(StrNew(Temp));
      end;
    end;
    if idx < 0 then idx:= 0;
    if idx > SampleDataColl^.Count then idx:= SampleDataColl^.count;
    LbTransfer.Selections^.Selections[0]:= idx;
    LbTransfer.Selections^.Count:= 1;
    Lb1^.Transfer(@LbTransfer,tf_SetData);
    Lb1^.SetSelIndex(idx);
    SendMessage(Lb1^.HWindow,wm_SetRedraw,1,0);
    GetClientRect(lb1^.Hwindow,Rect);
    InvalidateREct(lb1^.Hwindow,@Rect,False);
    SetFocus(lb1^.Hwindow);
    StrTyp:= 1;
  end
  else begin
    StrTyp:= 0;
    Lb1^.Clearlist;
    GetClientRect(lb1^.Hwindow,Rect);
    InvalidateRect(lb1^.Hwindow,@Rect,False);
  end;
  Update_Listbox:= StrTyp;
end;

Procedure TListWindow.cmFileOpen(var Msg: TMessage);
var
  FileType: Integer;
  FopenDlg: PFileDialog;
begin
  FOpenDlg:= New(PFileDialog,Init(@Self, PChar(sd_FileOpen), StrCopy(FileName,'*.db')));
  if Application^.ExecDialog(FOpenDlg) = id_OK then
  begin
    if SampleDataColl <> NIL then Dispose(SampleDataColl,Done);
    SampleDataColl:= New(PMyCollection,Init(FileName));
    LbTransfer.Selections:= AllocMultiSel(SampleDataColl^.TableStruc^.NumRecs);
    StrTyp:= 1;
    if SampleDataColl <> NIL then Update_Listbox(0)
    else strtyp:= 0;
  end;
  DefWndProc(Msg);
end;

Procedure TListWindow.cmFileClose(var Msg: TMessage);
var Rect: TRect;
begin
  if SampleDataColl <> NIL then begin
    Dispose(SampleDataColl,Done);
    SampleDataColl:= NIL;
    FreeMultiSel(LbTransfer.Selections);
    Lb1^.ClearList;
    GetClientRect(lb1^.Hwindow,Rect);
    InvalidateREct(lb1^.Hwindow,@Rect,False);
  end;
  StrTyp:= 0;
end;

Procedure TListWindow.cmRecordEdit(var Msg: TMessage);
var Edit3Dlg : PEdit3Dialog;
    RetValue : Integer;
    idx: integer;
    tr3rec: TEdit3Transferrecord;
begin
  if StrTyp = 0 then BWCCMessagebox(GetActiveWindow,'No Editor available','Edit',mb_ok+mb_IconStop)
  else begin
    Lb1^.Transfer(@lbTransfer,tf_GetData);
    if lbTransfer.Selections = NIL then BWCCMessagebox(0,'No record selected','Edit',mb_ok)
    else begin
      if lbTransfer.Selections^.Count <> 1 then BWCCMessagebox(0,'More than one record selected','Edit',mb_ok)
      else begin
        idx:= Lb1^.GetSelIndex;
        if idx < 0 then BWCCMessagebox(GetActiveWindow,'No record selected','Edit',mb_ok + mb_IconStop)
        else begin
          Edit3Dlg:= New(PEdit3Dialog,Init(@Self,'Editor',False));
          Edit3Dlg^.Translate_PClient_to_TransferRec(SampleDataColl^.At(idx),Tr3rec);
          Edit3Dlg^.TransferBuffer:= @Tr3Rec;
          RetValue:= Application^.ExecDialog(Edit3Dlg);
          UpDate_Listbox(idx);
        end;
      end;
    end;
  end;
  DefWndProc(Msg);
end;

Procedure TListWindow.cmRecordDel(var Msg: TMessage);
var Ctrl,idx,i: Integer;
    p : PClient;
    ix: string; pi: array[0..20] of char;
begin
  if (StrTyp = 0) or (SampleDataColl = NIL) or (SampleDataColl^.Count < 1) then
    BWCCMessagebox(GetActiveWindow,'No Data available','Delete',mb_ok+mb_IconStop)
  else begin
    Ctrl:= BwCCMessagebox(GetActiveWindow,'     Delete data ?'+#13
  			    +#13+'     Please confirm'
  			    +#13+'       or abort !','Confirm'
  			    ,mb_okCancel + mb_iconQuestion);
    if Ctrl = id_ok then begin
      Lb1^.Transfer(@Lbtransfer,tf_getData);
      if lbTransfer.Selections = NIL then BWCCMessagebox(0,'No record selected','Delete',mb_ok)
      else begin
        if lbTransfer.Selections^.Count < 1 then BWCCMessagebox(0,'No record selected','Delete',mb_ok)
        else begin
          idx:= Lb1^.GetSelIndex;
          For i:= 0 to lbTransfer.Selections^.Count-1 do begin
            P:= SampleDataColl^.At(lbTransfer.Selections^.Selections[i]);
            SampleDataColl^.Delete_Rec(P);
          end;
          Update_Listbox(idx);
        end;
      end;
    end;
  end;
  Msg.Result:= 1;
end;

Procedure TListWindow.cmRecordNew(var Msg: TMessage);
var Edit3Dlg	: PEdit3Dialog;
    RetValue   : Integer;
    idx: integer;
    tr3rec: TEdit3Transferrecord;
begin
  if StrTyp = 0 then BWCCMessagebox(GetActiveWindow,'No Editor available','Edit',mb_ok+mb_IconStop)
  else begin
    Edit3Dlg:= New(PEdit3Dialog,Init(@Self,'Editor',True));
    Edit3Dlg^.Translate_PClient_to_TransferRec(NIL,Tr3rec);
    Edit3Dlg^.TransferBuffer:= @Tr3Rec;
    RetValue:= Application^.ExecDialog(Edit3Dlg);
    UpDate_Listbox(0);
  end;
  DefWndProc(Msg);
end;

Function TListWindow.PrinterOptions(var A: Boolean): Integer;
var r1: PRadioButton;
    E1: PNumEdit;
    PrtDlg: PDialog;
    RetValue: Integer;
    Numbers : Integer;
    PrtTransfer : record
                    All  : Bool;
                    Mark : Bool;
                    Nbrs : Longint;
                  end;
begin
  Numbers:= 0;
  PrtDlg:= New(PDialog,Init(@Self,'PrintDlg'));
  R1:= New(PRadiobutton,InitResource(PrtDlg,101));
  R1:= New(PRadioButton,InitResource(PrtDlg,102));
  E1:= New(PNumEdit,InitResource(PrtDlg,104,3,0,999));
  PrtTransfer.All:= True;
  PrtTransfer.Mark:= False;
  PrtTransfer.Nbrs:= 1;
  PrtDlg^.TransferBuffer:= @PrtTransfer;
  RetValue:= Application^.ExecDialog(PrtDlg);
  if RetValue = id_ok then begin
    Numbers:= PrtTransfer.Nbrs;
    A:= PrtTransfer.All;
  end;
  PrinterOptions:= Numbers;
end;

Procedure TListWindow.cmPrintList(var Msg: TMessage);
var All: Boolean;
    a,RetValue,NCount: Integer;
    Printer: PLinePrinter;
    PageMetrics: Record
    	   	   PLen: Integer;
                   PWidth: Integer;
                 end;
    Notetext: array[0..40] of char;
    Note    : array[0..100] of char;
    x       : Longint;
    f	    : Byte;
    K	    : PClient;
begin
  if StrTyp = 0 then BWCCMessagebox(GetActiveWindow,'No File opened','Print',mb_ok+mb_IconStop)
  else begin
    All:= true;
    NCount:= PrinterOptions(All);
    if NCount > 0 then begin
      Printer:= New(PLinePrinter,Init(UsedFont,'PXPLIST'));
      PageMetrics.PLen:= GetDeviceCaps(PrintDC,VertSize);
      PageMetrics.PWidth:= GetDeviceCaps(PrintDC,HorzSize);
      WVSPrintf(Notetext,'Length: %d    Width: %d',PageMetrics);
      if PageMetrics.PLen < 100 then begin
        StrCopy(Note,'Page too small ! Change Printer Options !'#13);
        StrCat(Note,#13);
        strCat(Note,Notetext);
        RetValue:= BWCCMessagebox(GetFocus,Note,'Printer',mb_okCancel);
      end
      else RetValue:= id_ok;
      if RetValue = id_ok then begin
        if All then begin
          for a:= 1 to NCount do begin
            for x:= 0 to SampleDataColl^.Count-1 do begin
              K:= SampleDataColl^.At(x);
              For f:= 1 to SampleDataColl^.TableStruc^.NFields do begin
                Printer^.TabWrite(SampleDataColl^.TableStruc^.FieldLen[f],K^.Fld[f]);
              end;
              Printer^.NewLine; Printer^.NewLine;
            end;
            Printer^.NewPage;
          end;
        end
        else begin
          Lb1^.Transfer(@LbTransfer,tf_GetData);
          if LbTransfer.Selections = Nil then BWCCMessagebox(GetFocus,'Keine Daten ausgewhlt','Print',mb_ok)
          else begin
            if lbTransfer.Selections^.Count < 1 then BWCCMessagebox(GetFocus,'Keine Daten ausgewhlt','Print',mb_ok)
            else for a:= 1 to NCount do begin
              For x:= 0 to lbTransfer.Selections^.Count-1 do begin
                K:= SampleDataColl^.At(lbTransfer.Selections^.Selections[x]);
                For f:= 1 to SampleDataColl^.TableStruc^.NFields do begin
                  Printer^.TabWrite(SampleDataColl^.TableStruc^.FieldLen[f],K^.Fld[f]);
                end;
                Printer^.NewLine; Printer^.NewLine;
              end;
              Printer^.NewPage;
            end;
          end;
        end;
      end;
      Printer^.NewPage;
      Dispose(Printer,Done);
    end;
  end;
  DefWndProc(Msg);
end;

Procedure TListWindow.cmPrintLabel(var Msg: TMessage);
var All: Boolean;
    a,RetValue,NCount: Integer;
    Printer: PLinePrinter;
    PageMetrics: Record
    	   	   PLen: Integer;
                   PWidth: Integer;
                 end;
    Notetxt: array[0..40] of char;
    Note   : array[0..100] of char;
    x      : Longint;
    f	   : Byte;
    K	   : PClient;

    Procedure EtikPrint(Cl: PClient);
    begin
      Printer^.Writeln(Cl^.Fld[3]);
      Printer^.Write  (Cl^.Fld[2]);
      Printer^.Write  (' ');
      Printer^.Writeln(Cl^.Fld[1]);
      Printer^.Writeln(Cl^.Fld[4]);
      Printer^.Writeln(' ');
      Printer^.Write  (Cl^.Fld[5]);
      Printer^.Write  (' ');
      Printer^.Writeln(Cl^.Fld[6]);
      Printer^.NewPage;
    end;

begin
  if StrTyp = 0 then BWCCMessagebox(GetActiveWindow,'No file opened','Print',mb_ok+mb_IconStop)
  else begin
    All:= true;
    NCount:= PrinterOptions(All);
    if NCount > 0 then begin
      Printer:= New(PLinePrinter,Init(UsedFont,'PXPLABEL'));
      PageMetrics.PLen:= GetDeviceCaps(PrintDC,VertSize);
      PageMetrics.PWidth:= GetDeviceCaps(PrintDC,HorzSize);
      WVSPrintf(Notetxt,'Length: %d   Width: %d',PageMetrics);
      if PageMetrics.PLen > 70 then begin
        StrCopy(Note,'Page too small! Change printer options!'#13);
        StrCat(Note,#13);
        strCat(Note,Notetxt);
        RetValue:= BWCCMessagebox(GetFocus,Note,'Printer',mb_okCancel);
      end
      else RetValue:= id_ok;
      if RetValue = id_ok then begin
        if All then begin
          for a:= 1 to NCount do begin
            for x:= 0 to SampleDataColl^.Count-1 do begin
              K:= SampleDataColl^.At(x);
              EtikPrint(K);
            end;
          end;
        end
        else begin
          Lb1^.Transfer(@LbTransfer,tf_GetData);
          if LbTransfer.Selections = Nil then BWCCMessagebox(GetFocus,'No record selected','Print',mb_ok)
          else begin
            if lbTransfer.Selections^.Count < 1 then BWCCMessagebox(GetFocus,'No record selected','Print',mb_ok)
            else begin
              for a:= 1 to NCount do begin
                For x:= 0 to lbTransfer.Selections^.Count-1 do begin
                  K:= SampleDataColl^.At(lbTransfer.Selections^.Selections[x]);
                  EtikPrint(K);
                end;
              end;
            end;
          end;
        end;
      end;
      Printer^.NewPage;
      Dispose(Printer,Done);
    end;
  end;
  DefWndProc(Msg);
end;

Procedure TListWindow.cmPrinterSel(var Msg: TMessage);
var z: Integer;
begin
  SelectPrinter(HWindow);
  DefWndProc(Msg);
end;

Procedure TListWindow.cmPrinterFonts(var Msg: TMessage);
begin
  List_PrinterFonts(@Self,UsedFont);
  DefWndProc(Msg);
end;

{ TDlgApplication }
procedure TDlgApplication.InitMainWindow;
begin
  MainWindow := New(PListWindow, Init(nil, 'PXENGINE-Label-Printer'));
end;

constructor TDlgApplication.Init(AName: PChar);
begin
  DlgLib  := LoadLibrary(DlgDLLName);
  if (DlgLib < 32) then Status:= em_DllNotFound;
  TApplication.Init(AName);
end;

procedure TDlgApplication.Error(ErrorCode: Integer);
begin
  case ErrorCode of
    em_DLLNotFound:
      MessageBox(0, 'BWCC.DLL not found.', 'System Error', mb_Ok or mb_IconStop);
    else
      TApplication.Error(ErrorCode);
  end;
end;

destructor TDlgApplication.Done;
begin
  TApplication.Done;
  FreeLibrary(DlgLib);
end;

var
  MyApp: TDlgApplication;
begin
  MyApp.Init('PXLABELPRINTER');
  MyApp.Run;
  MyApp.Done;
end.
