{**********************************************************}
{*                                                        *}
{*  Unit to use PxEngine under Turbo-Pascal for Windows   *}
{*               Copyright 1992 Kurt Bertram              *}
{*		   Compuserve [100031,3373]               *}
{*                                                        *}
{*  This unit is programmed for a database with fields    *)
{*  NAME,VORNAME,STREET,CITYNO,CITY. If you print labels  *}
{*  for German mail you need these fields. For other      *}
{*  countries, additional fields may be added. Use        *}
{*  Resource Workshop or other editors to modify the      *}
{*  input-dialog. TransferRecord of this unit must also   *}
{*  be updated for your use.                              *}
{*                                                        *}
{*  Everyone is allowed to use this unit. If you discover *}
{*  bugs or make enhancements, I would be happy to know.  *}
{*                                                        *}
{**********************************************************}

Unit PXEdit;

interface

{$R PXEdit.Res}

Uses WObjects, Wintypes, Winprocs, Strings,
     MyInpt, WinPdx;

Const 	id_Mister 	= 103;
        id_Mrs	 	= 104;
        id_Miss	 	= 105;
        id_Name	 	= 107;
        id_Vorname 	= 108;
        id_Street	= 109;
        id_CityNo	= 110;
        id_City		= 111;
        id_Back		= 155;
	id_Forward	= 156;
        id_SaveBtn	= 159;

Type
  TEdit3TransferRecord = Record
    Mister      : Bool;
    Mrs 	: Bool;
    Miss        : Bool;
    Name  	: Array[0..25] of Char;
    Vorname     : Array[0..25] of Char;
    Street  	: Array[0..25] of Char;
    CityNo  	: Array[0..6]  of Char;
    City        : Array[0..25] of Char;
  end;

  PEditDialog = ^TEditDialog;        { Base dialog-object for several editors }
  TEditDialog = object(TDlgWindow)
    EditDaten: PMyCollection;        { See WINPDOX.PAS }
    IsDirty  : Boolean;              { True, if Field is edited }
    Neu      : Boolean;              { True, if New entry       }
    AktNr    : Longint;              { Necessary for quick search with Record-number }
    Constructor Init(AParent: PWindowsObject; AName: PChar; NewEntry: Boolean);
    Private
    Procedure SetupWindow; Virtual;
    Procedure WmEditChanged(var Msg: TMessage); virtual wm_First + wm_Editchanged;
    procedure Ok(var Msg: TMessage); virtual id_First + id_OK;
  end;

  PEdit3Dialog = ^TEdit3Dialog;
  TEdit3Dialog = object(TEditDialog)
    NameInput   : PCheckEdit;       { See MYINPUTS.PAS }
    VornameInput: PCheckEdit;
    R1	        : PMyRadio;
    StreetInput : PCheckEdit;
    CityNoInput : PCheckEdit;
    CityInput   : PCheckEdit;
    TransferRec : TEdit3TransferRecord;
    AltRec      : TEdit3TransferRecord;
    Constructor Init(AParent: PWindowsObject; AName: PChar; NewEntry: Boolean);
    Function Translate_PClient_to_TransferRec(Cl:PClient; var TR: TEdit3TransferRecord): Boolean;
    Procedure Translate_DataRec_to_DatesPtr(DRec: TEdit3TransferRecord; DX:DatesPtr);
    Procedure Btn_forward(var Msg: TMessage); virtual id_First + id_Forward;
    Procedure Btn_backw(var Msg: TMessage); virtual id_First + id_Back;
    Procedure Btn_save(var Msg: TMessage); virtual id_First + id_SaveBtn;
  end;

implementation

Uses Bwcc;    { if you don't have BWCC, delete this line and change all commands like }
              { BWCCMessagebox(... to Messagebox(...                                  }

{ TEditDialog }

Constructor TEditDialog.Init(AParent: PWindowsObject; AName: PChar; NewEntry: Boolean);
begin
  TDlgWindow.Init(AParent,AName);
  Neu:= NewEntry;
  AktNr:= 0;
end;

Procedure TEditDialog.SetupWindow;
begin
  TDlgWindow.SetupWindow;
  if Neu then begin
    EnableWindow(GetItemHandle(id_Back),False);
    EnableWindow(GetItemHandle(id_Forward),False);
  end
  else begin
    if AktNr < 2 then EnableWindow(GetItemHandle(id_Back),False);
    if AktNr >= EditDaten^.TableStruc^.NumRecs then EnableWindow(GetItemHandle(id_Forward),False);
  end;
end;

Procedure TEditDialog.WmEditChanged(var Msg: TMessage);
begin
  IsDirty:= True;
  Messagebeep(0);
  DefWndProc(Msg);
end;

procedure TEditDialog.Ok(var Msg: TMessage);
begin
  if IsDirty then begin
    BWCCMessagebox(getactivewindow,'Data changed. Please save before leaving !','',mb_ok+mb_iconStop);
    DefWndProc(Msg);
  end
  else TDlgWindow.Ok(Msg);
end;

{ TEdit3Dialog }

Constructor TEdit3Dialog.Init(AParent: PWindowsObject; AName: PChar; NewEntry: Boolean);
begin
  TEditDialog.Init(AParent,AName,NewEntry);
  EditDaten:= SampleDataColl;
  With TransferRec do begin
    New(R1,InitResource(@Self,id_Mister));
    New(R1,InitResource(@Self,id_Mrs));
    New(R1,InitResource(@Self,id_Miss));
    New(NameInput,InitResource(@Self,id_Name,1,Sizeof(Name)));
    New(VornameInput,InitResource(@Self,id_Vorname,1,Sizeof(Vorname)));
    New(StreetInput,InitResource(@Self,id_Street,1,Sizeof(Street)));
    New(CityNoInput,InitResource(@Self,id_CityNo,1,Sizeof(CityNo)));
    New(CityInput,InitResource(@Self,id_City,1,Sizeof(City)));
  end;
end;

Function TEdit3Dialog.Translate_PClient_to_TransferRec(Cl:PClient; var TR: TEdit3TransferRecord): Boolean;
var testhwnd: Hwnd;
    TransOk  : Boolean;
begin { Listbox-Records are PCLIENTS, Editor-Record must be translated for transfer }
  TransOk:= True;
  With TR do begin
      if Cl = NIL then begin
        AktNr:= 0;
        StrCopy(Name,'');
        StrCopy(Vorname,'');
        Mister:= true; Mrs:= false; Miss:= false;
        StrCopy(Street,'');
        StrCopy(CityNo,'');
        StrCopy(City  ,'');
      end
      else begin
        if IswindowEnabled(HWindow) then begin
          testhwnd:= GetItemHandle(id_Back);
          if IsWindowEnabled(testhwnd) then begin
            if Cl^.Index = 1 then begin
              PostMessage(HWindow,wm_NextDlgCtl,GetItemHandle(id_Forward),1);
              EnableWindow(testhwnd,False);
            end;
          end
          else begin
            if Cl^.Index > 1 then EnableWindow(testhwnd,True);
          end;
          testhwnd:= GetItemHandle(id_Forward);
          if IsWindowEnabled(testhwnd) then begin
            if Cl^.Index = EditDaten^.TableStruc^.NumRecs then begin
              PostMessage(HWindow,wm_NextDlgCtl,GetItemHandle(id_Back),1);
              EnableWindow(testhwnd,False);
            end;
          end
          else begin
            if Cl^.Index < EditDaten^.TableStruc^.NumRecs then EnableWindow(testhwnd,True);
          end;
        end;
        AktNr:= Cl^.Index;
        StrCopy(Name	,Cl^.Fld[1]);
        StrCopy(Vorname ,Cl^.Fld[2]);
        if StrComp(Cl^.Fld[3],'Mrs') = 0 then begin
          Mister:= false; Mrs:= true; Miss:= false;
        end
 	else if StrComp(Cl^.Fld[3],'Miss') = 0 then begin
          Mister:= false; Mrs:= false; Miss:= true;
        end
        else if StrComp(Cl^.Fld[3],'Mr') = 0 then begin
          Mister:= true; Mrs:= false; Miss:= false;
        end
        else begin
          Mister:= false; Mrs:= false; Miss:= false;
        end;
        StrCopy(Street ,Cl^.Fld[4]);
        StrCopy(CityNo ,Cl^.Fld[5]);
        StrCopy(City   ,Cl^.Fld[6]);
      end;
  end;
  AltRec:= TR;
  IsDirty:= False;
  Translate_PClient_to_TransferRec:= TransOK;
end;

Procedure TEdit3Dialog.Translate_DataRec_to_DatesPtr(DRec: TEdit3TransferRecord; DX:DatesPtr);
begin
  with DRec do begin { Transferrecord must be translated back to PCLIENT for saving }
    DX^[1]:= StrPas(Name);
    DX^[2]:= StrPas(Vorname);
    if Mrs = true then DX^[3]:= 'Mrs' else if Miss = true then DX^[3]:= 'Miss' else DX^[3]:= 'Mr';
    DX^[4]:= StrPas(Street);
    DX^[5]:= StrPas(CityNo);
    DX^[6]:= StrPas(City);
  end;
end;

Procedure TEdit3Dialog.Btn_forward(var Msg: TMessage);
var KClient: PClient;              { You can skip through Data by pressing }
    TRec: TEdit3TransferRecord;    { the Forward-Button.                   }
    MerkBuffer: Pointer;           { While entering new Data this Button will be disabled }
begin
  if IsDirty then BWCCMessagebox(getactivewindow,'Data changed. Please save before leaving !','',mb_ok+mb_iconStop)
  else begin
    KClient:= EditDaten^.At(AktNr);
    Translate_PClient_to_TransferRec(KClient,Trec);
    MerkBuffer:= Transferbuffer;
    TransferBuffer:= @TRec;
    TransferData(tf_SetData);
    TransferBuffer:= MerkBuffer;
  end;
  DefWndProc(Msg);
end;

Procedure TEdit3Dialog.Btn_backw(var Msg: TMessage);
var KClient: PClient; 		 { You can skip backwards, if you press }
    TRec: TEdit3TransferRecord;  { this button. While entering new Data }
    MerkBuffer: Pointer;         { this button will be disabled.        }
begin
  if IsDirty then BWCCMessagebox(getactivewindow,'Data changed. Please save before leaving !','',mb_ok+mb_iconStop)
  else begin
    KClient:= EditDaten^.At(AktNr-2);
    Translate_PClient_to_TransferRec(KClient,Trec);
    MerkBuffer:= Transferbuffer;
    TransferBuffer:= @TRec;
    TransferData(tf_SetData);
    TransferBuffer:= MerkBuffer;
  end;
  DefWndProc(Msg);
end;

Procedure TEdit3Dialog.Btn_save(var Msg: tMessage);
var x: Pointer;			{ If you want to save edited Data, press }
    AltD,NeuD: DatesPtr; 	{ Save-Button. It will only work, if you }
    Merkbuffer: Pointer;        { have really changed data.              }
    TRec: TEdit3TransferRecord;
begin
  if Canclose then begin
    if IsDirty then begin
      new(NeuD);
      MerkBuffer:= Transferbuffer;
      TransferBuffer:= @TRec;
      TransferData(tf_GetData);
      Translate_DataRec_to_DatesPtr(Trec,NeuD);
      if Neu then EditDaten^.Append_Rec(NeuD)
      else begin
        New(AltD);
        Translate_DataRec_to_DatesPtr(AltRec,AltD);
        EditDaten^.Edit_Rec(AltD,NeuD);
        Dispose(AltD);
      end;
      Transferbuffer:= MerkBuffer;
      Dispose(NeuD);
      IsDirty:= False;
      if Neu then begin
        Translate_PClient_to_TransferRec(NIL,Trec);
        MerkBuffer:= Transferbuffer;
        TransferBuffer:= @TRec;
        TransferData(tf_SetData);
        TransferBuffer:= MerkBuffer;
      end;
    end
    else BWccmessagebox(getactivewindow,'Data not changed. Saving denied!','',mb_ok+mb_IconInformation);
  end
  else
  BWCCMessagebox(getactivewindow,'Data not complete. Saving denied !','',mb_ok+mb_iconStop);
end;

begin
end.