
{}
{							}
{	PRNVIEW	      --TPrnBox View Demonstration	}
{	RUNDLG	      --Public Domain (1992)		}
{							}
{			Randolph Beck			}
{			CIS:  72361,753			}
{							}
{}

Program PRNVIEW;

{$B-,R-,V-,X+ }

uses
    Crt, Objects, Drivers, Views, Dialogs, Menus, App, MsgBox, RunDlg;

const
    cmPrint	=  101;

    InFileName	=  'PRNVIEW.PAS';
    OutFileName	=  'PRNVIEW.OUT';  { change to 'PRN' for printer }

type
    TMyApp	=  OBJECT (TApplication)
      procedure HandleEvent (var Event : TEvent);  VIRTUAL;
      procedure InitMenuBar;  VIRTUAL;
      procedure PrintFile;
    end;


  {  }

{$I- }
function  PrintFunc : word;  far;
var  i,ErrCode	: integer;
     S		: string;
     FIN,FOUT	: Text;
begin
  Assign (FIN,  InFileName);
  Assign (FOUT, OutFileName);
  Reset (FIN);
  ErrCode := IOResult;
  If (ErrCode = 0) then
    begin
    Rewrite (FOUT);
    ErrCode := IOResult;
    If (ErrCode = 0) and Running then
      begin
      WriteLn (FOUT, 'File: ' + InFileName);
      ErrCode := IOResult;
      If (ErrCode = 0) then
        begin
        WriteLn (FOUT);
        ErrCode := IOResult;
        end;
      While Running and (ErrCode = 0) and not Eof(FIN) do
        begin
        Delay (50);  { delay for demonstration only }
        ErrCode := IOResult;
        ReadLn (FIN, S);
        If (ErrCode = 0) then
          begin
          WriteLn (FOUT, S);
          ErrCode := IOResult;
          end;
        end;
      end;
    Close (FOUT);
    end;
  Close (FIN);
  If (ErrCode = 0) then PrintFunc := cmYes else PrintFunc := cmNo;
end;


  {  TMyApp  }


procedure TMyApp.HandleEvent (var Event : TEvent);
begin
  TApplication.HandleEvent (Event);
  If Event.What = evCommand then
    begin
    Case Event.Command of
      cmPrint:	PrintFile;
     else       Exit;
      end;
    ClearEvent (Event);
    end;
end;


procedure TMyApp.InitMenuBar;
var  R: TRect;
begin
  GetExtent (R);
  R.B.Y := succ (R.A.Y);
  MenuBar := New (PMenuBar, Init (R, NewMenu (
    NewItem ('~P~rnView','',	kbF7,	cmPrint,	hcNoContext,
    nil)
  )));
end;


procedure TMyApp.PrintFile;
var  R	: TRect;
     D	: PPrnBox;
begin
  R.Assign (0,0,40,9);
  D := New (PPrnBox, Init (R, 'Print', @PrintFunc,
	'Ensure that the device is ready.'^M^M'Destination: "' + OutFileName + '"',
	^C'Printing...'^M^M'Destination: "' + OutFileName + '"',
	^C'Waiting for user...'));
  D^.Options := D^.Options or ofCentered;
  Case DeskTop^.ExecView (D) of
    cmYes:  MessageBox ('Output ran to completion.', nil, mfInformation + mfOKButton);
    cmNo:   MessageBox ('Error during operation.', nil, mfError + mfOKButton);
    end;
  Dispose (D, Done);
end;


  {  }

var  MyApp: TMyApp;

Begin
  MyApp.Init;
  MyApp.Run;
  MyApp.Done;
End.
