
(**********************************************************************)
(* Simple program to demonstrate how to use the FlxKey unit to create *)
(* an encrypted registration-key file.                                *)
(**********************************************************************)

program MakeFlxKeyDemo1;
uses
  FlxKey;

var           (* This variable is used to check for errors returned   *)
              (* by CreateFlxKey routine.                             *)
  ErrorCode : word;

              (* Encryption-code strings used to create encrypted     *)
              (* registration-key file.                               *)
  Ecode1,
  Ecode2 : st100;

              (* This is the full path/filename of the encrypted      *)
              (* registration-key file to be created.                 *)
  RegKeyName : st79;

              (* This variable is used to pass the user-data to the   *)
              (* CreateFlxKey routine.                                *)
  TempKeyRec : FlxRec;

              (* Main program execution block.                        *)
BEGIN
              (* Clear the temporary key-record variable.             *)
  fillchar(TempKeyRec, sizeof(TempKeyRec), 0);

              (* Assign data to temporary key-record.                 *)
  with TempKeyRec do
    begin
              (* 20 char space is available for first-name.           *)
      FirstName := 'John';

              (* 30 char space is available for last-name.            *)
      LastName  := 'Smith';

              (* 30 char space is available for Address1.             *)
      Address1  := '1234 AnyPlace Road,';

              (* 30 char space is available for Address2.             *)
      Address2  := 'BigCity BigPlace,';

              (* 30 char space is available for Address3.             *)
      Address3  := 'BigCountry, BigZip';

              (* 20 char space is available for application-name.     *)
      AppName   := 'Amazing Program';

              (* Version can be assigned any valid word data.         *)
      Version   := 310;

              (* Serial can be assigned any valid longint data.       *)
      Serial    := 1234567890;

              (* Date can be assigned any valid "packed" date/time.   *)
              (* If a value of 0 is assigned to Date, CreateFlxKey    *)
              (* routine will assign the current date/time to this    *)
              (* variable in "packed" date/time format. Use TP's      *)
              (* standard "PackTime" and "UnPackTime" routines to     *)
              (* manipulate this data.                                *)
      Date      := 0;

              (* Access level can be assigned a number from 0..65,535 *)
      Access    := 1234
    end;

              (* Assign encryption-code strings used to create the    *)
              (* encrypted registration-key file.                     *)
  Ecode1 := 'Apple';
  Ecode2 := 'Orange';

              (* Filename for the encrypted registration-key to be    *)
              (* created.                                             *)
  RegKeyName := 'DEMO1.KEY';

              (* Create encrypted registration-key using the data     *)
              (* assigned to TempKeyRec.                              *)
  CreateFlxKey(TempKeyRec, Ecode1, Ecode2, RegKeyName, ErrorCode);

              (* Move cursor down one line.                           *)
  writeln;

              (* Check for errors.                                    *)
  case (ErrorCode AND $FF) of
     0 : writeln(' Sucessful key creation! No errors.');
     1 : writeln(' Error! One or more encryption-codes are blank.');
     2 : writeln(' Error! Filename for registration-key file is blank.');

              (* I/O error!                                           *)
    16 : begin
           writeln(' I/O error = ', (ErrorCode shr 8));

              (* Standard Turbo Pascal error-codes. See TP manuals,   *)
              (* as there are many types of errors to check for.      *)
           case (ErrorCode shr 8) of
               2 : writeln(' File not found.');
               3 : writeln(' Path not found.');
               4 : writeln(' Too many files open.');
               5 : writeln(' File access denied.');
             101 : writeln(' Disk write error.');
             103 : writeln(' File not open');
             150 : writeln(' Disk is write-protected')
           end  (* case (ErrorCode shr 8) of                          *)
         end
  end         (* case (ErrorCode AND $FF) of                          *)
END.


