program Resource;

{$R Resource.RES}

uses WObjects, WinTypes, WinProcs, Strings, Frames, BWcc, StdDlgs;

function GetHeapSpaces(Handle:THandle):longint; far; external 'KERNEL';

const
	sc_About=100;
	sc_Options=101;
	id_ed1 = 201;
	id_ed2 = 202;
	id_ed3 = 203;
	id_Default = 205;
	GDILen = 2;
	USRLen = 2;
	MemLen = 5;

var
  R:TRect;
  PctTxt1:array[0..4] of Char; {GDI heap free}
  PctTxt2:array[0..4] of Char; {User heap free}
  PctTxt3:array[0..4] of Char; {Memory free}
	GDIMin : array[0..GDILen] of Char;
  	USRMin : array[0..USRLen] of Char;
	MemMin : array[0..MemLen] of Char;

  InitMem:longint;
  size	 :integer;

type
  PDialogRec = ^DialogRec;
  DialogRec = record
  end;

  	PEdDialog = ^EdDialog;
	EdDialog = object(TDialog)
	  DataPointer: PDialogRec; 
	  constructor Init (AParent: PWindowsObject; AName: PChar;
		P: PDialogRec);
	  procedure SetupWindow; virtual;
	  procedure Ok(var Msg: TMessage);
		virtual id_first + id_ok;
	  procedure Default(var Msg: TMessage);
		virtual id_first + id_Default;
	end;

	TResourceApp = Object(TApplication)
	  procedure InitMainWindow; virtual;
    end;

	PResourceWindow = ^TResourceWindow;
	TResourceWindow = object(TWindow)
		SysMenu:HMenu;
		DialogData: DialogRec;
		function GetClassName: PChar; virtual;
		constructor Init(AParent: PWindowsObject; ATitle: PChar);
		procedure SetupWindow; virtual;
		procedure GetWindowClass(var AWndClass: TWndClass); virtual;
		procedure Paint(PaintDC:HDC; var PaintInfo:TPaintStruct); virtual;
		procedure WMDestroy(var Msg:TMessage); virtual wm_First+wm_Destroy;
		procedure About;
		procedure Options;
		procedure WMSysCommand(var Msg:TMessage); virtual wm_First+wm_SysCommand;
		procedure WMTimer(var Msg:TMessage); virtual wm_First+wm_Timer;
	end;


{Initialize edit control}
procedure SetText(HDlg: HWnd; CtrlID: Word; Buffer: PChar; MaxLen: Word);
begin
  SendDlgItemMessage(HDlg, CtrlID, wm_SetText, 0, LongInt(Buffer));
  SendDlgItemMessage(HDlg, CtrlID, em_LimitText, MaxLen, 0);
end;

{ Retieve Text}
procedure GetText(HDlg: HWnd; CtrlID: Word; Buffer: PChar; MaxLen: Word);
begin
  SendDlgItemMessage(HDlg, CtrlID, wm_GetText, MaxLen, LongInt(Buffer));
end;

constructor EdDialog.Init(AParent: PWindowsObject; AName: PChar;
  P: PDialogRec);

begin
  TDialog.Init(AParent, AName);
  DataPointer := P;
end;


function TResourceWindow.GetClassName: PChar;
begin
	GetClassName := 'ResourceWindow'
end;

procedure TResourceWindow.GetWindowClass(var AWndClass: TWndClass);
begin
	TWindow.GetWindowClass(AWndClass);
	AWndClass.HIcon := 0;
end;

procedure EdDialog.SetupWindow;
var
  I: Integer;

begin
  TDialog.SetupWindow;
  with DataPointer^ do
  begin
	SetText(HWindow, id_Ed1, GDIMin, GDILen);
	SetText(HWindow, id_Ed2, USRMin, USRLen);
	SetText(HWindow, id_Ed3, MemMin, MemLen);
  end;
end;

procedure TResourceWindow.SetupWindow;
var T:longint;
	wout:boolean;
    LogicFont:HFont;
	PaintDC:HDC;
	I: integer;

begin
	TWindow.SetupWindow;
	if SetTimer(HWindow,20,500,nil)=0 then  {timer set for 1/2 second}
	begin
		MessageBox(HWindow,'Cannot start timer for',
							 'Resource Monitor',mb_IconStop or mb_OK);
		CloseWindow;
	end;
	UpdateWindow(HWindow);
	SysMenu:=GetSystemMenu(HWindow,false);
	size:=10;
	wout:=true;
 	PaintDC:=GetDC(HWindow);
	while wout do
	begin
		LogicFont := CreateFont(size,0,0,0,900,0,0,0,0,0,0,0,ff_Swiss+Variable_Pitch,'MS Sans Serif');
		SelectObject(PaintDC,LogicFont);
		If Loword(GetTextExtent(PaintDC,'100%',4))<(GetSystemMetrics(sm_CXIcon)) then wout:=false
		else size:=size-1;
    DeleteObject(LogicFont);
	end;
  ReleaseDC(HWindow,PaintDC);
  if (size*3) > Round(GetSystemMetrics(sm_CYIcon)*0.65) then
	size := Round(GetSystemMetrics(sm_CYIcon)*0.45);
	DeleteMenu(SysMenu,sc_Restore,mf_ByCommand);
	DeleteMenu(SysMenu,sc_Maximize,mf_ByCommand);
	AppendMenu(SysMenu,mf_String,0,nil);
	AppendMenu(SysMenu,mf_String,sc_About,'&About ...');
	AppendMenu(SysMenu,mf_String,sc_Options,'&Options ...');
	SendMessage(HWindow,wm_Timer,1,0);
end;

constructor TResourceWindow.Init(AParent: PWindowsObject; ATitle: PChar);

begin
  TWindow.Init(AParent, ATitle);
  with DialogData do
  begin
	StrCopy(GDIMin, '45');
	StrCopy(USRMin, '45');
	StrCopy(MemMin, '4500');
  end;
end;

procedure TResourceWindow.Paint(PaintDC:HDC;var PaintInfo:TPaintStruct);

var TextMetrics			: TTextMetric;
	OldFont,LogicFont	: HFont;
	code,Y1,Y2,Y3		: integer;
	I,min				: integer;
	x					: string;

begin
	with R do
	begin
		Right:=GetSystemMetrics(sm_CXIcon)+3;
		Bottom:=GetSystemMetrics(sm_CYIcon)+3;
		Left:=0;Top:=0;
	end;
	DrawBorderFrame(PaintDC,R,true);
    LogicFont := CreateFont(size,0,0,0,900,0,0,0,0,0,0,0,ff_Swiss+Variable_Pitch,'MS Sans Serif');
	OldFont:=SelectObject(PaintDC,LogicFont);
	SetBkMode(PaintDC,Transparent);
	SetTextAlign(PaintDC,ta_Top);
	GetTextMetrics(PaintDC,TextMetrics);
	Y1:=Round((R.bottom-(2*size))/2)-4;
	Y2:=R.bottom-Y1-size-10;
	Y3:=R.bottom-Y2-size+12;

	x:= StrPas(PctTxt1);
	dec(x[0]);
	val(x, I, code );
	val(GDIMin,Min,code);
    if I < Min then
		SetTextColor(PaintDC,RGB(255,0,0))
	else
		SetTextColor(PaintDC,RGB(0,0,255));
	TextOut(PaintDC,Round((R.right-Loword(GetTextExtent(PaintDC,PctTxt1,StrLen(PctTxt1))))/2),
		Y1,PctTxt1,StrLen(PctTxt2));

	x:= StrPas(PctTxt2);
	dec(x[0]);
	val(x, I, code );
	val(USRMin,Min,code);
    if I < Min then
		SetTextColor(PaintDC,RGB(255,0,0))
	else 
		SetTextColor(PaintDC,RGB(0,0,255));
	TextOut(PaintDC,Round((R.right-Loword(GetTextExtent(PaintDC,PctTxt2,StrLen(PctTxt2))))/2),
		Y2,PctTxt2,StrLen(PctTxt2));


	val(StrPas(PctTxt3),I,code);
	val(MemMin,Min,code);
    if I < Min then
		SetTextColor(PaintDC,RGB(255,0,0))
	else
		SetTextColor(PaintDC,RGB(0,0,255));
	TextOut(PaintDC,Round((R.right-Loword(GetTextExtent(PaintDC,PctTxt3,StrLen(PctTxt3))))/2),
		Y3,PctTxt3,StrLen(PctTxt3));

  SelectObject(PaintDC,OldFont);
	DeleteObject(LogicFont);
end;

procedure TResourceWindow.WMTimer(var Msg:TMessage);
var
	wFree,wSize:word;
	GDIPct,UserPct,dwInfo:longint;
  	PctTxtT1,PctTxtT2,PctTxtT3:array[0..4] of char;
    PctNum:string;

begin
	dwInfo:=GetHeapSpaces(GetModuleHandle('GDI'));
	wSize:=HiWord(dwInfo);
	wFree:=LoWord(dwInfo);
	GDIPct:=Round(wFree/wSize*100);
	Str(GDIPct,PctNum);
	StrPCopy(PctTxtT1,PctNum+'%');

    dwInfo:=GetHeapSpaces(GetModuleHandle('User'));
	wSize:=HiWord(dwInfo);
	wFree:=LoWord(dwInfo);
	UserPct:=Round(wFree/wSize*100);
	Str(UserPct,PctNum);
	StrPCopy(PctTxtT2,PctNum+'%');

	Str(Round(MemAvail/1000),PctNum);
	StrPCopy(PctTxtT3,PctNum);

    if (StrComp(PctTxt1,PctTxtT1)<>0) or (StrComp(PctTxt2,PctTxtT2)<>0) or
		(StrComp(PctTxt3,PctTxtT3)<>0) or (Msg.wParam=1) then
	begin
		StrPCopy(PctTxt1,PctTxtT1);
		StrPCopy(PctTxt2,PctTxtT2);
		StrPCopy(PctTxt3,PctTxtT3);
		InvalidateRect(HWindow,nil,false);
		UpdateWindow(HWindow);
	end;
end;
{- Respond to Default butoon }
procedure EdDialog.Default(var Msg: TMessage);

begin
	StrCopy(GDIMin, '45');
	StrCopy(USRMin, '45');
	StrCopy(MemMin, '4500');
	TDialog.Ok(Msg);
end;

{- Respond to Ok butoon }
procedure EdDialog.Ok(var Msg: TMessage);
const
  NumSet = ['0'..'9'];

var
  TGDI: Array[0..2] of Char;
  TUSR: Array[0..2] of Char;
  TMem: Array[0..3] of Char;
  Text: Array[0..10] of Char;
  I,Len : integer;
  Valid : boolean;
   

begin
  GetText(HWindow, id_Ed1, TGDI, SizeOf(TGDI));
  GetText(HWindow, id_Ed2, TUSR, SizeOf(TUSR));
  GetText(HWindow, id_Ed3, TMem, SizeOf(TMem));
  StrCopy(Text,'');
  StrCat(Text,TGDI);
  StrCat(Text,TUSR);
  StrCat(Text,TMem);
	I := 0;
  	Len := StrLen(Text);
  	Valid := True;
  	while Valid and (I < Len) do
  	begin
		Valid := Text[I] in NumSet;
    	Inc(I);
  	end;
  if not Valid then
	  begin
		MessageBeep(0);
		MessageBox(Hwindow, 'Must enter Numbers only', 'Error', mb_Ok)
  	  end else
	begin
	with DataPointer^ do
		begin
	  		GetText(HWindow,id_Ed1, GDIMin, SizeOf(GDIMin));
	  		GetText(HWindow,id_Ed2, USRMin, SizeOf(USRMin));
	  		GetText(HWindow,id_Ed3, MemMin, SizeOf(MemMin));
		end;
		TDialog.Ok(Msg);
	end;
end;

procedure TResourceApp.InitMainWindow;
begin
	MainWindow := New(PResourceWindow, Init(nil, 'Resource Monitor'));
end;


procedure TResourceWindow.WMDestroy(var Msg:TMessage);
begin
	KillTimer(HWindow,20);
	TWindow.WMDestroy(Msg);
end;

procedure TResourceWindow.WMSysCommand(var Msg:TMessage);
begin
	case Msg.WParam of
		sc_About	:	About;
		sc_Options	:	Options;
	else
		DefWndProc(Msg);
	end;
end;

procedure TResourceWindow.About;
var Dialog:TDialog;
begin
	Application^.ExecDialog(New(PDialog,Init(@Self,'ABOUT')));
end;

procedure TResourceWindow.Options;
begin
	Application^.ExecDialog(New(PEdDialog,Init(@Self,'OPTIONS',@DialogData)));
end;

var
	ResourceApp: TResourceApp;

begin
	CmdShow:=sw_Minimize;
	ResourceApp.Init('ResourceApp');
	ResourceApp.Run;
	ResourceApp.Done;
end.
