(*
  !---------------------------------------------------------------------------!
  !                                                                           !
  !  ScrollBk/     Version 1.0                                                !
  !                                                                           !
  !  Date Started: 12/02/91     Date Version Completed: 01/22/92              !
  !                                                                           !
  !  Written By:   David D. Cruger/ CopyRight (CR) 1992                       !
  !                CompuServe #72047,2417                                     !
  !                                                                           !
  !  Language:    Turbo Pascal 5.0, 5.5, 6.0                                  !
  !                                                                           !
  !  Requires:    TSR's Made Easy by Turbo Power to recompile.                !
  !                                                                           !
  !  Files Date/Time:   01/22/92  12:00                                       !
  !                                                                           !
  !  See File:    Scrollbk.doc for additional information.                    !
  !                                                                           !
  !  Command Line Parameters:  /A    Append to Scrollkb buffer. (default)     !
  !                            /LON  Toggle Logging On                        !
  !                            /LOFF Toggle Logging Off                       !
  !                            /O    Overwrite Scrollbk buffer. (start new)   !
  !                            /U    Unload Scrollbk program.                 !
  !                                                                           !
  !---------------------------------------------------------------------------!
*)

  (* A =  align data
     B =  boolean short
     D =  debug on
     E =  emulate 80287
     F =  far calls
     L =  local symbol information
     N =  numeric processing switch
     O =  overlay
     R =  range checking on
     S =  stack-overflow
     V =  var-string checking
  *)

{$a+,b-,d-,e-,f+,l-,n-,o-,r-,s-,v-}                                         {}

{$M 2000,12500,12500}  { Stack, Min/Max heap                                {}

Program ScrollBk;

uses dos,crt,                 (* standard Turbo Pascal units *)
     opinline,opint,optsr;    (* Turbo Power units           *)

const
       Max_Buffer=100;                        (* Size of Buffer            *)
       Alt_Stack_Size=2048;                   (* Alt-Stack-Size            *)
       hotkey=$0C2E; (* ALT-CTRL-C *)         (* Define HOT keys           *)
       program_name: STRING = 'SCROLLBK';     (* Define TSR name           *)
       WaitForDos=true;                       (* Wait for DOS Before POPUP *)
       alt_l=#0+#38;                          (* Toggle Logging            *)
       f10=#0+#68;                            (* Unload TSR from memory    *)
       ESC=#27+#0;                            (* ESC/Exit from everything  *)

          (*----------  basic screen keys -----------*)
               pgup=#0+#73;            pgdn=#0+#81;
               home=#0+#71;            eend=#0+#79;
               uparrow=#0+#72;         downarrow=#0+#80;
               ctrl_pgup=#0+#132;      ctrl_pgdn=#0+#118;

type

   st80=string[80];
   st60=string[60];
   st20=string[20];
   st5 =string[05];
   st2 =string[02];

Buffer_Record=Record           (* Basic Record data of 80char *)
      data: st80;              (* and 1 byte to mark record   *)
    marked: boolean;
      end;

Buffer_Log = array[1..Max_Buffer] of Buffer_Record; (* Screen Buffer before write *)
Screentype = array[0..4006] of byte;                (* Screen Display             *)

var

(*--- test purpose -------*)
I10h_02,                      (* Int10h 02h counter             *)
I10h_06,                      (* Int10h 06h counter             *)
I10h_07,                      (* Int10h 07h counter             *)
I10h_09,                      (* Int10h 09h counter             *)
I10h_0A,                      (* Int10h 0Ah counter             *)
I10h_0E,                      (* Int10h 0Eh counter             *)
I10h_13        : longint;     (* Int10h 13h counter             *)

PopUpStack     : array[1..Alt_Stack_Size] of byte; (* Alt Stack for POPUP *)
TimerStack     : array[1..Alt_Stack_Size] of byte; (* Alt Stack for Timer *)

Cur10,                        (* during unload hold cur 10h      *)
OldExitproc    : pointer;     (* stores pointer to old exit proc *)

ColorScreen    : Screentype absolute $B800:$0000;  (* screen location for mono        *)
MonoScreen     : Screentype absolute $B000:$0000;  (* screen location for color       *)
Hold_Screen    : ^Screentype;                      (* hold screen on heap             *)

Is_Log_Open,                                       (* set on if log open              *)
LineFeed,                                          (* toggle Line feed check          *)
CR_LF,                                             (* Carriage Return/Line Feed mark  *)
Remove_TSR,                                        (* to unload or not                *)
Hold_Log_Status,                                   (* Hold the status of Screen IO    *)
Log_Screen_IO  : boolean;                          (* to log/or not to log            *)

bl_log         : ^buffer_log;                      (* buffer log on heap              *)

bl_num,                                            (* number in buffer                *)
error_code,                                        (* error code used by Stayres      *)
Int10hHandle,                                      (* Bios Int 10h handle             *)
TimerHandle,                                       (* Timer Routine Handle            *)
WriteLogHandle : byte;                             (* Handle for Writing log file     *)

log_line       : st80;                             (* holds the line currently on     *)
line1          : Buffer_Record;                    (* display line                    *)
inbuff         : file of Buffer_Record;            (* log file                        *)
outc           : file of longint;                  (* file for interrupt counter      *)
log_length     : byte absolute log_line;           (* holds the length of log_line    *)

Log_Name,                                          (* file name of buffer log         *)
Path           : st60;                             (* path to program directory       *)

num_on_file,                                       (* total number of lines on file   *)
top,bottom,rec,                                    (* Screen display pointers         *)
middle,span    : longint;                          (* Screen span limits              *)

rs             : st2;                              (* Input from keyboard 2 scancodes *)

(*------ get kbd strokes ----------*)
function get_kbd_strokes: st2;
begin
  rs[1]:=#0; rs[2]:=#0;
  repeat
    rs[1]:=readkey;
    if (rs[1]=#0) and (keypressed) then rs[2]:=readkey;
  until (rs[1]<>#0) or (rs[2]<>#0);
  get_kbd_strokes:=rs[1]+rs[2];
end; (* end function *)

(*============  buffer left  ============*)
function buffer_left(l:integer; key: st80; ch:char):st80;
var l1: byte absolute key;
begin

(* l = # of pos to buf left *)
if l1<l then
 repeat  key:=key+ch; until l1>=l;
 buffer_left:=key;

(* buffer text left fill right with char *)

end; (* end procedure *)

(*===========  charfill  ====================*)
function charfill(l1:integer; ch:char): st80;
var  key: st80; l: byte absolute key;
begin

key:='';
  if l1>0 then
   for l:=1 to l1 do key[l]:=ch;
charfill:=key;

end; (* end function *)

(*------ replace chars in a string ----------*)
function replace(key: st80; ch1,ch2: char): st80;
var l: byte absolute key;  z: byte;
begin

if l>0 then
 for z:=1 to l do
   if key[z]=ch1 then key[z]:=ch2;

replace:=key;

end; (* end function *)

(*=========  save screen ================*)
Procedure Savescreen(var screen:screentype);
begin

  case lastmode of                       (* based on lastmode/get screen   *)
       bw40 : move(colorscreen,screen,2000);
       co40 : move(colorscreen,screen,2000);
       bw80 : move(colorscreen,screen,4000);
       co80 : move(colorscreen,screen,4000);
       mono : move(monoscreen,screen,4000);
  end; (* case *)

  screen[4000]:=lo(windmin)+1;           (* 4000-4003 are window cords     *)
  screen[4001]:=hi(windmin)+1;
  screen[4002]:=lo(windmax)+1;
  screen[4003]:=hi(windmax)+1;
  screen[4004]:=textattr;                (* 4004 is current text attribute *)
  screen[4005]:=wherex;                  (* 4005-4006 are cursor cords     *)
  screen[4006]:=wherey;

end; (* end procedure *)

(*=========  restore screen  =============*)
Procedure RestoreScreen(var screen:screentype);
begin

  case lastmode of                       (* based on lastmode/restore scrn *)
       bw40 : move(screen,colorscreen,2000);
       co40 : move(screen,colorscreen,2000);
       bw80 : move(screen,colorscreen,4000);
       co80 : move(screen,colorscreen,4000);
       mono : move(screen,monoscreen,4000);
    end; (* case *)

  window(screen[4000],                   (* 4000-4003 are window cords     *)
         screen[4001],
         screen[4002],
         screen[4003]);

  textattr:=screen[4004];                (* 4004 is current text attribute *)
  gotoxy(screen[4005],screen[4006]);     (* 4005-4006 are cursor cords     *)

end; (* end procedure *)

(*------------  clr window ------------*)
procedure clr_window(x,y,x1,y1:byte);
var a,b,a1,b1,px,py: byte;  (* save old window cord *)
begin

   a:=lo(windmin)+1;    (* hold window cords *)
   b:=hi(windmin)+1;
  a1:=lo(windmax)+1;
  b1:=hi(windmax)+1;
  px:=wherex;
  py:=wherey;

  window(x,y,x1,y1);    (* set window        *)
  clrscr;               (* clr window        *)
  window(a,b,a1,b1);    (* reset window      *)
  gotoxy(px,py);        (* goto cursor pos   *)

end; (* end procedure *)

(*--------->>>>  write direct to video buffer  <<<-----------*)
procedure writed(key:st80; x,y: integer);
var n,x1: integer; l: byte absolute key;  (* length of key *)
begin

(* find location in video buffer *)
n:=(x*2)+(y*160)-162;
if odd(n) then inc(n); (* just to be sure *)

(*   check video mode for 40char  *)
  case lastmode of
       bw40 : n:=n div 2;
       co40 : n:=n div 2;
   end; (* case *)

(*  change characters color attribute  *)

x1:=0; (* reset *)
repeat  inc(x1);

     if lastmode=mono then
          memw[$b000:n]:=(textattr shl 8)+ord(key[x1])        (* mono   *)
     else
          memw[$b800:n]:=(textattr shl 8)+ord(key[x1]);       (* color  *)

    inc(n,2); (* push buffer *)

until (x1>=l);

end; (* end procedure *)

(*-----  write center direct  --------------*)
procedure writecd(key:st80; x,y: integer);
var l: byte absolute key;
begin

x:=x-(l DIV 2);  (* center off x *)
if l>0 then (* this will wrap around if it goes off the screen *)
  if (y>0) and (y<26) then writed(key,x,y);

end; (* end procedure *)

(*============  setcolors ============*)
procedure setcolors(bground,fground: byte);
begin
       textbackground(bground); textcolor(fground);
end; (* end procedure *)

(*-------->>> box <<<----------------------*)
procedure box_frame(a,b,a1,b1:byte);
var c: byte;
begin

writed(#201+charfill((a1-a-1),#205)+#187,a,b);
      for c:=b+1 to b1-1 do
         begin
            writed(#186,a,c);  writed(#186,a1,c);
         end;
writed(#200+charfill((a1-a-1),#205)+#188,a,b1);

end;  (* box fram  *)

(*-------  are you sure -------------*)
function are_you_sure(key:st20): boolean;
begin

setcolors(red,white);
box_frame(29,8,51,10);
clr_window(30,9,50,9);
writecd(' Are You Sure Y/N ',40,9);

setcolors(blue,white);
writed(key,31,8);  gotoxy(1,span);

rs:=#0+#0;
repeat   rs:=get_kbd_strokes;
until (upcase(rs[1])='Y') or (upcase(rs[1])='N') or (rs=ESC);

if upcase(rs[1])='Y' then are_you_sure:=true
                     else are_you_sure:=false;

 rs:=#0+#0; (* reset *)

end; (* end function *)

(*==========================================================================*)
(*=============== TSR MESSAGE /LOAD /UNLOAD /FAIL ETC.  ====================*)
(*==========================================================================*)

(*------- scrollbk main body message ------------*)
procedure scrollbk_main_body_message;
begin

writeln('(c) Copyright 1992. by David D. Cruger...........................');
writeln;
writeln('This product uses the TurborPower (tm) Ram-Resident library......');
writeln('and supports the TurboPower standard for Ram-Resident............');
writeln;

end; (* end procedure *)

(*------- unable to load scrollbk message -----------*)
procedure unable_to_load_scrollbk_message;
begin

setcolors(black,white);
writeln;
writeln('ScrollBk 1.0 has FAILED to LOAD..................................');
scrollbk_main_body_message;

end; (* end procedure *)

(*-------->>>> init tsr logo  <<<<------------*)
procedure init_tsr_logo;
begin

(*-- first log ------*)
inc(bl_num);
bl_log^[bl_num].data:='ScrollBk 1.0 is now INSTALLED....................................';
bl_log^[bl_num].marked:=true;
setcolors(black,white);
writeln;
writeln('ScrollBk 1.0 is now INSTALLED....................................');
scrollbk_main_body_message;
writeln('To Activate use hot keys (Alt-Ctrl-C)');
writeln('To Unload: /U');
writeln;

end; (* end procedure *)

(*------>>>  scrollbk already installed  <<<<--------*)
procedure scrollbk_already_installed;
begin

setcolors(black,white);
writeln;
writeln('ScrollBk ver 1.0 is ALREADY installed............................');
scrollbk_main_body_message;
writeln('To Activate use hot keys (Alt-Ctrl-C)');
writeln('To Unload: /U');
writeln;

end; (* end procedure *)

(*------>>>  unload scrollbk message  <<<<--------*)
procedure unload_scrollbk_message;
begin

setcolors(black,white);
writeln;
writeln('ScrollBk ver 1.0 Has been REMOVED ...............................');
scrollbk_main_body_message;

end; (* end procedure *)

(*------>>>  unload scrollbk failed message  <<<<--------*)
procedure unload_scrollbk_failed_message;
begin

setcolors(black,white);
writeln;
writeln('ScrollBk ver 1.0 Has FAILED to UNLOAD............................');
scrollbk_main_body_message;

end; (* end procedure *)

(*-------- scrollbk not installed -----------*)
procedure scrollbk_not_installed;
begin
  setcolors(black,white);
  writeln('ScrollBk 1.0 is NOT installed....................................');
  writeln('(c) Copyright 1992. by David D. Cruger...........................',#7);
  delay(1000);  halt(1);
end; (* end procedure *)

(*----- error msg ---------*)
function error_msg(ioerror: word; msg: st80): boolean;
begin
  if ioerror<>0 then
    begin
        writeln(msg+' I/O : ',ioerror);  error_msg:=true;
        delay(1000); (* pause *)
    end else error_msg:=false;

end; (* end function *)

(*------- zero interrupt counters ----------*)
procedure zero_int10h_counters;
begin

I10h_02:=0;  (* for testing *)
I10h_06:=0;
I10h_07:=0;
I10h_09:=0;
I10h_0A:=0;
I10h_0E:=0;
I10h_13:=0;

end; (* end procedure *)

(*------  save interrupt counter file ----------*)
procedure save_int10h_counter_file;
begin

{$i-} (* turn off io checking *)
assign(outc,path+'scrollbk.cnt');
rewrite(outc);
if error_msg(ioresult,'ERROR Creating counter file '+#7) then exit;

write(outc,I10h_02);
write(outc,I10h_06);
write(outc,I10h_07);
write(outc,I10h_09);
write(outc,I10h_0A);
write(outc,I10h_0E);
write(outc,I10h_13);

if error_msg(ioresult,'ERROR Writing counters '+#7) then exit;

close(outc);
if error_msg(ioresult,'ERROR Closing counter file '+#7) then exit;

end; (* end procedure *)

(*------  read interrupt counter file ----------*)
procedure read_int10h_counter_file;
begin

{$i-} (* turn off io checking *)
assign(outc,path+'scrollbk.cnt');
reset(outc);
if ioresult=0 then  (* if open ok then read else create new *)
  begin

   read(outc,I10h_02);
   read(outc,I10h_06);
   read(outc,I10h_07);
   read(outc,I10h_09);
   read(outc,I10h_0A);
   read(outc,I10h_0E);
   read(outc,I10h_13);
   if error_msg(ioresult,'ERROR Reading counters '+#7) then exit;

   close(outc);
   if error_msg(ioresult,'ERROR Closing counter file '+#7) then exit;

 end (* create *)
 else
 begin
    zero_int10h_counters;
    save_int10h_counter_file;
 end;

end; (* end procedure *)

(*---  open_buffer_log_file --------*)
procedure open_buffer_log_file;
begin

if (NOT Is_log_Open) then (* lets open it *)
  begin

    {$i-} (* turn off io log *)
    reset(inbuff);
    if ioresult<>0 then (* else create it *)
      begin
        rewrite(inbuff);
        if NOT error_msg(ioresult,'ERROR [SCROLLBK] during log create'+#7) then
         begin
         line1.data:=charfill(80,' ');
         line1.marked:=false;
         write(inbuff,line1); (* burn zero record *)
         Is_Log_Open:=true;
         end; (* if not error *)
      end; (* ioresult<>0 *)

    Is_Log_Open:=true;
    seek(inbuff,filesize(inbuff)); (* last record *)

  end; (* if open *)

 num_on_file:=filesize(inbuff)-1;

end; (* end procedure *)

(*---- close log file ------*)
procedure close_log_file;
begin

if Is_Log_Open then
{$i-} close(inbuff);
Is_Log_Open:=false;

end; (* end procedure *)

(*------ flush buffer to disk ---------*)
procedure flush_buffer_to_disk;
var z: byte;
begin

if NOT Is_Log_Open then  (* test if open *)
  open_buffer_log_file;

if bl_num>0 then (* flush *)
  begin
    seek(inbuff,filesize(inbuff)); (* goto end *)
    for z:=1 to bl_num do
      begin
        bl_log^[z].data:=buffer_left(80,bl_log^[z].data,' ');
        write(inbuff,bl_log^[z]);
        if error_msg(ioresult,'ERROR Flushing Log '+#7) then exit;
      end; (* z *)
    bl_num:=0;
  end (* bl_num>0 *)

end; (* end procedure *)

(*------  scrollbk exit routine ------------*)
{$f+} (* set far call on   *)
Procedure ScrollBk_Exit_Routine;
begin

 Exitproc:=Oldexitproc;             (* restore old exit procedure     *)
 dispose(bl_log);                   (* dispose on heap / buffer log   *)
 dispose(hold_screen);              (* dispose on heap / hold screen  *)

end; (* end procedure *)
{$f-} (* turn off far call *)

(*===========================================================================*)
(*================ INT 10H ISR ROUTINE / MONITOR SCREEN OUTPUT ==============*)
(*===========================================================================*)

(*------ new int 10h routine --------------*)
{$f+} (* set far call on   *)
Procedure New_Int_10h_Routine(BP: Word);
INTERRUPT;
var AH: byte; dummy: char;
    Int_Regs: IntRegisters absolute BP;
begin

(*----- use Int_regs to test ---------------*)
if log_screen_IO then     (* only log if turned ON  *)
 begin

  (*------ this is were all of the loging functions go -----*)
  AH:=Hi(Int_Regs.AX);  (* get high byte of AX *)
  dummy:=#0;

   case AH of (* test for which sub-function *)
     $02:begin  (* Int 10h function 02h/ Set Cursor Position *)
           inc(I10h_02);  (* for counts *)
         end; (* $02 *)
     $06:begin  (* Int 10h function 06h/ Scroll Up window *)
           inc(I10h_06);  (* for counts *)
         end; (* $06 *)
     $07:begin  (* Int 10h function 07h/ Scroll Dn window *)
           inc(I10h_07);  (* for counts *)
         end; (* $07 *)
     $09:begin  (* Int 10h function 09h/ Write Character/Attribute at Cursor *)
           inc(I10h_09);  (* for counts *)
           dummy:=char(Int_Regs.AL);
         end; (* $09 *)
     $0A:begin  (* Int 10h function 0Ah/ Write Character At Cursor *)
           inc(I10h_0A);  (* for counts *)
           dummy:=char(Int_Regs.AL);
         end; (* $0A *)
     $0E:begin  (* Int 10h function 0Eh/ Write Char in Teletype Mode *)
           inc(I10h_0E);  (* for counts *)
           dummy:=char(Int_Regs.AL);
         end; (* $0E *)
     $13:begin  (* Int 10h function 13h/ Write String in Teletype Mode *)
           inc(I10h_13);  (* for testing *)
           (*---- everything here goes throught 02h and 0Eh ---*)
         end; (* $13 *)
     end; (* case *)

     (*----- test if dummy<>#0 to add to log ----------*)
       if dummy<>#0 then (* continue *)
        if dummy<>#13 then (* continue *)
         if (dummy=#10) then CR_LF:=true else (* add to log line *)
           if dummy=#8 then dec(log_length) (* back space *)
                       else
                       begin
                         inc(log_length);
                         log_line[log_length]:=dummy;
                      end; (* <>#8 *)

     if (log_length>=80) or (CR_LF) then (* line feed / to log file *)
      begin
        inc(bl_num);
        if bl_num>=Max_Buffer then  (* if Internal buffer overflows log it *)
          begin
            bl_num:=Max_Buffer;
            log_line:='***ScrollBk--Buffer Overflow***';
            bl_log^[bl_num].marked:=true;
          end else bl_log^[bl_num].marked:=false;
        bl_log^[bl_num].data:=log_line;
        log_line:=''; CR_LF:=false;
      end; (* if log>80 or CR_LF *)

  end; (* only log if turned ON *)

ChainInt(Int_Regs,IsrArray[Int10hHandle].OrigAddr); (* now jump to old interrupt *)

end; (* end procedure *)
{$f-} (* turn off far call *)

(*==========================================================================*)
(*================== BASIC BUFFER  AND SCREEN DISPLAY  =====================*)
(*==========================================================================*)

(*--- display scrollbk headers ----------*)
procedure display_scrollbk_headers(clear: boolean);
begin

setcolors(black,white); window(1,1,80,25);
if clear then clrscr;  setcolors(white,black);
writed(buffer_left(67,' ScrollBk/ CopyRight(CR) 1992/ David D. Cruger/ Ver 1.0/ 12/02/91',' '),1,1);
writed(buffer_left(77,' Alt-L/ogging Toggle, C/ounters, '+#24+#25+', Pg-Up/Dn, ESC/Exit',' '),1,25);
setcolors(black,white); window(1,2,80,24);

end; (* end procedure *)

(*--- check top bottom file pointers -------*)
procedure check_top_bottom_file_pointers;
begin

 if top<=0 then
   begin
     bottom:=span;
       top:=1;
         bottom:=span;
           middle:=1;
             rec:=1;
   end; (* top<0 *)

 if bottom>num_on_file then
   begin
     top:=num_on_file-span+1;
       bottom:=num_on_file;
         middle:=span;
           rec:=num_on_file;
   end; (* bottom>num on file *)

end; (* end procedure *)

(*---- figure all file pointers --------*)
procedure figure_all_file_pointers;
begin

if num_on_file<23 then span:=num_on_file
                   else  span:=23;  (* this sets screen span        *)

 bottom:=num_on_file;           (* always start at bottom       *)
 top:=bottom-span+1;            (* set top marker               *)
 rec:=bottom;                   (* set current display rec      *)
 middle:=span;                  (* current or middle position   *)

end; (* end procedure *)

(*------ redisplay scrollbk page ----------*)
procedure redisplay_scrollbk_page(t,b: longint);
var z,y: longint;
begin

  setcolors(black,white);
  y:=1;                                (* set starting position           *)
  for z:=t to b do
    begin inc(y); (* next position *)
      seek(inbuff,z); read(inbuff,line1);    (* set next record                 *)
      if error_msg(ioresult,'ERROR Reading log'+#7) then rs:=esc+#0;
      if line1.marked then setcolors(white,blue) else setcolors(black,white);
      writed(line1.data,1,y);          (* write directory to video memory *)
      setcolors(black,white);
    end; (* z *)
end; (* end procedure *)

(*------ display interrupt counters ----------*)
procedure display_interrupt_counters;
var nstr: string[7];  x,y,x1,y1: byte;
begin

x:=60; y:=9;  x1:=x+18; y1:=y+8;
setcolors(blue,white); box_frame(x,y,x1,y1);
writed('Interrupt Cnts',x+2,y);
writed('Space/Clear',x+4,y1);
inc(x); inc(y); dec(x1); dec(y1);
window(x,y,x1,y1); clrscr;  window(1,2,80,24);
gotoxy(1,span);

repeat (* until rs[1]<>#32 space *)
x:=62; y:=10;
str(I10h_02:7,nstr);
writed('10h_02: '+nstr,x,y);  (* for testing *)
str(I10h_06:7,nstr); inc(y);
writed('10h_06: '+nstr,x,y);  (* for testing *)
str(I10h_07:7,nstr); inc(y);
writed('10h_07: '+nstr,x,y);  (* for testing *)
str(I10h_09:7,nstr); inc(y);
writed('10h_09: '+nstr,x,y);  (* for testing *)
str(I10h_0A:7,nstr); inc(y);
writed('10h_0A: '+nstr,x,y);  (* for testing *)
str(I10h_0E:7,nstr); inc(y);
writed('10h_0E: '+nstr,x,y);  (* for testing *)
str(I10h_13:7,nstr); inc(y);
writed('10h_13: '+nstr,x,y);  (* for testing *)

rs:=get_kbd_strokes;
if rs[1]=#32 then
  begin
    zero_int10h_counters;
    save_int10h_counter_file;
  end;

until rs[1]<>#32; (* space *)

setcolors(black,white);
rs:=#0+#0;

end; (* end procedure *)

(*------ view scrollbk buffer -------------*)
procedure view_scrollbk_buffer;
var  snum1,snum2: st5;  Marking_ON: boolean;
begin

  rs:=PgDn;   Marking_ON:=false;  (* preset                     *)

  repeat (* until esc *)
    if (rs=pgup) or
       (rs=pgdn) or   (* page dn *)
       (rs=ctrl_pgdn) or
       (rs=ctrl_pgup) or
       (rs=eend) or
       (rs=home) then redisplay_scrollbk_page(top,bottom);

       rs:=#0+#0; (* preset *)
       rec:=top+middle-1; (* set record *)

       (*---- display record number -------*)
       str(rec:5,snum1); str(num_on_file:5,snum2);
       snum1:=replace(snum1,' ','0');
       snum2:=replace(snum2,' ','0');
       line1.data:=' '+snum1+'/'+snum2+' ';
       setcolors(blue,white); writed(line1.data,68,1);

       (*----- display logging status ----*)
       case hold_log_status of
         true:begin
                setcolors(red,white); writed('ON ',78,25);
              end;
        false:begin
                setcolors(blue,white); writed('OFF',78,25);
              end;
           end; (* case *)

       seek(inbuff,rec); read(inbuff,line1); (* set next record *)

       setcolors(red,white);
       writed(line1.data,1,1+middle);           (* display line hightlight    *)
       gotoxy(1,span);                          (* cursor position            *)

       rs:=get_kbd_strokes;                     (* two scan codes             *)

       if (rs=uparrow) or (rs=downarrow) then    (* blank line/up/dn arrow     *)
         begin
           if line1.marked then setcolors(white,blue) else setcolors(black,white);
           writed(line1.data,1,1+middle);       (* display line no hightlight *)
           setcolors(black,white);
          end;

       if rs=downarrow then
         begin
           if rec<num_on_file then inc(middle);
           if middle>span then
             begin
               middle:=span;  inc(top); inc(bottom);
               check_top_bottom_file_pointers;
               gotoxy(79,span); writeln; (* kick a blank line/scroll up *)
             end; (* if middle>span *)
         end; (* downarrow *)

       if rs=uparrow then (* uparrow *)
         begin
           if rec>1 then dec(middle);
           if middle<1 then
             begin
               middle:=1; dec(top); dec(bottom);
               check_top_bottom_file_pointers;
               gotoxy(1,1); insline;  (* kick a blank line/scroll down *)
             end; (* if middle<1 *)
         end; (* uparrow   *)

       if rs=pgup then (* pgup *)
         begin
            dec(top,span); dec(bottom,span);
            check_top_bottom_file_pointers;
         end; (* page up *)

       if rs=pgdn then
         begin
            inc(top,span); inc(bottom,span);
            check_top_bottom_file_pointers;
         end; (* page down *)

       if rs=ctrl_pgup then
         begin
            dec(top,span*4); dec(bottom,span*4);
            check_top_bottom_file_pointers;
         end; (* ctrl (4) page up *)

       if rs=ctrl_pgdn then
         begin
            inc(top,span*4); inc(bottom,span*4);
            check_top_bottom_file_pointers;
         end; (* ctrl (4) page down *)

       if rs=home (* Home *) then
         begin
            top:=1; bottom:=span; middle:=1; rec:=1;
            check_top_bottom_file_pointers;
         end; (* home *)

       if rs=Eend then
         begin
            bottom:=num_on_file; top:=bottom-span+1; middle:=span;
            check_top_bottom_file_pointers;
         end; (* eend *)

      if rs=alt_l then (* toggle logging *)
        begin
           case hold_log_status of
               true:hold_log_status:=false;
              false:hold_log_status:=true;
                 end;
        end; (* alt_l *)

      if upcase(rs[1])='C' then (* test display counters *)
        begin
          display_interrupt_counters;
          redisplay_scrollbk_page(top,bottom);
          rs:=#0+#0;
        end; (* T *)

  until rs=ESC;  (* repeat until rs=ESC *)

end; (* end procedure *)

(*-------- unload scrollbk ---------*)
function Unload_Scrollbk: boolean;
var SaveRetVec: Pointer;
begin

Unload_Scrollbk:=false; (* preset *)
if SafeToDisable then
  begin

    (*-- Last log ------*)
    inc(bl_num);
    bl_log^[bl_num].data:='ScrollBk 1.0 has now been REMOVED................................';
    bl_log^[bl_num].marked:=true;
(*  save_int10h_counter_file;                 (* save interrupt counters    *)
    open_buffer_log_file;
    flush_buffer_to_disk;                     (* flush remaining buffer     *)
    close_log_file;                           (* close log file             *)

    unload_scrollbk_message;                  (* this is the unload msg     *)

    {save copy of current return vector}
    SaveRetVec := GetReturnVec($10);

    {set new return vector}
    SetVecOnReturn($10,IsrArray[Int10hHandle].OrigAddr);

    Unload_Scrollbk:=true;
    {try to disable the TSR}
    if DisableTSR then
      begin
        Remove_TSR:=true;                   (* Set to true                *)
        log_screen_IO:=false;               (* Stop any loging            *)
      end
    else
      begin
       Unload_Scrollbk:=false;
       {restore the previous return vector}
        SetVecOnReturn($10, SaveRetVec);
       {restore the previous ISR}
        Cur10:=nil;
        SetIntVec($10, Cur10);
        Remove_TSR:=false;                (* Cancel Remove TSR          *)
        log_screen_IO:=false;             (* Turn off loging            *)
        (*-- Last log ------*)
        inc(bl_num);
        bl_log^[bl_num].data:='ScrollBk 1.0 UNABLE to REMOVED......................................';
        bl_log^[bl_num].marked:=true;
        unload_scrollbk_failed_message;
      end; (* disable *)

   end; (* safe to disable *)

end; (* end procedure *)

{$f+} (* set far call on   *)

(*--------  Main POP UP procedure ------------*)
procedure Main_POP_UP_Procedure(var Regs: Registers);
begin

Popupsoff;                                  (* turn off popups              *)

 (*--- first set logging to false ---------*)
 hold_log_status:=log_screen_IO;            (* save this                    *)
 log_screen_IO:=false;                      (* turn off io when in POP UP   *)

       savescreen(hold_screen^);            (* save current screen          *)

       if NOT Is_Log_Open then              (* test to see if already open  *)
         open_buffer_log_file;              (* if not open file             *)
         flush_buffer_to_disk;              (* flush remaining buffer       *)
         close_log_file;                    (* close file                   *)
         save_int10h_counter_file;          (* save interrupt counters      *)
         open_buffer_log_file;              (* now open insures all writes  *)

            figure_all_file_pointers;       (* set view file pointers       *)
            display_scrollbk_headers(true); (* create display window        *)
            view_scrollbk_buffer;           (* view the buffer file         *)

         flush_buffer_to_disk;              (* flush remaining buffer       *)
         close_log_file;                    (* close file                   *)

       restorescreen(hold_screen^);         (* restore current screen       *)

 (*--- now set logging to true ---------*)
 log_screen_IO:=true;                       (* turn on io logging           *)
 log_screen_IO:=hold_log_status;            (* Restore this                 *)

Popupson;                                   (* turn on popups               *)

end; (* end procedure *)

(*-------- Timer Int ----------------*)
procedure TimerMonitor(BP : Word); interrupt;
var Regs : IntRegisters absolute BP;
begin
    EmulateInt(Regs,IsrArray[TimerHandle].OrigAddr);
    if (log_screen_IO) and (bl_num>0) then
      SetPopTicker(WriteLogHandle,36);
end; (* end procedure *)

(*--------  Main Timer POP UP procedure ------------*)
procedure Main_Timer_POP_UP_Procedure(var Regs: Registers);
begin

if bl_num>10 then  (* log must have at lease ten lines entered *)
  begin

     Popupsoff;                               (* turn off popups            *)

     (*--- first set logging to false ---------*)
      hold_log_status:=log_screen_IO;         (* save this                  *)
      log_screen_IO:=false;                   (* turn off io when in POP UP *)

      open_buffer_log_file;                   (* open log file for write    *)
      flush_buffer_to_disk;                   (* flush remaining buffer     *)
      close_log_file;                         (* close log file             *)

     (*--- now set logging to true ---------*)
      log_screen_IO:=true;                    (* turn on io logging         *)
      log_screen_IO:=hold_log_status;         (* Restore this               *)

     Popupson;                                (* turn on popups             *)

  end; (* if time to flush *)

end; (* end procedure *)

(*---- External_interface --------------*)
procedure External_Interface(BP : Word);
INTERRUPT;
var  Regs : IntRegisters absolute BP;
     SavePSP : Word;
begin

(*
 Options:
    AH='C' Display Interrupt Counters
    AH='F' Flush buffer and close file
    AH='G' Get logging status
         AL=1 logging is off
         AL=0 logging if on
    AH='L'
      subfunction
        AL='1' then turn logging off
        AL='0' then turn logging on
    AH='U' Unload TSR
*)

    InterruptsOn;
    PopupsOff;                              (* turn off popups            *)
    hold_log_status:=log_screen_IO;         (* hold status                *)

      (*----- display interrupt counters -------------*)
      if Regs.AH=ord('C') then
          display_interrupt_counters;

      (*----- do we try to open/flush and close --------*)
      if Regs.AH=ord('F') then
        begin
            open_buffer_log_file;           (* open log file for write    *)
            flush_buffer_to_disk;           (* flush remaining buffer     *)
            close_log_file;                 (* close log file             *)
            save_int10h_counter_file;       (* save interrupt counters    *)
            log_screen_IO:=false;
        end; (* F *)

      (*----- get logging status --------*)
      if Regs.AH=ord('G') then
        begin
           (* 1=off  0=on *)
           case log_screen_IO of
             true:Regs.AL:=0; (* on  *)
            false:Regs.AL:=1; (* off *)
              end; (* case *)
        end; (* G *)

      (*----- turn off logging --------*)
      if Regs.AH=ord('L') then
        begin
           (* 1=off  0=on *)
           if Regs.AL=ord('1') then log_screen_IO:=false
          else
           if Regs.AL=ord('0') then log_screen_IO:=true;
        end; (* L *)

      (*----- do we try to unload --------*)
      if Regs.AH=ord('U') then
        begin

            log_screen_IO:=false;           (* turn off io when in POP UP *)
            SavePSP := GetPSP;              (* Save Current PSP           *)

            SetPSP(PrefixSeg);              (* Switch back to our PSP     *)

            Regs.AL:=Ord(Unload_Scrollbk);  (* Try to Unload Scrollbk     *)
            if Regs.AL = 1 then
               log_screen_IO:=false;

            SetPSP(SavePSP);                (* Switch back to previous PSP *)

          end; (* U *)

PopupsOn; (* inable popups *)

end; (* end procedure *)

{$f-} (* set far call off  *)

(*--------- unload program from command line -----------*)
procedure unload_from_command_line;
var prog_ptr: ifcptr;  Regs: IntRegisters;
begin
(*
   Command Line Parameters:  /A    Append to Scrollkb buffer. (default)
                             /LON  Toggle Logging On
                             /LOFF Toggle Logging Off
                             /O    Overwrite Scrollbk buffer. (start new)
                             /U    Unload Scrollbk program.
*)
if paramcount=1 then
  begin

  prog_ptr:=moduleptrbyname(program_name); (* test if program already loaded *)

    (*
      append realy does not have an effect if already loaded nothing
      to do if not loaded the default is append
    *)

    if (pos('/A',paramstr(1))>0) or   (* append    *)
       (pos('/a',paramstr(1))>0) then delay(100); (* this is the default *)

    if (pos('/O',paramstr(1))>0) or   (* overwrite *)
       (pos('/o',paramstr(1))>0) then
       begin
         open_buffer_log_file;               (* open log file for write     *)
           rewrite(inbuff);                  (* clears file                 *)
         close_log_file;                     (* close log file              *)
         if prog_ptr<>nil then               (* check if program is loaded  *)
           begin (* if yes just zero and do not load *)
              writeln('Scrollbk 1.0 Buffer file zeroed');
              halt(0);                       (* program already loaded zero *)
           end; (* <> nil let program load *)
       end; (* overwrite *)

    if (pos('/LON',paramstr(1))>0) or (* toggle logging on *)
       (pos('/lon',paramstr(1))>0) then
         begin
           if prog_ptr<>nil then  (* check to see if program is resident *)
             begin
               Regs.AH:=Ord('L');    (* logging function   *)
               Regs.AL:=Ord('0');    (* 0=on               *)
               EmulateInt(regs,prog_ptr^.CmdEntryPtr);
               writeln('Scrollbk 1.0 loging ON');
               halt(0);
             end else scrollbk_not_installed; (* <>nil *)
         end; (* toggle loging ON  *)

    if (pos('/LOFF',paramstr(1))>0) or (* toggle logging off *)
       (pos('/loff',paramstr(1))>0) then
         begin
           if prog_ptr<>nil then  (* check to see if program is resident *)
             begin
               Regs.AH:=Ord('L');    (* logging function   *)
               Regs.AL:=Ord('1');    (* 1=off              *)
               EmulateInt(regs,prog_ptr^.CmdEntryPtr);
               writeln('Scrollbk 1.0 loging OFF');
               halt(0);
             end else scrollbk_not_installed; (* <>nil *)
         end; (* toggle loging OFF  *)

    if (pos('/U',paramstr(1))>0) or (* try to unload program *)
       (pos('/u',paramstr(1))>0) then
         begin
           if prog_ptr<>nil then  (* check to see if program is resident *)
             begin
               RestoreAllVectors;    (* restore everything *)
               Regs.AH:=Ord('U');
               EmulateInt(regs,prog_ptr^.CmdEntryPtr);
               (*---- NO NEED TO DISPLAY ANY MESSAGE MAIN PROGRAM WILL ---*)
               halt(0);
             end else scrollbk_not_installed; (* <>nil *)
          end; (* try to unload *)

  end; (* if paramcount=1 *)

end; (* end procedure *)

(*--------  main program ---------*)
begin

{$i-}                                (* turn off io checking              *)
Filemode:=$42;                       (* set everything free for all       *)
OldExitProc:=ExitProc;               (* Save old exit procedure           *)
ExitProc:=@ScrollBk_Exit_Routine;    (* Set our exit routine in place     *)
Int10hHandle:=17;                    (* Set 10h interrupt handle          *)
TimerHandle:=18;                     (* Set Timer handle to 18            *)
getdir(0,path); path:=path+'\';      (* get current directory             *)
Log_Name:=path+'scrollbk.bfr';       (* set buffer name (disk)            *)
zero_int10h_counters;                (* sets all counters to zero         *)
read_int10h_counter_file;            (* load counters from file           *)
assign(inbuff,Log_Name);             (* assign file handle name           *)
new(bl_log);                         (* create on heap / buffer log       *)
new(hold_screen);                    (* create on heap / hold screen      *)
Is_Log_Open:=false;                  (* set on when log is open           *)
log_screen_IO:=false;                (* turn off all loging at start      *)
LineFeed:=false;                     (* start out linefeed checking       *)
line1.data:=''; log_line:='';        (* preset                            *)

for bl_num:=1 to Max_Buffer do
  begin
     bl_log^[bl_num].data:='';       (* zero out                          *)
     bl_log^[bl_num].marked:=false;  (* zero out                          *)
  end;

unload_from_command_line;  (* if /u or /U *)

bl_num:=0;
setcolors(black,white); clrscr;

if moduleinstalled(program_name) then
  begin
       scrollbk_already_installed;
       halt(1);
  end;

  (*--- install program name ----*)
  installmodule(program_name,@External_Interface);
  open_buffer_log_file;                (* creates and opens log file       *)
  figure_all_file_pointers;            (* sets viewing pointers            *)
  close_log_file;                      (* closes files                     *)

if InitVector($1C,TimerHandle,@TimerMonitor)  and
   InitVector($10,Int10hHandle,@New_Int_10h_Routine) and
   DefinePop(hotkey,Main_POP_UP_Procedure,@PopUpStack[Alt_Stack_Size],WaitforDos) and
   DefinePopProc(WriteLogHandle,Main_Timer_POP_UP_Procedure,@TimerStack[Alt_Stack_Size]) then
 begin
   log_screen_IO:=true; (* turn on *)
   remove_tsr:=false;   (* false   *)
   error_code:=0;       (* reset   *)
   init_tsr_logo;
   PopUpsOn;  (* Enables popups *)
   StayRes(paragraphstokeep,error_code);
   writeln;
   writeln('Error Code:=',error_code);
   writeln;
 end;

 RestoreAllVectors; (* just in case some were loaded *)

 unable_to_load_scrollbk_message;

end.
