{$A+,B-,D+,E+,F+,I-,L-,N-,O-,R-,S-,V-}
{$M 1024,60000,60000}
program LZH_Test;
uses
  LZH;
var
  infile,outfile: file;
  s: String[60];
  Hufmode : boolean;

  procedure Error (msg: String);
  begin
    writeln(msg);
    HALT(1)
  end;

{$F+}

  procedure ReadNextBlock; {This routine handles reading of input data}

  begin
    If Hufmode then write(LZHMem^.textsize,#13);
    LZHMem^.inptr:= 0;
    BlockRead(infile,LZHMem^.inbuf,sizeof(LZHMem^.inbuf),LZHMem^.inend);
    if IoResult>0 then Error('! Error reading input file');
  end;

  procedure WriteNextBlock; {This routine handles reading of output data}
  var
    wr: word;
  begin
    BlockWrite(outfile,LZHMem^.outbuf,LZHMem^.outptr,wr);
    If Not Hufmode then write(LZHMem^.count,#13);
    if (IoResult>0) or (wr<LZHMem^.outptr) then
      Error('! Error writing output file');
    LZHMem^.outptr:= 0;
  end;

  procedure OpenInput (fn: String);
  begin
    assign(infile,fn); reset(infile,1);
    if IoResult>0 then Error('! Can''t open input file');
  end;

  procedure OpenOutput (fn: String);
  begin

    assign(outfile,fn); rewrite(outfile,1);
    if IoResult>0 then Error('! Can''t open output file');
    LZHMem^.outend:= sizeof(LZHMem^.Outbuf);
    LZHMem^.outptr:= 0;
  end;

Var
   test : Word;
   RData  : Byte;

begin
     Hufmode := false;
     Writeln ('Huffman Compression Engine v',EngineVer);
     if ParamCount<>3 then begin
        writeln('Usage: lz e(compression)|d(uncompression) infile outfile');
        HALT(1);
     end;
     WriteFromBuffer:= WriteNextBlock;
     ReadToBuffer:= ReadNextBlock;
     InitLZH;    {This routine should be called before any LZHMem calls}
     OpenInput(ParamStr(2));
     OpenOutput(ParamStr(3));
     s:= ParamStr(1);
     case s[1] of
          'e','E': Begin
                        Hufmode := true;
                        LZHMem^.Ebytes:= filesize(infile);
                        Writeln (LZHMem^.Ebytes);
                        Encode;     {Call black box routine to compress}
                        writeln('input:  ',LZHMem^.textsize,' bytes');
                        writeln('output: ',LZHMem^.codesize,' bytes');
                        writeln('compression: ',LZHMem^.textsize*100 DIV LZHMem^.codesize,'%');

                        End;
     'd','D': Decode   {Call black box routine to decompress}
   else
     Error('! Use [D] for Decompression or [E] for Compression')
   end;
   close(infile); if IoResult>0 then Error('! Error closing input file');
   close(outfile); if IoResult>0 then Error('! Error closing output file');
   DInitLZH;


   end.
