{      program: DISAP1
       disappearing input-line and radiobuttons

       solution by steve schafer
       program by august quint
}
 
{$X+}
program DisappearingInputLineDemo;

uses
    Objects,Views,Dialogs,App;

type
    PDemo = ^TDemo;
    TDemo = object (TApplication)
       constructor Init;
    end;

(* RadioButtons, disabling or enabling other objects: *)
    PLinkedRadioButtons = ^TLinkedRadioButtons;
    TLinkedRadioButtons = object (TRadioButtons)
       Link_IL : PView;
       Link_RB : array [1..5] of PView;
       procedure MovedTo (    Item: Integer); virtual;
       procedure Press   (    Item: Integer); virtual;
       constructor Init  (var Bounds: TRect;
                              AStrings : PSItem;
                              ALink0,
                              ALink1, ALink2, ALink3, ALink4, ALink5 : PView);
       procedure  ShowDependents;
    end;


constructor TDemo.Init;
var
    Dialog           : PDialog;
    Disap_InputLine  : PInputLine;
    Rectangle        : TRect;
    Button           : PButton;
    SpecRadioButtons : PLinkedRadioButtons;
    StdRadioButtons,
    Disap_RB_1,
    Disap_RB_2,
    Disap_RB_3,
    Disap_RB_4,
    Disap_RB_5       : PRadioButtons;
    Text             : PStaticText;
    LabelText        : PLabel;
    RetCode          : Word;
begin
    TApplication.Init;

    Rectangle.Assign(2,1,77,20);
    Dialog := New(PDialog,Init(Rectangle,'enter printer-data'));

    Rectangle.Assign(3,9,34,10);
    Text := New(PStaticText,Init(Rectangle,'printer connected via COMx:'));
    Dialog^.Insert(Text);

    Rectangle.Assign(3,2,27,5);
    StdRadioButtons := New(PRadioButtons,Init(Rectangle,
                           NewSItem('IBM-GraphicPrinter',
                           NewSItem('HP LaserJet II/III',
                           NewSItem('Epson FX80',nil)))));
    Rectangle.Assign(2,1,20,2);
    LabelText := New(PLabel,Init(Rectangle,'type of printer:',StdRadioButtons));
    Dialog^.Insert(LabelText);
    Dialog^.Insert(StdRadioButtons);

    Rectangle.Assign(45,8,72,9);
    Disap_InputLine := New(PInputLine,Init(Rectangle,64));
    Rectangle.Assign(45,7,69,8);
    LabelText := New(PLabel,Init(Rectangle,'if output in file:',Disap_InputLine));
    Dialog^.Insert(LabelText);
(*  do not Insert here! *)

    Rectangle.Assign(13,10,73,11);
    Disap_RB_1 := New(PRadioButtons,Init(Rectangle,
                      NewSItem(' 300',
                      NewSItem(' 600',
                      NewSItem('1200',
                      NewSItem('2400',
                      NewSItem('4800',
                      NewSItem('9600',nil))))))));
    Disap_RB_1^.Value := 5;
    Disap_RB_1^.Sel := 5;
    Rectangle.Assign(2,10,13,11);
    LabelText := New(PLabel,Init(Rectangle,'baud:',Disap_RB_1));
    Dialog^.Insert(LabelText);
(*  do not Insert here! *)

    Rectangle.Assign(19,11,45,12);
    Disap_RB_2 := New(PRadioButtons,Init(Rectangle,
                      NewSItem('8 bits  ',
                      NewSItem('7 bits',nil))));
    Rectangle.Assign(2,11,9,12);
    LabelText := New(PLabel,Init(Rectangle,'data:',Disap_RB_2));
    Dialog^.Insert(LabelText);
(*  do not Insert here! *)

    Rectangle.Assign(19,12,45,13);
    Disap_RB_3 := New(PRadioButtons,Init(Rectangle,
                      NewSItem('1 bit   ',
                      NewSItem('2 bits',nil))));
    Rectangle.Assign(2,12,8,13);
    LabelText := New(PLabel,Init(Rectangle,'stop:',Disap_RB_3));
    Dialog^.Insert(LabelText);
(*  do not Insert here! *)

    Rectangle.Assign(19,13,43,14);
    Disap_RB_4 := New(PRadioButtons,Init(Rectangle,
                      NewSItem('odd     ',
                      NewSItem('even',nil))));
    Rectangle.Assign(2,13,10,14);
    LabelText := New(PLabel,Init(Rectangle,'parity:',Disap_RB_4));
    Dialog^.Insert(LabelText);
(*  do not Insert here! *)

    Rectangle.Assign(19,14,42,15);
    Disap_RB_5 := New(PRadioButtons,Init(Rectangle,
                      NewSItem('XON/XOFF',
                      NewSItem('DTR',nil))));
    Rectangle.Assign(2,14,16,15);
    LabelText := New(PLabel,Init(Rectangle,'flow control:',Disap_RB_5));
    Dialog^.Insert(LabelText);
(*  do not Insert here! *)

    Rectangle.Assign(33,2,45,9);
    SpecRadioButtons := New(PLinkedRadioButtons,Init(Rectangle,
                            NewSItem('LPT 1',
                            NewSItem('LPT 2',
                            NewSItem('COM 1',
                            NewSItem('COM 2',
                            NewSItem('COM 3',
                            NewSItem('COM 4',
                            NewSItem('File:',nil))))))),
                            Disap_InputLine,
                            Disap_RB_1, Disap_RB_2, Disap_RB_3, Disap_RB_4, Disap_RB_5));
    Rectangle.Assign(31,1,47,2);
    LabelText := New(PLabel,Init(Rectangle,'outputting via:',SpecRadioButtons));
    SpecRadioButtons^.Value := 0;
    SpecRadioButtons^.Sel   := 0;
    Dialog^.Insert(LabelText);
    Dialog^.Insert(SpecRadioButtons);

(*  Insert here: we want the right order of the objects *)
    Dialog^.Insert(Disap_InputLine);
    Dialog^.Insert(Disap_RB_1);
    Dialog^.Insert(Disap_RB_2);
    Dialog^.Insert(Disap_RB_3);
    Dialog^.Insert(Disap_RB_4);
    Dialog^.Insert(Disap_RB_5);
    SpecRadioButtons^.ShowDependents;

    Rectangle.Assign(13,16,21,18);
    Button := New(PButton,Init(Rectangle,'O~K~',cmOK,bfDefault));
    Button^.AmDefault := True;
    Dialog^.Insert(Button);

    Rectangle.Assign(48,16,60,18);
    Button := New(PButton,Init(Rectangle,'Cancel',cmCancel,bfNormal));
    Dialog^.Insert(Button);

    Dialog^.SelectNext(False);
    RetCode := DeskTop^.ExecView(Dialog);

    Dispose(Dialog,Done);
end;


(*                                                                    *)
(*       the RadioButtons with the link to other objects              *)
(*                                                                    *)
(*       create object and save the links                             *)
(*                                                                    *)
constructor TLinkedRadioButtons.Init (var Bounds: TRect; AStrings : PSItem;
                                          ALink0,
                                          ALink1, ALink2, ALink3,
                                          ALink4, ALink5          : PView);
begin
    TRadioButtons.Init (Bounds, AStrings);
    Link_IL := ALink0;
    Link_RB[1] := ALink1;
    Link_RB[2] := ALink2;
    Link_RB[3] := ALink3;
    Link_RB[4] := ALink4;
    Link_RB[5] := ALink5;
end;
(*                                                                    *)
(*       selection is moved                                           *)
(*                                                                    *)
procedure TLinkedRadioButtons.MovedTo (Item: Integer);
begin
    TRadioButtons.MovedTo (Item);
    ShowDependents;
end;
(*                                                                    *)
(*       a button is pressed                                          *)
(*                                                                    *)
procedure TLinkedRadioButtons.Press (Item: Integer);
begin
    TRadioButtons.Press (Item);
    ShowDependents;
end;
(*                                                                    *)
(*       depending on the selection: show or hide the linked objects  *)
(*                                                                    *)
procedure TLinkedRadioButtons.ShowDependents;
  procedure HideLinkedRadioButtons;
  var
      i : integer;
  begin
      for i:=1 to 5 do
          Link_RB[i]^.Hide;
  end;
  procedure ShowLinkedRadioButtons;
  var
      i : integer;
  begin
      for i:=1 to 5 do
          Link_RB[i]^.Show;
  end;
begin
    case Value of
      0,
      1 : begin
              Link_IL^.Hide;
              HideLinkedRadioButtons;
          end;
      2,
      3,
      4,
      5 : begin
              Link_IL^.Hide;
              ShowLinkedRadioButtons;
          end;
      6 : begin
              Link_IL^.Show;
              HideLinkedRadioButtons;
          end;
    end;
    Select;
end;


var
    Demo: TDemo;

begin
    Demo.Init;
    Demo.Run;
    Demo.Done;
end.
