


TIN(1)                           LOCAL                            TIN(1)



NAME
     tin, rtin, cdtin, tind - A threaded Netnews reader

SYNOPSIS
     tin/rtin/cdtin/tind [ options ] [ newsgroups ]

DESCRIPTION
     Tin is a full-screen easy to use threaded Netnews reader. It
     can  read  news  locally  (i.e. /usr/spool/news) or remotely
     (rtin or tin -r option) via a NNTP (Network  News  Transport
     Protocol)  server.   Cdtin  can  read  news locally and news
     archived on CD-ROM. It will automatically utilize nov  (news
     overview)  style index files if available locally or via the
     nntp xover command.

     Tin has five separate levels of operation:  Group  selection
     level,  Spooldir  selection level, Group level, Thread level
     and Article level.  Use the 'h' (help)  command  to  view  a
     list of the commands available at a particular level.

     On startup tin will show a list of the newsgroups  found  in
     $HOME/.newsrc.  An  arrow '->' or highlighted bar will point
     to the first  newsgroup.  Move  to  a  group  by  using  the
     terminal  arrow  keys  (terminal  dependent) or 'j' and 'k'.
     Use PgUp/PgDn (terminal dependent) or Ctrl-U and  Ctrl-D  to
     page up/down.  Enter a newsgroup by pressing RETURN.

     The TAB key advances  to  the  next  newsgroup  with  unread
     articles and enters it.

OPTIONS
     -c          create/update index files  for  every  group  in
                 $HOME/.newsrc or file specified by -f option and
                 mark all articles as read.

     -f file     use  the  specified  file   of   subscribed   to
                 newsgroups in place of $HOME/.newsrc.

     -h          help listing all command line options.

     -H          brief introduction to tin that is also shown the
                 first time it is started.

     -I dir      directory in  which  to  store  newsgroup  index
                 files.  Default is $HOME/.tin/.index.

     -m dir      mailbox   directory   to   use.    Default    is
                 $HOME/Mail.

     -M user     mail unread articles to specified user for later
                 reading.   For  more  information  read  section
                 Automatic Mailing and Saving New News.



August 20, 1993       Last change: Version 1.2 PL1                     1






TIN(1)                           LOCAL                            TIN(1)



     -p program  print program with options.

     -q          quick start without checking for new newsgroups.

     -P          purge group index  files  of  articles  that  no
                 longer  exist.  Care  should be taken when using
                 this command as it stats each and every  article
                 in  each  group that is accessed. On a low speed
                 connection this can have an  undisirable  effect
                 and   it  also  knocks  the  hell  out  of  your
                 filesystem.

     -r          read news remotely from the default NNTP  server
                 specified in the environment variable NNTPSERVER
                 or contained in the file /etc/nntpserver.

     -R          read  news  saved  by   -S   option   (not   yet
                 implemented).

     -s dir      save  articles   to   directory.    Default   is
                 $HOME/News.

     -S          save unread articles for  later  reading  by  -R
                 option.    For  more  information  read  section
                 Automatic Mailing and Saving New News.

     -u          create/update index files  for  every  group  in
                 $HOME/.newsrc  or  file  specified by -f option.
                 This option is disabled  if  tin  retreives  its
                 index files via a NNTP server.

     -U          start tin in  the  background  to  update  index
                 files  while  reading  news  in  the foreground.
                 This option is disabled  if  tin  retreives  its
                 index files via a NNTP server.

     -v          verbose mode for -c -M -S -u and -Z options.

     -w          quick mode to post an article and then exit.

     -z          only start tin if there is any new/unread  news.
                 If  there  is  news  tin will position cursor at
                 first group with unread news. Useful for putting
                 in login file.

     -Z          check if there is any new/unread news  and  exit
                 with   appropriate  status.   If  -v  option  is
                 specified the number of unread articles in  each
                 group  is  printed.  An exit code 0 indicates no
                 news, 1  that  an  error  occurred  and  2  that
                 new/unread  news  exists.   Useful  for  writing
                 scripts.



August 20, 1993       Last change: Version 1.2 PL1                     2






TIN(1)                           LOCAL                            TIN(1)



     Tin can also dynamically change its options by the 'M'  menu
     command.  Any changes are written to $HOME/.tin/tinrc.

     The index daemon version, tind, only supports the -f, -h, -I
     and -v options.

INDEX FILES
     In order to keep track of threads, tin  maintains  an  index
     for  each  newsgroup. There are a number of methods in which
     index files can be created and updated.

     The simplest method is that each user creates/updates  there
     own  index  files that are stored in $HOME/.tin/.index. This
     has the advantage that any user can compile and install tin,
     but  the  disadvantage  is  that  each  user  is going to be
     creating duplicate files and using precious disk  space.   A
     good  way  to  keep index files updated is by doing a tin -U
     that will update index files in the background while you are
     reading  news  in  the foreground. You can also update index
     files via the system batcher cron with the -u option:
          30 6 * * * /usr/local/bin/tin -u

     A slightly better method is to set tin setuid news and  have
     all  index  files  created  and  updated  in  the news spool
     directory  (i.e.  /usr/spool/news/.index).  This   has   the
     advantage  that  there  will  only  be one copy of the index
     files on each machine on your network, but the  disadvantage
     is that you will have tin running setuid news.

     A better method is to install the tind index  file  updating
     daemon  and  have  it  create and update index files for all
     groups in your active file at regular intervals in the  news
     spool  directory (i.e. /usr/spool/news/.index). This has the
     advantage that there will only be  one  copy  of  the  index
     files  on  each  machine on your network and tin must not be
     setuid news, but the disadvantage is that you will  have  to
     have  news  permissions to install tind and root permissions
     to install an entry in the cron batcher system to have  tind
     regularly update index files.

     The best method is to install the tind index  file  updating
     daemon  on  your  NNTP  server and have it create and update
     index files for all groups in your active  file  at  regular
     intervals    in    the    news    spool    directory   (i.e.
     /usr/spool/news/.index).  This has the advantage that  there
     will  only be one copy of the index files on the NNTP server
     for the whole of your network, but the disadvantage is  that
     you will have to install my NNTP server patches to allow tin
     to retreive index file from your NNTP  server  and  and  you
     must  install  an  entry  in the cron batcher system to have
     tind regularly update index files (note  that  this  is  the
     method  we use on our network of 40-50 machines and have not



August 20, 1993       Last change: Version 1.2 PL1                     3






TIN(1)                           LOCAL                            TIN(1)



     had any problems).

     Entering a group the first time tends to be slow because the
     index file must be built from scratch unless the tind update
     daemon is being used. To alleviate the slowness start tin to
     create  all index files for the groups you subscribe to with
     tin -u -v and go for a  coffee.  Subsequent  readings  of  a
     group will cause incremental updating of the index file.

     If reading news remotely and locally  updating  index  files
     operation  will be somewhat slower because the articles must
     be retreived from the NNTP server.

NEWS ADMINISTRATION
     Maintaining Netnews on large networks of machines can  be  a
     pretty  time  consuming job as I discovered when I was given
     the job of maintaining our news system and news users.

     Tin is a News User Agent and  so  most  of  the  users  were
     always  asking  questions  or  doing  things  that  could be
     frowned upon by there departments.  To releive  news  admins
     (and especially me) of this features have been added to make
     life easier for news adminstrators.

     When a user starts tin it is possible to inform them of  any
     important  changes/information concerning the news system by
     displaying a message of the day (motd) file. The  motd  file
     should   be   created  in  your  news  lib  directory  (i.e.
     /usr/lib/news/motd) and should have file permissions set  to
     0644.  The  motd file will only be displayed if its contents
     is newer than the last time the user started tin. If reading
     news  via NNTP my XMOTD patch will have to have been applied
     to your NNTP server.

     A user starting tin for the first time can be  automatically
     subscribed   to   a  list  of  newsgroups  that  are  deemed
     appropriate by the  news  administrator.  At  our  site  the
     subscriptions  file has 125 groups (our active file contains
     over 400 groups with many only being marginally  interesting
     to  most  people).  The subscriptions file should be created
     in      your      news       lib       directory       (i.e.
     /usr/lib/news/subscriptions)    and    should    have   file
     permissions set to 0644. If reading news via  NNTP  my  LIST
     SUBSCRIPTIONS  patch  will have to have been applied to your
     NNTP server.

     If my NNTP XUSER patch has been applied to your NNTP  server
     you  will  be  able  to log the username and machine to your
     NNTP logfile for usage statistics.

SCREEN FORMAT
     Tin has five separate levels of operation:  Group  selection



August 20, 1993       Last change: Version 1.2 PL1                     4






TIN(1)                           LOCAL                            TIN(1)



     level,  Spooldir  selection level, Group level, Thread level
     and Article level.

     At the Group Selection level the title displays  the  number
     of  subscribed  groups.  The newsgroups are displayed on the
     left of the  screen  with  the  number  of  unread  articles
     displayed on the same line in the middle of the screen.
               <Selection Num> <Newsgroup> <Num of unread articles>
          i.e.,
               1  alt.sources            10
               2  comp.sources.misc      3
               3  news.software.readers  12

     At the Group level the title contains the name of the group,
     the  number  of  conversation  threads  and  total number of
     articles i.e., alt.sources (7 23).  If the  group  has  been
     setup  not  to  thread  articles  (i.e.,  alt.sources  is in
     $(HOME)/.tin/unthread) the title will be alt.sources (U 23).
     There are two possible display formats as shown below:
               <Selection Num> <Unread> <Responses> <Subject> <Author>
          i.e.,
               1   +   3   Bnews sources?      iain@anl433.uucp
               2       1   This question has   ether@net
          or
               <Selection Num> <Unread> <Responses> <Subject (longer)>
          i.e.,
               1   +   3   Bnews sources?
               2       1   This question has a longer subject line

     At the Article level  the  page  header  has  the  following
     format:
               <Date posted> <Newsgroup>    <Thread 1 of n>
               <Article Num> <Subject>      <Num of responses in thread>
               <Author>                     <Organization>

               <Article body>
          i.e.,
               24 Jul 15:20:03 GMT   alt.sources      Thread 1 of 2
               Article 452           Bnews sources?   3 responses
               iain@anl433.uucp                       Organization name

               <Article boby>

COMMON MOVING KEYS
     This table shows the common keys/commands for moving at  all
     five levels within tin.
                                     ansi/at386/vt100  Other Terminals
          Beginning of list/article  Home              1 (^R or g at article level)
          End of list/article        End               $ (also G at article level)
          Page Up                    PgUp              ^U or ^B or b
          Page Down                  PgDn              ^D or ^F or <SPACE>
          Line Up                    Up arrow          k (not at article level)



August 20, 1993       Last change: Version 1.2 PL1                     5






TIN(1)                           LOCAL                            TIN(1)



          Line Down                  Down arrow        j (not at article level)

COMMON EDITING COMMANDS
     An emacs style editing package allows the  easy  editing  of
     input  strings.   An  history  list allows the easy reuse of
     previously entered  strings.   The  following  commands  are
     available when editing a string:

     ^A,^E     move to beginning or end of line, respectively.

     ^F,^B     nondestructive move forward or back one  location,
               respectively.

     ^D        delete the character currently under  the  cursor,
               or send EOF if no characters in the buffer.

     ^H,<DEL>  delete character left of the cursor.

     ^K        delete from cursor to end of line.

     ^P,^N     move   through   history,   previous   and   next,
               respectively.

     ^L,^R     redraw the current line.

     <CR>      places line on history list if  nonblank,  appends
               newline and returns to the caller.

     <ESC>     aborts the present editing operation.

NEWSGROUP SELECTION COMMANDS
     4         Select group 4.

     ^K        Delete current group from $HOME/.newsrc file.

     ^L        Redraw page.

     ^R        Reset $HOME/.newsrc file.

     <CR>      Read current group.

     <TAB>     View next group with unread news. Will wrap around
               to  the  beginning  of  the  group  selection list
               looking for unread groups.

     c         Mark current group as all read  with  confirmation
               and goto next group in group selection list.

     C         Mark current group  as  all  read  and  goto  next
               unread group in group selection list.

     d         Toggle display to show just the groupname  or  the



August 20, 1993       Last change: Version 1.2 PL1                     6






TIN(1)                           LOCAL                            TIN(1)



               groupname and the groups description.

     g         Choose a new group by name.  The position  of  the
               group  within  the  group  list will also be asked
               for.  By entering '1' the new group  will  be  the
               first group in the displayed list, by entering '8'
               the group will be the eighth  group  in  the  list
               etc.   By  entering '$' the group will be the last
               group displayed.

     h         Help screen of newsgroup selection commands.

     H         Toggle the display of help mini menu at the bottom
               of the screen.

     I         Toggle inverse video.

     l         List and allow selection of  the  available  spool
               directories.   This  feature  requires  a  special
               library to be linked  with  tin  to  create  cdtin
               which  can then read news from an active news feed
               and also from multiple CD-ROMs.

     m         Move the current group within the group  selection
               list.   By  entering '1' the group will become the
               first displayed group in the list, by entering '8'
               the eighth group in the list etc.  By entering '$'
               the group will be the last group displayed.

     M         User   configurable   options   menu   (for   more
               information see section Options Menu).

     q         Quit tin.

     Q         Quit tin.

     r         Toggle display of all  subscribed  to  groups  and
               just  the  subscribed  to groups containing unread
               articles. Command has no  effect  if  groups  were
               read from the command line when tin was started.

     R         Mail a bug report or comment to the author.   This
               is the best way of getting bugs fixed and features
               added/changed.

     s         Subscribe to current group.

     S         Subscribe  to  groups  matching   user   specified
               pattern.

     u         Unsubscribe to current group.




August 20, 1993       Last change: Version 1.2 PL1                     7






TIN(1)                           LOCAL                            TIN(1)



     U         Unsubscribe  to  groups  matching  user  specified
               pattern.

     v         Print tin version information.

     w         Post an article to current group.

     W         List articles posted by user.   The  date  posted,
               the newsgroup and the subject are listed.

     y         The first time this command is called it will yank
               in  all groups from $LIBDIR/active that are not in
               $HOME/.newsrc.   After  any   groups   have   been
               subscribed/unsubscribed   to,   this   command  if
               pressed  again  will  reread   $HOME/.newsrc   and
               display only the subscribed groups.

     Y         Reread the active file to see if any new news  has
               arrived since starting tin.

     z         Mark all articles in the current group as unread.

     Z         Undelete previously deleted group  by  ^K  command
               from $HOME/.newsrc.

     /         Group forward search.

     ?         Group backward search.

SPOOL DIRECTORY SELECTION COMMANDS
     4         Select spool directory 4.

     ^L        Redraw page.

     <CR>      Read news from selected spool directory.

     h         Help screen of spool directory selection commands.

     H         Toggle the display of help mini menu at the bottom
               of the screen.

     I         Toggle inverse video.

     q         Return to previous level.

     Q         Quit tin.

     R         Mail a bug report or comment to the author.   This
               is the best way of getting bugs fixed and features
               added/changed.

     v         Print tin version information.



August 20, 1993       Last change: Version 1.2 PL1                     8






TIN(1)                           LOCAL                            TIN(1)



GROUP INDEX COMMANDS
     4         Select article 4.

     ^K        Kill current article (for  more  information  read
               section Kill Article Menu).

     ^L        Redraw page.

     <CR>      Read current article.

     <TAB>     View next unread article or group.

     a         Author forward search.

     A         Author backward search.

     c         Mark all articles as read with confirmation.

     C         Mark all articles as read and goto next group with
               unread news.

     d         Toggle display to show just  the  subject  or  the
               subject and author.

     g         Choose a new group by name.

     h         Help screen of group index commands.

     H         Toggle the display of help mini menu at the bottom
               of the screen.

     I         Toggle inverse video.

     K         Mark article/thread as read and  advance  to  next
               unread article/thread.

     l         List the author of each response in current thread
               and enter thread selection level.

     m         Mail current article  /  thread  /  auto  selected
               (hot)  articles  /  articles  matching  pattern  /
               tagged articles to someone.

     M         User   configurable   options   menu   (for   more
               information see section Options Menu).

     n         Go to next group.

     N         Go to next unread article.

     o         Output current article / thread  /  auto  selected
               (hot)  articles  /  articles  matching  pattern  /



August 20, 1993       Last change: Version 1.2 PL1                     9






TIN(1)                           LOCAL                            TIN(1)



               tagged articles to printer.

     p         Go to previous group.

     P         Go to previous unread article.

     q         Return to previous level.

     Q         Quit tin.

     R         Mail a bug report or comment to the author.   This
               is the best way of getting bugs fixed and features
               added/changed.

     s         Save current article  /  thread  /  auto  selected
               (hot)  articles  /  articles  matching  pattern  /
               tagged articles to file /  files  /  mailbox.   To
               save  to  a  mailbox  enter '=' or '=mailbox' when
               asked  for  filename  to  save  to.   To  save  in
               <newsgroup     name>/<filename>    format    enter
               '+filename'.  Environment  variables  are  allowed
               within a filename (i.e. $SOURCES/dir/filename).

     t         Tag current article / thread for mailing  ('m')  /
               piping  ('|')  /  printing  ('o') / saving ('s') /
               crossposting ('x').

     u         Toggle display to show all articles as  unthreaded
               or threaded.

     U         Untag all articles that were tagged.

     v         Print tin version information.

     w         Post an article to current group.

     W         List articles posted by user.   The  date  posted,
               the newsgroup and the subject are listed.

     x         Crosspost already posted current article /  thread
               / auto selected (hot) articles / articles matching
               pattern / tagged articles to another newsgroup(s).
               Useful   for   reposting   from  global  to  local
               newsgroups.

     X         Mark  all  unread  articles  that  have  not  been
               selected  as  read, redo screen to reflect changes
               and  put  index  at  the  first  thread  to  begin
               reading.  Pressing  'X'  again will toggle back to
               the  way  it  was  before.  See  '~'  command  for
               clearing the toggle effect.




August 20, 1993       Last change: Version 1.2 PL1                    10






TIN(1)                           LOCAL                            TIN(1)



     z         Mark current article as unread.

     Z         Mark current thread as unread.

     /         Search forward for specified subject.

     ?         Search backward for specified subject.

     -         Show last message.

     |         Pipe current article  /  thread  /  auto  selected
               (hot)  articles  /  articles  matching  pattern  /
               tagged articles into command.

     *         Select current thread for later processing.

     Toggle selection of current thread. If at least one unread art,
               but  not  all  unread arts, in thread is selected,
               then all unread arts become selected.

     @         Reverse all selections on all articles.

     ~         Undo all selections on all articles. It clears the
               toggle  effect  of  'X'  command. Thus after first
               doing  a  'X',  one  can  then  do  '~'  to  reset
               articles.  Thus,  one can iteratively whittle down
               uninteresting threads.

     +         Perform auto-selection on current group.

     ;         For each thread in current group, if it  at  least
               one unread art is selected, all unread arts become
               selected. This is  useful  for  auto-selection  on
               author where reader wants to see entire thread.

     =         Prompts for a pattern with which to match on.  All
               threads  whose  subjects match the pattern will be
               selected.  A  pattern  of  "*"  will   match   all
               subjects.   Entering  just  <CR>  will  cause  the
               previous pattern to be used.

THREAD LISTING COMMANDS
     4         Select article 4 within thread.

     ^L        Redraw page.

     <CR>      Read current article within thread.

     <TAB>     View next unread article within thread.

     c         Mark thread as read after confirmation and  return
               to previous level.



August 20, 1993       Last change: Version 1.2 PL1                    11






TIN(1)                           LOCAL                            TIN(1)



     d         Toggle display to show just  the  subject  or  the
               subject and author.

     h         Help screen of thread listing commands.

     H         Toggle the display of help mini menu at the bottom
               of the screen.

     I         Toggle inverse video.

     K         Mark thread as read and return to previous level.

     q         Return to previous level.

     Q         Quit tin.

     r         Toggle display to show all articles or only unread
               articles.

     R         Mail a bug report or comment to the author.   This
               is the best way of getting bugs fixed and features
               added/changed.

     t         Tag current article for  mailing  ('m')  /  piping
               ('|')   /   printing   ('o')   /  saving  ('s')  /
               crossposting ('x').

     T         Return to group index level.

     v         Print tin version information.

     z         Mark current article in thread as unread.

     Z         Mark all articles in thread as unread.

ARTICLE VIEWER COMMANDS
     0         Read the base article in this thread.

     4         Read response 4 in this thread.

     ^H        Show all of the articles mail header.

     ^K        Kill current article (for  more  information  read
               section Kill Article Menu).

     ^L        Redraw page.

     <CR>      Goto next base article.

     <TAB>     Goto next unread article.

     a         Author forward search.



August 20, 1993       Last change: Version 1.2 PL1                    12






TIN(1)                           LOCAL                            TIN(1)



     A         Author backward search.

     c         Mark all articles as read  with  confirmation  and
               return to group selection level.

     C         Mark current group  as  all  read  and  goto  next
               unread group in group selection list.

     d         Toggle rot-13 decoding for this article.

     D         Delete current article.  It must have been  posted
               by  the same user.  The cancel message can be seen
               in the newsgroup 'control'.

     f         Post a followup to the current article with a copy
               of the article included.

     F         Post a followup to the current article.

     h         Help screen of article page commands.

     H         Toggle the display of help mini menu at the bottom
               of the screen.

     I         Toggle inverse video.

     k         Mark article as read and advance  to  next  unread
               article.

     K         Mark thread as read and  advance  to  next  unread
               thread.

     m         Mail current article  /  thread  /  auto  selected
               (hot)  articles  /  articles  matching  pattern  /
               tagged articles to someone.

     M         User   configurable   options   menu   (for   more
               information see section Options Menu).

     n         Go to the next article.

     N         Go to the next unread article.

     o         Output current article / thread  /  auto  selected
               (hot)  articles  /  articles  matching  pattern  /
               tagged articles to printer.

     o         Output article/thread/tagged articles to printer.

     p         Go to the previous article.

     P         Go to the previous unread article.



August 20, 1993       Last change: Version 1.2 PL1                    13






TIN(1)                           LOCAL                            TIN(1)



     q         Return to previous level.

     Q         Quit tin.

     r         Reply through mail to the author  of  the  current
               article with a copy of the article included.

     R         Reply through mail to the author  of  the  current
               article.

     s         Save current article  /  thread  /  auto  selected
               (hot)  articles  /  articles  matching  pattern  /
               tagged articles to file /  files  /  mailbox.   To
               save  to  a  mailbox  enter '=' or '=mailbox' when
               asked  for  filename  to  save  to.   To  save  in
               <newsgroup     name>/<filename>    format    enter
               '+filename'.  Environment  variables  are  allowed
               within a filename (i.e. $SOURCES/dir/filename).

     t         Return to group selection level.

     T         Tag current article for  mailing  ('m')  /  piping
               ('|')   /   printing   ('o')   /  saving  ('s')  /
               crossposting ('x').

     v         Print tin version information.

     w         Post an article to current group.

     W         List articles posted by user.   The  date  posted,
               the newsgroup and the subject are listed.

     x         Crosspost already posted current article /  thread
               / auto selected (hot) articles / articles matching
               pattern / tagged articles to another newsgroup(s).
               Useful   for   reposting   from  global  to  local
               newsgroups.

     z         Mark article as unread.

     /         Article forward search.

     ?         Article backward search

     |         Pipe current article  /  thread  /  auto  selected
               (hot)  articles  /  articles  matching  pattern  /
               tagged articles into command.

     <         Goto the first article in the current thread.

     >         Goto the last article in the current thread.




August 20, 1993       Last change: Version 1.2 PL1                    14






TIN(1)                           LOCAL                            TIN(1)



     *         Select current thread for later processing.

     Toggle selection of current article.

     @         Reverse article selections.

     ~         Undo all selections on current thread.

GLOBAL OPTIONS MENU
     This menu is accessed by pressing 'M'  at  all  levels.   It
     allows  the  user  to  customize  the  behaviour of tin. The
     options are saved to the file $HOME/.tin/tinrc.  Use <SPACE>
     to toggle the required option and <CR> to set.

     Auto save
         Automatically save articles/threads by ``Archive-name:''
         line  in article header and post process them if process
         type is not set to None.

     Editor offset
         Set ON if the editor used for  posting,  follow-ups  and
         bug   reports   has   the  capability  of  starting  and
         positioning the cursor at  a  specified  line  within  a
         file.

     Mark saved read
         Allows saved articles/threads to be automatically marked
         as read.

     Confirm Command
         Allows certain commands (i.e. 'c' catchup) that  require
         user confirmation to be executed immediately if set OFF.

     Draw arrow
         Allows groups/articles to be selected by an  arrow  '->'
         if set ON or by an highlighted bar if set OFF.

     Print header
         This  allows  the  complete  mail  header  or  only  the
         ``Subject:''  and  ``From:''   fields  to be output when
         printing articles.

     Goto 1st unread
         This allows the cursor to be placed at the first /  last
         unread  article  upon  entering  a newsgroup with unread
         news.

     Scroll full page
         If set ON scrolling of groups/articles will  be  a  full
         page at a time, otherwise half a page at a time.

     Catchup on quit



August 20, 1993       Last change: Version 1.2 PL1                    15






TIN(1)                           LOCAL                            TIN(1)



         If set ON the user is asked when quitting if all  groups
         read during the current session should be marked read.

     Thread articles
         If set ON  articles  will  be  threaded  in  all  groups
         (default),  otherwise articles will be shown unthreaded.
         Threading/unthreading is possible on a per  group  basis
         by setting the group attribute variable 'thread_arts' to
         ON/OFF in the file $HOME/.tin/attributes.

     Show only unread
         If set ON show only new/unread articles, otherwise  show
         all articles.

     Show description
         If set  ON  show  a  short  descriptive  text  for  each
         displayed  newsgroup.   The  text used is taken from the
         $LIBDIR/newsgroups file.

     Show Author
         If  set  'None'  only  the  ``Subject:''  line  will  be
         displayed.   If  set  'Addr'  ``Subject:''  line  &  the
         address part of the ``From:'' line  are  displayed.   If
         set  'Name'  ``Subject:''  line  & the authors full name
         part of the  ``From:''   line  are  displayed.   If  set
         'Both' ``Subject:'' line & all of the ``From:'' line are
         displayed.

     Process type
         This specifies the default type of  post  processing  to
         perform  on  saved  articles.   The  following  types of
         processing are allowed:
             -none.
             -unpacking of multi-part shell archives.
             -unpacking of multi-part uuencoded files.
             -unpacking  of  multi-part  uuencoded  files,  which
              produce a *.zoo archive whose contents is listed.
             -unpacking  of  multi-part  uuencoded  files,  which
              produce   a   *.zoo   archive   whose  contents  is
              extracted.
             -unpacking  of  multi-part  uuencoded  files,  which
              produce a *.zip archive whose contents is listed.
             -unpacking  of  multi-part  uuencoded  files,  which
              produce   a   *.zip   archive   whose  contents  is
              extracted.
             -unpacking  of  multi-part  uuencoded  files,  which
              produce  a  *.lha  archive whose contents is listed
              (AmigaDOS version only).
             -unpacking  of  multi-part  uuencoded  files,  which
              produce a *.lha archive whose contents is extracted
              (AmigaDOS version only).




August 20, 1993       Last change: Version 1.2 PL1                    16






TIN(1)                           LOCAL                            TIN(1)



     Sort articles by
         This specifies  how  articles  should  be  sorted.   The
         following sort types are allowed:
             -don't sort articles (default).
             -sort articles by ``Subject:''  field  (ascending  &
              descending).
             -sort  articles  by  ``From:''  field  (ascending  &
              descending).
             -sort  articles  by  ``Date:''  field  (ascending  &
              descending).

     Save directory
         The directory where articles/threads are  to  be  saved.
         Default is $HOME/News.

     Mail directory
         The directory where articles/threads are to be saved  in
         mailbox format.  This feature is mainly for use with the
         Elm  mail  program.   It  allows  the   user   to   save
         articles/threads/groups  simply  by  giving  '='  as the
         filename to save to.

     Printer
         The printer program with options that is to be  used  to
         print  articles.  Default is lpr for BSD machines and lp
         for SysV machines.

TINRC CONFIGURABLE VARIABLES
     The following variables are  user  configurable  by  editing
     $HOME/.tin/tinrc directly. It is hoped to eventually provide
     a menu to allow the setting of the most common variables.

     batch_save
         If set ON articles/threads will be saved in  batch  mode
         when  save  -S  or  mail  -M is specified on the command
         line. Default is OFF.

     beginner_level
         If set ON a mini menu of the most useful  commands  will
         be displayed at the bottom of the screen for each level.
         Default is ON.

     display_reading_prompt
         The prompt ``Reading...'' will be displayed when reading
         an article from a NNTP server to provide feedback to the
         user. Default is ON.

     force_screen_redraw
         Specifies whether a screen redraw should always be  done
         after certain external commands. Default is OFF.

     groupname_max_length



August 20, 1993       Last change: Version 1.2 PL1                    17






TIN(1)                           LOCAL                            TIN(1)



         Maximum  length  of  the  names  of  newsgroups  to   be
         displayed  so  that more of the newgroup description can
         be displayed. Default is 132.

     default_sigfile
         The path that specifies the signature file to  use  when
         posting,  following  upto  or replying to an article. If
         the path is a  directory  then  the  signature  will  be
         randomly  generated from files that are in the specified
         directory.  Default is $HOME/.Sig.

     editor_format
         The format  string  used  to  create  the  editor  start
         command  with parameters.  Default is '%E +%N %F' (i.e.,
         /bin/vi +7 .article).

     hot_art_mark
         The character used to show  that  an  article/thread  is
         auto-selected (hot). Default is '*'.

     quote_chars
         The character used in quoting included text  to  article
         followups  and mail replys. The '_' character represents
         a blank character and is replaced with '  '  when  read.
         Default is ':_'.

     reread_active_file_secs
         The news active file is reread at regular  intervals  to
         show  if  any  new  news  has  arrived.  Default  is 300
         seconds.

     return_art_mark
         The character used to show that an article will  return.
         Default is '-'.

     save_to_mmdf_mailbox
         Allows articles to be saved  to  a  MMDF  style  mailbox
         instead  of  mbox format.  Default is OFF unless reading
         news on SCO Unix which uses MMDF by default.

     show_last_line_prev_page
         The last line of the previous page will be displayed  as
         the first line of next page. Default is OFF.

     slow_speed_terminal
         Strips the blanks from the end of  each  line  therefore
         speeding  up the display when reading on a slow terminal
         or via modem. Default is OFF.

     tab_after_X_selection
         If enabled will  automatically  goto  the  first  unread
         article  after  having  selected  all  hot  articles and



August 20, 1993       Last change: Version 1.2 PL1                    18






TIN(1)                           LOCAL                            TIN(1)



         threads with the  'X'  command  at  group  index  level.
         Default is OFF.

     tab_goto_next_unread
         If enabled pressing TAB at the article viewer level will
         goto  the  next  unread  article  immediately instead of
         first paging through the current one. Default is ON.

     unread_art_mark
         The character used to show that an article has not  been
         read. Default is '+'.

     use_builtin_inews
         Allows the builtin NNTP inews  to  be  enabled/disabled.
         Default is ON (enabled).

     use_keypad
         Allows  the  scroll   keys   on   the   keypad   to   be
         enabled/disabled on supported terminals. Default is OFF.

GROUP ATTRIBUTES
     Tin allows certain attributes to  be  set  on  a  per  group
     basis.  These  group  attributes  are  read  from  the  file
     $HOME/.tin/attributes.  A later version will provide a  menu
     interface  to  set  all  the attributes. At present you will
     have to edit the file with your editor  :-(.  The  following
     group attributes are available:

          newsgroup=alt.sources
          maildir=/usr/iain/Mail/sources
          savedir=/usr/iain/News/alt.sources
          sigfile=/usr/iain/.funny_sig
          organization=Wacky Bits Inc.
          followup_to=alt.sources.d
          printer=/usr/local/bin/a2ps -nn | /bin/lpr
          auto_save=ON
          batch_save=OFF
          delete_tmp_files=ON
          show_only_unread=OFF
          thread_arts=ON
          show_author=1
          sort_art_type=5
          post_proc_type=1

     Note that  the  ''newsgroup=<groupname>''  line  has  to  be
     specified  before  the  attributes  are  specified  for that
     group.

     All attributes are set to a reasonable default so  you  only
     have to specify the attribute that you want to change (i.e.,
     savedir).




August 20, 1993       Last change: Version 1.2 PL1                    19






TIN(1)                           LOCAL                            TIN(1)



     All toggle attributes are set by specifying ON/OFF.

     The show_author attribute is specified by a number from  the
     following  range:  0=none,  1=username,  2=network  address,
     3=both.

     The sort_art_type attribute is specified by  a  number  from
     the following range: 0=none, 1=subject descending, 2=subject
     ascending,  3=from  descending,  4=from  ascending,   5=date
     descending, 6=date ascending.

     The post_proc_type attribute is specified by a  number  from
     the   following   range:   0=none,   1=unshar,   2=uudecode,
     3=uudecode & list zoo  archive,  4=uudecode  &  extract  zoo
     archive, 5=uudecode & list zip archive, 6=uudecode & extract
     zip archive. (note: if running on AmigaDOS the  zoo  options
     are replaced by there corresponding lha archiver options).

AUTOMATIC KILL AND SELECTION
     When there is a subject or an author which  you  are  either
     very  interested  in,  or find completely uninteresting, you
     can easily instruct tin to auto-select or auto-kill articles
     with  specific  subjects  or  from  specific authors.  These
     instructions are stored in a kill file.

     This menu is accessed by pressing '^K' at the group and page
     levels.   It  allows  the  user to kill or select an article
     that matches the current ``Subject:'' line,  ``From:''  line
     or a string entered by the user. The user entered string can
     be applied to the ``Subject:''  or  ``From:''  lines  of  an
     article.  The kill description can be limited to the current
     newsgroup or it can apply to all  newsgroups.  Once  entered
     the  user  can  abort  the  command  and  not  save the kill
     description,  edit  the  kill  file   or   save   the   kill
     description.

     On starting tin the users killfile $HOME/.tin/kill  is  read
     and  on entering a newsgroup any kill or select descriptions
     are applied.

     Articles that match a kill description are marked killed and
     are  not  displayed.  Articles  that  match  an  auto-select
     description are marked with a ''*'' when displayed.

POSTING ARTICLES
     Tin allows posting of articles, follow-up to already  posted
     articles  and  replying direct through mail to the author of
     an article.

     Use the 'w' command to  post  an  article  to  a  newsgroup.
     After entering the post subject the default editor (i.e. vi)
     or the editor specified by the $VISUAL environment  variable



August 20, 1993       Last change: Version 1.2 PL1                    20






TIN(1)                           LOCAL                            TIN(1)



     will  be  started  and  the  article  can  be  entered.   To
     crosspost articles simply add a comma and the  name  of  the
     newsgroup(s)  to  the end of the ``Newsgroups:'' line at the
     beginning of the article.   After  saving  and  exiting  the
     editor  you  are  asked  if  you  wish to a)bort posting the
     article, e)dit the article again or p)ost the article to the
     specified newsgroup(s).

     Use the 'W' command to display a history of the articles you
     have  posted.   The  date  the  article  was  posted,  which
     newsgroups the  article  was  posted  to  and  the  articles
     subject line are displayed.

     Use the 'f' / 'F' command to post a follow-up article to  an
     already  posted article.  The 'f' command will copy the text
     of the  original  article  into  the  editor.   The  editing
     procedure  is  the  same as when posting an article with the
     'w' command.

     Use the 'r' / 'R' command to reply direct  through  mail  to
     the  author  of  an already posted article.  The 'r' command
     will copy the text of the original article into the  editor.
     The editing procedure is the same as when posting an article
     with the 'w' command.  After saving and exiting  the  editor
     you  are  asked  if  you wish to a)bort sending the article,
     e)dit the article again or s)end the article to the author.

CUSTOMIZING THE ARTICLE QUOTE STRING
     When posting a followup to an article or replying direct  to
     the  author  of an article via email the text of the article
     can be quoted. The beginning of the quoted text can  contain
     information  about  the  quoted  article (i.e., Name and the
     Message  Id  of  the  article).  To  allow   for   different
     situations  certain information from the article can be used
     in the quoted string. The following variables  are  expanded
     if  found  in  the  tinrc  variables 'mail_quote_format=' or
     'news_quote_format=':
          %A  Address (Email)
          %D  Date
          %F  Full address (%N (%A))
          %G  Groupname
          %M  Message Id
          %N  Name of user
     i.e.,
          mail_quote_format=On %D in %G you wrote:
          news_quote_format=In %M, %F wrote:
     would expand when used to:
          On 21 Jul 1992 09:45:51 -0400 in alt.sources you wrote:
          In <abcINN123@anl433.uucp>, Iain Lea (iain@erlm.siemens.de) wrote:

MAILING PIPING PRINTING REPOSTING AND SAVING ARTICLES
     The command interface  to  mail  ('m'),  pipe  ('|'),  print



August 20, 1993       Last change: Version 1.2 PL1                    21






TIN(1)                           LOCAL                            TIN(1)



     ('o'),  crosspost  ('x') and save ('s') articles is the same
     for ease of use.

     The initial command will ask you to select  which  a)rticle,
     t)hread,   h)ot  (auto  selected)  r)egex  pattern,  t)agged
     articles you wish to mail, pipe etc.

     Tagged articles must have already been tagged with  the  'T'
     command.   All  tagged  articles  can be untagged by the 'U'
     untag command.

     If regex pattern matching is selected you are asked to enter
     a  regular  expression  (i.e.  to match all articles subject
     lines containing 'net News' you must  enter  '*net  News*').
     Any  articles  that  match  the  entered  expression will be
     mailed, piped etc.

     To save articles to a mailbox with the name of  the  current
     newsgroup  (i.e. Alt.sources) enter '=' or '=<mailbox name>'
     when asked for the save filename.

     To save articles in <newsgroup name>/<filename> format enter
     '+<filename>'.

     When saving articles you can specify whether the saved files
     should   be  post  processed  (i.e.  unshar  shell  archive,
     uudecode multiple parts etc).  A default process type can be
     set by the 'Process type:' in the 'M' options menu.

AUTOMATIC MAILING AND SAVING NEW NEWS
     Tin  allows  new/unread  news  articles  to  be  mailed  (-M
     option)/saved  (-S  option) in batch mode for later reading.
     Useful when going on holiday and you don't  want  to  return
     and  find  that  expire  has  removed a whole load of unread
     articles.  Best to run from  crontab  everyday  while  away,
     after  which  you  will be mailed a report of which articles
     were mailed/saved from which newsgroups and the total number
     of  articles  mailed/saved.  Articles are saved in a private
     news structure under your <savedir>  directory  (default  is
     $HOME/News).   Be careful of using this option if you read a
     lot of groups because you could  overflow  your  filesystem.
     If  you  only  want to save a few groups it would be best to
     backup your full $HOME/.newsrc and create  a  new  one  that
     only  contains  the newsgroups you want to mail/save.  Saved
     news can be read later by tin -R.

     tin -M iain -c -f newsrc.mail
                         (mail any unread articles  in  newgroups
                         specified in file newsrc.mail)

     tin -S -c -f newsrc.save
                         (save any unread articles  in  newgroups



August 20, 1993       Last change: Version 1.2 PL1                    22






TIN(1)                           LOCAL                            TIN(1)



                         specified in file newsrc.save)

     tin -R              (read any articles saved by tin -S)

SIGNATURES
     Tin will recognize a signature in either $HOME/.signature or
     $HOME/.Sig.   If $HOME/.signature exists, then the signature
     will be  pulled  into  the  editor  for  mail  commands.   A
     signature  in  $HOME/.signature  will not be pulled into the
     editor for posting commands  since  inews  will  append  the
     signature itself.

     A signature in $HOME/.Sig will be pulled into the editor for
     both posting and mailing commands.

     The following is an example of a $HOME/.Sig file:
          NAMES  Iain Lea    iain.lea@erlm.siemens.de
          SNAIL  Bruecken Strasse 12, 8500 Nuernberg 90, Germany
          PHONE  +49-911-331963 (home)  +49-911-3089-407 (work)
     Tin also has the capability to generate random signatures on
     a  per  newsgroup basis if so desired. The way to accomplish
     this is to  specify  the  default  signature  or  the  group
     attribute  sigfile  as  a  directory.   If  for  example the
     sigfile path is /usr/iain/.sigs and  .sigs  is  a  directory
     then  tin  will select a random signature from any file that
     is in the directory .sigs (note: one signature per  numbered
     file).  A  random signature can also consist of a fixed part
     signature that can contain your name, address etc.  followed
     by  the random sig. The fixed part of the random sig is read
     from the file $HOME/.sigfixed.

ENVIROMENT VARIABLES
     TINRC
          Define this variable if you  want  to  specify  command
          line  options  that  tin should be started with to save
          typing them each time it is started.  The  contents  of
          the  environment variable are added to the front of the
          command line options  before  it  is  parsed  therefore
          allowing  an  option  specified  on the command line to
          override the same option specified in the environment.

     TINDIR
          Define this variable  if  you  do  not  want  the  .tin
          directory  in  $HOME/.tin.  (i.e. if you want all tin's
          private files in /tmp/.tin  you  would  set  TINDIR  to
          /tmp.

     TIN_INDEX
          Define this variable if you  do  not  want  the  .index
          directory  in  $HOME/.tin/.index. (i.e. if you want all
          tin's  index  files  in  /tmp/.index  you   would   set
          TIN_INDEX to /tmp.



August 20, 1993       Last change: Version 1.2 PL1                    23






TIN(1)                           LOCAL                            TIN(1)



     NNTPSERVER
          The default NNTP server to  remotely  read  news  from.
          This  variable  only  needs to be set if the -r command
          line option is specified and the  file  /etc/nntpserver
          does not exist.

     DISTRIBUTION
          Set the article header field ``Distribution:''  to  the
          contents of the variable instead of the system default.

     ORGANIZATION
          Set the article header field ``Organization:''  to  the
          contents of the variable instead of the system default.
          This   variable   has   precedence   over   the    file
          $HOME/.tin/organization   that   may  also  contain  an
          organization string.  If  reading  news  on  an  Apollo
          DomainOS  machine  the environment variable NEWSORG has
          to be used instead of ORGANIZATION.

     REPLYTO
          Set the  article  header  field  ``Reply-To:''  to  the
          return  address  specified  by  the  variable.  This is
          useful if the machine is not  registered  in  the  UUCP
          mail  maps  or  if  you  wish  to  receive replies at a
          different machine.  This variable has  precedence  over
          the  file  $HOME/.tin/replyto  that  may also contain a
          return address.

     ADD_ADDRESS
          This can contain an address to  append  to  the  return
          address when replying directly through mail to somebody
          whose mail address is not directly  recognized  by  the
          local  host.   For  example  say  the return address is
          user@bigvax, but bigvax is not recognized by your host,
          so  therefore  the  mail  will not reach user.  But the
          host littevax is  known  to  recognize  your  host  and
          bigvax,   so   if  ADD_ADDRESS  is  set  (i.e.  'setenv
          ADD_ADDRESS @littevax'  for  csh  or  'set  ADD_ADDRESS
          @littevax' and 'export ADD_ADDRESS' for sh) the address
          user@bigvax@littlevax will be used and  the  mail  will
          reach  user@bigvax.   This variable has precedence over
          the file $HOME/.tin/add_address that may  also  contain
          an address.

     BUG_ADDRESS
          If the 'B' command  bug  report  mail  address  is  not
          correct this variable should be set to the correct mail
          address.  This variable has precedence  over  the  file
          $HOME/.tin/bug_address  that  may  also  contain a mail
          address.

     MAILER



August 20, 1993       Last change: Version 1.2 PL1                    24






TIN(1)                           LOCAL                            TIN(1)



          This variable has precedence over  the  default  mailer
          that is used in all mailing operations within tin (i.e.
          replying 'rR', and bug reports 'B').

     VISUAL
          This variable has precedence over  the  default  editor
          (i.e. vi) that is used in all editing operations within
          tin (i.e. posting 'w', replying 'rR',  follow-ups  'fF'
          and bug reports 'B').

TIPS AND TRICKS
     Tin can be pretty much be navigated by using the four cursor
     keys.  The  left  arrow key goes up a level, the right arrow
     key goes down a level, the up arrow key goes up a line (page
     at  article viewer level) and the down arrow key goes down a
     line (page at article viewer level).

     The  following   newsgroups   provide   useful   information
     concerning news software:
         -news.software.readers (info.  about  news  user  agents
          tin,rn,nn,vn etc.)
         -news.software.nntp (info. about NNTP)
         -news.software.b  (info.  about  news  transport  agents
          Bnews,Cnews and INN)
         -news.answers (Frequently Asked  Questions  (FAQ)  about
          many different themes)

     Many prompts (i.e. 'Mark  everything  as  read?  (y/n):  y')
     within  tin  offer  a  default  choice  that  the  cursor is
     positioned on.  By pressing <CR> the default value is taken.

     Many prompts (i.e. 'Post subject []>')  within  tin  can  be
     aborted by pressing ESC.

     When tin is run in an xterm window  it  will  resize  itself
     each time the xterm is resized.

     Tin will reread the active file at set intervals to show any
     new news.

FILES
     $HOME/.newsrc       subscribed to newgroups.

     $HOME/.newsauth     ``nntpserver password'' pairs  for  NNTP
                         servers that require authorization.

     $HOME/.tin/tinrc    options.

     $HOME/.tin/attributes
                         contains    user     specified     group
                         attributes.




August 20, 1993       Last change: Version 1.2 PL1                    25






TIN(1)                           LOCAL                            TIN(1)



     $HOME/.tin/.index   newsgroups index files directory.

     $HOME/.tin/.mailidx mailgroups index files directory.

     $HOME/.tin/.saveidx saved newsgroups index files directory.

     $HOME/.tin/active.mail
                         active file of users mailgroups.

     $HOME/.tin/active.save
                         active file of users saved newsgroups.

     $HOME/.tin/add_address
                         address to add to when replying  through
                         mail.

     $HOME/.tin/bug_address
                         address to send bug reports to.

     $HOME/.tin/kill     article kill and auto-selection file.

     $HOME/.tin/organization
                         string to replace default organization.

     $HOME/.tin/posted   history of articles posted by user.

     $HOME/.tin/replyto  host address  to  use  in  ``Reply-To:''
                         mail header.

     $HOME/.signature    signature.

     $HOME/.Sig          signature.

     $HOME/.sigfixed     fixed  part  of  a  randomly   generated
                         signature.

     /usr/lib/news/motd  News message of the day file.

     /usr/lib/news/newsgroups
                         Short description of all newsgroups.

     /usr/lib/news/subscriptions
                         List of newsgroups  to  subscribe  first
                         time user to.

BUGS
     There are bugs somewhere among the creeping featurism.   Any
     bugs  found  should  be  reported  by  the  'B' (bug report)
     command.

     Coredumps when  setting  certain  toggle  options  from  the
     options menu at article viewer level.



August 20, 1993       Last change: Version 1.2 PL1                    26






TIN(1)                           LOCAL                            TIN(1)



     Coredumps when killing last article in a thread  at  article
     viewer level.

HISTORY
     Based on the tass newsreader  that  was  developed  by  Rich
     Skrenta  and  posted to alt.sources in March 1991.  Tass was
     itself heavily influenced by NOTES which  was  developed  at
     the  University of Illinois by Ray Essick and Rob Kolstad in
     1982.

     v1.0 PL0 (full) was posted in 8 parts to alt.sources  on  23
     Aug 1991.
     v1.0 PL1 (full) was posted in 8 parts to alt.sources  on  03
     Sep 1991.
     v1.0 PL2 (full) was posted in 9 parts to alt.sources  on  24
     Sep 1991.
     v1.0 PL3 (patch) was posted in 4 parts to alt.sources on  30
     Sep 1991.
     v1.0 PL4 (patch) was posted in 2 parts to alt.sources on  02
     Oct 1991.
     v1.0 PL5 (patch) was posted in 4 parts to alt.sources on  17
     Oct 1991.
     v1.0 PL6 (patch) was posted in 5 parts to alt.sources on  27
     Nov 1991.
     v1.0 PL7 (patch) was posted in 2 parts to alt.sources on  27
     Nov 1991.
     v1.1 PL0 (full) was posted in 11 parts to alt.sources on  13
     Feb 1992.
     v1.1 PL1 (full) was posted in 12 parts to alt.sources on  24
     Mar 1992.
     v1.1 PL2 (patch) was posted in 4 parts to alt.sources on  30
     Mar 1992.
     v1.1 PL3 (full) was posted in 15 parts to alt.sources on  13
     May 1992.
     v1.1 PL4 (full) was posted in 15 parts to alt.sources on  22
     Jun 1992.
     v1.1 PL5 (patch) was posted in 7 parts to alt.sources on  11
     Aug 1992.
     v1.1 PL6 (full) was posted in 15 parts to alt.sources on  14
     Sep 1992.
     v1.1 PL7 (patch) was posted in 10 parts to alt.sources on 15
     Nov 1992.
     v1.1 PL8 (patch) was posted in 6 parts to alt.sources on  06
     Dec 1992.
     v1.1 PL9 (patch) was posted in 3 parts to alt.sources on  20
     Mar 1993.
     v1.2 PL0 (full) was posted in 14 parts to alt.sources on  25
     May 1993.
     v1.2 PL1 (patch) was posted in 8 parts to alt.sources on  14
     Jul 1993.





August 20, 1993       Last change: Version 1.2 PL1                    27






TIN(1)                           LOCAL                            TIN(1)



CREDITS
     Rich Skrenta   author of tass  v3.2  which  this  newsreader
                    used as its base.

     Bill Davidsen  author  of  envarg.c   environment   variable
                    reading routine.

     Mike Gleason   author   of   sigfile.c   random    signature
                    generation  routines.   Arnold Robbins author
                    of strftime.c date formatting routine.

     Jim Robinson   co-author of kill.c article  kill  and  auto-
                    selection routines.

     Rich Salz      author  of  wildmat.c  pattern  matching  and
                    parsedate.y date parsing routines.

     Dave Taylor    author of curses.c from the elm mailreader.

     Chris Thewalt  author  of  getline.c  emacs  style   editing
                    routine.

     Mark Tomlinson for porting tin  to  the  AmigaDOS  operating
                    system.

     Andreas Wrede  for porting tin to the OS/2 operating system.

     Dieter Becker  for generously posting certain  releases  for
                    me  when  my  net connection was removed by a
                    group of very short sighted people.

     I wish to thank the following people for supplying patches:

     David Abbott,  Earle  Ake,  Joachim  Astel,  Anton  Aylward,
     George  Baltz, Paul Bauwens, Dieter Becker, Dan Berry, David
     Binderman, Fokke de Boer, Mark Boucher, Herman  ten  Brugge,
     Leila  Burrell-Davis,  Peter  Castro, Robert Claeson, Steven
     Cogswell, Don Costello, Bryan Curnutt, Ned  Danieley,  Chris
     Davies,  John  Davis, Tom Dickey, Craig Durland, Kirk Edson,
     Stefan Elf, Rob Engle, Brent Ermlick, Olle Eriksson, Michael
     Faurot,  Werner  Fleck,  Callum  Gibson,  Mike  Glendinning,
     Philippe Goujard, Carl Hage, Paul Halsema, Ed Hanway,  Scott
     Hauck, Per Headland, Daniel Hermans, Jose Herrero, Tom Hite,
     Torsten Homeyer, Tommy Hsieh, Steve  Hunt,  Robbin  Johnson,
     Nelson  Kading,  Fritz  Kleeman, Dwarven Knight, Karl-Koenig
     Koenigsson, Martin Kraemer, Kris Kugel,  Alex  Lange,  Alain
     Lasserre,   Hakan  Lennestal,  Geoff  Lane,  Marty  Leisner,
     Clifford Luke, David MacKenzie, Hugh Mahon, Owen Medd, Soren
     Moller,  Sergio Morales, Michael Morrell, Klaus Mueller, Udo
     Munk, James Nugen, Jeb Palmer, Neil Parker, Tom  Parry,  Jim
     Patterson, Walter Pelissero, Eric Peterson, Tim Pierce, Bill
     Poitras, Wolfgang  Prediger,  Ted  Richards,  Jim  Robinson,



August 20, 1993       Last change: Version 1.2 PL1                    28






TIN(1)                           LOCAL                            TIN(1)



     Stephen Roseman, Clifton Royston, Nickolay Saukh, Rich Salz,
     Gary  Sanders,  John  Sauter,  Christopher   Sawtell,   John
     Schmitz,  Bart  Sears,  Karl-Olav  Serrander,  Doug  Sewell,
     Philip Shearer, Mark Smith, Steve Spearman, Cliff  Stanford,
     Steve  Starck,  Jason  Steiner,  Ed  Sznyter, Derek Terveer,
     Andry Timonin, Mark Tomlin,  Michael  Traub,  Adri  Verhoef,
     Paul Vickers, Cary Whitney, Greg Woods, Lloyd Wright

     I   wish   to   thank   the   following   people   for   bug
     reports/comments:

     Jack  Applin,  Klaus  Arzig,  Scott  Babb,  Reiner  Balling,
     Preston  Bannister,  Bill  de Beabien, Volker Beyer, Etienne
     Bido, Roger Binns, Georg Biehler, Jean-Marc Bonnaudet,  Eric
     Bowles,  Sean Brady, Ian Brown, Andreas Brosig, Craig Bruce,
     Tom Czarnik, Dave Datta, Mat Davis,  Karl  Denninger,  Klaus
     Dimmler,  David Donovan, Peter Dressler, Gerhard Ermer, Hugh
     Fader, Miguel Farah, Joachim Feld, Paul Fox,  Jay  Geertsen,
     Herschel  Gelman,  Bernhard  Gmelch, Jason Haar, Viet Hoang,
     Andy Jackson, Joe Johnson, Ralph Jud, Cyrill Jung, Kuo-Chein
     Kai, Tonis Kelder, Hans-Juergen Knopp, Sridhar Komandur, Tom
     Kovar, Bernhard Kroenung, Murray Laing, Per Lindqvist,  Eric
     Litman,  Bob  Lukas,  Michael  Marshall,  Kazushi  Marukawa,
     Phillip Molloy, Toni Metz, Greg Miller, Deeptendu  Majumder,
     Klaus  Neuberger,  Otto Niesser, Reiner Oelhaf, Alex Pakter,
     John Palkovic, Dave  Pascoe,  Wolf  Paul,  Andrew  Phillips,
     Stefan  Rathmann,  Jon  Robinson,  David Ross, Jonas Rwgmyr,
     Daemon  Schaefer,  Dean  Schrimpf,  Klamer  Schutte,   Fredy
     Schwatz,  Dave  Schweisguth,  Bernd  Schwerin,  Don Sheythe,
     Chris Smith, Daniel Smith, Ralf Stephan, Hironobu Takahashi,
     Ken  Taylor,  Tony  Travis,  Paul  Verket, Sven Werner, Dick
     Wexelblat, Paul Wood, Gregory Woodbury, Norm  Yamane,  Blair
     Zajac, Orest Zboroski, Thomas Ziegler

AUTHOR
     Iain Lea  (iain.lea@erlm.siemens.de)



















August 20, 1993       Last change: Version 1.2 PL1                    29



