ECHO OFF
CLS
rem     This BAT file provides an example use of the configuration/
rem     installation utility LLCONFIG.COM.
rem
rem           Title: User Provides Data File Name and Portion of Path
rem     Description: Runs LLCONFIG.COM with a DOS parameter for data
rem                  path selection and one for data file naming. Can
rem                  therefore be used to select a departments directory
rem                  and a persons name etc.

rem     Check to see user has provided a dept/dir name

if "%1"=="" goto error

rem     Check to see user has provided a file name

if "%2"=="" goto error

rem     They have provided a file name and directory name
rem     perform installation

:INST

ECHO    ͻ
ECHO         INSTALLING & CONFIGURING LANLOG's TSR LLOG.COM   
ECHO    ͹
ECHO                                                          
ECHO           Installation will take only a few seconds.     
ECHO                                                          
ECHO     NOTE: Previously installed copies of LLOG.COM will   
ECHO           be erased - press CNTRL-C to terminate         
ECHO           installation, any other key to continue.       
ECHO                                                          
ECHO       {Cntrl-C} = terminate, any other key = continue    
ECHO                                                          
ECHO    ͼ

rem     get user response

PAUSE

rem     Run the LLCONFIG.COM file

LLCONFIG /PATH: C:\METER.DAT\%1 /NAME: %2

rem     To change the destination drive and path edit C:\METER.DAT
rem     Note, this will create a Meter file only installation
rem     use the /LOG and /MET command line options to override
rem     this default.

goto QUIT

:ERROR

rem     user didn't provide a command line parameter for created data
rem     file name or path portion

CLS

ECHO    ͻ
ECHO                         SYNTAX ERROR                     
ECHO    ͹
ECHO                                                          
ECHO     This BATCH file requires two parameters, the first   
ECHO     tells LLCONFIG which dir/dept to place data into the 
ECHO     second what unique file name to give it.             
ECHO                                                          
ECHO     The correct syntax:                                  
ECHO                                                          
ECHO                   CONFEG04 {path} {name}                 
ECHO                                                          
ECHO     Where {path} is any DOS valid 12 character string    
ECHO     and {name} is any DOS valid 8 character string.      
ECHO                                                          
ECHO     Example:                                             
ECHO                                                          
ECHO                 CONFEG03 ACCOUNTS GEORGE                 
ECHO                                                          
ECHO    ͼ

rem     The End

:QUIT

ECHO ON
