Internet Wiretap Edition of

THE GREAT REVOLUTION IN PITCAIRN by MARK TWAIN

From "The Writings of Mark Twain Volume XX", 
Copyright 1903, Samuel Clemens.

This text is placed in the Public Domain, May 1993.


LET me refresh the reader's memory a little. Nearly
a hundred years ago the crew of the British ship
Bounty mutinied, set the captain and his officers adrift
upon the open sea, took possession of the ship, and
sailed southward. They procured wives for themselves
among the natives of Tahiti, then proceeded to a lonely
little rock in mid-Pacific, called Pitcairn's Island,
wrecked the vessel, stripped her of everything that
might be useful to a new colony, and established them-
selves on shore.

Pitcairn's is so far removed from the track of com-
merce that it was many years before another vessel
touched there. It had always been considered an un-
inhabited island; so when a ship did at last drop its
anchor there, in 1808, the captain was greatly surprised
to find the place peopled. Although the mutineers
had fought among themselves, and gradually killed
each other off until only two or three of the original
stock remained, these tragedies had not occurred be-
fore a number of children had been born; so in 1808
the island had a population of twenty-seven persons.
John Adams, the chief mutineer, still survived, and
was to live many years yet, as governor and patriarch
of the flock. From being mutineer and homicide, he
had turned Christian and teacher, and his nation of
twenty-seven persons was now the purest and devoutest
in Christendom. Adams had long ago hoisted the
British flag and constituted his island an appanage of
the British crown.

To-day the population numbers ninety persons --
sixteen men, nineteen women, twenty-five boys, and
thirty girls -- all descendants of the mutineers, all
bearing the family names of those mutineers, and all
speaking English, and English only. The island stands
high up out of the sea, and has precipitous walls. It
is about three-quarters of a mile long, and in places is
as much as half a mile wide. Such arable land as it
affords is held by the several families, according to a
division made many years ago. There is some live-
stock -- goats, pigs, chickens, and cats; but no dogs,
and no large animals. There is one church building --
used also as a capitol, a schoolhouse, and a public
library. The title of the governor has been, for a
generation or two, "Magistrate and Chief Ruler, in
subordination to her Majesty the Queen of Great
Britain." It was his province to make the laws, as
well as execute them. His office was elective; every-
body over seventeen years old had a vote -- no matter
about the sex.

The sole occupations of the people were farming and
fishing; their sole recreation, religious services. There
has never been a shop in the island, nor any money.
The habits and dress of the people have always been
primitive, and their laws simple to puerility. They
have lived in a deep Sabbath tranquility, far from the
world and its ambitions and vexations, and neither
knowing nor caring what was going on in the mighty
empires that lie beyond their limitless ocean solitudes.
Once in three or four years a ship touched there,
moved them with aged news of bloody battles, devas-
tating epidemics, fallen thrones, and ruined dynasties,
then traded them some soap and flannel for some yams
and breadfruit, and sailed away, leaving them to retire
into their peaceful dreams and pious dissipations once
more.

On the 8th of last September, Admiral de Horsey,
commander-in-chief of the British fleet in the Pacific,
visited Pitcairn's Island, and speaks as follows in his
official report to the admiralty:


  They have beans, carrots, turnips, cabbages, and a
  little maize; pineapples, fig-trees, custard-apples,
  and oranges; lemons, and cocoa-nuts. Clothing is
  obtained alone from passing ships, in barter for
  refreshments. There are no springs on the island, but
  as it rains generally once a month they have plenty
  of water, although at times, in former years, they
  have suffered from drought. No alcoholic liquors,
  except for medicinal purposes, are used, and a drunkard
  is unknown...

  The necessary articles required by the islanders are
  best shown by those we furnished in barter for
  refreshments: namely, flannel, serge, drill, half-boots,
  combs, tobacco, and soap. They also stand much in need
  of maps and slates for their school, and tools of any
  kind are most acceptable. I caused them to be supplied
  from the public stores with a union-jack for display
  on the arrival of ships, and a pit-saw, of which they
  were greatly in need. This, I trust, will meet the
  approval of their lordships. If the munificent people
  of England were only aware of the wants of this most
  deserving little colony, they would not long go
  unsupplied...

  Divine service is held every Sunday at 10.30 A.M. and
  at 3 P.M., in the house built and used by John Adams
  for that purpose until he died in 1829. It is conducted
  strictly in accordance with the liturgy of the Church
  of England, by Mr. Simon Young, their selected pastor,
  who is much respected. A Bible class is held every
  Wednesday, when all who conveniently can attend. There
  is also a general meeting for prayer on the first Friday
  in every month. Family prayers are said in every house
  the first thing in the morning and the last thing in
  the evening, and no food is partaken of without asking
  God's blessing before and afterwards. Of these islanders'
  religious attributes no one can speak without deep
  respect. A people whose greatest pleasure and privilege
  is to commune in prayer with their God, and to join
  in hymns of praise, and who are, moreover, cheerful,
  diligent, and probably freer from vice than any other
  community, need no priest among them.

Now I come to a sentence in the admiral's report
which he dropped carelessly from his pen, no doubt,
and never gave the matter a second thought. He little
imagined what a freight of tragic prophecy it bore!
This is the sentence:

  One stranger, an American, has settled on the island --
  a DOUBTFUL ACQUISITION.

A doubtful acquisition, indeed! Captain Ormsby
in the American ship Hornet, touched at Pitcairn's
nearly four months after the admiral's visit, and from
the facts which he gathered there we now know all
about that American. Let us put these facts together
in historical form. The American's name was Butter-
worth Stavely. As soon as he had become well ac-
quainted with all the people -- and this took but a few
days, of course -- he began to ingratiate himself with
them by all the arts he could command. He became
exceedingly popular, and much looked up to; for one
of the first things he did was to forsake his worldly way
of life, and throw all his energies into religion. He was
always reading his Bible, or praying, or singing hymns,
or asking blessings. In prayer, no one had such
"liberty" as he, no one could pray so long or so well.

At last, when he considered the time to be ripe, he
began secretly to sow the seeds of discontent among
the people. It was his deliberate purpose, from the
beginning, to subvert the government, but of course he
kept that to himself for a time. He used different arts
with different individuals. He awakened dissatisfaction
in one quarter by calling attention to the shortness of
the Sunday services; he argued that there should be
three three-hour services on Sunday instead of only
two. Many had secretly held this opinion before;
they now privately banded themselves into a party to
work for it. He showed certain of the women that
they were not allowed sufficient voice in the prayer-
meetings; thus another party was formed. No weapon
was beneath his notice; he even descended to the chil-
dren, and awoke discontent in their breasts because --
as HE discovered for them -- they had not enough
Sunday-school. This created a third party.

Now, as the chief of these parties, he found himself
the strongest power in the community. So he pro-
ceeded to his next move -- a no less important one
than the impeachment of the chief magistrate, James
Russell Nickoy; a man of character and ability, and
possessed of great wealth, he being the owner of a
house with a parlor to it, three acres and a half of yam
land, and the only boat in Pitcairn's, a whale-boat;
and, most unfortunately, a pretext for this impeach-
ment offered itself at just the right time. One of the
earliest and most precious laws of the island was the
law against trespass. It was held in great reverence,
and was regarded as the palladium of the people's
liberties. About thirty years ago an important case
came before the courts under this law, in this wise: a
chicken belonging to Elizabeth Young (aged, at that
time, fifty-eight, a daughter of John Mills, one of the
mutineers of the Bounty) trespassed upon the grounds
of Thursday October Christian (aged twenty-nine, a
grandson of Fletcher Christian, one of the mutineers).
Christian killed the chicken. According to the law,
Christian could keep the chicken; or, if he preferred,
he could restore its remains to the owner, and receive
damages in "produce" to an amount equivalent to
the waste and injury wrought by the trespasser. The
court records set forth that "the said Christian afore-
said did deliver the aforesaid remains to the said Eliza-
beth Young, and did demand one bushel of yams in
satisfaction of the damage done." But Elizabeth
Young considered the demand exorbitant; the parties
could not agree; therefore Christian brought suit in
the courts. He lost his case in the justice's court; at
least, he was awarded only a half peck of yams, which
he considered insufficient, and in the nature of a
defeat. He appealed. The case lingered several years
in an ascending grade of courts, and always resulted in
decrees sustaining the original verdict; and finally the
thing got into the supreme court, and there it stuck for
twenty years. But last summer, even the supreme
court managed to arrive at a decision at last. Once
more the original verdict was sustained. Christian then
said he was satisfied; but Stavely was present, and
whispered to him and to his lawyer, suggesting, "as a
mere form," that the original law be exhibited, in
order to make sure that it still existed. It seemed an
odd idea, but an ingenious one. So the demand was
made. A messenger was sent to the magistrate's
house; he presently returned with the tidings that it
had disappeared from among the state archives.

The court now pronounced its late decision void,
since it had been made under a law which had no actual
existence.

Great excitement ensued immediately. The news
swept abroad over the whole island that the palladium
of the public liberties was lost -- maybe treasonably
destroyed. Within thirty minutes almost the entire
nation were in the courtroom -- that is to say, the
church. The impeachment of the chief magistrate
followed, upon Stavely's motion. The accused met
his misfortune with the dignity which became his great
office. He did not plead, or even argue; he offered
the simple defense that he had not meddled with the
missing law; that he had kept the state archives in the
same candle-box that had been used as their depository
from the beginning; and that he was innocent of the
removal or destruction of the lost document.

But nothing could save him; he was found guilty of
misprision of treason, and degraded from his office, and
all his property was confiscated.

The lamest part of the whole shameful matter was
the REASON suggested by his enemies for his destruction
of the law, to wit: that he did it to favor Christian,
because Christian was his cousin! Whereas Stavely
was the only individual in the entire nation who was
NOT his cousin. The reader must remember that all
these people are the descendants of half a dozen men;
that the first children intermarried together and bore
grandchildren to the mutineers; that these grand-
children intermarried; after them, great and great-
great-grandchildren intermarried; so that to-day every-
body is blood kin to everybody. Moreover, the rela-
tionships are wonderfully, even astoundingly, mixed
up and complicated. A stranger, for instance, says to
an islander:

"You speak of that young woman as your cousin;
a while ago you called her your aunt."

"Well, she IS my aunt, and my cousin, too. And
also my step-sister, my niece, my fourth cousin, my
thirty-third cousin, my forty-second cousin, my great-
aunt, my grandmother; my widowed sister-in-law --
and next week she will be my wife."

So the charge of nepotism against the chief magis-
trate was weak. But no matter; weak or strong, it
suited Stavely. Stavely was immediately elected to the
vacant magistracy, and, oozing reform from every
pore, he went vigorously to work. In no long time
religious services raged everywhere and unceasingly.
By command, the second prayer of the Sunday morn-
ing service, which had customarily endured some thirty-
five or forty minutes, and had pleaded for the world,
first by continent and then by national and tribal detail,
was extended to an hour and a half, and made to in-
clude supplications in behalf of the possible peoples in
the several planets. Everybody was pleased with this;
everybody said, "Now THIS is something LIKE." By
command, the usual three-hour sermons were doubled
in length. The nation came in a body to testify their
gratitude to the new magistrate. The old law for-
bidding cooking on the Sabbath was extended to the
prohibition of eating, also. By command, Sunday-
school was privileged to spread over into the week.
The joy of all classes was complete. In one short
month the new magistrate had become the people's
idol.

The time was ripe for this man's next move. He
began, cautiously at first, to poison the public mind
against England. He took the chief citizens aside,
one by one, and conversed with them on this topic.
Presently he grew bolder, and spoke out. He said the
nation owed it to itself, to its honor, to its great tradi-
tions, to rise in its might and throw off "this galling
English yoke."

But the simple islanders answered:

"We had not noticed that it galled. How does it
gall? England sends a ship once in three or four years
to give us soap and clothing, and things which we
sorely need and gratefully receive; but she never
troubles us; she lets us go our own way."

"She lets you go your own way! So slaves have
felt and spoken in all the ages! This speech shows
how fallen you are, how base, how brutalized you
have become, under this grinding tyranny! What!
has all manly pride forsaken you? Is liberty nothing?
Are you content to be a mere appendage to a foreign
and hateful sovereignty, when you might rise up and
take your rightful place in the august family of nations,
great, free, enlightened, independent, the minion of no
sceptered master, but the arbiter of your own destiny,
and a voice and a power in decreeing the destinies of
your sister-sovereignties of the world?"

Speeches like this produced an effect by and by.
Citizens began to feel the English yoke; they did not
know exactly how or whereabouts they felt it, but they
were perfectly certain they did feel it. They got to
grumbling a good deal, and chafing under their chains,
and longing for relief and release. They presently fell
to hating the English flag, that sign and symbol of their
nation's degradation; they ceased to glance up at it as
they passed the capitol, but averted their eyes and
grated their teeth; and one morning, when it was
found trampled into the mud at the foot of the staff,
they left it there, and no man put his hand to it to
hoist it again. A certain thing which was sure to hap-
pen sooner or later happened now. Some of the chief
citizens went to the magistrate by night, and said:

"We can endure this hated tyranny no longer. How
can we cast it off?"

"By a coup d'etat."

"How?"

"A coup d'etat. It is like this: everything is got
ready, and at the appointed moment I, as the official
head of the nation, publicly and solemnly proclaim its
independence, and absolve it from allegiance to any
and all other powers whatsoever."

"That sounds simple and easy. We can do that
right away. Then what will be the next thing to do?"

"Seize all the defenses and public properties of all
kinds, establish martial law, put the army and navy on
a war footing, and proclaim the empire!"

This fine program dazzled these innocents. They
said:

"This is grand -- this is splendid; but will not Eng-
land resist?"

"Let her. This rock is a Gibraltar."

"True. But about the empire? Do we NEED an
empire and an emperor?"

"What you NEED, my friends, is unification. Look
at Germany; look at Italy. They are unified. Unifi-
cation is the thing. It makes living dear. That con-
stitutes progress. We must have a standing army, and
a navy. Taxes follow, as a matter of course. All
these things summed up make grandeur. With unifica-
tion and grandeur, what more can you want? Very
well -- only the empire can confer these boons."

So on the 8th day of December Pitcairn's Island was
proclaimed a free and independent nation; and on the
same day the solemn coronation of Butterworth I.,
emperor of Pitcairn's Island, took place, amid great re-
joicings and festivities. The entire nation, with the ex-
ception of fourteen persons, mainly little children,
marched past the throne in single file, with banners and
music, the procession being upwards of ninety feet
long; and some said it was as much as three-quarters
of a minute passing a given point. Nothing like it had
ever been seen in the history of the island before.
Public enthusiasm was measureless.

Now straightway imperial reforms began. Orders of
nobility were instituted. A minister of the navy was
appointed, and the whale-boat put in commission. A
minister of war was created, and ordered to proceed at
once with the formation of a standing army. A first
lord of the treasury was named, and commanded to get
up a taxation scheme, and also open negotiations for
treaties, offensive, defensive, and commercial, with for-
eign powers. Some generals and admirals were ap-
pointed; also some chamberlains, some equerries in
waiting, and some lords of the bedchamber

At this point all the material was used up. The
Grand Duke of Galilee, minister of war, complained
that all the sixteen grown men in the empire had been
given great offices, and consequently would not consent
to serve in the ranks; wherefore his standing army was
at a standstill. The Marquis of Ararat, minister of the
navy, made a similar complaint. He said he was will-
ing to steer the whale-boat himself, but he MUST have
somebody to man her.

The emperor did the best he could in the circum-
stances: he took all the boys above the age of ten years
away from their mothers, and pressed them into the
army, thus constructing a corps of seventeen privates,
officered by one lieutenant-general and two major-gen-
erals. This pleased the minister of war, but procured
the enmity of all the mothers in the land; for they said
their precious ones must now find bloody graves in the
fields of war, and he would be answerable for it. Some
of the more heartbroken and unappeasable among
them lay constantly in wait for the emperor and threw
yams at him, unmindful of the bodyguard.

On account of the extreme scarcity of material, it
was found necessary to require the Duke of Bethany,
postmaster-general, to pull stroke-oar in the navy, and
thus sit in the rear of a noble of lower degree, namely,
Viscount Canaan, lord justice of the common pleas.
This turned the Duke of Bethany into a tolerably open
malcontent and a secret conspirator -- a thing which
the emperor foresaw, but could not help.

Things went from bad to worse. The emperor raised
Nancy Peters to the peerage on one day, and married
her the next, notwithstanding, for reasons of state, the
cabinet had strenuously advised him to marry Emme-
line, eldest daughter of the Archbishop of Bethlehem.
This caused trouble in a powerful quarter -- the church.
The new empress secured the support and friendship of
two-thirds of the thirty-six grown women in the nation
by absorbing them into her court as maids of honor;
but this made deadly enemies of the remaining twelve.
The families of the maids of honor soon began to rebel,
because there was nobody at home to keep house.
The twelve snubbed women refused to enter the im-
perial kitchen as servants; so the empress had to require
the Countess of Jericho and other great court dames to
fetch water, sweep the palace, and perform other menial
and equally distasteful services. This made bad blood
in that department.

Everybody fell to complaining that the taxes levied
for the support of the army, the navy, and the rest of
the imperial establishment were intolerably burdensome,
and were reducing the nation to beggary. The em-
peror's reply -- "Look at Germany; look at Italy. Are
you better than they? and haven't you unification?" --
did not satisfy them. They said, "People can't EAT
unification, and we are starving. Agriculture has
ceased. Everybody is in the army, everybody is in the
navy, everybody is in the public service, standing
around in a uniform, with nothing whatever to do,
nothing to eat, and nobody to till the fields --"

"Look at Germany; look at Italy. It is the same
there. Such is unification, and there's no other way
to get it -- no other way to keep it after you've got it,"
said the poor emperor always.

But the grumblers only replied, "We can't STAND the
taxes -- we can't STAND them."

Now right on top of this the cabinet reported a
national debt amounting to upwards of forty-five dol-
lars -- half a dollar to every individual in the nation.
And they proposed to fund something. They had
heard that this was always done in such emergencies.
They proposed duties on exports; also on imports.
And they wanted to issue bonds; also paper money,
redeemable in yams and cabbages in fifty years. They
said the pay of the army and of the navy and of the
whole governmental machine was far in arrears, and
unless something was done, and done immediately,
national bankruptcy must ensue, and possibly insurrec-
tion and revolution. The emperor at once resolved
upon a high-handed measure, and one of a nature never
before heard of in Pitcairn's Island. He went in state
to the church on Sunday morning, with the army at his
back, and commanded the minister of the treasury to
take up a collection.

That was the feather that broke the camel's back.
First one citizen, and then another, rose and refused
to submit to this unheard-of outrage -- and each refusal
was followed by the immediate confiscation of the
malcontent's property. This vigor soon stopped the
refusals, and the collection proceeded amid a sullen and
ominous silence. As the emperor withdrew with the
troops, he said, "I will teach you who is master here."
Several persons shouted, "Down with unification!"
They were at once arrested and torn from the arms of
their weeping friends by the soldiery.

But in the meantime, as any prophet might have fore-
seen, a Social Democrat had been developed. As the
emperor stepped into the gilded imperial wheelbarrow
at the church door, the social democrat stabbed at him
fifteen or sixteen times with a harpoon, but fortunately
with such a peculiarly social democratic unprecision of
aim as to do no damage.

That very night the convulsion came. The nation
rose as one man -- though forty-nine of the revolu-
tionists were of the other sex. The infantry threw
down their pitchforks; the artillery cast aside their
cocoanuts; the navy revolted; the emperor was seized,
and bound hand and foot in his palace. He was very
much depressed. He said:

"I freed you from a grinding tyranny; I lifted you
up out of your degradation, and made you a nation
among nations; I gave you a strong, compact, cen-
tralized government; and, more than all, I gave you
the blessing of blessings, -- unification. I have done all
this, and my reward is hatred, insult, and these bonds.
Take me; do with me as you will. I here resign my
crown and all my dignities, and gladly do I release my-
self from their too heavy burden. For your sake I took
them up; for your sake I lay them down. The im-
perial jewel is no more; now bruise and defile as ye will
the useless setting."

By a unanimous voice the people condemned the ex-
emperor and the social democrat to perpetual banish-
ment from church services, or to perpetual labor as
galley-slaves in the whale-boat -- whichever they might
prefer. The next day the nation assembled again, and
rehoisted the British flag, reinstated the British tyranny,
reduced the nobility to the condition of commoners
again, and then straightway turned their diligent atten-
tion to the weeding of the ruined and neglected yam
patches, and the rehabilitation of the old useful indus-
tries and the old healing and solacing pieties. The ex-
emperor restored the lost trespass law, and explained
that he had stolen it -- not to injure any one, but to
further his political projects. Therefore the nation gave
the late chief magistrate his office again, and also his
alienated property.

Upon reflection, the ex-emperor and the social demo-
crat chose perpetual banishment from religious services
in preference to perpetual labor as galley-slaves "with
perpetual religious services," as they phrased it;
wherefore the people believed that the poor fellows'
troubles had unseated their reason, and so they judged
it best to confine them for the present. Which they
did.

Such is the history of Pitcairn's "doubtful acquisition."

END.
