/***********************************************************************
  Author:  SemWare (Sammy Mitchell)
           Additional help and input from Gary Weinfurther, Bradley Small

  Date:    April 5, 1993    Initial version
           April 9, 1993    Add Copy/Cut/Paste per Gary Weinfurther

  Description:

  CUA style shift-cursor block marking/manipulation macro for TSE.  Tested
  with TSE 1.0.  To work properly, you _must_ have EquateEnhancedKbd ON!!!
  (This is the factory default)

  This macro will allow the dedicated (or 'grey' in TSE terms) cursor keypad
  keys to be used to block a character block when shift is pressed in
  combination with them, as in the Borland IDE, the MS-DOS editor, and many
  Windows applications.

  In addition, the following CUA compliant keys have been assigned:

  shift ins - Paste
  ctrl ins  - Copy
  ctrl del  - DelBlock
  shift del - Cut

  Usage notes:

  To work properly, you _must_ have EquateEnhancedKbd ON!!!  (This is the
  factory default)

  To use, add these macros to your TSE.S file, and key assignments to
  your TSE.KEY file, and re-bind the editor using the -b switch of sc.

  Alternatively, add the key assignments to this file, and load the
  macro (as an external macro) as needed via the LoadMacro command
  (<ctrl f10><L> or 'menu->macro->load')

------------------------------------------------------------------------

   binary file (referenced below) is: (can be built using debug)

    mov     ah, 2
    int     16h
    mov     ah, 0
    cwd
    retf

    Note that this file is only needed at compile time, not at actual
    macro run time.
 ***********************************************************************/

 // return the keyboard flags (shift, ctrl, alt, etc)
binary ["getshift.bin"]
    integer proc GetShiftState() : 0
end

// return FALSE if no shift keys pressed; non-zero otherwise.
integer proc ShiftKeyPressed()
    return (GetShiftState() & 3)
end

// do the default action for the passed key; return FALSE if the key is
// not recognized.
integer proc DoCursorCommand(integer key)
    case key
        when <CursorRight>, <GreyCursorRight>
            Right()
        when <CursorLeft>,  <GreyCursorLeft>
            Left()
        when <CursorUp>,    <GreyCursorUp>
            Up()
        when <CursorDown>,  <GreyCursorDown>
            Down()
        when <Home>,        <GreyHome>
            BegLine()
        when <End>,         <GreyEnd>
            EndLine()
        when <PgUp>,        <GreyPgUp>
            PageUp()
        when <PgDn>,        <GreyPgDn>
            PageDown()
        otherwise
            return (FALSE)
    endcase
    return (TRUE)
end

// Do CUA style marking for dedicated keypad cursor keys.  If the shift
// key is not pressed, do the normal cursor movement.
proc CUACursorKeys()
    if not ShiftKeyPressed()
        DoCursorCommand(Query(key))
        return ()
    endif
    UnmarkBlock()
    MarkChar()
    DoCursorCommand(Query(key))
    UpdateDisplay()
    While ShiftKeyPressed()
        if KeyPressed()
            if DoCursorCommand(GetKey())
                UpdateDisplay()
            else
                PushKey(Query(key))
                break
            endif
        endif
    endwhile
    Set(Marking, off)
end

// Handles the DEL key, both shift and unshifted
proc mDelete()
    if ShiftKeyPressed()
        Cut()
    else
        if CurrChar() >= 0
            DelChar()
        else
            JoinLine()
        endif
    endif
end

// Handles the INS key, both shifted and unshifted
proc mInsert()
    if ShiftKeyPressed()
        Paste()
    else
        ToggleInsert()
    endif
end

// key definitions

<Ins>         mInsert()
<Ctrl Ins>    Copy()
<Del>         mDelete()
<Ctrl Del>    DelBlock()

<CursorRight> CUACursorKeys()
<CursorLeft>  CUACursorKeys()
<CursorUp>    CUACursorKeys()
<CursorDown>  CUACursorKeys()
<Home>        CUACursorKeys()
<End>         CUACursorKeys()
<PgUp>        CUACursorKeys()
<PgDn>        CUACursorKeys()
