\  VARIABLE.S
\  This table contains a collection of unrelated
\  variable-length search-and-replace equations
\  for EXAMPLE purposes.

\  This table will run VERY slowly, because we are using
\  equations with first-character wild cards in addition to the
\  variable-length search-and-replace.

\  In normal practice, you'll use only one of these sample equation
\  patterns in a table. That will speed things up.

\ ***************************************************************************

\  This equation puts a special code in front of a line in which the first
\  three words are capitalized. The limit for a "word" is up to 15
\  characters. The literal reading of this equation is:

\  any printable character + up to 15 upper case letters terminated by a 
\  space + up to 15 upper case letters terminated by a space + up to 15 
\  upper case letters terminated by a space + up to 80 printable characters 
\  terminated by a CR-LF = [CAP LINE] + the first character of the line + 
\  word 1 + a space + word 2 + a space + word 3 + a space + rest of line + 
\  a CR-LF

\v\^*(15)\u \^*(15)\u \^*(15)\u \^*(80)\v\0d\0a=            \+ continued...
[CAP LINE]\p0\^1 \^2 \^3 \^4\0d\0a

\ ***************************************************************************

\  This equation will scan a line for the presence of leader dots and then
\  put a code in front a line that contains them. The literal reading of
\  this equation is:

\  any printable character + up to 80 printable characters terminated by 
\  four periods + up to 80 more printable characters terminated by a CR-LF 
\  = [LEADERED LINE] + the first character of the line + the first 
\  variable-length string + four periods + the second variable-length 
\  string + a CR-LF

\v\^*(80)\v....\^*(80)\v\0d\0a=[LEADERED LINE]\p0\^1....\^2\0d\0a

\  You could change the effect of the equation by changing the four periods
\  to some other literal text, such as the word "CHAPTER" or a question mark
\  or anything you choose. Try it.

\ ***************************************************************************

\  This equation will put a special code in front of a line that is preceded
\  and followed by blank lines. The literal reading of this equation is:

\  two CR-LFs + up to 100 printable characters terminated by two CR-LFs 
\  = two CR-LFs + [SINGLE LINE] + the first variable-length string + two 
\  CR-LFs

\0d\0a\0d\0a\^*(100)\v\0d\0a\0d\0a=\0d\0a\0d\0a[SINGLE LINE]\^1\0d\0a\0d\0a

\ ***************************************************************************

\  This equation will swap the order of 5 variable-length columns which are
\  separated by ASCII tab codes (hex 09). The literal reading of this equation
\  is:

\  any printable character + up to 40 printable characters terminated by 
\  a tab + up to 40 printable characters terminated by a tab + up to 40 
\  printable characters terminated by a tab + up to 40 printable characters 
\  terminated by a tab + up to 40 printable characters terminated by a 
\  CR-LF = the second variable-length string + tab + the fourth 
\  variable-length string + tab + the first character of the line + the 
\  first variable-length string + tab + the fifth variable-length string + 
\  tab + the third variable-length string + CR-LF

\v\^*(40)\v\09\^*(40)\v\09\^*(40)\v\09\^*(40)\v\09\^*(40)\v\0d\0a=  \+ cont.
\^2\09\^4\09\p0\^1\09\^5\09\^3\0d\0a

\ ***************************************************************************

\  IMPORTANT NOTE: All of the above equations happen to use the CR-LF
\  terminator. It is NOT a requirement in SNR that variable-length
\  equations end in CR-LF! Any literal character string that suits your
\  purpose is allowed as a terminator. Here's an example:

[\^*(20)\v]=

\  The equation reads:
\  a left bracket + up to 20 printable characters terminated by a
\  right bracket = nothing

\ ***************************************************************************

\  The following equation will scan for the presence of a city, state, zip
\  sequence of characters and mark the line appropriately. The literal
\  reading of this equation is:

\  an upper case letter + up to 40 characters terminated by a comma + up 
\  to 20 spaces terminated by 2 upper case letters + up to 20 spaces 
\  terminated by 5 numbers = [city] + the first character + variable-length 
\  string 1 + variable-length string 2 + [state] + variable-length string 
\  2's terminator + variable-length string 3 + [zip] + variable-length 
\  string 3's terminator


\u\^*(40)\v,\^*(20) \u\u\^*(20) \n\n\n\n\n=     \+ continued
[city]\p0\^1,\^2[state]\^:2\^3[zip]\^:3

\  The next equation does basically the same thing, except for Canadian
\  city, province, country. Zips are of the form A1B2C3.

\u\^*(30)\v \^*(30)\v\^*(20) Can\^*(5)\v\^*(20) \u\n\u\n\u\n=     \+ continued
[city/province]\p0\^1\^:1\^2\^3[country]\^:3\^4\^5[zip]\^:5

\ (Same as preceding, except zips are of the form A1B 2C3)
\u\^*(30)\v \^*(30)\v\^*(20) Can\^*(5)\v\^*(20) \u\n\u \n\u\n=     \+ continued
[city/province]\p0\^1\^:1\^2\^3[country]\^:3\^4\^5[zip]\^:5

\ ***************************************************************************

\  The following equations will swap the order of two arguments in a couple
\  of 'C' language function calls. You programmers out there -- pay
\  attention! You can use this technique for ANY language whose functions or
\  subroutines require arguments.

\  This first example turns an fputs() function into a puts() function by
\  renaming the function and keeping only the second argument

fputs(\^*(20)\v,\^*(20)\v)=puts(\^2)

\  This second example swaps the order of the two arguments in a stpcpy()
\  function and renames it to strcpy() at the same time

stpcpy(\^*(20)\v,\^*(20)\v)=strcpy(\^2,\^1)

\  You probably won't ever need to swap the order of arguments in such
\  common functions as fputs and stpcpy, but it's a handy technique to know.

\ ***************************************************************************

