/*****************************************************************************\
*                                                                             *
* ewapi.h -     E! API functions, types, and definitions                      *
*                                                                             *
*               Version 1.2                                                   *
*                                                                             *
*               Copyright (c) 1992,1993 Patrick Philippot, GIS                *
*                                                                             *
******************************************************************************/

#ifndef _INC_EWAPI
#define _INC_EWAPI      /* #defined if ewapi.h has been included */

/* Command codes used to identify EW functions within hooks */

#define ew_MFOpen            201
#define ew_MFNew             202
#define ew_MFClone           203
#define ew_MFGet             204
#define ew_MFWrite           205
#define ew_MFAppend          206
#define ew_MFSave            207
#define ew_MFSaveAs          208
#define ew_MFRefresh         209
#define ew_MFGrep            210
#define ew_MFAssociate       211
#define ew_MFCC              215
#define ew_MFPrint           217
#define ew_MFPrintSetup      218
#define ew_MFPageSetup       219
#define ew_MFExit            221
#define ew_MFExitEditor      222

#define ew_MEUndo            301
#define ew_MEClearUndo       302
#define ew_MECut             304
#define ew_MECutAppend       305
#define ew_MECopy            306
#define ew_MECopyAppend      307
#define ew_MEPasteIns        308
#define ew_MEPasteOvr        309
#define ew_MEClear           311
#define ew_MESelectAll       312
#define ew_MEDelete          314
#define ew_MEDraw            316
#define ew_MERecordMac       318
#define ew_MELoadMac         319
#define ew_MESaveMac         320
#define ew_MEReplayMac       321
#define ew_MEReplayMacN      322
#define ew_MEAsciiMode       323

#define ew_MBSet             401
#define ew_MBGotoMark1       403
#define ew_MBGotoMark2       404
#define ew_MBGotoMark3       405
#define ew_MBRemoveMark1     407
#define ew_MBRemoveMark2     408
#define ew_MBRemoveMark3     409
#define ew_MBGoto            411
#define ew_MBGotoSel         412
#define ew_MBCompare         414

#define ew_MSFind            501
#define ew_MSRepeatFind      502
#define ew_MSFindWord        503

#define ew_MCCompile         601
#define ew_MCMake            602
#define ew_MCRebuild         603
#define ew_MCDebug           604
#define ew_MCExecute         605
#define ew_MCNext            607
#define ew_MCPrevious        608
#define ew_MCCommands        610

#define ew_MLSet             701
#define ew_MLSaveCnf         702
#define ew_MLLoadCnf         703
#define ew_MLAssign          705
#define ew_MLExpansion       707

#define ew_MWRibbon          801
#define ew_MWHide            803
#define ew_MWTile            805
#define ew_MWCascade         806
#define ew_MWHideAll         807
#define ew_MWIconizeAll      808
#define ew_MWScrolling       810
#define ew_MWFont            812

#define ew_MULoadExt         901
#define ew_MUUnloadExt       902
#define ew_MUExecuteExt      903
#define ew_MUAutoLoad        904
#define ew_DefineMenu        906

#define ew_AddTab               9001
#define ew_BlockShift           9010
#define ew_BeginLine            9011
#define ew_CasePrimUpper        9012
#define ew_CasePrimLower        9013
#define ew_CheckBrace           9014
#define ew_ClearLine            9015
#define ew_DeleteCurLine        9016
#define ew_DeleteEOL            9017
#define ew_DeleteLeftChar       9018
#define ew_DeleteWord           9019
#define ew_EndLine              9020
#define ew_Enter                9021
#define ew_GoNextPar            9022
#define ew_GoNextTab            9023
#define ew_GoPrevPar            9024
#define ew_GoPrevTab            9025
#define ew_InputPause           9026
#define ew_InsertBrace          9027
#define ew_InsertDate           9028
#define ew_InsertFilename       9029
#define ew_InsertTime           9030
#define ew_JoinLine             9031
#define ew_LoadUserFile         9032
#define ew_NextCol              9041
#define ew_NextLine             9042
#define ew_NextWord             9043
#define ew_PageBottom           9044
#define ew_PageTop              9045
#define ew_PageScrollHLeft      9046
#define ew_PageScrollHRight     9047
#define ew_PageScrollVDown      9048
#define ew_PageScrollVUp        9049
#define ew_PrevCol              9050
#define ew_PrevLine             9051
#define ew_PrevWord             9052
#define ew_Reflow               9054
#define ew_RemoveTab            9055
#define ew_SetCurLine2Bottom    9056
#define ew_SetCurLine2Middle    9057
#define ew_SetCurLine2Top       9058
#define ew_ShiftTextRight       9059
#define ew_SplitLine            9072
#define ew_StepScrollDown       9073
#define ew_StepScrollLeft       9074
#define ew_StepScrollRight      9075
#define ew_StepScrollUp         9076
#define ew_StripFlow            9077
#define ew_SumBlock             9078
#define ew_TextBoundBegin       9079
#define ew_TextBoundEnd         9080
#define ew_TextToCursor         9081
#define ew_ToggleIns            9082
#define ew_UpcaseFirst          9083
#define ew_UserBlockSort        9084
#define ew_UserFillBlock        9085

/* Value that should be returned by EWExecute or by a hook if the extension
   failed. Otherwise return 0 or leave the original EW return code unchanged. */

#define ewerr_EXTFAILED 300

/* Values returned by EWCallUserExt if the extension could not be executed */

#define ewerr_NOSUCHEXTENSION  301
#define ewerr_NOEXECEXPORTED   302

/* Values that may be returned after execution of an editing function */

#define ewerr_CANTMOVE     351  /* The cursor could not be moved as requested */
#define ewerr_CANTPROCEED  352  /* The function could not be executed  */

 /* Values passed by EWSetHook and EWRemoveHook to EW */

#define EWHook_FunctionEntry   0
#define EWHook_FunctionExit    1
#define EWHook_KeyboardEntry   2
#define EWHook_PaintEntry      3
#define EWHook_LoadExit        4
#define EWHook_Notify          5

/* Values passed by EW to the callback notification hook to identify the event */

#define EWNotify_ExitEditor    0
#define EWNotify_CreateClone   1
#define EWNotify_DestroyClone  2
#define EWNotify_FileAutosaved 3
#define EWNotify_FontChanged   4
#define EWNotify_PosChanged    5
#define EWNotify_ActWinChanged 6
#define EWNotify_CharEntry     7
#define EWNotify_CharExit      8

/* Possible assignment modes when using EWAddMenuEntry */

#define EWMNU_Program   0
#define EWMNU_Command   1
#define EWMNU_Macro     2
#define EWMNU_Extension 3

/* Global Flags constants */

#define  EWGlbShow              1     /* Show edit window when created */
#define  EWGlbShowWild          2     /* Show windows created with wildcards */
#define  EWGlbMinCC             3     /* Iconize CC after creating window */
#define  EWGlbReShowCC          4     /* Reshow CC after edit window creation */
#define  EWGlbDispShortCuts     5     /* Display shortcuts in menus */
#define  EWGlbReplaceSel        6     /* Typing replace Selection */
#define  EWGlbAddOnLast         7     /* Insert with  on last line */
#define  EWGlbFormatFrom        8     /* Format from current line only */
#define  EWGlbExpansion         9     /* Syntax Expansion enabled */
#define  EWGlbAutoMacros       10     /* Auto Macros enabled */
#define  EWGlbEnterClassic     11     /* Split line with Enter */
#define  EWGlbInsert           12     /* Insert on by default */
#define  EWGlbAutoScroll       13     /* Use autoscroll mode */
#define  EWGlbAlarm            14     /* Beep on error */
#define  EWGlbLog              15     /* Maintain session logging */
#define  EWGlbBak              16     /* Create .BAK flags */
#define  EWGlbWarning          17     /* Warning before file overwrite */
#define  EWGlbLoadList         18     /* @xxxx.xxx files are lists */
#define  EWGlbAutosaveOpt      19     /* Autosave options */
#define  EWGlbAutosave         20     /* Autosave files */
#define  EWGlbDeleteOut        21     /* Suppress .ERR file */
#define  EWGlbGrepRegular      22     /* Grep uses Boolean Search */
#define  EWGlbGrepAnsi         23     /* Grep uses Ansi charset */
#define  EWGlbGrepCase         24     /* Grep makes a case sensitive search */
#define  EWGlbGrepSubDir       25     /* Grep searches in subdirectories */
#define  EWGlbJump             26     /* Jump on Home/End */
#define  EWGlbHasScrollbars    27     /* Edit Windows have Scrollbars */
#define  EWGlbHasRibbon        28     /* Edit Windows have a Ribbon */
#define  EWGlbRepaint          29     /* Scroll method */
#define  EWGlbStripJoin        30     /* Strip Spaces when joining lines */

/* Local Flags constants */

#define  EWLclbBlank       1          /* Strip trailing blanks */
#define  EWLclbAutoBack    2          /* Backspace behaviour */
#define  EWLclbAutoTab     4          /* Autotab flag */
#define  EWLclbAutoInsert  5          /* AutoInsert braces */
#define  EWLclbAutoComp    6          /* AutoCompress tabs */
#define  EWLclbWordWrap    7          /* Wordwrap */
#define  EWLclbJustify     8          /* Right justification */
#define  EWLclbLoadAscii   9          /* Loaded file supposed to be Ascii file */
#define  EWLclbSaveAscii  10          /* Save file in Ascii format */
#define  EWLclbEOF        11          /* Add a Ctrl Z at the end of the file */
#define  EWLclbAutoIndent 12          /* Auto Indentation */

/* Search Flags constants */

#define  EWSearchbBackward  1         /* Backward search */
#define  EWSearchbBlock     2         /* Search within marked block only */
#define  EWSearchbCase      3         /* Case sensitive search */
#define  EWSearchbKeepCase  4         /* Keep case type when replacing string */
#define  EWSearchbGlobal    5         /* Global Search */
#define  EWSearchbGothru    6         /* Replace without prompting */
#define  EWSearchbRegular   7         /* Boolean search flag */
#define  EWSearchbWord      8         /* Word-only search */
#define  EWSearchbAcross    9         /* Search across edited files */

/* Compile command codes */

#define  EWCompileCommand   0
#define  EWMakeCommand      1
#define  EWBuildCommand     2
#define  EWDebugCommand     3
#define  EWExecuteCommand   4

/* Macro string codes */

#define  EWMacro_Time       0
#define  EWMacro_Date       1
#define  EWMacro_FileName   2

/* Position codes */

#define  EWPosition_Top     0
#define  EWPosition_Middle  1
#define  EWPosition_Bottom  2

/* Selection modes */

#define  EWSelection_None   0
#define  EWSelection_Line   1
#define  EWSelection_Stream 2
#define  EWSelection_Block  3

/* Write modes for EWWriteBlock */

#define EWWrite_ReWrite     1
#define EWWrite_Append      2

typedef struct tagTSelStruct
{

  unsigned int SelType;
  int FirstSelLine;
  int LastSelLine;
  int FirstSelCol;
  int LastSelCol;
  int StartSelIndex;
  int EndSelIndex;

} TSelStruct;

typedef TSelStruct FAR* PSelStruct;

typedef void (FAR PASCAL* TEnumEditorsProc)(long EditorId, char FAR* Name);
typedef void (FAR PASCAL* TEnumClonesProc)(HANDLE CloneHandle, BYTE CloneId);
typedef int  (FAR PASCAL* TFuncEntryHook)(unsigned int command);
typedef int  (FAR PASCAL* TFuncExitHook)(unsigned int command, int FAR* pRetcode);
typedef int  (FAR PASCAL* TKbdEntryHook)(MSG MSg);
typedef int  (FAR PASCAL* TPaintEntryHook)(HDC DC,
                                           PAINTSTRUCT FAR* PaintInfo,
                                           PSelStruct SelInfo,
                                           HANDLE hWindow);
typedef int  (FAR PASCAL* TLoadExitHook)(long EditorId);
typedef int  (FAR PASCAL* TNotifyHook)(unsigned int code, unsigned int wParam, long lParam);
typedef int  (FAR PASCAL* TExecFunc)(unsigned int MenuId);

/* Editing functions */

int FAR PASCAL EWAddTab(int col, unsigned int fAdd);
int FAR PASCAL EWAlternateHelp(int col, int row);
int FAR PASCAL EWBeginLine(unsigned int fSkipToPrev);
int FAR PASCAL EWBlockShift(void);
int FAR PASCAL EWBlockSort(unsigned int fAscend);
int FAR PASCAL EWCase(unsigned int fUpper);
int FAR PASCAL EWCheckBrace(int col, int row);
int FAR PASCAL EWClearLine(int row);
int FAR PASCAL EWExecCompileCommand(unsigned int commandindex);
int FAR PASCAL EWDeleteChar(void);
int FAR PASCAL EWDeleteCurLine(void);
int FAR PASCAL EWDeleteEOL(void);
int FAR PASCAL EWDeleteLeft(unsigned int fDeleteCurrent);
int FAR PASCAL EWDeleteLines(int start, int num);
int FAR PASCAL EWDeleteSelection(void);
int FAR PASCAL EWDeleteWord(void);
int FAR PASCAL EWEndLine(unsigned int fSkipToNext, unsigned int fStrip);
int FAR PASCAL EWFillBlock(unsigned char ch);
int FAR PASCAL EWGetFile(char FAR* Name, int row);
int FAR PASCAL EWGotoBookmark(unsigned int index);
int FAR PASCAL EWGotoNextParagraph(void);
int FAR PASCAL EWGotoNextTab(void);
int FAR PASCAL EWGotoPrevTab(void);
int FAR PASCAL EWGotoPrevParagraph(void);
int FAR PASCAL EWGotoCompileError(unsigned int fNext);
int FAR PASCAL EWGotoLine(int row);
int FAR PASCAL EWGotoXY(int col, int row);
int FAR PASCAL EWGotoSelection(unsigned int fBegin);
int FAR PASCAL EWInsertBrace(int col, int row);
int FAR PASCAL EWInsertLines(int start, int num);
int FAR PASCAL EWInsertMacroText(int col, int row, unsigned int macrotype);
int FAR PASCAL EWJoinLine(int row);
int FAR PASCAL EWLoadUserFile(int col, int row);
int FAR PASCAL EWNextCol(void);
int FAR PASCAL EWNextLine(void);
int FAR PASCAL EWNextWord(unsigned int fNext);
int FAR PASCAL EWTopOfPage(unsigned int fTop);
int FAR PASCAL EWHorzPageScroll(unsigned int fLeft);
int FAR PASCAL EWVerPageScroll(unsigned int fUp);
int FAR PASCAL EWPrevCol(void);
int FAR PASCAL EWPrevLine(void);
int FAR PASCAL EWPaste(unsigned int fInsert);
int FAR PASCAL EWReflow(int row);
int FAR PASCAL EWRefresh(unsigned int bAsk);
int FAR PASCAL EWRemoveBookmark(unsigned int index);
int FAR PASCAL EWSaveFile(char FAR* Name);
int FAR PASCAL EWSelectAll(void);
int FAR PASCAL EWSetBookmark(int col, int row);
int FAR PASCAL EWSetClipboard(unsigned int fAppend);
int FAR PASCAL EWPositionCurLine(unsigned int position);
int FAR PASCAL EWShiftTextRight(int col, int row, int count);
int FAR PASCAL EWSplitLine(int col, int row);
int FAR PASCAL EWStepScroll(int dX, int dY);
int FAR PASCAL EWSumBlock(void);
int FAR PASCAL EWStripFlow(void);
int FAR PASCAL EWTopOfText(unsigned int fTop);
int FAR PASCAL EWTextToCurSor(void);
int FAR PASCAL EWToggleInsert(void);
int FAR PASCAL EWUpcaseFirst(int col, int row);
int FAR PASCAL EWWriteBlock(int startrow,
                            int endrow,
                            int startcol,
                            int endcol,
                            char FAR* Name,
                            unsigned int mode,
                            unsigned int fBlock,
                            unsigned int fCompress);


/* Service functions */

long FAR PASCAL EWAddMenuEntry(char FAR* Command,
                               char FAR* Title,
                               unsigned int CommandId,
                               unsigned int AssignMode,
                               unsigned int RoutineId);
int FAR PASCAL EWBeginSelection(unsigned int SelType, int col, int row);
int FAR PASCAL EWCallUserExt(char FAR* Name);
long FAR PASCAL EWEditFile(char FAR* Name);
int FAR PASCAL EWEndSelection(void);
void FAR PASCAL EWEnumClones(long EditorId, TEnumClonesProc CloneEnumProc);
void FAR PASCAL EWEnumEditors(TEnumEditorsProc EdEnumProc);
long FAR PASCAL EWFind(unsigned int FAR* MatchLen);
unsigned int FAR PASCAL EWFindRegular(char FAR* src,
                                      char FAR* dest,
                                      unsigned int FAR* MatchLen);
long FAR PASCAL EWGetCaretPos(void);
unsigned int FAR PASCAL EWGetCloneNum(void);
long FAR PASCAL EWGetCurWord(void);
long FAR PASCAL EWGetCurrentEditor(void);
char FAR* FAR PASCAL EWGetFileName(long EditorId);
int FAR PASCAL  EWGetGlobalFlag(unsigned int FlagId);
unsigned int FAR PASCAL EWGetInsertState(void);
char FAR* FAR PASCAL EWGetLineAt(int index);
int FAR PASCAL EWGetLineCount(void);
int FAR PASCAL EWGetLocalFlag(unsigned int FlagId);
int FAR PASCAL EWGetSearchFlag(unsigned int FlagId);
void FAR PASCAL EWGetSelection(PSelStruct Selection);
long FAR PASCAL EWGetTextPos(void);
unsigned int FAR PASCAL EWGetVersion(void);
unsigned int FAR PASCAL EWGetWindowHandle(void);
void FAR PASCAL EWRemoveHook(unsigned int hFlag, void FAR* HookAddress);
int FAR PASCAL EWRemoveMenuEntry(long Id);
long FAR PASCAL EWRepeatFind(unsigned int FAR* MatchLen);
long FAR PASCAL EWSetCurrentEditor(long EditorId);
void FAR PASCAL EWSetFindPattern(char FAR* pattern);
int FAR PASCAL EWSetGlobalFlag(unsigned int FlagId, unsigned int value);
void FAR PASCAL EWSetHook(unsigned int hFlag, void FAR* HookAddress);
int FAR PASCAL EWSetLineAt(char FAR* P, int index);
int FAR PASCAL EWSetLocalFlag(unsigned int FlagId, unsigned int value);
void FAR PASCAL EWSetModified(void);
int FAR PASCAL EWSetSearchFlag(unsigned int FlagId, unsigned int value);
int FAR PASCAL EWStopSelection(int col, int row);
int FAR PASCAL EWUpdateSelection(int col, int row);
void FAR PASCAL EWWriteMessage(char FAR* message);
unsigned int FAR PASCAL EWGetTextWindowHandle(void);
unsigned int FAR PASCAL EWGetInstance(void);
unsigned int FAR PASCAL EWIsModified(void);
int FAR PASCAL EWGetEditorLocalFlag(unsigned int FlagId);
int FAR PASCAL EWSetEditorLocalFlag(unsigned int FlagId, unsigned int value);
int FAR PASCAL EWSaveAll();

/* Please see Technical Note #008 before using these functions */
void FAR PASCAL EWSetEditor(long EditorId);
void FAR PASCAL EWSetWindowHandle(unsigned int H);

#endif /* _INC_EWAPI */
