/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#if defined( Uses_TStaticTextf) && !defined( __TStaticTextf )
#define __TStaticTextf

#include <stdarg.h>
class TStaticTextf : public TStaticText
{

public:

    TStaticTextf( const TRect& bounds, const char *fmt, ... );
    TStaticTextf( const ushort x, const ushort y, const char *fmt, ... );

private:

    virtual void init( const char *fmt, va_list arglist );
    virtual const char *streamableName() const
        { return name; }

protected:

    TStaticTextf( StreamableInit );
    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:

    static const char * const near name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TStaticTextf& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TStaticTextf*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TStaticTextf& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TStaticTextf* cl )
    { return os << (TStreamable *)cl; }

#endif  // Uses_TStaticTextf
