//
// regx.cpp     : Define implementation for regular expression class
// Author       : Roy S. Woll
//
// Copyright (c) 1993 by Roy S. Woll
// You may distribute this source freely as long as you leave all files
// in their original form, including the copyright notice as is.
//
//
// Version 2.1      12/10/92
//    Add copy constructor
//
// Version 2.00     11/31/92
//    Define class for regular expressions.
//

#include <iostream.h>
#include "regX.h"
#include "regximp.h"

regXimp::regXimp(void):compiledPattern(256){
   error = 1;
   caseSensitive=1;
   startMatch=endMatch=0;
};


regX::regX(void):imp(new regXimp()){};

regX::regX(const regX& r):imp(new regXimp())
{
   *imp = *r.imp;
};

regX::regX(const char * regexp):imp(new regXimp())
{
   imp->makepat(regexp);
};

regX::~regX(void){ delete imp;};

regX& regX::operator=(const char * regexp){
   return *this = regX(regexp);
};

regX& regX::operator=(const regX& r){
   *imp = *r.imp;
   return *this;
};


int regX::index(const char * s, int * matchLenPtr, int start,
                    int p_caseSensitive) const
{
   if (error()) return -1;

   if ( imp->matchs(s+start, p_caseSensitive) ){
      *matchLenPtr = imp->endMatch - imp->startMatch +1;
      return imp->startMatch - s;
   }
   else {
      *matchLenPtr = 0;
      return -1;
   };
};

int regX::error(void) const{ return imp->error; };


