//
// grep.cpp: Demo program for str class
// Author  : Roy S. Woll
//
// Copyright (c) 1993 by Roy S. Woll
// You may distribute this source freely as long as you leave all files
// in their original form, including the copyright notice as is.
//
// Version 2.11     03/08/93     Support path specification
// Version 2.00     11/30/92
//
#include <fstream.h>
#include <iomanip.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include "str.h"
#include "regx.h"

int fileNamesOnly=0;       // true if only file names should be shown
int enableLineNumbers=0;   // true if line numbers should be shown
str line;                  // str used to compare - (case sensitive?)
regX pattern;              // regular expression search pattern

void grepfile(const char * curfile)
{
   ifstream searchFile( curfile );
   int foundMatch = 0, lineCount=0, pos;
   str match;
   while (!searchFile.eof()) {
      searchFile >> line;
      lineCount++;
      pos = 0;
      if (line.search(pattern, &match, &pos)){
          if (!foundMatch++){
             if (fileNamesOnly) {
                cout << "File: " << curfile << endl;
                return;
             };
             str Bar;
             Bar.stream() << pad("", strlen(curfile)+14, str::right, '*')
                          << endl;
             cout << endl << Bar << "*** File: " << curfile << " ***"
                  << endl << Bar;
          };
          if (enableLineNumbers) cout << setw(4) << lineCount << ": ";
          cout << line << endl;
      };
   }
};

void displayInvocation(void){
   cout << "GREP : Demo for str (Version 2.11)  Copyright (c) 1992 Roy S. Woll"
        << endl;
   cout << "Syntax:   GREP [-iln] SearchString File[s]" << endl;
   cout << "     -i Case insensitive search" << endl;
   cout << "     -l list only file names" << endl;
   cout << "     -n list line numbers" << endl;
   exit(1);
};

int main(int argc, char * argv[]){
   if (argc<2) displayInvocation();
   str filespec, options;

   if (!strncmp(argv[1],"-", 1)) {
      if (argc <3) displayInvocation();
      options = argv[1];
      pattern = argv[2];
      filespec = argv[3];
      if (options.search("i")) line.setCaseSensitive(0);
      if (options.search("n")) enableLineNumbers = 1;
      if (options.search("l")) fileNamesOnly=1;
   }
   else {
      pattern = argv[1];
      filespec = argv[2];
   };

   ffblk fileblk;
   if (findfirst(filespec, &fileblk, 0))
      cout << endl << "*** No Files Found! " << endl;
   else {
      int pos=0, lastpos=-1;
      while (filespec.search("\\", &pos)) lastpos = pos++;
      str directory = filespec(0, lastpos+1);
      grepfile(directory + fileblk.ff_name);
      while (!findnext(&fileblk)) grepfile(directory + fileblk.ff_name);
   };
   return 0;
};

