//
//      **************************************************************
//       JdeBP C++ Library Routines      General Public Licence v1.00
//          Copyright (c) 1991,1992  Jonathan de Boyne Pollard
//      **************************************************************
//
//  Compiler Specifics
//

#if !defined(___STDDEF_H_INCLUDED)

//
//  Far pointer utilities
//
#if __BORLANDC__
#define     _FP_SEG(p)  ( (unsigned short)(void _seg *)(void far *)(p) )
#define     _FP_OFF(p)  ( (unsigned short)(void near *)            (p) )
#define     _MK_FP(s,o) ( (void _seg *) (s) + (void near *) (o) )
#elif __MSC__
#define     _FP_OFF(p)  ( ((unsigned short _far *)&(p)) [0] )
#define     _FP_SEG(p)  ( ((unsigned short _far *)&(p)) [1] )
#define     _MK_FP(s,o) ( (void _far *) ( (unsigned long)(o) + ( ((unsigned long)(s)) << 16 ) ) )
#endif

//
//  Bases for standard types declared in multiple headers
//
typedef unsigned long   _Nobjectid_t;	// Network object ID type
typedef unsigned long	_Fpos_t;		// fpos_t				(ANSI)
typedef unsigned int	_Wchar_t;		// wchar_t				(ANSI)
typedef unsigned long	_Time_t;		// time_t				(ANSI)
typedef long            _Clock_t;		// clock_t				(ANSI)
#if defined(__HUGE__)||defined(__LARGE__)||defined(__COMPACT__)
typedef signed short	_Ptrdiff_t;		// ptrdiff_t (signed)	(ANSI)
#else
typedef signed long		_Ptrdiff_t;		// ptrdiff_t (signed)	(ANSI)
#endif
typedef unsigned int	_Size_t;		// size_t (unsigned)	(ANSI)
typedef signed int		_Ssize_t;		// ssize_t (signed)		(POSIX.1)
typedef unsigned short	_Dev_t;			// dev_t				(POSIX.1)
typedef _Nobjectid_t	_Gid_t;			// gid_t				(POSIX.1)
typedef unsigned short	_Ino_t;			// ino_t				(POSIX.1)
typedef unsigned short	_Mode_t;		// mode_t				(POSIX.1)
typedef unsigned short	_Nlink_t;		// nlink_t				(POSIX.1)
typedef long			_Off_t;			// off_t (signed)		(POSIX.1)
typedef short			_Pid_t;			// pid_t (signed)		(POSIX.1)
typedef _Nobjectid_t	_Uid_t;			// uid_t				(POSIX.1)
typedef unsigned long	_Sigset_t;		// sigset_t				(POSIX.1)

//
//  Basis for standard macros declared in multiple headers
//
#ifndef _NULL
#define _NULL   ((void *)0)
#define	_FARNULL	0L
#endif

//
//  _CDECL              Force C style calling in function declarations
//  _LOADDS             Force load DS segment
//  _FARFUNC            Force far calling in DLL function definitions
//  _FAR                Force far data    in DLL function declarations
//  _FARCALL            Force far calling in DLL function declarations
//  _DLLCLASS           Force far classes in DLL class    declarations
//

//
// Borland C++
//
//  _BUILDRTLDLL        When compiling source for DLL standard library
//  _RTLDLL             When compiling headers for DLL standard library
//  _CLASSDLL           When compiling DLL class library
//

#if __BORLANDC__

#if defined(__COMPACT__) || defined(__LARGE__) || defined(__HUGE__)
#	define	__FARDATA__
#else
#	define	__NEARDATA__
#endif
#if defined(__MEDIUM__) || defined(__LARGE__) || defined(__HUGE__)
#	define	__FARCODE__
#else
#	define	__NEARCODE__
#endif

#   if __STDC__
#       define _CDECL
#       define _LOADDS
#       define _FARFUNC
#       define _FAR
#       define _FARCALL
#       define _DLLCLASS
#   else
#
#       define _CDECL _cdecl
#       define _LOADDS _loadds
#
#       if defined(_BUILDRTLDLL)
#           define _FARFUNC _export
#       elif defined(_RTLDLL)
#           define _FARFUNC far
#       else
#           define _FARFUNC
#       endif
#       if defined(__DLL__)
#           if defined(_RTLDLL) || defined(_CLASSDLL)
#               define _DLLCLASS _export
#           else
#               define _DLLCLASS far
#           endif
#           define _FAR far
#       elif defined(_RTLDLL) || defined(_CLASSDLL)
#           define _DLLCLASS huge
#           define _FAR far
#       else
#           define _FAR
#           if defined(__TINY__) || defined(__SMALL__) || defined(__MEDIUM__)
#               define _DLLCLASS  near
#           elif defined(__COMPACT__) || defined(__LARGE__)
#               define _DLLCLASS  far
#           else
#               define _DLLCLASS  huge
#           endif
#       endif
#   endif
#
#   if defined(_BUILDRTLDLL)
#       define _FARCALL _export
#   else
#       define _FARCALL far
#   endif
#
#endif

// The following macros control the behaviour of the standard headers :
//
// _POSIX_SOURCE        Causes definition of _POSIX1_SOURCE and _POSIX2_...
//                      that reflect the compliancy of this library
// _POSIX1_SOURCE       Controls POSIX.1 compliancy
// _POSIX2_SOURCE       Controls POSIX.2 compliancy
// _MSDOS_SOURCE        Controls MS-DOS API compliancy
// _BSD_SOURCE          Controls BSD **IX library support

#if _POSIX_SOURCE && !defined(_POSIX1_SOURCE) && !defined(_POSIX2_SOURCE)
#define _POSIX1_SOURCE  1
#undef  _POSIX2_SOURCE
#endif

#define ___STDDEF_H_INCLUDED

#endif
