//
//      **************************************************************
//       JdeBP C++ Library Routines      General Public Licence v1.00
//          Copyright (c) 1991,1992  Jonathan de Boyne Pollard
//      **************************************************************
//
//  FILE CONTROL (POSIX)
//

#if !defined(___STDDEF_H_INCLUDED)
#include <_stddef.h>
#endif
#if !defined(___OMODE_H_INCLUDED)
#include <_omode.h>
#endif

#if !defined(__FCNTL_H_INCLUDED)

// Locking commands

#define F_RDLCK 0
#define F_WRLCK 1
#define F_UNLCK 2

// Commands for fcntl()

#define F_DUPFD     0
#define F_GETFL     1
#define F_SETFL     2
#define F_GETFD     3
#define F_SETFD     4
#define F_GETLK     5
#define F_SETLK     6
#define F_SETLKW    7

//
// Open flags for opening files.  See <_omode.h> for details.
//

#define O_RDONLY    _O_RDONLY
#define O_WRONLY    _O_WRONLY
#define O_RDWR      _O_RDWR
#define O_ACCMODE   _O_ACCMODE
#define O_CREAT     _O_CREAT
#define O_TRUNC     _O_TRUNC
#define O_EXCL      _O_EXCL
#define O_APPEND    _O_APPEND
#define O_NOCTTY    _O_NOCTTY
#define O_NONBLOCK  _O_NONBLOCK
#define O_COMPAT    _O_COMPAT
#define O_DENYALL   _O_DENYALL
#define O_DENYWRITE _O_DENYWRITE
#define O_DENYREAD  _O_DENYREAD
#define O_DENYNONE  _O_DENYNONE
#define O_NOINHERIT _O_NOINHERIT
#define O_FAILONERR _O_FAILONERR
#define O_WRITETHRU _O_WRITETHRU
#define O_DASD      _O_DASD
#define O_TEXT      _O_TEXT
#define O_BINARY    _O_BINARY
#define O_RAW       _O_BINARY
#define O_NDELAY    O_NONBLOCK      /* Not strictly correct for System V */

#ifndef _FLOCK_DEFINED
struct flock {
    short   l_type;         // Type is one of the F_ macros
    short   l_whence;       // One of the SEEK_ macros from <stdio.h>
    _Off_t  l_start;        // Start of lock, in bytes
    _Off_t  l_len;          // Length of lock, in bytes
    _Pid_t  l_pid;          // Return value: pid of locking process
};
#define _FLOCK_DEFINED
#endif

extern "C" {

int     _CDECL  creat       (const char *, int);
int     _CDECL  open        (const char *, int, ...);
int     _CDECL  fcntl       (int, int, ...);

#if _MSDOS_SOURCE > 0
int     _CDECL  sopen       (const char *, int, int, ...);
#endif

}

#define __FCNTL_H_INCLUDED
#endif

