//
//      **************************************************************
//       JdeBP C++ Library Routines      General Public Licence v1.00
//          Copyright (c) 1991,1992  Jonathan de Boyne Pollard
//      **************************************************************
//
// DOS FUNCTIONS and SEGMENT:OFFSET MAIPULATIONS (MS-DOS)
//

#if !defined(___STDDEF_H_INCLUDED)
#include <_stddef.h>
#endif
#if !defined(___PORTINT_H_INCLUDED)
#include <_portint.h>       // PORT and INTERRUPT FUNCTIONS
#endif
#if !defined(___ATTRIB_H_INCLUDED)
#include <_attrib.h>        // File attribute constants
#endif

#ifndef _DOS_H_INCLUDED

#define NULL    _NULL

#define MK_FP(s,o) _MK_FP(s,o)
#define FP_SEG(fp) _FP_SEG(fp)
#define FP_OFF(fp) _FP_OFF(fp)

struct DOSERROR {
	int exterror;
	char errclass;
	char action;
	char locus;
};

struct find_t {
	char        reserved[21];
	char        attrib;
	unsigned    wr_time;
	unsigned    wr_date;
	long        size;
	char        name[13];
};

struct dosdate_t {
	unsigned char day;          /* 1-31 */
	unsigned char month;        /* 1-12 */
	unsigned int year;          /* 1980-2099 */
	unsigned char dayofweek;    /* 0-6, 0=Sunday */
};
struct dostime_t {
	unsigned char hour;     /* 0-23 */
	unsigned char minute;   /* 0-59 */
	unsigned char second;   /* 0-59 */
	unsigned char hsecond;  /* 0-99 */
};

struct diskfree_t {
	unsigned total_clusters;
	unsigned avail_clusters;
	unsigned sectors_per_cluster;
	unsigned bytes_per_sector;
};

extern "C" {

//
//  _dos calls only available under DOS
//
void        _CDECL  _dos_fullname(const char *, char *) ;
void        _CDECL  _dos_keep   (unsigned, unsigned);
unsigned    _CDECL  _dos_leadbytetable  (const void far * far * ) ;
void        interrupt (_far * _CDECL getvect    (unsigned))();
void        _CDECL  setvect (unsigned, void (interrupt _far *)());

#ifdef __MSC__
void        _CDECL  _chain_intr (void (_CDECL _interrupt _far *)());
void        interrupt (_far * _CDECL _dos_getvect(unsigned))();
void        _CDECL  _dos_setvect    (unsigned, void (interrupt _far *)());
#endif

//
//  _dos calls available under OS/2
//
unsigned    _CDECL  _dos_allocmem(unsigned short, unsigned short *);
unsigned    _CDECL  _dos_close  (int);
unsigned    _CDECL  _dos_creat  (const char *, unsigned, int *);
unsigned    _CDECL  _dos_creatnew   (const char *, unsigned, int *);
unsigned    _CDECL  _dos_findfirst  (const char *, unsigned, struct find_t *);
unsigned    _CDECL  _dos_findnext   (struct find_t *);
unsigned    _CDECL  _dos_freemem    (unsigned);
void        _CDECL  _dos_getdate    (struct dosdate_t *);
void        _CDECL  _dos_getdrive   (unsigned *);
unsigned    _CDECL  _dos_getdiskfree    (unsigned, struct diskfree_t *);
unsigned    _CDECL  _dos_getfileattr    (const char *, unsigned *);
unsigned    _CDECL  _dos_getftime   (int, unsigned *, unsigned *);
void        _CDECL  _dos_gettime    (struct dostime_t *);
unsigned    _CDECL  _dos_open   (const char *, unsigned, int *);
unsigned    _CDECL  _dos_read   (int, void _far *, unsigned, unsigned *);
unsigned    _CDECL  _dos_seek   (int, long, int, long *);
unsigned    _CDECL  _dos_setblock   (unsigned, unsigned, unsigned *);
unsigned    _CDECL  _dos_setdate    (struct dosdate_t *);
void        _CDECL  _dos_setdrive   (unsigned, unsigned *);
unsigned    _CDECL  _dos_setfileattr    (const char *, unsigned);
unsigned    _CDECL  _dos_setftime   (int, unsigned, unsigned);
unsigned    _CDECL  _dos_settime    (struct dostime_t *);
unsigned    _CDECL  _dos_write  (int, const void _far *, unsigned, unsigned *);
int         _CDECL  _dos_exterr (struct DOSERROR *);

//
//  Global variables related to DOS
//
extern unsigned int     _CDECL _psp;            // Program Segment Prefix
extern char far *       _CDECL _pspadr;         // PSP far pointer
extern const char far * _CDECL _pgmptr;         // Pointer to prog name
extern unsigned char    _CDECL _osmajor;        // DOS major version
extern unsigned char    _CDECL _osminor;        // DOS minor version
extern unsigned int     _CDECL _osversion;

}

//
//  Windows compatible function call to perform int 21h services
//
//
// This is for the DOS library only.  Windows exports a far pascal function
// from KERNEL.EXE which (in 386 enhanced mode) performs faster processing
// of int 21h than an actual int 21h instruction would, because of less
// overhead with interrupt gates.  All of the other DOS...() functions call
// Dos3Call to ensure future windows compatibility.
//
#ifdef __WINDOWS__
extern "C"  void  _APICALL  Dos3Call    (void) ;
#else
#define Dos3Call()  { asm int 0x21; }
#endif

#define _DOS_H_INCLUDED
#endif
