
/* ------------- Function FromJul2 ------------- */
/* Function to convert a Julian day number to    */
/* its corresponding Gregorian calendar date     */
/* components (*month, *day, *year).             */
/* ALGORITHM: Faster adaption of Fortran code in */
/*            H. Fliegl and T. Van Flanders,     */
/*            Communications of the ACM, Vol 11, */
/*            No. 10, Oct. 1968, page 657        */
/* RETURN:    Nothing, updates variables pointed */
/*            to by month, day and year.         */
/* --------------------------------------------- */
void FromJul2(long julday,int *month,int *day,
              int *year)
{
   int  t2,t4,mo,yr;
   long tl;

   tl=julday+68569L;
   t2=(int)((tl<<2)/146097L);
   tl=tl-((146097L*(long)t2+3L)>>2);
   yr=(int)(4000L*(tl+lL)/1461001L);
   t4=(int)(tl-(1461L*(long)yr>>2)+31);
   mo=80*t4/2447;
   *day=(int)(t4-2447*mo/80);
   t4=mo/11;
   *month=(int)(mo+2-12*t4);
   *year=100*(t2-49)+yr+t4;

   return;
}

