/*

  FUNCTION: ClipFax()
  Description: Function to use FAXER.EXE from Simple Simon Software
               from within CLIPPER 5.2
  Calls: BLINKER 2.01 SwpRunCmd()

*/

FUNCTION CLIPFAX(cPort,cPhone,cFile)
LOCAL cString, lSuccess, nWhatHappened

// Resolve Parameters
IF Pcount() < 3
   RETURN(.F.)         // Failed
ENDIF


// Use Clipper to Validate File
IF !FILE(cFile)
   RETURN(.F.)         // File Not Found
ENDIF


//Fix up the command String
cString := ("FAXER " + cPort+ " " + cPhone + " " + cFile)


// Leave the rest to Faxer
lSuccess := SwpRunCmd(cString)     // Call to BLINKER's SwpRunCmd() function


// See if the Command Interpreter failed
IF (!lSuccess)
   RETURN(.F.)
ENDIF


// Otherwise,
// FAXER has executed properly, so lets check the DOS errorlevel
// for results
nWhatHappened := ERRORLEVEL()


// Return the DOS Errorlevel
Return(nWhatHappened)

