/*
  T_INFO.PRG
  Author:  D.B. McDonald  [ CIS 76334,3521 ]
  Created: April 25, 1993

  Version: 1.10.00
  Update:  May 13, 1993
*/

#include "simpleio.ch"
#include "blinker2.ch"

* -------------------------------------------------------------------------- *
* t_Info()
*    - Adds Blinker derived information to Clipper //info parameter
*
Procedure t_Info()
* -------------------------------------------------------------------------- *
  local aBlDemo := BlinkDemo(), ;
        aBlSer  := SerNum()

   ?? aBlSer.Name + ' -- version:' + aBlSer.version + ' -- update:'  + aBlSer.Date
    if ( aBlDemo.Revision < 0 )
       ? aBlSer.Comment 
    else
       ? 'Blinker ' + TransForm( aBlDemo.Revision / 100, '9.99' ) +  ':' + aBlSer.Comment 
    endif
    ? ""
return

* -------------------------------------------------------------------------- *
* t_Syntax()
*    - Syntax/Help screen 
*
Procedure t_Syntax()                      
* -------------------------------------------------------------------------- *
   local aSerNum := SerNum()

  ?? aSerNum.Name + " <file spec> <option list>"
   ? "  Alter the date and/or time attributes of a file or a group of files"
   ? ""
   ? "  <file spec> is name of file or the file specification to touch up"
   ? "  -d[<date>]  is the date in mm/dd/yy format to apply to touch up"
   ? "  -t[<time>]  is the time in hh:mm:ss format to apply to touch up"
   ? "  -n          changes the date and time of the file to 'NOW'"
   ? "  -v          verbose mode in format <oldfile> => <new file>"
   ? "  -h          this help screen"
   ? ""
return

