*------------------------------------------------------------------------
* Simple program to illustrate the working of the .rp1 read functions
*
* Compile:
*   clipper rrtest /n /w /m
*   clipper rrlib  /n /w /m
*
* Link
*   Blinker file rrtest,rrlib
*
* Ernst Peter Tamminga CIS 100042,1760, march 1993
*------------------------------------------------------------------------

function RRTest( cLibrary )
local lnI
local lnJ
local aNames
local aDetail

if cLibrary == NIL .or. !file(cLibrary)
   ? "Use as: RRTEST abc.rp1"
   quit
endif

aNames := RR_names( cLibrary )         // Get all the report names

for lnI := 1 to len(aNames)

   scroll()
   @ 0,0 say "Library " + upper(cLibrary) +  "; details of: " + aNames[lnI]

   aDetail := RR_Details( cLibrary, aNames[lnI])

   showme( "Master database   ", aDetail[1,1] )
   showme( "    .. index      ", aDetail[1,2] )
   showme( "    .. alias name ", aDetail[1,3] )
   showme( "    .. TAG name   ", aDetail[1,4] )

   for lnJ := 1 to len( aDetail[2] )
      showme( "Related file #" + str(lnJ,4), aDetail[2,lnJ,1] )
      showme( "     .. index     ", aDetail[2,LnJ,2] )
      showme( "     .. alias name", aDetail[2,LnJ,3] )
      showme( "     .. TAG name  ", aDetail[2,lnJ,4] )
   next

   showme( "Font file         ", aDetail[3]      )
   showme( "Ascii file        ", aDetail[4,1]    )
   showme( "   .. file alias  ", aDetail[4,2]    )
   showme( "UDF library       ", aDetail[5]      )
   showme( "Date stored       ", aDetail[6]      )
   showme( "Time stored       ", aDetail[7]      )
   showme( "# of Copies       ", aDetail[8]      )

   for lnJ := 1 to len( aDetail[9] )
      showme( "Calculated field  ", aDetail[9,lnJ,1] )
      showme( "     .. expression", aDetail[9,LnJ,2] )
      showme( "     .. file #    ", aDetail[9,LnJ,3] )
   next

   MyWait()


next
return NIL

*------------------------------------------------------------------------
* Simple function to scroll on screen
*------------------------------------------------------------------------

static function showme( cSubject, xValue )

if row() == maxrow()-1

   MyWait()

   scroll( 1, 0, maxrow(), maxcol() )
   @ 1,0 say " << Continued >> "
endif

? cSubject + ": "

if xValue # NIL
   ?? xValue
endif

return NIL

*------------------------------------------------------------------------
static function MyWait()

? "Press [Space] to continue, [Esc] to stop"
if inkey(0) == 27
   quit
endif

return NIL
