// Class TIniFile for CA-Clipper        (c) Antonio Linares, 1993

// Object Oriented INI Files management
// Use examples

//----------------------------------------------------------------------------//

function Main()

    local oIni := TIniFile():Use( "MyApp.ini" )
    local n

    if ! File( "MyApp.ini" )
       BuildIni( oIni )
    endif

    Alert( oIni:ClassName() )

    SetColor( oIni:cGet( "main", "colors" ) )
    CLS

    @ 0, 0 SAY PadC( oIni:cGet( "main", "title" ), MaxCol() + 1 ) ;
      COLOR oIni:cGet( "colors", "title" )

    @ MaxRow(), 0 SAY PadC( oIni:cGet( "main", "message" ), MaxCol() + 1 ) ;
      COLOR oIni:cGet( "colors", "message" )

    @ 10, 10 PROMPT oIni:cGet( "MainMenu", "Item1" )
    @ 12, 10 PROMPT oIni:cGet( "MainMenu", "Item2" )
    MENU TO n

    oIni:Use()

return

//----------------------------------------------------------------------------//

function BuildIni( oIni )

   oIni:Set( "main", "title",   "The title of my program" )
   oIni:Set( "main", "colors",  "W+/B, W+/R,,,N/BG" )
   oIni:Set( "main", "message", "Main message of my program" )

   oIni:Set( "users", "supervisor", "PASSWORD" )

   oIni:Set( "colors", "title",   "GR+/RB" )
   oIni:Set( "colors", "message", "GR+/BG" )

   oIni:Set( "MainMenu", "Item1", "My Clients" )
   oIni:Set( "MainMenu", "Item2", "My Accounts" )

   oIni:Set( "Clients", "Dbf", "Clients.dbf" )

   oIni:Save()

return

//----------------------------------------------------------------------------//
