/*
 Ŀ
  Module....: DATADICT.prg                                                
  Author....: Steve Kolterman (DataTech Associates, Inc.)                 
  Copyright.: Princeton MICRAN Associates, Inc.                           
  Date......: April 1993                                                  
 Ĵ
  Notes.....: Data-driven oDB.                                            
 
*/

#include "objectdb.ch"
#ifdef DBFSIX
 #include "dbfsix2.ch"
#endif
#ifdef COMIX
 #include "cmx.ch"
#endif

DATA DEFINITION MODULE
LOCAL nLen,oTable,nX

DEFINE DATABASE ddsample

USE TABLES NEW SHARED
CheckIndex("tables"+IndexExt(),"Upper(field->table)","TABLES")

USE COLUMNS NEW SHARED
CheckIndex("columns"+IndexExt(),"Upper(field->table)+field->table_pos+" +;
           "Upper(field->column)","COLUMNS")

USE INDEXES NEW SHARED
CheckIndex("indexes"+IndexExt(),"Upper(field->table)+field->order+" +;
           "IIF(field->isprimary,'T','F')","INDEXES" )

USE INDXCOLS NEW SHARED
CheckIndex("indxcols"+IndexExt(),"Upper(field->table)+field->order+" +;
           "field->sequence","INDXCOLS" )

USE FKEYS NEW SHARED
CheckIndex("fkeys"+IndexExt(),"Upper(field->table)+field->order","FKEYS")

SELECT TABLES ; GO TOP

WHILE tables->( !Eof() )
   oTable:= table():new( db(), ;
            Trim(tables->table), ;
            IIF( !Empty(tables->alias),Trim(tables->alias),NIL ) ,;
            IIF( !Empty(tables->descr) ,Trim(tables->descr),NIL )  )
   IF columns->( dbSeek(oTable:filename) )
      Columns( oTable )
      PKeys( oTable )
   ENDIF
   tables->(dbSkip())
ENDDO

nLen:= Len(db():aTables)
FOR nX:= 1 TO nLen
   Indexes( db():aTables[nX] )
   Fkeys( db():aTables[nX] )
NEXT

// close utility's tables.
Aeval({"TABLES","COLUMNS","INDEXES","INDXCOLS","FKEYS"} ,;
      {|e| dbCloseArea(e)} )

// collect garbage.  sniff, sniff.
MEMORY(-1)

// get outta Dodge.
IF Empty(Procname(1))
   QUIT
ENDIF

END DATA DEFINITION MODULE

STATIC FUNCTION CheckIndex(cFilename,cExpr,cIndex)
IF NetErr()
   DumbMsg( "Error opening "+Upper(cFilename) )
ENDIF
IF !File(cFilename)
   IF (cIndex)->(!Flock())
      DumbMsg("Failure locking "+Upper(cFilename)+" for re-indexing.")
   ELSE
      INDEX ON &(cExpr) TO (cIndex)
      (cIndex)->(dbUnlock())
   ENDIF
ELSE; SET INDEX TO (cIndex)
ENDIF
RETURN NIL

STATIC FUNCTION DumbMsg(cMsg)
 SetPos(row(),0)
 OutStd(cMsg)
 Inkey(1) ; QUIT
RETURN NIL

